/****************************************************************************/
/* FILE NAME       : EntryWDTInt_R12.c                                      */
/* VERSION         : 1.00                                                   */
/* FUNCTION        : [UWDTG[ݓo^  TvvO          */
/*                   (R12CCPU-V)                                            */
/*                                                                          */
/*  Cӂ̃^XN(LQ)𐶐EsĂB                        */
/*  PDEntryWDTMain()s                                            */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp        */
/*  ܂悤肢܂B                                      */
/*                                                                          */
/* CREATED         : 2014/10/09   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/
#include    <vxWorks.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <taskLib.h>
#include    <semLib.h>
#include    "CCPUFunc.h"

#define UNIT            2           /* jbgʎq                       */
#define PRIORITY_150    150         /* vCIeB150                    */
#define PRIORITY_160    160         /* vCIeB160                    */
#define STACK           20000       /* X^bN̈20000                    */
#define TASK_NAME_1     "SmpTask_1" /* ^XNP                           */
#define TASK_NAME_2     "SmpTask_2" /* ^XNQ                           */

long    glWDTIntCnt = 0;            /* WDT݃JEg                  */

/* jbgXe[^XĎ                                               */
void    StatusCheckRtn();
/* Y[ho͏                                                          */
void    YWord_WriteRtnTask();
/* WDT݃tbN[`                                                  */
void    WDTIntHookRtn();

/****************************************************************************/
/* MODULE   : EntryWDTMain                                                  */
/* ABSTRACT : WDTC                                                 */
/* FUNCTION : ^XNNB                                            */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-09  MITSUBISHI ELECTRIC CORPORATION                   */
/* UPDATE   :                                                               */
/****************************************************************************/
void EntryWDTMain()
{
    short   sRet;

    /************************************************************************/
    /* jbgXe[^XĎ^XNN                               */
    /************************************************************************/
    sRet = taskSpawn(TASK_NAME_1,
                    PRIORITY_150,
                    0,
                    STACK,
                    (FUNCPTR)StatusCheckRtn,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    if(sRet == ERROR){
        printf("StatusCheckRtn task start error sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }
    
    /************************************************************************/
    /* Yo̓^XNN                                                */
    /************************************************************************/
    sRet = taskSpawn(TASK_NAME_2,
                    PRIORITY_160,
                    0,
                    STACK,
                    (FUNCPTR)YWord_WriteRtnTask,
                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    if(sRet == ERROR){
        printf("YWord_WriteRtnTask task start error sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }

    return;
}

/****************************************************************************/
/* MODULE   : StatusCheckRtn                                                */
/* ABSTRACT : jbgXe[^XĎ                                    */
/* FUNCTION : jbgXe[^X̊ĎWDT̐sB                   */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-09  MITSUBISHI ELECTRIC CORPORATION                   */
/* UPDATE   :                                                               */
/****************************************************************************/
void StatusCheckRtn()
{
    short          sRet;
    unsigned short pusErrInfo[3];
    long           lEvent[4];
    unsigned long  ulBufSize;

    /************************************************************************/
    /* 500ms̃^C}CxgZbg                                */
    /************************************************************************/
    lEvent[0] = 1;    /* ^C}Cxg                                   */
    lEvent[1] = 1;    /* ^C}CxgNo.1                                 */
    lEvent[2] = 500;  /* ^C}Cxg̎(500ms)                        */
    lEvent[3] = 1;    /* ^C}Cxg̓(1:)                   */


    /************************************************************************/
    /* ^C}Cxgo^                                             */
    /* (500ms̃^C}Cxgo^)                                */
    /************************************************************************/
    sRet = CCPU_EntryTimerEvent(lEvent);
    if(sRet != 0){
        printf("CCPU_EntryTimerEvent Error sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }

    /************************************************************************/
    /* WDT݃[`o^                                          */
    /************************************************************************/
    sRet = CCPU_EntryWDTInt(0, WDTIntHookRtn);
    if(sRet != 0){
        printf("CCPU_EntryWDTInt Error sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }

    /************************************************************************/
    /* WDTĎJn(Ԋu1000ms(1b)ŊĎ)                             */
    /************************************************************************/
    sRet = CCPU_StartWDT(0, 100);
    if(sRet != 0){
        printf("CCPU_StartWDT Error sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }

    /************************************************************************/
    /*  ^C}No.1(500msԊu)閈Ɉȉ̏             */
    /*                                                                      */
    /*  @CRg[jbg̏ԏǂݏo                     */
    /*  AjbgG[ꍇ                                      */
    /*    WDTĎ~ďI                                   */
    /*  BjbgG[Ȃꍇ                                    */
    /*    WDTZbg                                                 */
    /************************************************************************/
    while(1){
        /********************************************************************/
        /*  CRg[jbg̏ԏ̓ǂݏos         */
        /********************************************************************/
        ulBufSize = sizeof(pusErrInfo) / 2;
        sRet = CCPU_GetErrInfo(pusErrInfo, ulBufSize);
        if(sRet != 0){
            printf("\nCCPU_GetErrInfo Error  sRet = %d ( %hxH )\n", sRet, sRet);
            break;
        }

        /********************************************************************/
        /* KvɉCRg[jbg̏ԏ̎ʁA          */
        /* ʏJX^}CYĂB                             */
        /********************************************************************/
        
        /********************************************************************/
        /* CRg[jbg̃G[ԂmF                  */
        /********************************************************************/
        if(pusErrInfo[1] != 0 || pusErrInfo[2] != 0){   /* Error            */
            printf("Module Error Occurred!!  pusErrInfo[1] = 0x%x, pusErrInfo[2] = 0x%x\n", pusErrInfo[1], pusErrInfo[2]);
            /****************************************************************/
            /* WDTĎ~                                            */
            /****************************************************************/
            sRet = CCPU_StopWDT(0);
            if(sRet != 0){
                printf("CCPU_StopWDT Error sRet = %d ( %hxH )\n", sRet, sRet);
            }
            break;
        }

        /********************************************************************/
        /* WDTĎZbg                                            */
        /********************************************************************/
        sRet = CCPU_ResetWDT(0);
        if(sRet != 0){
            printf("CCPU_ResetWDT Error sRet = %hd ( %hxH )\n", sRet, sRet);
            break;
        }

        /********************************************************************/
        /* ^C}CxgNo.1(500ms)҂                                */
        /********************************************************************/
        sRet = CCPU_WaitTimerEvent(1);
        if(sRet != 0){
            printf("CCPU_WaitTimerEvent Error ret = %d ( %hxH )\n", sRet, sRet);
            break;
        }
    }

    return;
}

/****************************************************************************/
/* MODULE   : YWord_WriteRtnTask                                            */
/* ABSTRACT : Y[ho͏                                               */
/* FUNCTION : Y10`Y1F1bɃCNgB                         */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-09  MITSUBISHI ELECTRIC CORPORATION                   */
/* UPDATE   :                                                               */
/****************************************************************************/
void    YWord_WriteRtnTask()
{
    short          sRet          = -1;
    unsigned short pusDataBuf[1] = {0};

    /************************************************************************/
    /* Y10`Y1F1bɃCNg                                  */
    /************************************************************************/
    pusDataBuf[0] = 0;
    
    while(1){
        /********************************************************************/
        /* Y10`Y1F̒l                                           */
        /********************************************************************/

        sRet = CCPU_Y_Out_WordEx(0, 0x10, 1, pusDataBuf, 0);
        if(sRet != 0){
            printf("CCPU_Y_Out_WordEx Error sRet = %hd ( %hxH )\n", sRet, sRet);
            break;
        }

        /********************************************************************/
        /* o̓f[^CNg                                   */
        /********************************************************************/
        pusDataBuf[0]++;
        
        /********************************************************************/
        /* KvɉCRg[jbg̏ԏǏo            */
        /* (CCPU_GetErrInfo)sď𕪂ĂB                */
        /********************************************************************/
        /*                  [U                                      */

        /********************************************************************/
        /* 1bEFCg                                                      */
        /********************************************************************/
        taskDelay(60);
    }

    return;
}

/****************************************************************************/
/* MODULE   : WDTIntHookRtn                                                 */
/* ABSTRACT : WDT݃tbN[`                                       */
/* FUNCTION : WDTG[OɎc                                         */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-09  MITSUBISHI ELECTRIC CORPORATION                   */
/* UPDATE   :                                                               */
/****************************************************************************/
void    WDTIntHookRtn()
{
    short          sRet;
    unsigned short pusDataBufWR[1] = {0};
    unsigned short pusDataBufRD[1] = {0};

    /************************************************************************/
    /* WDT݉񐔂CNg                                    */
    /************************************************************************/
    glWDTIntCnt++;
    pusDataBufWR[0] = glWDTIntCnt;

    /************************************************************************/
    /* obNAbvRAMփf[^                                    */
    /************************************************************************/

    sRet = CCPU_WriteDevice_ISR(Dev_CCPU_ZR, 0, 1, pusDataBufWR);
    if(sRet != 0){
        return;
    }

    /************************************************************************/
    /* obNAbvRAMf[^ǂݏo                                  */
    /************************************************************************/

    sRet = CCPU_ReadDevice_ISR(Dev_CCPU_ZR, 0, 1, pusDataBufRD);
    if(sRet != 0){
        return;
    }

    /************************************************************************/
    /* CxgO֒ǉ                                               */
    /************************************************************************/

    sRet = CCPU_RegistEventLog(0x1111AAFF, "WDTIntHook from WDTIntHookRtn()");
    /* 0x1111AAFF : Cxgɓo^R[h                            */
    if(sRet != 0){
        return;
    }

    return;
}
