/****************************************************************************/
/* FILE NAME       FMotionLink_R12.c                                       */
/* VERSION         F1.00                                                   */
/* FUNCTION        F[VCPUƂ̘Ag@\𗘗pTvvO  */
/*                   (R12CCPU-V p)                                         */
/*                                                                          */
/*   [VCPUAg@\TvvÕC֐                    */
/*  MotionLinkMain֐̑1ɉLTvvONo.w            */
/*  ƑΉTvvO^XNNĎs܂B          */
/*  2ɂ́AeTvvOɓnp[^w肵܂B         */
/*                                                                          */
/*  y\z                                                                */
/*      {TvvO͉L̍\KvƂ܂B                    */
/*      ___________________                                                 */
/*      |  R  | R |   |   |                                                 */
/*      |  1  | 1 |   |   |                                                 */
/*      |  2  | 6 |   |   |   1@FiQ-R PlatformΉCRg[     */
/*      |  C  | M |   |   |   2@FiQ-R PlatformΉ[VCPU         */
/*      |  C  | T |   |   |                                                 */
/*      |  P  | C |   |   |                                                 */
/*      |  U  | P |   |   |                                                 */
/*      |     | U |   |   |                                                 */
/*      |     |   |   |   |                                                 */
/*      |_____|___|___|___|__                                               */
/*                                                                          */
/*  @ [VfoCXANZX(ǏoE)                           */
/*    (MotionDeviceAccess())                                                */
/*      [VCPŨfoCXD8000(f[^WX^)1[h           */
/*      ݁Ǎ㓯foCXǏoāA݃f[^ƓǏof[^          */
/*      ̒lƍ܂BOq̓100ms100JԂ܂B          */
/*      ݃f[^͏݉񐔂ƓlłB(1`100)                      */
/*       ƍG[NꍇɂUSER LED_܂B                   */
/*                                                                          */
/*  A [VSFCvON                                          */
/*    (MotionSFCStarting())                                                 */
/*      [VCPUSFCvŐNv𔭍s܂B                */
/*                                                                          */
/*  B T[{vOs                                                 */
/*    (MotionSVSTExec())                                                    */
/*      [VCPU̎No.1ɑ΂ĎwT[{vO                 */
/*      nv܂B                                                  */
/*                                                                          */
/*  C ݒlύXvs                                                   */
/*    (MotionCHGAExec())                                                    */
/*      [VCPU̎No.1̌ݒlύXv܂B                     */
/*                                                                          */
/*  D xlύXvs                                                   */
/*    (MotionCHGVExec())                                                    */
/*      [VCPU̎No.1̑xlύXv܂B                     */
/*                                                                          */
/*  E gNlύXvs                                             */
/*    (MotionCHGTExec())                                                    */
/*      [VCPU̎No.1̃gNlύXv܂B               */
/*                                                                          */
/*   {Tvł̃^CAEgl̓ftHg(0:10b)łB               */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp        */
/*  ܂悤肢܂B                                      */
/*                                                                          */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxWorks.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <usrLib.h>
#include    <taskLib.h>
#include    "CCPUFunc.h"

#define MOTIONCPU    0x3E1      /*[VCPU:2@ */

/*  @D[VCPUfoCXANZX                                   */
void MotionDeviceAccess();
/*  AD[VSFCvON                                     */
void MotionSFCStarting(int ProgramNo);
/*  BDT[{vOs                                            */
void MotionSVSTExec(int ProgramNo);
/*  CDݒlύXvs                                              */
void MotionCHGAExec(int iData);
/*  DDxlύXvs                                              */
void MotionCHGVExec(int iData);
/*  EDgNlύXvs                                        */
void MotionCHGTExec(int iData);

/****************************************************************************/
/* MODULE   : MotionLinkMain                                                */
/* ABSTRACT : [VCPUAg@\TvvO C                */
/* FUNCTION : TvvONo.ɑΉ^XNNB             */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionLinkMain(
    int iNSampleNo,  /* sTvvONo.                       */
    int iParam)      /* p[^                                          */
{
    /************************************************************************/
    /* ^XN̐                                                         */
    /************************************************************************/
    switch(iNSampleNo){                 /* sTvvONo.́H*/
    case 1:                             /* TvvONo1̏ꍇ      */
        /********************************************************************/
        /* @^XN𐶐(sp܂taskSpawngp)                      */
        /********************************************************************/
        sp((FUNCPTR)MotionDeviceAccess,0,0,0,0,0,0,0,0,0);
        break;
    case 2:                             /* TvvONo2̏ꍇ      */
        /********************************************************************/
        /* A^XN𐶐(sp܂taskSpawngp)                      */
        /********************************************************************/
        sp((FUNCPTR)MotionSFCStarting,iParam,0,0,0,0,0,0,0,0);
        break;
    case 3:                             /* TvvONo3̏ꍇ      */
        /********************************************************************/
        /* B^XN𐶐(sp܂taskSpawngp)                      */
        /********************************************************************/
        sp((FUNCPTR)MotionSVSTExec,iParam,0,0,0,0,0,0,0,0);
        break;
    case 4:                             /* TvvONo4̏ꍇ      */
        /********************************************************************/
        /* C^XN𐶐(sp܂taskSpawngp)                      */
        /********************************************************************/
        sp((FUNCPTR)MotionCHGAExec,iParam,0,0,0,0,0,0,0,0);
        break;
    case 5:                             /* TvvONo5̏ꍇ      */
        /********************************************************************/
        /* D^XN𐶐(sp܂taskSpawngp)                      */
        /********************************************************************/
        sp((FUNCPTR)MotionCHGVExec,iParam,0,0,0,0,0,0,0,0);
        break;
    case 6:                             /* TvvONo6̏ꍇ      */
        /********************************************************************/
        /* E^XN𐶐(sp܂taskSpawngp)                      */
        /********************************************************************/
        sp((FUNCPTR)MotionCHGTExec,iParam,0,0,0,0,0,0,0,0);
        break;
    default:                             /* LȊȌꍇ                  */
        /********************************************************************/
        /* ^XN𐶐Ȃ                                               */
        /********************************************************************/
        break;
    }
}

/****************************************************************************/
/* MODULE   : MotionDeviceAccess                                            */
/* ABSTRACT : @D[VCPUfoCXANZX                         */
/* FUNCTION : [VCPU(2@)̃foCXD8000ɑ΂ǂݏsB   */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionDeviceAccess()
{
    int             i;
    short           sRet;
    short           sControlData[2] = {0,0};
    short           sEndStatus[2] = {0,0};
    unsigned long   ulSize;
    unsigned long   ulBufSize;
    short  sWriteData;
    short  sReadData;

    /************************************************************************/
    /* 3bEFCg                                                          */
    /************************************************************************/
    taskDelay(60 * 3);

    /************************************************************************/
    /* [VCPUfoCX̓ǂݏJԂ                            */
    /************************************************************************/
    printf("\nExecute Access to the Deveice of MotionCPU");
    printf("\n");
    ulSize      = 1;
    ulBufSize   = 1;
    sControlData[1]    = 1;
    for(i=0;i<100;i++){                                 /* 100JԂ    */
        /********************************************************************/
        /* [VCPU(2@)̃foCXD80001[h             */
        /********************************************************************/
        sWriteData = i + 1;
        sRet = CCPU_DedicatedDInst("DDWR", MOTIONCPU, &sControlData[0], 2, &sWriteData, 1, (short*)"D8000", 5, &sEndStatus[0], 2, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
        if((sRet != 0)||(sControlData[0] != 0)){
            printf("\nCCPU_DedicatedDInst:DDWR Error!!\tErrorCode:%d[%04hxH]\tControlData:%d[%04hxH]",sRet,sRet,sControlData[0],sControlData[0]);
            break;
        }

        /********************************************************************/
        /* 100~bEFCg                                                */
        /********************************************************************/
        taskDelay(60 / 10);

        /********************************************************************/
        /* [VCPU(2@)̃foCXD80001[hǏo             */
        /********************************************************************/
        sRet = CCPU_DedicatedDInst("DDRD", MOTIONCPU, &sControlData[0], 2, (short*)"D8000", 5, &sReadData, 1, &sEndStatus[0], 2, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
        if((sRet != 0)||(sControlData[0] != 0)){
            printf("\nCCPU_DedicatedDInst:DDRD Error!!\tErrorCode:%d[%04hxH]\tControlData:%d[%04hxH]",sRet,sRet,sControlData[0],sControlData[0]);
            break;
        }

        /********************************************************************/
        /* ݃f[^ƓǏof[^ƍ                             */
        /********************************************************************/
        if(sWriteData != sReadData){  /* ݃f[^ƓǏof[^قȂꍇ   */
            printf("\nData Compare Error!!\tCount %d",i+1);
            /****************************************************************/
            /* USER LED _iԐFj                                  */
            /****************************************************************/
            CCPU_SetLEDStatus(0,1);
            break;
        }
        printf(".");
    }
    printf("\n---------------- End");
    printf("\n");
}

/****************************************************************************/
/* MODULE   : MotionSFCStarting                                             */
/* ABSTRACT : AD[VSFCvON                           */
/* FUNCTION : [VCPU(2@)SFCvO(wNo.)NB      */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionSFCStarting(
    int ProgramNo)  /* N郂[VSFCvONo.(0`255)           */
{
    short   sRet;
    short   sEndBit[2];
    short   sEndStatus;

    /************************************************************************/
    /* 3bEFCg                                                          */
    /************************************************************************/
    taskDelay(60 * 3);

    /************************************************************************/
    /* [VCPU(2@)SFCvO(wNo.)̋Nv         */
    /************************************************************************/
    sRet = CCPU_DedicatedDInst("SFCS", MOTIONCPU, (short*)&ProgramNo, 1, &sEndBit[0], 2, &sEndStatus, 1, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
    if((sRet == 0)&&(sEndBit[0] == 1)&&(sEndBit[1] == 0)){
        printf("\nCCPU_DedicatedDInst:SFCS Success!!");
    }else{
        printf("\nCCPU_DedicatedDInst:SFCS Error!!\tErrorCode:%d[%04hxH]\tEndStatus:%d[%04hxH]",sRet,sRet,sEndStatus,sEndStatus);
    }
    printf("\n\tProgramNo:%hd", (short)ProgramNo);
    printf("\n");

}

/****************************************************************************/
/* MODULE   : MotionSVSTExec                                                */
/* ABSTRACT : BDT[{vOs                                  */
/* FUNCTION : [VCPU(2@)̎No.1T[{vOnB      */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionSVSTExec(
    int ProgramNo)  /* NT[{vONo.(0`4095)                 */
{
    short   sRet;
    short   sEndBit[2];
    short   sEndStatus;

    /************************************************************************/
    /* 3bEFCg                                                          */
    /************************************************************************/
    taskDelay(60 * 3);

    /************************************************************************/
    /* [VCPU(2@)̎No.1ɑ΂ăT[{vO̎nv */
    /************************************************************************/
    sRet = CCPU_DedicatedDInst("SVST", MOTIONCPU, (short*)"J1", 2, (short*)&ProgramNo, 1, &sEndBit[0], 2, &sEndStatus, 1, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
    if((sRet == 0)&&(sEndBit[0] == 1)&&(sEndBit[1] == 0)){
        printf("\nCCPU_DedicatedDInst:SVST Success!!");
    }else{
        printf("\nCCPU_DedicatedDInst:SVST Error!!\tErrorCode:%d[%04hxH]\tEndStatus:%d[%04hxH]",sRet,sRet,sEndStatus,sEndStatus);
    }
    printf("\n\tProgramNo:%hd", (short)ProgramNo);
    printf("\n");

}

/****************************************************************************/
/* MODULE   : MotionCHGAExec                                                */
/* ABSTRACT : CDݒlύXvs                                    */
/* FUNCTION : [VCPU(2@)̎No.1̌ݒlύXB              */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionCHGAExec(
    int iData)      /* ύXݒl(-2147483648`2147483647)                  */
{
    short   sRet;
    short   sEndBit[2];
    short   sEndStatus;

    /************************************************************************/
    /* 3bEFCg                                                          */
    /************************************************************************/
    taskDelay(60 * 3);

    /************************************************************************/
    /* [VCPU(2@)̎No.1̌ݒlύXv                   */
    /************************************************************************/
    sRet = CCPU_DedicatedDInst("CHGA", MOTIONCPU, (short*)"J1", 2, (short*)&iData, 2, &sEndBit[0], 2, &sEndStatus, 1, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
    if((sRet == 0)&&(sEndBit[0] == 1)&&(sEndBit[1] == 0)){
        printf("\nCCPU_DedicatedDInst:CHGA Success!!");
    }else{
        printf("\nCCPU_DedicatedDInst:CHGA Error!!\tErrorCode:%d[%04hxH]\tEndStatus:%d[%04hxH]",sRet,sRet,sEndStatus,sEndStatus);
    }
    printf("\n\tlData:%d", iData);
    printf("\n");
}

/****************************************************************************/
/* MODULE   : MotionCHGVExec                                                */
/* ABSTRACT : DDxlύXvs                                    */
/* FUNCTION : [VCPU(2@)̎No.1̑xlύXB              */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionCHGVExec(
    int iData)      /* ύXxl(-2147483647`2147483647)                  */
{
    short   sRet;
    short   sEndBit[2];
    short   sEndStatus;

    /************************************************************************/
    /* 3bEFCg                                                          */
    /************************************************************************/
    taskDelay(60 * 3);

    /************************************************************************/
    /* [VCPU(2@)̎No.1̑xlύXv                   */
    /************************************************************************/
    sRet = CCPU_DedicatedDInst("CHGV", MOTIONCPU, (short*)"J1", 2, (short*)&iData, 2, &sEndBit[0], 2, &sEndStatus, 1, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
    if((sRet == 0)&&(sEndBit[0] == 1)&&(sEndBit[1] == 0)){
        printf("\nCCPU_DedicatedDInst:CHGV Success!!");
    }else{
        printf("\nCCPU_DedicatedDInst:CHGV Error!!\tErrorCode:%d[%04hxH]\tEndStatus:%d[%04hxH]",sRet,sRet,sEndStatus,sEndStatus);
    }
    printf("\n\tlData:%d", iData);
    printf("\n");
}

/****************************************************************************/
/* MODULE   : MotionCHGTExec                                                */
/* ABSTRACT : EDgNlύXvs                              */
/* FUNCTION : [VCPU(2@)̎No.1̃gNlύXB        */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionCHGTExec(
    int iData)      /* ύXgNl(1`10000)                           */
{
    short   sRet;
    long    lData2;
    short   sEndBit[2];
    short   sEndStatus;

    /************************************************************************/
    /* 3bEFCg                                                          */
    /************************************************************************/
    taskDelay(60 * 3);

    /************************************************************************/
    /* [VCPU(2@)̎No.1̃gNlύXv             */
    /************************************************************************/
    lData2 = -1;
    sRet = CCPU_DedicatedDInst("CHGT", MOTIONCPU, (short*)"J1", 2, (short*)&iData, 2, (short*)&lData2, 2, &sEndBit[0], 2, &sEndStatus, 1, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
    if((sRet == 0)&&(sEndBit[0] == 1)&&(sEndBit[1] == 0)){
        printf("\nCCPU_DedicatedDInst:CHGT Success!!");
    }else{
        printf("\nCCPU_DedicatedDInst:CHGT Error!!\tErrorCode:%d[%04hxH]\tEndStatus:%d[%04hxH]",sRet,sRet,sEndStatus,sEndStatus);
    }
    printf("\n\tlData:%d", iData);
    printf("\n");
}
