/****************************************************************************/
/* FILE NAME       FMotionSyncInt_R12.c                                    */
/* VERSION         F1.00                                                   */
/* FUNCTION        F[VCPUƂ̃}`荞݂ɘA          */
/*                   ݏsTvvO                 */
/*                   (R12CCPU-V p)                                         */
/*                                                                          */
/*  y\z                                                                */
/*      {TvvO͉L̍\KvƂ܂B                    */
/*      _______________                                                     */
/*      |  R  | R |   |                                                     */
/*      |  1  | 1 |   |                                                     */
/*      |  2  | 6 |   |                                                     */
/*      |  C  | M |   |   1@   FiQ-R PlatformΉCRg[      */
/*      |  C  | T |   |   2@   FiQ-R PlatformΉ[VCPU          */
/*      |  P  | C |   |                                                     */
/*      |  U  | P |   |                                                     */
/*      |     | U |   |                                                     */
/*      |     |   |   |                                                     */
/*      |_____|___|___|__                                                   */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*  {TvvÓA2@CPUANZXobt@32_            */
/*  f[^iU3E1G2048`U3E1G2079j擾A擾f[^ɑΉ            */
/*  ZISRɂĎ{Ď@̃}`CPUԍʐMGA32_          */
/*  f[^iU3E0G2048`U3E0G2079jZbgvOłB              */
/*  ܂AISRɂĈƂ̂łȂ^XNɂĎ{邽߂           */
/*  Z}tH𔭍sAZ}tHM^XNISRŎ{łȂ           */
/*  {Ă܂B                                                  */
/*                                                                          */
/*  {TvvOɂēmFsۂɂ́A2@CPUɂ              */
/*  CPUANZXobt@̐܂ԂsvO𓮍삳               */
/*  B                                                              */
/*  iU3E0G2048`U3E0G2079  U3E1G2048`U3E1G2079 ̐ܕԂ                 */
/*  vO쐬āA삳ĂBj                            */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp        */
/*  ܂悤肢܂B                                      */
/*                                                                          */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxWorks.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <semLib.h>
#include    <taskLib.h>
#include    "CCPUFunc.h"

#define MULTICPUSYNCINT 45      /*}`CPUԓ荞ݔԍ:45 */
#define CCPU         0x3E0      /*CRg[:1@ */
#define MOTIONCPU    0x3E1      /*[VCPU:2@ */

/* }`ݒxpZ}tH                                       */
static SEM_ID semMotionSyncInt = NULL;

/* }`ݏ                                                     */
void MotionSyncIntISR(void);
/* }`ݒx                                                 */
void MotionSyncIntTask(void);


/****************************************************************************/
/* MODULE   : MotionSyncIntMain                                             */
/* ABSTRACT : }`荞ݏTvvO C               */
/* FUNCTION : }`荞ݏ^XNNB                      */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionSyncIntMain(void)
{
    short           sRet;

    /************************************************************************/
    /* }`ݏISRɓo^                                  */
    /************************************************************************/
    sRet = CCPU_EntryInt( MULTICPUSYNCINT, (CCPU_FUNCPTR)MotionSyncIntISR);
    /*  oXN[Y                              */
    if(sRet != 0){
        printf("CCPU_EntryInt Error!!\tErrorCode:%d[%04hxH]\n",sRet,sRet);
        return;
    }

    /************************************************************************/
    /* }`ݒxpZ}tH𐶐                         */
    /************************************************************************/
    semMotionSyncInt = semBCreate(SEM_Q_FIFO, SEM_EMPTY);
    if(semMotionSyncInt == NULL){
        return;
    }

    /************************************************************************/
    /* }`ݒxp̃^XNN                         */
    /************************************************************************/
    taskSpawn("tMSyncInt",100,0,0x1000,
                (FUNCPTR)MotionSyncIntTask,0,0,0,0,0,0,0,0,0,0);

    return;
}

/****************************************************************************/
/* MODULE   : MotionSyncIntISR                                              */
/* ABSTRACT : }`ݏ                                          */
/* FUNCTION : }`荞ݏsB                            */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionSyncIntISR(void)
{
    short           sRet;
    unsigned short  data[32];
    int             i;

    /************************************************************************/
    /* 2@CPŨ}`CPUԍʐMGA̒lǂݏo                    */
    /************************************************************************/
    sRet = CCPU_FromBuf_ISR(MOTIONCPU,2048,32,data);
    if(sRet != 0){
        CCPU_DisableInt_ISR(MULTICPUSYNCINT);
        return;
    }

    /************************************************************************/
    /* ǂݏolɑ΂ĔCӂ̉Zs                                 */
    /************************************************************************/
    for(i=0;i<32;i++)
        data[i]++;

    /************************************************************************/
    /* Zl@CPŨ}`CPUԍʐMGA֏           */
    /************************************************************************/
    sRet = CCPU_ToBuf_ISR(CCPU,2048,32,data);
    if(sRet != 0){
        CCPU_DisableInt_ISR(MULTICPUSYNCINT);
        return;
    }

    /************************************************************************/
    /* ISRɂĎ{łȂ^XNɂĎs悤                    */
    /* }`ݒxpZ}tH𔭍s                         */
    /************************************************************************/
    if((data[0] & 0x00FF) == 0){
        semGive(semMotionSyncInt);
    }

    return;
}

/****************************************************************************/
/* MODULE   : MotionSyncIntTask                                             */
/* ABSTRACT : }`ݒx                                      */
/* FUNCTION : }`荞݂Ŏ{łȂsB              */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void MotionSyncIntTask(void)
{
    short           sRet;
    STATUS          stat;
    long            velocity[4] = {0,50000,10000,25000};
    int             i;
    short           sEndBit[2];
    short           sEndStatus;

    /************************************************************************/
    /* o^}`ݏLɂ                             */
    /************************************************************************/
    sRet = CCPU_EnableInt(MULTICPUSYNCINT);
    if(sRet != 0){
        printf("CCPU_EnableInt Error!!\tErrorCode:%d[%04hxH]\n",sRet,sRet);
        return;
    }
    for(i=0;i<10000;i++){
        /********************************************************************/
        /* }`ݏZ}tHŝ҂             */
        /********************************************************************/
        stat = semTake(semMotionSyncInt,WAIT_FOREVER);
        if(stat == OK){
            /****************************************************************/
            /* ISRɂĎ{łȂC{ӏŎ{                  */
            /****************************************************************/
            sRet = CCPU_DedicatedDInst("CHGV", MOTIONCPU, (short*)"J1", 2, (short*)&velocity[i%4], 2, &sEndBit[0], 2, &sEndStatus, 1, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0);
            if((sRet == 0)&&(sEndBit[0] == 1)&&(sEndBit[1] == 0)){
                printf("CCPU_DedicatedDInst:CHGV Executed(%d[%04hxH])\t:velocity = %ld\n",sRet,sRet,velocity[i%4]);
            }
            else{
                printf("CCPU_DedicatedDInst:CHGV Error!!\tErrorCode:%d[%04hxH]\tEndStatus:%d[%04hxH]",sRet,sRet,sEndStatus,sEndStatus);
            }
        }
    }

    /************************************************************************/
    /* }`ݏISR폜                                */
    /************************************************************************/
    sRet = CCPU_EntryInt(MULTICPUSYNCINT,(CCPU_FUNCPTR)NULL);

    return;
}
