/****************************************************************************/
/* FILE NAME       FDevAccessChanCCIEC_R12.c                               */
/* VERSION         F1.00                                                   */
/* FUNCTION        FMELSECʐM֐(MD֐)TvvO(CC-Link IE)   */
/*                   (R12CCPU-V p)                                         */
/*                                                                          */
/*  CC-Link IE Rg[lbg[NoRfoCXANZX                 */
/*                                                                          */
/*  e                                                                    */
/*  CCIEC_OwnAccessRtnMain                                                */
/*    CC-Link IE Rg[lbg[N(`lNo.151Albg[N      */
/*    No.1)ǂLB20ONꍇALB30`LB3FǂݏoāA             */
/*    LW0ɏ݂܂B                                               */
/*                                                                          */
/*  CCIEC_OtherAccessRtnMain                                              */
/*    CC-Link IE Rg[lbg[N(`lNo.151Albg[N      */
/*    No.1)Aǔ2LB20`LB2FǂݏoāAD0W20֒l݂܂B */
/*                                                                          */
/*      151                                                             */
/*        ǔ 1        ǔ 2                                              */
/*        擪I/O:0x00  擪I/O:0x00                                        */
/*  _________    __________                                             */
/*  | C  |C |      |R |C |  |                                               */
/*  | C  |C |      |C |C |  |                                               */
/*  | P  |I |      |P |I |  |                                               */
/*  | U  |E |      |U |E |  |                                               */
/*  |    |C |      |  |C |  |                                               */
/*  |    |  |      |  |  |  |                                               */
/*  |____|__|__    |__|__|__|__                                             */
/*        |____________|                                                    */
/*          ȯܰNo.1   151                                            */
/*                                                                          */
/*  ylbg[N͈͊tz                                                */
/*      ________________________________                                    */
/*      |______|_LB________|_LW________|                                   */
/*      |       |           |           |                                   */
/*      | ǔ 1|  0`1F    |  0`1F    |                                   */
/*      |_______|___________|___________|                                   */
/*      |       |           |           |                                   */
/*      | ǔ 2| 20`3F    | 20`3F    |                                   */
/*      |_______|___________|___________|                                   */
/*                                                                          */
/*  ⑫FNfoCXɂ                                            */
/*  CCPU        CCIEC               CCIEC       RCPU                        */
/*              ǔ 1              ǔ 2                                  */
/*_____________    _LB/LW___           _LB/LW___   _B/W____                 */
/*|            |   |       |           |       |   |       |                */
/*|            | | 0`1F \\\\\\ 0`1F| |       |                */
/*|mdSendEx/   |   |_______|           |_______|   |_______|                */
/*|mdReceiveEx |   |       |           |       |   |       |                */
/*|            | |20`3F \\\\\\20`3F| |       |                */
/*|____________|___|_______|__         |_______|___|_______|_               */
/*                                                                          */
/*   lbg[N͈͊tŐݒ肳ꂽNfoCX́AǔԂɊ蓖       */
/*   ꂽfoCX̒lɑǂɔfB                             */
/*   ̂Ƃl CCIEC_OwnAccessRtnMain()̓B              */
/*  ECCIEC_OwnAccessRtnMain ɂfoCXlω̈                   */
/*  @ CCIECǔ2LB20ONƁAǔ1LB20ONB                    */
/*  A (ǔ1)LB20ON̂ŁATvvO͎(ǔ1)     */
/*     LB30`LB3FǏoB                                                 */
/*      (ǂLB30`LB3F͏ɋǔ2̓foCX̒lfĂ)       */
/*  B ǏoLB30`LB3F̒l[hPʂňA̒l(ǔ1)      */
/*     LW0ɏށB                                                      */
/*  C ǔ1Ɋ蓖ĂꂽfoCX(LW0)̒lω̂ł̓e       */
/*     ǂɔf邽߁Aǔ2LW0̒lωB                     */
/*                                                                          */
/*  ) B̎ɎǂłȂǔ2LW0ɑ΂ď݂sꍇAǔ2       */
/*      LW0̒lωĒɋǔ1LW0̒lf邱ƂɂȂ       */
/*      ߁AڏfoCXLW0̒l͕ωȂB                         */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp        */
/*  ܂悤肢܂B                                      */
/*                                                                          */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxWorks.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <usrLib.h>
#include    <taskLib.h>
#include    "MDFunc.h"
#include    "CCPUFunc.h"

#define OWN_STATION     0xFF    /* ǔ()                               */

#if 0
/*  L̑S𖞂ꍇ́A#if 01ɕύX                          */
/*  EANZXfoCX̃tbVp[^ݒ肠                      */
#define __LINK_REFRESH_ON__     /* NtbVɂANZX         */
#endif

/* CC-Link IE Rg[lbg[NǃANZX                      */
void CCIEC_OwnAccessRtn();
/* CC-Link IE Rg[lbg[NǃANZX                      */
void CCIEC_OtherAccessRtn();

/****************************************************************************/
/* MODULE   : CCIEC_OwnAccessRtnMain                                        */
/* ABSTRACT : CC-Link IE Rg[lbg[NǃANZX^XNN     */
/* FUNCTION : ^XNNB                                            */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CCIEC_OwnAccessRtnMain()
{
    /************************************************************************/
    /* ^XN𐶐(sp܂taskSpawngp)                            */
    /************************************************************************/
    sp((FUNCPTR)CCIEC_OwnAccessRtn, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    return;
}

/****************************************************************************/
/* MODULE   : CCIEC_OwnAccessRtn                                            */
/* ABSTRACT : CC-Link IE Rg[lbg[NǃANZX               */
/* FUNCTION : ǃANZXsB                                          */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CCIEC_OwnAccessRtn()
{
    long    lRet;
    long    lPath;
    short   sData;
    long    lSize;

    /************************************************************************/
    /* CC-Link IE Rg[lbg[Njbg1ڂI[v       */
    /************************************************************************/
#ifdef __LINK_REFRESH_ON__      /* NtbVɂANZX(oXANZXF) */
    lRet = mdOpen( 12, -1, &lPath );    /* ǃfoCXoRăANZX邽߁ARV[YoXC^tF[X(`lNo.12)I[v  */
#else
    lRet = mdOpen(151, -1, &lPath);     /* NfoCXoRăANZX邽߁ACC-Link IE Rg[lbg[Njbg(`lNo.151)I[v */
#endif
    if(lRet != 0){
        printf("\nmdOpens  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
        return;
    }

    /************************************************************************/
    /* foCXLB20ONꍇALB30`LB3F̒lǂݏoĎLW0  */
    /* ɏ݂܂                                                       */
    /************************************************************************/
    while(1){ /* [v                                                 */
        /********************************************************************/
        /* LB20ǂݏo                                               */
        /********************************************************************/
        lSize = 2;
#ifdef __LINK_REFRESH_ON__      /* NtbVɂANZX */
        lRet = mdReceiveEx(lPath, 0, OWN_STATION, DevB, 0x20, &lSize, &sData);
#else                           /* _CNgANZX   */
        lRet = CCPU_ReadLinkDevice(0x0, Dev_LB, 0x20, lSize, (unsigned short*)&sData, lSize);
#endif
        if(lRet != 0){
            printf("\nmdReceiveExs  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
            mdClose(lPath);
            return;
        }

        /********************************************************************/
        /* ǂݏoƏ                                               */
        /********************************************************************/
        if((sData & 0x0001) == 1){ /* LB20ON                          */
            /****************************************************************/
            /* LB30`LB3Fǂݏo                                     */
            /****************************************************************/
            lSize = 2;
#ifdef __LINK_REFRESH_ON__      /* NtbVɂANZX         */
            lRet = mdReceiveEx(lPath, 0, OWN_STATION, DevB, 0x30, &lSize, &sData);
#else                           /* _CNgANZX                       */
            lRet = CCPU_ReadLinkDevice(0x0, Dev_LB, 0x30, lSize, (unsigned short*)&sData, lSize);
#endif
            if(lRet != 0){
                printf("\nmdReceiveExs  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
                mdClose(lPath);
                return;
            }

            /****************************************************************/
            /* ǂݏof[^LW0ɏ                          */
            /****************************************************************/
#ifdef __LINK_REFRESH_ON__      /* NtbVɂANZX         */
            lRet = mdSendEx(lPath, 0, OWN_STATION, DevW, 0, &lSize, &sData);
#else                           /* _CNgANZX                       */
            lRet = CCPU_WriteLinkDevice(0x0, Dev_LW, 0, lSize, (unsigned short*)&sData, 0);
#endif
            if(lRet != 0){
                printf("\nmdSendExs  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
                mdClose(lPath);
                return;
            }
            break;
        }

        /********************************************************************/
        /* 1bEFCg                                                      */
        /********************************************************************/
        taskDelay(60);
    }

    /************************************************************************/
    /* ǂݏoLB30`LB3F̃f[^\                               */
    /************************************************************************/
    printf("Read Data  (LB30-LB3F) = %hd ( %hxH )\n", sData, sData);

    /************************************************************************/
    /* CC-Link IE Rg[lbg[Njbg1ڂN[Y       */
    /************************************************************************/
    mdClose(lPath);
    return; 
}


/****************************************************************************/
/* MODULE   : CCIEC_OtherAccessRtnMain                                      */
/* ABSTRACT : CC-Link IE Rg[lbg[NǃANZX^XNN     */
/* FUNCTION : ^XNNB                                            */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CCIEC_OtherAccessRtnMain()
{
    /************************************************************************/
    /* ^XN𐶐(sp܂taskSpawngp)                            */
    /************************************************************************/
    sp((FUNCPTR)CCIEC_OtherAccessRtn, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    return;
}

/****************************************************************************/
/* MODULE   : CCIEC_OtherAccessRtn                                          */
/* ABSTRACT : CC-Link IE Rg[lbg[NǃANZX               */
/* FUNCTION : ǃANZXsB                                          */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CCIEC_OtherAccessRtn()
{
    long    lRet;
    long    lPath;
    long    lStationNo = 2;   /* ǔ2                                      */
    short   sData;
    long    lSize;
    long    lNetNo = 1;       /* lbg[NNo.=1                          */
    
    /************************************************************************/
    /* CC-Link IE Rg[lbg[Njbg1(`lNo.151)   */
    /* I[v                                                         */
    /************************************************************************/
    lRet = mdOpen(151, -1, &lPath);    
    if(lRet != 0){
        printf("\nmdOpens  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
        return;
    }

    /************************************************************************/
    /* ǔ2̃foCXLB20`LB2F̒lǂݏo                              */
    /************************************************************************/
    lSize = 2;
    lRet = mdReceiveEx(lPath, lNetNo, lStationNo, DevLB(lNetNo), 0x20, &lSize, &sData);
    if(lRet != 0){
        printf("\nmdReceiveExs  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏof[^ǔ2(ǗCPU)D0ɏ                       */
    /************************************************************************/
    lRet = mdSendEx(lPath, lNetNo, lStationNo, DevD, 0, &lSize, &sData);
    if(lRet != 0){
        printf("\nmdSendEx(D)s  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏof[^ǔ2(ǗCPU)W20ɏ                      */
    /************************************************************************/
    lRet = mdSendEx(lPath, lNetNo, lStationNo, DevW, 0x20, &lSize, &sData);
    if(lRet != 0){
        printf("\nmdSendEx(W)s  lRet = %hd ( %hxH )\n", (short)lRet, (short)lRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏoLB20`LB2F\                                       */
    /************************************************************************/
    printf("Read Data (LB20-LB2F) = %hd ( %hxH )\n", sData, sData);

    /************************************************************************/
    /* CC-Link IE Rg[lbg[Njbg1(`lNo.151)   */
    /* N[Y                                                         */
    /************************************************************************/
    mdClose(lPath);
    return;
}
