/****************************************************************************/
/* FILE NAME       FDevAccessChanCCL_R12.c                                 */
/* VERSION         F1.00                                                   */
/* FUNCTION        FMELSECʐM֐(MD֐)TvvO(CC-Link)      */
/*                   (R12CCPU-V p)                                         */
/*                                                                          */
/*  CC-LinkoRfoCXANZX                                             */
/*                                                                          */
/*  e                                                                    */
/*  CC_OwnAccessRtnMain                                                   */
/*    CC-Link(`lNo.81)ǂRX0ONꍇARX10`RX1F         */
/*    ǂݏoāARY10`RY1Fɏ݂܂B                            */
/*                                                                          */
/*  CC_OtherAccessRtnMain                                                 */
/*    CC-Link(`lNo.81)Aǔ1RX0`RXFǂݏoD0           */
/*    RY0`RYF֒l݂܂B                                          */
/*                                                                          */
/*                                                                          */
/*     81                                                               */
/*      }X^        [J                                          */
/*      ǔ 0          ǔ 1(4ǐL)                                     */
/*      擪I/O:0x00    擪I/O:0x00                                        */
/*  _________    __________                                             */
/*  | C  |C |      |R |C |  |                                               */
/*  | C  |C |      |C |C |  |                                               */
/*  | P  |L |      |P |L |  |                                               */
/*  | U  |i |      |U |i |  |                                               */
/*  |    |n |      |  |n |  |                                               */
/*  |    |k |      |  |k |  |                                               */
/*  |____|__|__    |__|__|__|__                                             */
/*        |____________|                                                    */
/*        81                                                            */
/*                                                                          */
/*  ⑫FNfoCXɂ                                            */
/*       CC-Link̋ǔ1(4ǐL)Ɋ蓖ĂRXERY޲͈̔͂        */
/*       0`7Fł(*1)B                                                  */
/*       L\ɂRXERY̊֌W}ɎB                         */
/*                                                                          */
/*  CCPU        CC-Link             CC-Link     RCPU                        */
/*              }X^            [J                              */
/*              ǔ 0              ǔ 1(4ǐL)                         */
/*  ____________    _RX______           _RY______   _(޲)_              */
/*  |           |   |       |           |       |   |       |               */
/*  |           | | 0`7F \\\\\\ 0`7F| |       |               */
/*  |mdSendEx/  |   |_______|           |_______|   |       |               */
/*  |mdReceiveEx|   |       |           |       |   |       |               */
/*  |           |   _RY_____|           _RX_____|   |       |               */
/*  |           |   |       |           |       |   |       |               */
/*  |           | | 0`7F \\\\\\ 0`7F| |       |               */
/*  |___________|___|_______|           |_______|___|_______|__             */
/*                                                                          */
/*  *1  }X^ǁ[Jǂ̌Mł́AŌ2rbg(ł́A        */
/*      7E7F)gpł܂B                                           */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp        */
/*  ܂悤肢܂B                                      */
/*                                                                          */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxWorks.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <usrLib.h>
#include    <taskLib.h>
#include    "MDFunc.h"

#define OWN_STATION     0xFF    /* ǔ()                               */

/* CC-LinkǃANZX                                                  */
void CC_OwnAccessRtn();
/* CC-LinkǃANZX                                                  */
void CC_OtherAccessRtn();

/****************************************************************************/
/* MODULE   : CC_OwnAccessRtnMain                                           */
/* ABSTRACT : CC-LinkǃANZX^XNN                             */
/* FUNCTION : ^XNNB                                            */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CC_OwnAccessRtnMain()
{
    /************************************************************************/
    /* ^XN𐶐(sp܂taskSpawngp)                            */
    /************************************************************************/
    sp((FUNCPTR)CC_OwnAccessRtn, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    return;
}

/****************************************************************************/
/* MODULE   : CC_OwnAccessRtn                                               */
/* ABSTRACT : CC-LinkǃANZX                                       */
/* FUNCTION : ǃANZXsB                                          */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CC_OwnAccessRtn()
{
    short   sRet;
    long    lPath;
    short   sData;
    long    lSize;

    /************************************************************************/
    /* CC-Linkjbg1ڂI[v                                   */
    /************************************************************************/
    sRet = mdOpen(12, -1, &lPath);    /* CeWFg@\jbgobt@oRăANZX邽߁ARV[YoXC^tF[X(`lNo.12)I[v  */
    if(sRet != 0){
        printf("\nmdOpens  sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }

    /************************************************************************/
    /* RX0ONꍇARX10`RX1F̒lǂݏoĎ              */
    /* RY10`RY1Fɏ݂܂                                             */
    /************************************************************************/
    while(1){  /* [v                                                */
        /********************************************************************/
        /* RX0ǂݏo                                                */
        /********************************************************************/
        lSize = 2;  /* CeWFg@\jbgobt@oRŃANZX */
        sRet = mdReceiveEx(lPath,0, OWN_STATION, DevSPG(0), 0xE0, &lSize, &sData);
        if(sRet != 0){
            printf("\nmdReceiveExs  sRet = %hd ( %hxH )\n", sRet, sRet);
            mdClose(lPath);
            return;
        }

        /********************************************************************/
        /* ǂݏoƏ                                               */
        /********************************************************************/
        if((sData & 0x0001) == 1){  /* RX0ON                          */
            /****************************************************************/
            /* RX10`RX1Fǂݏo                                     */
            /****************************************************************/
            lSize = 2;  /* CeWFg@\jbgobt@oRŃANZX */
            sRet = mdReceiveEx(lPath,0, OWN_STATION, DevSPG(0), 0xE1, &lSize, &sData);
            if(sRet != 0){
                printf("\nmdReceiveExs  sRet = %hd ( %hxH )\n", sRet, sRet);
                mdClose(lPath);
                return;
            }

            /****************************************************************/
            /* ǂݏof[^RY10`RY1Fɏ                   */
            /****************************************************************/
            /* CeWFg@\jbgobt@oRŃANZX  */
            sRet = mdSendEx(lPath, 0, OWN_STATION, DevSPG(0), 0x161, &lSize, &sData);
            if(sRet != 0){
                printf("\nmdSendExs  sRet = %hd ( %hxH )\n", sRet, sRet);
                mdClose(lPath);
                return;
            }
            break;
        }

        /********************************************************************/
        /* 1bEFCg                                                      */
        /********************************************************************/
        taskDelay(60);
    }

    /************************************************************************/
    /* ǂݏoRX10`RX1F̃f[^\                               */
    /************************************************************************/
    printf("Read Data  (RX10-RX1F) = %hd ( %hxH )\n", sData, sData);

    /************************************************************************/
    /* CC-Linkjbg1ڂN[Y                                   */
    /************************************************************************/
    mdClose(lPath);
    return; 
}

/****************************************************************************/
/* MODULE   : CC_OtherAccessRtnMain                                         */
/* ABSTRACT : CC-LinkǃANZX^XNN                             */
/* FUNCTION : ^XNNB                                            */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CC_OtherAccessRtnMain()
{
    /************************************************************************/
    /* ^XN𐶐(sp܂taskSpawngp)                            */
    /************************************************************************/
    sp((FUNCPTR)CC_OtherAccessRtn, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    return;
}

/****************************************************************************/
/* MODULE   : CC_OtherAccessRtn                                             */
/* ABSTRACT : CC-LinkǃANZX                                       */
/* FUNCTION : ǃANZXsB                                          */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CC_OtherAccessRtn()
{
    short   sRet;
    long    lPath;
    short   sData;
    long    lSize;
    long    lStationNo = 1;   /* ǔ1                                      */

    /************************************************************************/
    /* CC-Linkjbg1(`lNo.81)I[v                    */
    /************************************************************************/
    sRet = mdOpen(81, -1, &lPath);
    if(sRet != 0){
        printf("\nmdOpens  sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }

    /************************************************************************/
    /* ǔ1RX0`RXF̒lǂݏo                                        */
    /************************************************************************/
    lSize = 2;  /* CeWFg@\jbgobt@oRŃANZX */
    sRet = mdReceiveEx(lPath, 0, lStationNo, DevSPG(0), 0xE0, &lSize, &sData);
    if(sRet != 0){
        printf("\nmdReceiveExs  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏof[^ǔ1(ǗCPU)D0ɏ                       */
    /************************************************************************/
    sRet = mdSendEx(lPath, 0, lStationNo, DevD, 0, &lSize, &sData);
    if(sRet != 0){
        printf("\nmdSendEx(D)s  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏof[^ǔ1RY0`RYFɏ                          */
    /************************************************************************/
#if 1       /* RYtbVfoCXݒȂCeWFg@\jbgobt@oRŃANZX */
    sRet = mdSendEx(lPath, 0, lStationNo, DevSPG(0), 0x160, &lSize, &sData);
#else       /* RYtbVfoCXݒ肠(RYM0)                     */
    sRet = mdSendEx(lPath, 0, lStationNo, DevM, 0, &lSize, &sData);
#endif
    if(sRet != 0){
        printf("\nmdSendEx(RY)s  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏoRX0`RXF\                                         */
    /************************************************************************/
    printf("Read Data (RX0-RXF) = %hd ( %hxH )\n", sData, sData); 

    /************************************************************************/
    /* CC-Linkjbg1(`lNo.81)N[Y                    */
    /************************************************************************/
    mdClose(lPath);
    return;
}
