/****************************************************************************/
/* FILE NAME       FDevAccessChanRBF_R12.c                                 */
/* VERSION         F1.00                                                   */
/* FUNCTION        FMELSECʐM֐(MD֐)TvvO(CPUoX)      */
/*                   (R12CCPU-V p)                                         */
/*                                                                          */
/*  CPUoXoRfoCXANZX                                             */
/*                                                                          */
/*  e                                                                    */
/*  CPU_BusAccessRtnMain                                                  */
/*    RV[YoXC^tF[X(`lNo.12)ɂă}`CPU\       */
/*    1@CPUD0ǂݏoāAD1ɏM0ON܂B                  */
/*    ̌M0`M15AD0AD1CPUL(SPB1)ǂݏo܂B        */
/*                                                                          */
/*      ____________                                                        */
/*      |R | C  |  |                                                        */
/*      |C | C  |  |                                                        */
/*      |P | P  |  |                                                        */
/*      |U | U  |  |                                                        */
/*      |  |    |  |                                                        */
/*      |  |    |  |                                                        */
/*      |__|____|__|__                                                      */
/*        |_|                                                               */
/*           12                                                         */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp        */
/*  ܂悤肢܂B                                      */
/*                                                                          */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxWorks.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <usrLib.h>
#include    <taskLib.h>
#include    "MDFunc.h"

#define OWN_STATION     0xFF    /* ǔ()                               */

/* RV[YoXC^tF[X                                          */
void CPU_BusAccessRtn();

/****************************************************************************/
/* MODULE   : CPU_BusAccessRtnMain                                          */
/* ABSTRACT : RV[YoXC^tF[X^XNN                     */
/* FUNCTION : ^XNNB                                            */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CPU_BusAccessRtnMain()
{
    /************************************************************************/
    /* ^XN𐶐(sp܂taskSpawngp)                            */
    /************************************************************************/
    sp((FUNCPTR)CPU_BusAccessRtn, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    return;
}

/****************************************************************************/
/* MODULE   : CPU_BusAccessRtn                                              */
/* ABSTRACT : RV[YoXC^tF[X                               */
/* FUNCTION : RV[YoXC^tF[X̏sB                     */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void CPU_BusAccessRtn()
{
    short   sRet;
    long    lPath;
    short   sData;
    long    lSize;
    long    plDev[7];
    short   psBuf[3];

    /************************************************************************/
    /* RV[YoXC^tF[XI[v                            */
    /************************************************************************/
    sRet = mdOpen(12, -1, &lPath); 
    if(sRet != 0){
        printf("\nmdOpens  sRet = %hd ( %hxH )\n", sRet, sRet);
        return;
    }

    /************************************************************************/
    /* CPU1@̃foCXD0̒lǂݏo                                   */
    /************************************************************************/
    lSize = 2;
    sRet = mdReceiveEx(lPath, 0, 1, DevD, 0, &lSize, &sData);
    if(sRet != 0){
        printf("\nmdReceiveEx(D0)s  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏof[^D0lD1ɏ                                   */
    /************************************************************************/
    sRet = mdSendEx(lPath, 0, 1, DevD, 1, &lSize, &sData);
    if(sRet != 0){
        printf("\nmdSendExs  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* M0ON                                                           */
    /************************************************************************/
    sRet = mdDevSetEx(lPath, 0, 1, DevM, 0);
    if(sRet != 0){
        printf("\nmdDevSetExs  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* M0`M15AD0AD1̒lǂݏo                                        */
    /************************************************************************/
    plDev[0] = 2;     /*ubN                                          */
    plDev[1] = DevM;  /*ubNNo.1̃foCX^Cv                        */
    plDev[2] = 0;     /*ubNNo.1̐擪foCXNo.                       */
    plDev[3] = 16;    /*ubNNo.1̓Ǐo_                            */
    plDev[4] = DevD;  /*ubNNo.2̃foCX^Cv                        */
    plDev[5] = 0;     /*ubNNo.2̐擪foCXNo.                       */
    plDev[6] = 2;     /*ubNNo.2̓Ǐo_                            */
    sRet = mdRandREx(lPath, 0, 1, plDev, psBuf, 6);
    if(sRet != 0){
        printf("\nmdRandRExs  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* CPU1@CPUL(SPB1)ǂݏo                              */
    /************************************************************************/
    sRet = mdReceiveEx(lPath, 0, OWN_STATION, DevSPB1, 0, &lSize, &sData);
    if(sRet != 0){
        printf("\nmdReceiveExs  sRet = %hd ( %hxH )\n", sRet, sRet);
        mdClose(lPath);
        return;
    }

    /************************************************************************/
    /* ǂݏoM0`M15AD0AD1̃f[^\                          */
    /************************************************************************/
    printf("M0-M15    = %hd ( %hxH )\n", psBuf[0], psBuf[0]);
    printf("D0        = %hd ( %hxH )\n", psBuf[1], psBuf[1]);
    printf("D1        = %hd ( %hxH )\n", psBuf[2], psBuf[2]);

    /************************************************************************/
    /* ǂݏoCPUL\                                    */
    /************************************************************************/
    printf("SPB1 0000 = %hd ( %hxH )\n", sData, sData);

    /************************************************************************/
    /* RV[YoXC^tF[XN[Y                            */
    /************************************************************************/
    mdClose(lPath);
    return;
}
