/****************************************************************************/
/* FILE NAME       FFTPGet_R12.c                                           */
/* VERSION         F1.00                                                   */
/* FUNCTION        FPCT[o(FTPT[o)FTPʐMsTvvO   */
/*                   (R12CCPU-V p)                                         */
/*                                                                          */
/*  Tvj                                                                  */
/*  PCT[o(FTPT[o)vOt@C_E[hA^XN     */
/*  AN܂B                                                      */
/*  āACRg[jbgFTPT[oɃt@C̑Ms    */
/*  ܂B                                                                  */
/*                                                                          */
/*  j                                                                  */
/*  PD{TvvOQoutt@C쐬ĂB       */
/*  1)FTPGet.out iTvvOspj                               */
/*  2)Demo1.out i_E[hpB1)̃t@CRs[At@C̖O  */
/*                ύXč쐬ĂBj                              */
/*                                                                          */
/*  QD_E[hpt@CFTPT[oɒuĂB                 */
/*  ݒ胂j^c[I/Otݒŋ󂫃Xbg0_ɐݒ肵ĂB  */
/*                                                                          */
/*  菇j                                                                  */
/*  STARTUPt@Cňȉ̊֐^XNƂĐNĂB         */
/*                                                                          */
/*  STARTUP.CMD̗j(SDJ[hɒu܂)                                   */
/*  1)SDJ[hgp                                                        */
/*      ld(1,0,"/2/FTPGet.out")                                             */
/*      taskSpawn("initsk", 150, 0, 8192, func, 0)                          */
/*                                                                          */
/*  2)RAMfBXNgp                                                     */
/*      ld(1,0,"/2/FTPGet.out")                                             */
/*      taskSpawn("initsk_RAM", 150, 0, 8192, func_ram, 1024*2)             */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp        */
/*  ܂悤肢܂B                                      */
/*                                                                          */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/
#include    <vxworks.h>
#include    <stdio.h>
#include    <ftpLib.h>
#include    <stat.h>
#include    <usrLib.h>
#include    <loadLib.h>
#include    <ioLib.h>
#include    <symLib.h>
#include    <string.h>
#include    <selectLib.h>
#include    <dosFsLib.h>
#include    <xbdRamDisk.h>
#include    "CCPUFunc.h"

#define RAM_DRV_NAME    "/RAMDISK"  /* RAMfBXN(C)                  */

extern  SYMTAB_ID       sysSymTbl;  /* V{(֐)                     */

/* RAMfBXN쐬                                                      */
int ramMake(int iBlockSize);        /* MakeRAMDisk_ModeEx.c                 */
/* ^XNNmFp                                                     */
void vY_Output1(void);
/* FTPANZX(RAMfBXN쐬)                                         */
void func_ram(int iBlockSize);
/* FTPANZX                                                          */
void func(int iFlg);
/* FTPt@C擾                                                      */
int tcpFileGet(int iFlg);
/* FTPt@CM                                                      */
void tcpFilePut(int iFlg);

/****************************************************************************/
/* MODULE   : ramMake                                                       */
/* ABSTRACT : RAMfBXN쐬                                           */
/* FUNCTION : w肳ꂽubNRAMfBXN쐬B                 */
/* NOTE     : Ȃ                                                          */
/* RETURN   :                                                               */
/*            0        I                                             */
/*            0ȊO   G[                                                */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
int ramMake(
    int iBlockSize)       /* RAMfBXÑubN                          */
{
    int             iRamDiskSize;
    device_t        stxbdId;

    /************************************************************************/
    /* RAMfBXN̍쐬                                                    */
    /************************************************************************/
    iRamDiskSize = (512 * iBlockSize);  /* RAMfBXÑTCY              */

    /************************************************************************/
    /* RAMfBXN(foCX)쐬                                          */
    /************************************************************************/
    stxbdId = (device_t)(BLK_DEV*)xbdRamDiskDevCreate(512, iRamDiskSize, 0, RAM_DRV_NAME);
    if(stxbdId == NULLDEV) {
        goto ERROR_EXIT;
    }

    /************************************************************************/
    /* t@CVXe̍\z                                               */
    /************************************************************************/
    /* RAM disk̃tH[}bg                                               */
    dosFsVolFormat(RAM_DRV_NAME, (DOS_OPT_BLANK | DOS_OPT_QUIET), NULL);

    return OK;

/****************************************************************************/
/* G[I                                                           */
/****************************************************************************/
ERROR_EXIT:
    printf("\nramMake ERROR: iBlockSize=%d\n", iBlockSize);
    return ERROR;
}

/****************************************************************************/
/* MODULE   : vY_Output1                                                    */
/* ABSTRACT : ^XNNmFp                                          */
/* FUNCTION : Y0`YF1bɃCNg܂B                         */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void vY_Output1()
{
    short           sRet;
    unsigned short  pusData[1];

    /************************************************************************/
    /*  Y0`YF1bɃCNg                                   */
    /************************************************************************/
    pusData[0] = 0;
    while(1){   /* [v                                               */
        /********************************************************************/
        /* Y0`YF̒l                                             */
        /********************************************************************/
        sRet = CCPU_Y_Out_WordEx(0, 0, 1, pusData, 0);
        if(sRet != 0){
            printf("CCPU_Y_Out_WordExs sRet = %hd ( %hxH )\n", sRet, sRet);
            break;
        }

        /********************************************************************/
        /* o̓f[^CNg                                   */
        /********************************************************************/
        pusData[0]++;

        /********************************************************************/
        /* 1bEFCg                                                      */
        /********************************************************************/
        taskDelay(60);
    }

    return;
}

/****************************************************************************/
/* MODULE   : func_ram                                                      */
/* ABSTRACT : FTPANZX(RAMfBXN쐬)                              */
/* FUNCTION : RAMfBXN쐬܂B                                     */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void func_ram(
    int iBlockSize)    /* RAMfBXÑubN                           */
{
    int sRet;

    /************************************************************************/
    /* RAMfBXN쐬                                                */
    /************************************************************************/
    sRet = ramMake(iBlockSize);
    if(sRet != OK) {
        return;
    }

    /************************************************************************/
    /* RAMfBXNgpăeXgs                                    */
    /************************************************************************/
    func(1);
}

/****************************************************************************/
/* MODULE   : func                                                          */
/* ABSTRACT : FTPANZX                                               */
/* FUNCTION : t@C̎MA^XNNAt@C̑Ms܂B        */
/* NOTE     : Ȃ                                                          */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void func(
    int iFlg)   /* t@Cۑ(0:SDA0ȊO:RAMfBXN)              */
{
    STATUS      stStatus= OK;
    int         iResult; 
    MODULE_ID   stModuleId;
    SYMBOL_DESC stSymbolDesc;

    /************************************************************************/
    /*  FTPT[ot@C擾CCPUɕۑ                   */
    /************************************************************************/
    if(tcpFileGet(iFlg) != OK) {
        return;
    }

    /************************************************************************/
    /* 擾vOt@CCRg[jbg              */
    /* [NRAMɃ[h                                                */
    /*  (:FTPT[õt@CDemo1.out̏ꍇ)                       */
    /************************************************************************/
    if(iFlg != 0) { /* RAMfBXNgp                                      */
        /* RAMfBXN"/RAMDISK"                                          */
        stModuleId = (MODULE_ID)ld(1,0,(char*)"/RAMDISK/Demo1.out");
    } else {       /* SDJ[hgp                                          */
        stModuleId = (MODULE_ID)ld(1,0,(char*)"/2/Demo1.out");
    }

    /************************************************************************/
    /* W[[hɎs璆f                                     */
    /************************************************************************/
    if(stModuleId == NULL){
        return;
    }

    /************************************************************************/
    /* ォ烍[hW[ivOt@Cj̃V{(֐) */
    /* ł邽߁AV{擾Ă^XNN             */
    /************************************************************************/
    memset (&stSymbolDesc, 0, sizeof(SYMBOL_DESC));
    stSymbolDesc.mask = SYM_FIND_BY_NAME;
    stSymbolDesc.name = "vY_Output1";
    stStatus = symFind( sysSymTbl, &stSymbolDesc );
    if(stStatus == OK) {
      iResult = taskSpawn((char *)"TaskName1", (int)150, (int)0, (int)1024, (FUNCPTR)stSymbolDesc.value, 0,0,0,0,0,0,0,0,0,0);
    }

    /************************************************************************/
    /*  CCPUFTPT[oփt@C𑗐M                           */
    /************************************************************************/
    tcpFilePut(iFlg);
}

/****************************************************************************/
/* MODULE   : tcpFileGet                                                    */
/* ABSTRACT : FTPt@C擾                                           */
/* FUNCTION : FTPŃt@C擾B                                     */
/* NOTE     : s̓G[LED_B                                 */
/* RETURN   :                                                               */
/*            0        I                                             */
/*            0ȊO   G[                                                */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
int tcpFileGet(
    int iFlg)   /* t@Cۑ(0:SDA0ȊO:RAMfBXN)              */
{
    /************************************************************************/
    /* PCT[ołFTPT[o@\삵Ă邱ƂOƂĂ܂B    */
    /* FTPT[oIPAhXA[UApX[hAAJEg͓KXύX  */
    /* Kv܂B                                                     */
    /* ȂAmFFTPT[õt[\tg(Tiny FTP Deamon/95)+XP Progp */
    /* Ă܂B                                                         */
    /************************************************************************/

    int     iCtrlSock;
    int     iDataSock;
    char    pcBuf [2048];
    int     iNByte = -1;
    STATUS  stStatus= OK;
    FILE*   pFd;
    short   sRet;
    int     i;
    int     iNRet;
    fd_set  st_fdset_r;
    struct timeval  stTimeout;

    /************************************************************************/
    /* FTP]Jn3܂ŃgC                                 */
    /************************************************************************/
    for(i=0; i<3; i++) {                                 /* ő3JԂ */
        /********************************************************************/
        /* FTP]Jn                                                */
        /* FTPR}hiL"RETR̓t@C擾̃R}h"j͎gpFTP */
        /* T[odlɍ킹ĉ                                       */
        /********************************************************************/
        if (ftpXfer ("192.168.3.3", "target", "password", "",
                "RETR %s", "", "Demo1.out",  /* Demo1.out擾t@C */
            &iCtrlSock, &iDataSock) == ERROR) {
            /* Cӂ̃\Pbg쐬łȂA܂͐ڑmłȂꍇ   */
            /****************************************************************/
            /* OFTPT[oTCPڑmRlNVcĂ     */
            /* ^CAEgG[łɗ܂B                           */
            /****************************************************************/

            /* gC                                                     */
            continue;   
        } else { /* \Pbg̍쐬Aڑ̊m                        */
            /* gC𔲂                                             */
            break;
        }
    }

    /************************************************************************/
    /* gCR{G[^[                             */
    /************************************************************************/
    if(i >= 3) {    /* gC3ځH                                      */
        /* USER LED_iԐFj                                             */
        sRet = CCPU_SetLEDStatus(0, 1);
        /* G[^[                                                   */
        return ERROR;
    }
    /* ȌA擾datasockett@C̓e𕪊擾             */

    /************************************************************************/
    /* CRg[jbg̕ۑpt@Cw肵ăI[v    */
    /************************************************************************/
    if(iFlg != 0) {             /* RAMfBXNgp                          */
        pFd = fopen("/RAMDISK/Demo1.out","wb");
    } else {                    /* SDJ[hgp                             */
        pFd = fopen("/2/Demo1.out","wb");
    }

    /************************************************************************/
    /* t@CI[viFTPŃt@C擾j                    */
    /************************************************************************/
    if(pFd != 0) {
        FD_ZERO(&st_fdset_r);
        FD_SET(iDataSock,&st_fdset_r);
        stTimeout.tv_sec = 30;
        stTimeout.tv_usec = 0;
        do{
            iNRet = select(iDataSock+1,&st_fdset_r,NULL,NULL,&stTimeout);
            if((iNRet == 0) || (iNRet == ERROR)){
                stStatus = ERROR;
                break;
            }
            iNByte = read (iDataSock, pcBuf, sizeof (pcBuf));
            if(iNByte <= 0){
                break;
            }
            if(iNByte > fwrite(pcBuf, 1, iNByte, pFd)){
                stStatus = ERROR;
                break;
            }
        }while(1);
        fclose(pFd);
    } else {
        stStatus = ERROR;
    }
    close (iDataSock);

    /************************************************************************/
    /*  Ǐos̓G[                                                */
    /************************************************************************/
    if (iNByte < 0) { 
        stStatus = ERROR;
    }

    /************************************************************************/
    /* FTPʐM̊mF                                              */
    /************************************************************************/
    if (ftpReplyGet (iCtrlSock, TRUE) != FTP_COMPLETE) {
        stStatus = ERROR;
    }

    /************************************************************************/
    /* FTPR}hM  --FTPʐM̃OAEgAؒf--                       */
    /************************************************************************/
    if (ftpCommand (iCtrlSock, "QUIT", 0, 0, 0, 0, 0, 0) != FTP_COMPLETE) {
        stStatus = ERROR;
    }
    close (iCtrlSock);

    /************************************************************************/
    /* 탊^[                                                         */
    /************************************************************************/
    if(stStatus == OK) {
        return OK;
    }

    /************************************************************************/
    /* G[USER LEDᑬ_ŁiԐFj                               */
    /************************************************************************/
    sRet = CCPU_SetLEDStatus(0, 2);     /* USER LEDᑬ_ŁiԐFj         */
    return ERROR;                       /* G[^[                   */
}

/****************************************************************************/
/* MODULE   : tcpFilePut                                                    */
/* ABSTRACT : FTPt@CM                                           */
/* FUNCTION : FTPŃt@C𑗐MB                                     */
/* NOTE     : s̓G[LED_B                                 */
/* RETURN   : Ȃ                                                          */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
void tcpFilePut(
    int iFlg)   /* t@Cۑ(0:SDA0ȊO:RAMfBXN)              */
{
    /************************************************************************/
    /* PCT[ołFTPT[o@\삵Ă邱ƂOƂĂ܂B    */
    /* FTPT[oIPAhXA[UApX[hAAJEg͓KXύX  */
    /* Kv܂B                                                     */
    /* ȂAmFFTPT[õt[\tg(Tiny FTP Deamon/95)+XP Progp */
    /* Ă܂B                                                         */
    /************************************************************************/

    int     iCtrlSock;
    int     iDataSock;
    char    pcBuf [2048];
    int     iNByte = 0;
    STATUS  stStatus= OK;
    FILE*   pFd;
    short   sRet;
    int     i;

    /************************************************************************/
    /* FTP]Jn3܂ŃgC                                 */
    /************************************************************************/
    for(i=0; i<3; i++) {                            /* ő3JԂ      */
        /********************************************************************/
        /* FTP]Jn                                                */
        /* FTPR}hiL"STOR̓t@C̑MR}h"j͎gp    */
        /* FTPT[odlɍ킹ĉB                                  */
        /* (FDemo1_copy.outƂt@CFTPT[o֑M܂)      */
        /********************************************************************/
        if (ftpXfer ("192.168.3.3", "target", "password", "",
            "STOR %s", "", "Demo1_copy.out", /* Demo1_copy.outFTPT[oɂ̖O CꑤŎw   */
            &iCtrlSock, &iDataSock) == ERROR) {
            /* Cӂ̃\Pbg쐬łȂA܂͐ڑmłȂꍇ   */
            /* gC                                                     */
            continue;   
        } else { /* \Pbg̍쐬Aڑ̊m                        */
            /* gC𔲂                                             */
            break;
        }
    }

    /************************************************************************/
    /* gCR{G[^[                             */
    /************************************************************************/
    if(i >= 3) {
        sRet = CCPU_SetLEDStatus(0, 1);     /* USER LED_iԐFj         */
        return;                             /* G[^[               */
    }
    /* ȌA擾datasockett@C̓e𕪊M             */

    /************************************************************************/
    /* CRg[jbg̑Mpt@Cw肵ăI[v    */
    /************************************************************************/
    if(iFlg != 0) {         /* RAMfBXNgp                              */
        pFd = fopen("/RAMDISK/Demo1.out","rb");
    } else {                /* SDJ[hgp                                 */
        pFd = fopen("/2/Demo1.out","rb");
    }

    /************************************************************************/
    /* t@C𑗐M                                                   */
    /************************************************************************/
    if(pFd == NULL) {       /* Mt@CI[vs                     */
        stStatus = ERROR;
    }else{                  /* Mt@CI[v                     */
        /********************************************************************/
        /* PUTt@Ce                                          */
        /********************************************************************/
        while ((iNByte = fread( pcBuf, 1, sizeof (pcBuf), pFd)) > 0)
        {
            if(write(iDataSock, pcBuf, iNByte)== ERROR)
            {
                stStatus = ERROR;
                break;
            }
        }
        fclose(pFd);
    }
    close (iDataSock);

    /************************************************************************/
    /*  Ǐos                                                        */
    /************************************************************************/
    if (iNByte < 0) {
        stStatus = ERROR;
    }

    /************************************************************************/
    /* FTPʐM̊mF                                              */
    /************************************************************************/
    if (ftpReplyGet (iCtrlSock, TRUE) != FTP_COMPLETE) {
        stStatus = ERROR;
    }

    /************************************************************************/
    /* FTPR}hM  --FTPʐM̃OAEgAؒf--                       */
    /************************************************************************/
    if (ftpCommand (iCtrlSock, "QUIT", 0, 0, 0, 0, 0, 0) != FTP_COMPLETE) {
        stStatus = ERROR;
    }
    close (iCtrlSock);

    /************************************************************************/
    /* G[USER LEDᑬ_ŁiԐFj                               */
    /************************************************************************/
    if(stStatus == ERROR) {
        sRet = CCPU_SetLEDStatus(0, 2);    /* USER LEDᑬ_ŁiԐFj */
    }
}
