/****************************************************************************/
/* FILE NAME       FMakeRAMDisk_R12.c                                      */
/* VERSION         F1.00                                                   */
/* FUNCTION        FRAMfBXN쐬TvvO                */
/*                   (R12CCPU-V p)                                         */
/*                                                                          */
/*  CRg[jbgSYSTEMROMINCLUDEtH_               */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[            */
/*  rhĂB                                                    */
/*                                                                          */
/*  TvvÔgpɊւẮAql̐ӔCɂ              */
/*  gp܂悤肢܂B                                */
/*                                                                          */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION           */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxworks.h>
#include    <stdio.h>
#include    <dosFsLib.h>
#include    <xbdRamDisk.h>

#define RAM_DRV_NAME    "/RAMDISK"  /* RAMfBXN(C)                  */

/* RAMfBXN쐬                                                      */
int ramMake(int iBlockSize);

/****************************************************************************/
/* MODULE   : ramMake                                                       */
/* ABSTRACT : RAMfBXN쐬                                           */
/* FUNCTION : w肳ꂽubNRAMfBXN쐬B                 */
/* NOTE     : {֐͈ɍ쐬RAMfBXÑubNw肵       */
/*            gpĂB                                            */
/*            RAMfBXÑTCY                                         */
/*            ww肵ubN ~ 512byte(bytesPerBlk)x  ƂȂ܂B  */
/*            ܂A쐬RAMfBXN̓I[v\ȃt@C     */
/*            10 (MaxFileNumŎw)łB                                   */
/*                                                                          */
/*            call functions -                                              */
/*                xbdRamDiskDevCreate = RAMfBXN̍쐬                   */
/*                dosFsVolFormat      = DOSt@CVXeł̃tH[}bg */
/* RETURN   :                                                               */
/*            0        I                                             */
/*            0ȊO   G[                                                */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
int ramMake(
    int iBlockSize)         /* RAMfBXÑubN                        */
{
    int             iRamDiskSize;
    device_t        stxbdId;
    
    /************************************************************************/
    /* RAMfBXN̍쐬                                                    */
    /************************************************************************/
    iRamDiskSize = (512 * iBlockSize);  /* RAMfBXÑTCY              */
    /************************************************************************/
    /* RAMfBXN(foCX)쐬                                          */
    /************************************************************************/
    stxbdId = (device_t)(BLK_DEV*)xbdRamDiskDevCreate(512, iRamDiskSize, 0, RAM_DRV_NAME);
    if(stxbdId == NULLDEV) {
        goto ERROR_EXIT;
    }

    /************************************************************************/
    /* t@CVXe̍\z                                               */
    /************************************************************************/
    /* RAM disk̃tH[}bg                                               */
    dosFsVolFormat(RAM_DRV_NAME, (DOS_OPT_BLANK | DOS_OPT_QUIET), NULL);
    return OK;

/****************************************************************************/
/* G[I                                                           */
/****************************************************************************/
ERROR_EXIT:
    printf("\nramMake ERROR: iBlockSize=%d\n", iBlockSize);
    return ERROR;
}
