/********************************************************************************/
/* FILE NAME       FRD75Status_R12.c                                           */
/* VERSION         F1.00                                                       */
/* FUNCTION        Fʒu߃jbgǏoăVbgj^         */
/*                   (R12CCPU-V p)                                             */
/*                                                                              */
/*  {vO͈ȉ̓eʒu߃jbgǏoăVbg          */
/*  j^TvvOłB                                          */
/*                                                                              */
/*  {vO͈ȉ̈ʒu߃jbgɑΉĂ܂BȊO        */
/*    ʒu߃jbg֎gpł܂̂łӂB                      */
/*                                                                              */
/*  Ήʒu߃jbg                                                      */
/*  RD75P**                                                                     */
/*  RD75D**                                                                     */
/*                                                                              */
/*  Vbgj^e                                                    */
/*    @茻ݒl                                                              */
/*    AݒliRD75M܂RD75MH̏ꍇ̂݁j                                 */
/*    BG[ԍ                                                            */
/*    C[jOԍ                                                        */
/*    DXe[^X                                                              */
/*    ET[{Xe[^XiRD75M܂RD75MH̏ꍇ̂݁j                         */
/*                                                                              */
/*  CRg[jbgSYSTEMROMINCLUDEtH_                   */
/*  CCPUFunc.hMDFunc.h擾AC:\WindRiver\INCLUDEɊi[                */
/*  rhĂB                                                        */
/*                                                                              */
/*  TvvÔgpɊւẮAql̐ӔCɂĂgp            */
/*  ܂悤肢܂B                                          */
/*                                                                              */
/* CREATED         F2014/10/22   MITSUBISHI ELECTRIC CORPORATION               */
/*                                                                              */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED       */
/********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "CCPUFunc.h"

/********************************************************************************/
/* 1̊eItZbgAhX                                                    */
/********************************************************************************/
#define CURRENT_FEED_VAL    800 /* Md.20  茻ݒl̃obt@            */
#define AXSIS_ERR_NO        806 /* Md.23  G[ԍ̃obt@          */
#define AXSIS_WARNING_NO    807 /* Md.24  [jOԍ̃obt@      */
#define STATUS              817 /* Md.31  Xe[^X̃obt@            */
#define REAL_CURRENT_VAL    850 /* Md.101 ݒl̃obt@              */
#define SERVO_STATUS        877 /* Md.108 T[{Xe[^X̃obt@      */

/********************************************************************************/
/* 1()̃ItZbgTCY                                            */
/********************************************************************************/
#define AXIS_OFSET_SIZE     100

/********************************************************************************/
/* ʒu߃jbg`                                                         */
/********************************************************************************/
#define UNITTYPE_RD75P        0 /* ʒu߃jbg` RD75P                   */
#define UNITTYPE_RD75D        1 /* ʒu߃jbg` RD75D                   */
#define UNITTYPE_RD75M        2 /* ʒu߃jbg` RD75M                   */
#define UNITTYPE_RD75MH       3 /* ʒu߃jbg` RD75MH                  */

/*  RD75Xe[^Xj^[`                                                */
short RD75Status( unsigned short usIoNo, short sType);

/********************************************************************************/
/* MODULE   : RD75Status                                                        */
/* ABSTRACT : RD75Xe[^Xj^[`                                      */
/* FUNCTION : ʒu߃jbg̃Vbgj^                              */
/* NOTE     : sType ɂ͈ȉw肵ĂB                                */
/*               ʒu߃jbg`                                           */
/*                 0:RD75P                                                      */
/*                 1:RD75D                                                      */
/*                 2:RD75M                                                      */
/*                 3:RD75MH                                                     */
/* RETURN   :                                                                   */
/*            0        I                                                 */
/*            0ȊO    ُI                                                 */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                     */
/* UPDATE   :                                                                   */
/********************************************************************************/
short RD75Status(
     unsigned short usIoNo,             /*  (I)擪I/ONo.(:0x20)              */
     short sType)                       /*  (I)ʒu߃jbg`             */
{
    short               sRet;           /* ֐̖߂l                         */
    unsigned long       ulOffset;       /* obt@̃ItZbg           */
    unsigned long       ulSize;         /* ǂݏo[h                     */
    unsigned short      pusDataBuf[2];  /* ǂݏof[^                       */
    unsigned long       ulBufSize;      /* f[^i[GApusDataBuf̃TCY   */
    short               sLoop;          /* [vpϐ                         */

    /****************************************************************************/
    /* Ǐof[^i[ϐ 4                                               */
    /****************************************************************************/
    long                plCurrentFeedVal[4]; /* 茻ݒl                      */
    long                plRealCurrentVal[4]; /* ݒl                        */
    unsigned short      pusAxisErrNo[4];     /* G[ԍ                      */
    unsigned short      pusAxisWarningNo[4]; /* [jOԍ                  */
    unsigned short      pusStatus[4];        /* Xe[^X                      */
    unsigned short      pusServoStatus[4];   /* T[{Xe[^X                */

    /****************************************************************************/
    /* ʒu߃jbg`͈̓`FbN                                     */
    /****************************************************************************/
    if( (sType < UNITTYPE_RD75P) || (sType > UNITTYPE_RD75MH) ){
        printf("RD75 Unit type error\n");
        return 1;
    }

    /****************************************************************************/
    /* Md.20 茻ݒl̓Ǐo                                                 */
    /****************************************************************************/
    ulOffset = CURRENT_FEED_VAL;        /* 茻ݒl̃ItZbgAhX       */
    ulSize = 2;                         /* Ǐo[hTCY                   */
    ulBufSize = 2;                      /* Ǐoobt@TCY                 */
    for (sLoop = 0 ; sLoop < 4 ; sLoop++ ){ /* 4̓Ǐos              */
        sRet = CCPU_FromBuf(usIoNo / 16, ulOffset, ulSize, pusDataBuf, ulBufSize);
        
        if(sRet != 0){                  /*  ǂݏoG[̏ꍇ                */
            printf("CCPU_FromBuf Error Md.20 [ret = %hd]\n", sRet);
            return sRet;
        }
        plCurrentFeedVal[sLoop] = (long)(pusDataBuf[0] + (pusDataBuf[1] << 16)); /* 茻ݒlϐɊi[   */
        ulOffset += AXIS_OFSET_SIZE;    /* 1̃ItZbgTCYZ              */
    }

    /****************************************************************************/
    /* Md.23 G[ԍ̓Ǐo                                               */
    /****************************************************************************/
    ulOffset = AXSIS_ERR_NO;            /* G[ԍ̃ItZbgAhX     */
    ulSize = 1;                         /* Ǐo[hTCY                   */
    ulBufSize = 1;                      /* Ǐoobt@TCY                 */
    for (sLoop = 0 ; sLoop < 4 ; sLoop++ ){ /* 4̓Ǐos              */
        sRet = CCPU_FromBuf(usIoNo / 16, ulOffset, ulSize, pusDataBuf, ulBufSize);
        if(sRet != 0){                  /*  ǂݏoG[̏ꍇ                */
            printf("CCPU_FromBuf Error Md.23 [ret = %hd]\n", sRet);
            return sRet;
        }
        pusAxisErrNo[sLoop] = pusDataBuf[0];/* G[ԍϐɊi[         */
        ulOffset += AXIS_OFSET_SIZE;    /* 1̃ItZbgTCYZ  */
    }

    /****************************************************************************/
    /* Md.24 [jOԍ̓Ǐo                                           */
    /****************************************************************************/
    ulOffset = AXSIS_WARNING_NO;        /* [jOԍ̃ItZbgAhX */
    ulSize = 1;                         /* Ǐo[hTCY                   */
    ulBufSize = 1;                      /* Ǐoobt@TCY                 */
    for (sLoop = 0 ; sLoop < 4 ; sLoop++ ){ /* 4̓Ǐos              */
        sRet = CCPU_FromBuf(usIoNo / 16, ulOffset, ulSize, pusDataBuf, ulBufSize);
        if(sRet != 0){                  /*  ǂݏoG[̏ꍇ                */
            printf("CCPU_FromBuf Error Md.24 [ret = %hd]\n", sRet);
            return sRet;
        }
        pusAxisWarningNo[sLoop] = pusDataBuf[0];/* [jOԍϐɊi[ */
        ulOffset += AXIS_OFSET_SIZE;    /* 1̃ItZbgTCYZ  */
    }

    /****************************************************************************/
    /* Md.31 Xe[^X̓Ǐo                                                 */
    /****************************************************************************/
    ulOffset = STATUS;                  /* Xe[^X̃ItZbgAhX       */
    ulSize = 1;                         /* Ǐo[hTCY                   */
    ulBufSize = 1;                      /* Ǐoobt@TCY                 */
    for (sLoop = 0 ; sLoop < 4 ; sLoop++ ){ /* 4̓Ǐos              */
        sRet = CCPU_FromBuf(usIoNo / 16, ulOffset, ulSize, pusDataBuf, ulBufSize);
        if(sRet != 0){                  /*  ǂݏoG[̏ꍇ                */
            printf("CCPU_FromBuf Error Md.31 [ret = %hd]\n", sRet);
            return sRet;
        }
        pusStatus[sLoop] = pusDataBuf[0];   /* Xe[^XϐɊi[           */
        ulOffset += AXIS_OFSET_SIZE;    /* 1̃ItZbgTCYZ  */
    }

    /****************************************************************************/
    /* RD75M܂RD75MHw肵Ăꍇ́AݒlAT[{Xe[^X      */
    /* ǂݏo                                                                 */
    /****************************************************************************/
    if( (sType == UNITTYPE_RD75M) || (sType == UNITTYPE_RD75MH) ){  /* RD75M or RD75MH  */
        /************************************************************************/
        /* Md.101 ݒl̓Ǐo                                              */
        /************************************************************************/
        ulOffset = REAL_CURRENT_VAL;    /* ݒl̃ItZbgAhX         */
        ulSize = 2;                     /* Ǐo[hTCY                   */
        ulBufSize = 2;                  /* Ǐoobt@TCY                 */
        for (sLoop = 0 ; sLoop < 4 ; sLoop++ ){ /* 4̓Ǐos          */
            sRet = CCPU_FromBuf(usIoNo / 16, ulOffset, ulSize, pusDataBuf, ulBufSize);
            if(sRet != 0){              /*  ǂݏoG[̏ꍇ                */
                printf("CCPU_FromBuf Error Md.101 [ret = %hd]\n", sRet);
                return sRet;
            }
            plRealCurrentVal[sLoop] = (long)(pusDataBuf[0] + (pusDataBuf[1] << 16));  /* ݒlϐɊi[ */
            ulOffset += AXIS_OFSET_SIZE;    /* 1̃ItZbgTCYZ          */
        }

        /************************************************************************/
        /* Md.108 T[{Xe[^X̓Ǐo                                      */
        /************************************************************************/
        ulOffset = SERVO_STATUS;        /* T[{Xe[^X̃ItZbgAhX */
        ulSize = 1;                     /* Ǐo[hTCY                   */
        ulBufSize = 1;                  /* Ǐoobt@TCY                 */
        for (sLoop = 0 ; sLoop < 4 ; sLoop++ ){ /* 4̓Ǐos          */
            sRet = CCPU_FromBuf(usIoNo / 16, ulOffset, ulSize, pusDataBuf, ulBufSize);
            if(sRet != 0){              /*  ǂݏoG[̏ꍇ                */
                printf("CCPU_FromBuf Error Md.108 [ret = %hd]\n", sRet);
                return sRet;
            }
            pusServoStatus[sLoop] = pusDataBuf[0];  /* T[{Xe[^XϐɊi[ */
            ulOffset += AXIS_OFSET_SIZE;    /* 1̃ItZbgTCYZ  */
        }
    } 

    /****************************************************************************/
    /* e\                                                         */
    /****************************************************************************/
    printf("/****************************************************************************/\n");
    printf("/************      RD75[I/O No.%3hXh] Information                  **********/\n",usIoNo);
    printf("/****************************************************************************/\n");     

    /****************************************************************************/
    /* No.\                                                                */
    /****************************************************************************/
    printf("%35s%14s%14s%14s\n", "Axis1", "Axis2", "Axis3", "Axis4");

    /****************************************************************************/
    /* Md.20 茻ݒl                                                         */
    /****************************************************************************/
    printf("CurrentFeedVal[Md.20 ]");
    printf("%13ld%14ld%14ld%14ld\n", plCurrentFeedVal[0], plCurrentFeedVal[1], plCurrentFeedVal[2], plCurrentFeedVal[3]);

    /****************************************************************************/
    /*  RD75M܂RD75MHw肵Ăꍇ́Aݒl\               */
    /****************************************************************************/
    if( (sType == UNITTYPE_RD75M) || (sType == UNITTYPE_RD75MH) ){  /* RD75M or RD75MH  */
        /************************************************************************/
        /* Md.101 ݒl                                                      */
        /************************************************************************/
        printf("RealCurrentVal[Md.101]");
        printf("%13ld%14ld%14ld%14ld\n", plRealCurrentVal[0], plRealCurrentVal[1], plRealCurrentVal[2], plRealCurrentVal[3]);
    }

    /****************************************************************************/
    /* Md.23 G[ԍ                                                       */
    /****************************************************************************/
    printf("AxisErrNo     [Md.23 ]");
    printf("%13u%14u%14u%14u\n", pusAxisErrNo[0], pusAxisErrNo[1], pusAxisErrNo[2], pusAxisErrNo[3]);

    /****************************************************************************/
    /* Md.24 [jOԍ                                                   */
    /****************************************************************************/
    printf("AxisWarningNo [Md.24 ]");
    printf("%13u%14u%14u%14u\n", pusAxisWarningNo[0], pusAxisWarningNo[1], pusAxisWarningNo[2], pusAxisWarningNo[3]);

    /****************************************************************************/
    /* Md.31 Xe[^X                                                     */
    /****************************************************************************/
    printf("Status        [Md.31 ]");
    printf("%7s0x%04hX%8s0x%04hX%8s0x%04hX%8s0x%04hX \n", "", pusStatus[0], "", pusStatus[1], "", pusStatus[2], "", pusStatus[3]);

    /****************************************************************************/
    /*  RD75M܂RD75MHw肵Ăꍇ́AT[{Xe[^X\       */
    /****************************************************************************/
    if( (sType == UNITTYPE_RD75M) || (sType == UNITTYPE_RD75MH) ){  /* RD75M or RD75MH  */
        /************************************************************************/
        /* Md.108 T[{Xe[^X                                          */
        /************************************************************************/
        printf("ServoStatus   [Md.108]");
        printf("%7s0x%04hX%8s0x%04hX%8s0x%04hX%8s0x%04hX\n\n", "", pusServoStatus[0], "", pusServoStatus[1], "", pusServoStatus[2], "", pusServoStatus[3]);
    }

    return EXIT_SUCCESS;
}
