#include "Common.h"
#include "GC_GUIScreen.h"
#include "GAction.h"
#ifdef WIN32
#include "windows.h"
#endif
#include "stdio.h"
#include "gbutton.h"
#include <time.h>


static void ReadCsvFile_Operate(char* pFileName);
static void ReadCsvFile_Error(char* pFileName);
static void ReadCsvFile_Device(char* pFileName);
static void SetOldErrSts(void);
static GUInt16 FindCtrlID(GUInt16 usCtrlID);

void InitProfile(void)
{
	/*엚֘At@C*/
	//ReadCsvFile_Operate(NULL);
	READ_RECODE(g_pRecodeHeader_Operate, OPERATE_HISTORY_HEADER, OPERATE_HISTORY_NODE, OPEPATE_HISTORY_FILE_NAME);
	/*G[Ǘ֘At@C*/
	ReadCsvFile_Error(NULL);
	READ_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_HEADER, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);
	SetOldErrSts();
	SetNowErrNode();
	/*MOfoCX֘At@C*/
	ReadCsvFile_Device(NULL);
	READ_RECODE(g_pRecodeHeader_Device, DEVICE_HISTORY_HEADER, DEVICE_HISTORY_NODE, DEVIVE_HISTORY_FILE_NAME);
}


GUInt8 CheckOperateLevel(void *pSelf, GUInt8 ucLevel)
{
	GUInt8 ucResult = G_TRUE;

	/*݂̃xA̕ȋ\x艺*/
	if (ucLevel > g_ucPermitLevel)
	{
		ucResult = G_FALSE;
		/*G[bZ[W\*/
		memset(g_szErrorMsg, 0, sizeof(g_szErrorMsg));
		sprintf(g_szErrorMsg, "Ǘx%dȏŃOCĂB", ucLevel);
		GActScreenOpenWindow( pSelf, SHOWGWINDOW_MESSAGE );	
	}

	return ucResult;
}

void CompareOperateTime(void)
{
	g_afterTimeSecondTotal = 0;
}

void GetDateInfo(DATE_INFO* pDate)
{
#ifdef WIN32
	SYSTEMTIME	localtime;
	GetLocalTime(&localtime);

	pDate->usYear	= localtime.wYear;
	pDate->usMonth	= localtime.wMonth;
	pDate->usDay		= localtime.wDay;
#else
	struct timespec ts_val;
	struct tm *pstlocaltime;
	  
	clock_gettime( CLOCK_REALTIME, &ts_val );
	pstlocaltime = localtime( &(ts_val.tv_sec) );
	
	pDate->usYear	= pstlocaltime->tm_year + 1900;
	pDate->usMonth	= pstlocaltime->tm_mon + 1;
	pDate->usDay	= pstlocaltime->tm_mday;
#endif
}

void GetTimeInfo(TIME_INFO* pTime)
{
#ifdef WIN32
	SYSTEMTIME	localtime;
	GetLocalTime(&localtime);

	pTime->usHour	= localtime.wHour;
	pTime->usMinute	= localtime.wMinute;
	pTime->usSecond	= localtime.wSecond;
#else
	struct timespec ts_val;
	struct tm *pstlocaltime;
	  
	clock_gettime( CLOCK_REALTIME, &ts_val );
	pstlocaltime = localtime( &(ts_val.tv_sec) );
		
	pTime->usHour	= pstlocaltime->tm_hour;
	pTime->usMinute	= pstlocaltime->tm_min;
	pTime->usSecond	= pstlocaltime->tm_sec;
#endif
}

void ReadCsvFile_Error(char* pFileName)
{
	ERROE_CSV_NODE*		pNode;
	FILE*				f;
	int					nErrIndex;
	int					nErrLevel;
	int					nErrCode;
	int					nStrID;

	f = fopen(ERROR_CSV_FILE_NAME, "r");
	if (NULL == f)
	{
		return;
	}

	/*G[CSVobt@wb_[*/
	g_pCsvHeader_Error = (ERROR_CSV_HEADER*)malloc(sizeof(ERROR_CSV_HEADER));
	g_pCsvHeader_Error->pTop = NULL;
	g_pCsvHeader_Error->pTail = NULL;
	
	while(EOF != fscanf(f, "%d,%d,%x,%d", &nErrIndex, &nErrLevel, &nErrCode, &nStrID))
	{
		pNode = (ERROE_CSV_NODE*)malloc(sizeof(ERROE_CSV_NODE));
		pNode->pNext = NULL;
		pNode->pErrCsv.ucErrIndex = nErrIndex;
		pNode->pErrCsv.usErrCode = nErrCode;
		pNode->pErrCsv.ucErrLevel = nErrLevel;
		pNode->pErrCsv.usStrID = nStrID;

		ADD_NODE_ONEWAY(g_pCsvHeader_Error, pNode);
	}

	fclose(f);
}

void ReadCsvFile_Device(char* pFileName)
{
	DEVICE_CSV_NODE*		pNode;
	FILE*					f;
	int						nGdbID;

	f = fopen(DEVICE_CSV_FILE_NAME, "r");
	if (NULL == f)
	{
		return;
	}

	/*MOfoCXCSVobt@wb_[*/
	g_pCsvHeader_Device = (DEVICE_CSV_HEADER*)malloc(sizeof(DEVICE_CSV_HEADER));
	g_pCsvHeader_Device->pTop = NULL;
	g_pCsvHeader_Device->pTail = NULL;

	while(1 == fscanf(f, "%d,", &nGdbID))
	{
		pNode = (DEVICE_CSV_NODE*)malloc(sizeof(DEVICE_CSV_NODE));
		pNode->pNext = NULL;
		pNode->usGdbID = nGdbID;
		ADD_NODE_ONEWAY(g_pCsvHeader_Device, pNode);
	}

	fclose(f);
}

/*{^̕𑀍엚ɕ\*/
void DoOperate(GUInt16 usCtrlID, void *pSelf)
{
	GButton				*pButton;
	OPERATE_HISTORY_NODE *pNode;

	pButton = (GButton*)GWGetVmt(GPanel_VMT, pSelf)->GetChild(pSelf, usCtrlID);
	/*엚pm[h쐬*/
	pNode = (OPERATE_HISTORY_NODE*)malloc(sizeof(OPERATE_HISTORY_NODE));
	pNode->pNext = NULL;
	pNode->pPrev = NULL;
	pNode->data.usStrID = GWGetVmt(GButton_VMT, pButton)->GetStringID(pButton);
	GetDateInfo(&(pNode->data.date));
	GetTimeInfo(&(pNode->data.time));
	/*NXgɒǉ*/
	PUSH_RECODE(g_pRecodeHeader_Operate, pNode, OPERATE_HISTORY_NODE, RECODE_COUNT_MAX_OPERATE);
	WRITE_RECODE(g_pRecodeHeader_Operate, OPERATE_HISTORY_NODE, OPEPATE_HISTORY_FILE_NAME);
}

/*鎞AÕG[(/)ǂݏo*/
void SetOldErrSts(void)
{
	ERROR_HISTORY_NODE	*pNode;

	memset(g_gdbOldErrList, 0, sizeof(g_gdbOldErrList));
	
	pNode = g_pRecodeHeader_Error->pTop;
	while(NULL != pNode)
	{
		g_gdbOldErrList[pNode->data.ucErrIndex] = pNode->data.ucErrSts;
		pNode = pNode->pNext;
	}
}

/*G[*/
void TriggerError(GUInt8 ucErrIndex)
{
	ERROE_CSV_NODE*		pCsvNode;
	ERROR_HISTORY_NODE*	pHistoryNode;	

	pCsvNode = IsMonitorError(ucErrIndex);
	if (NULL != pCsvNode)
	{
		/*G[i[m[hp*/
		pHistoryNode = (ERROR_HISTORY_NODE*)malloc(sizeof(ERROR_HISTORY_NODE));
		memset(pHistoryNode, NUM_INIT_0, sizeof(ERROR_HISTORY_NODE));
		pHistoryNode->pNext = NULL;
		pHistoryNode->pPrev = NULL;
		pHistoryNode->data.usErrCode = pCsvNode->pErrCsv.usErrCode;
		pHistoryNode->data.ucErrLevel = pCsvNode->pErrCsv.ucErrLevel;
		pHistoryNode->data.usStrID = pCsvNode->pErrCsv.usStrID;
		pHistoryNode->data.ucErrIndex = pCsvNode->pErrCsv.ucErrIndex;
		pHistoryNode->data.ucErrSts = ERROR_STS_TRIGGER;
		GetDateInfo(&(pHistoryNode->data.date));
		GetTimeInfo(&(pHistoryNode->data.timeTrigger));
		/*Oobt@ɒǉ*/
		PUSH_RECODE(g_pRecodeHeader_Error, pHistoryNode, ERROR_HISTORY_NODE, RECODE_COUNT_MAX_ERROR);
		/*t@Cɏ*/
		WRITE_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);
		/*ݔG[L*/
		g_pNowErrNode = pHistoryNode;
	}
}

void RepairError(GUInt8 ucErrIndex)
{
	ERROE_CSV_NODE*		pCsvNode;
	ERROR_HISTORY_NODE*	pHistoryNode;	

	pCsvNode = IsMonitorError(ucErrIndex);
	if (NULL != pCsvNode)
	{
		pHistoryNode = GetRepairNode(ucErrIndex);
		if (NULL != pHistoryNode)
		{
			/*Ԃǉ*/
			pHistoryNode->data.ucErrSts = ERROR_STS_REPAIR;
			GetTimeInfo(&(pHistoryNode->data.timeRepair));
			/*G[ꂽꍇ*/
			if (pHistoryNode == g_pNowErrNode)
			{
				// ̎ɐVG[\
				SetNowErrNode();
			}
		}
		/*t@Cɏ*/
		WRITE_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);
	}
}

ERROE_CSV_NODE* IsMonitorError(GUInt8 ucErrIndex)
{
	ERROE_CSV_NODE*		pNode;

	pNode = g_pCsvHeader_Error->pTop;
	
	while(pNode)
	{
		if (pNode->pErrCsv.ucErrIndex == ucErrIndex)
		{
			return pNode;
		}
		pNode = pNode->pNext;
	}

	return NULL;
}

ERROR_HISTORY_NODE* GetRepairNode(GUInt8 ucErrIndex)
{
	ERROR_HISTORY_NODE*		pNode;

	pNode = g_pRecodeHeader_Error->pTop;
	
	while(pNode)
	{
		if (pNode->data.ucErrIndex == ucErrIndex)
		{
			return pNode;
		}
		pNode = pNode->pNext;
	}

	return NULL;
}

GInt8 CompareTime(ERROR_HISTORY_NODE *pNode, ERROR_HISTORY_NODE *pNextNode)
{
	GInt8 nResult;

	if (pNode->data.date.usYear > pNextNode->data.date.usYear)
	{
		nResult = NUM_DATA_1;
	}
	else if (pNode->data.date.usYear < pNextNode->data.date.usYear)
	{
		nResult = NUM_NEGATIVE_1;
	}
	/*Yeervł*/
	else
	{
		if (pNode->data.date.usMonth > pNextNode->data.date.usMonth)
		{
			nResult = NUM_INIT_1;
		}
		else if (pNode->data.date.usMonth < pNextNode->data.date.usMonth)
		{
			nResult = NUM_NEGATIVE_1;
		}
		/*vł*/
		else
		{
			if (pNode->data.date.usDay > pNextNode->data.date.usDay)
			{
				nResult = NUM_INIT_1;
			}
			else if (pNode->data.date.usMonth < pNextNode->data.date.usMonth)
			{
				nResult = NUM_NEGATIVE_1;
			}
			/*vł*/
			else{
				if (pNode->data.timeTrigger.usHour > pNextNode->data.timeTrigger.usHour)
				{
					nResult = NUM_INIT_1;
				}
				else if (pNode->data.timeTrigger.usHour < pNextNode->data.timeTrigger.usHour)
				{
					nResult = NUM_NEGATIVE_1;
				}
				/*vł*/
				else
				{
					if (pNode->data.timeTrigger.usMinute > pNextNode->data.timeTrigger.usMinute)
					{
						nResult = NUM_INIT_1;
					}
					else if (pNode->data.timeTrigger.usMinute < pNextNode->data.timeTrigger.usMinute)
					{
						nResult = NUM_NEGATIVE_1;
					}
					/*vł*/
					else
					{
						if (pNode->data.timeTrigger.usSecond > pNextNode->data.timeTrigger.usSecond)
						{
							nResult = NUM_INIT_1;
						}
						else
						{
							nResult = NUM_NEGATIVE_1;
						}
					}
				}
			}
		}
	}

	return nResult;
}

void GetNowErrString(GTCHAR *pErrString)
{
	if (NULL != g_pNowErrNode)
	{
		/*ݔG[*/
		sprintf(pErrString, ERROR_STRING_FORMAT_TRIGGER, g_pNowErrNode->data.ucErrLevel, 
									g_pNowErrNode->data.date.usYear, g_pNowErrNode->data.date.usMonth, g_pNowErrNode->data.date.usDay,
									g_pNowErrNode->data.timeTrigger.usHour, g_pNowErrNode->data.timeTrigger.usMinute, g_pNowErrNode->data.timeTrigger.usSecond, 
									g_pNowErrNode->data.usErrCode, GRCLoadString(g_pNowErrNode->data.usStrID));
	}
}

void SetNowErrNode(void)
{
	ERROR_HISTORY_NODE *pNode;
	g_pNowErrNode = g_pRecodeHeader_Error->pTop;
	/*G[݂*/
	if (NULL != g_pNowErrNode)
	{
		pNode = g_pRecodeHeader_Error->pTop->pNext;
		/*G[̒ňԐVm[hT*/
		while(NULL != pNode)
		{
			if (ERROR_STS_TRIGGER == pNode->data.ucErrSts)
			{
				if (0 > CompareTime(g_pNowErrNode, pNode))
				{
					g_pNowErrNode = pNode;
				}
			}
			pNode = pNode->pNext;
		}

		/*G[Ȃ*/
		if (ERROR_STS_REPAIR == g_pNowErrNode->data.ucErrSts)
		{
			g_pNowErrNode = NULL;
		}

	}
}