#ifndef _COMMON_H_
#define _COMMON_H_

#include <genifa.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
#define	OPEPATE_HISTORY_FILE_NAME			"OperateHistory.log"
#define	ERROR_HISTORY_FILE_NAME				"ErrorHistory.log"
#define	DEVIVE_HISTORY_FILE_NAME			"LoggingDevice.log"
#define	ERROR_CSV_FILE_NAME					"ErrorInfo.csv"
#define	DEVICE_CSV_FILE_NAME				"LoggingDevice.csv"
#define	PASSWORD_CSV_FILE_NAME				"PasswordInfo.csv"
#define	RECIPE_FILE_NAME					"Recipe"
#else
#define	OPEPATE_HISTORY_FILE_NAME			"/ROM/OperateHistory.log"
#define	ERROR_HISTORY_FILE_NAME				"/ROM/ErrorHistory.log"
#define	DEVIVE_HISTORY_FILE_NAME			"/ROM/LoggingDevice.log"
#define	ERROR_CSV_FILE_NAME					"/ROM/ErrorInfo.csv"
#define	DEVICE_CSV_FILE_NAME				"/ROM/LoggingDevice.csv"
#define	PASSWORD_CSV_FILE_NAME				"/ROM/PasswordInfo.csv"
#define	RECIPE_FILE_NAME					"/ROM/Recipe"
#endif

#define	LOGGING_DEVICE_MAX					16
#define	LOGGING_DATA_CYCLE					60*60*1000
#define	MONITOR_ERROR_COUNT_MAX				50
#define	RECODE_COUNT_MAX_ERROR				100
#define	RECODE_COUNT_MAX_OPERATE			100
#define	RECODE_COUNT_MAX_DEVICE				100

#define	CHECK_HOLD_TIME_FREQUENCY			1000
#define	CHECK_HOLD_FIVE_MINUTE				300
#define ERROR_STRING_FORMAT_TRIGGER			"\t\t\t%d\t\t\t\t\t\t\t\t\t%d/%02d/%02d\t\t\t%02d:%02d:%02d\t\t\t\t\t\t%04X\t\t\t\t\t\t%s"
#define ERROR_STRING_FORMAT_REPAIR			"\t\t\t%d\t\t\t\t\t\t\t\t\t%d/%02d/%02d\t\t\t%02d:%02d:%02d\t\t\t\t\t\t%04X\t\t\t\t\t\t%s\t\t\t\t\t\t\t\t\t\t\t\t%02d:%02d:%02d"

#define NUM_INIT_0							0
#define NUM_INIT_1							1
#define NUM_INIT_2							2
#define NUM_INIT_3							3
#define NUM_INIT_4							4
#define NUM_INIT_5							5
#define NUM_INIT_6							6
#define NUM_INIT_7							7
#define NUM_INIT_8							8
#define NUM_INIT_9							9
#define NUM_INIT_10							10
#define NUM_INIT_11							11
#define NUM_INIT_12							12
#define NUM_INIT_13							13
#define NUM_INIT_14							14
#define NUM_INIT_15							15
#define NUM_INIT_16							16
#define NUM_INIT_17							17
#define NUM_INIT_18							18
#define NUM_INIT_19							19
#define NUM_INIT_20							20

#define NUM_FLG_0							0
#define NUM_FLG_1							1
#define NUM_FLG_2							2
#define NUM_FLG_3							3
#define NUM_FLG_4							4
#define NUM_FLG_5							5
#define NUM_FLG_6							6
#define NUM_FLG_8							8
#define NUM_FLG_10							10
#define NUM_FLG_11							11
#define NUM_FLG_23							23
#define NUM_FLG_24							24
#define NUM_FLG_47							47
#define NUM_FLG_58							58
#define NUM_FLG_64							64
#define NUM_FLG_71							71
#define NUM_FLG_96							96
#define NUM_FLG_103							103
#define NUM_FLG_32768						32768

#define NUM_STATUS_0						0
#define NUM_STATUS_1						1
	
#define NUM_NEGATIVE_1						-1
#define NUM_NEGATIVE_32769					-32769

#define NUM_DATA_0							0
#define NUM_DATA_1							1
#define NUM_DATA_2							2
#define NUM_DATA_10							10
#define NUM_DATA_90							90
#define NUM_DATA_99							99
#define NUM_DATA_100						100
#define NUM_DATA_1900						1900

#define NUM_KEY_0							0
#define NUM_KEY_1							1
#define NUM_KEY_2							2
#define NUM_KEY_3							3
#define NUM_KEY_4							4
#define NUM_KEY_5							5
#define NUM_KEY_6							6
#define NUM_KEY_7							7
#define NUM_KEY_8							8
#define NUM_KEY_9							9
#define NUM_KEY_10							10
#define NUM_KEY_11							11
#define NUM_KEY_12							12
#define NUM_KEY_13							13
#define NUM_KEY_14							14
#define NUM_KEY_15							15

#define NUM_BUFF_0							0
#define NUM_BUFF_1							1
#define NUM_BUFF_4							4
#define NUM_BUFF_5							5
#define NUM_BUFF_8							8
#define NUM_BUFF_9							9
#define NUM_BUFF_10							10
#define NUM_BUFF_18							18*2
#define NUM_BUFF_40							40
#define NUM_BUFF_128						128

#define NUM_TIMER_100						100
#define NUM_TIMER_1500						1500

#define NUM_MOVE_1							1
#define NUM_MOVE_2							2
#define NUM_MOVE_18							18
#define NUM_MOVE_19							19
#define NUM_MOVE_20							20
#define NUM_MOVE_21							21
#define NUM_MOVE_22							22
#define NUM_MOVE_23							23
#define NUM_MOVE_24							24
#define NUM_MOVE_25							25
#define NUM_MOVE_26							26
#define NUM_MOVE_27							27
	
#define NUM_MOD_2							2
#define NUM_MOD_6							6
#define NUM_MOD_10							10
#define NUM_MOD_18							18
	
//#define Lebel_1							1
//#define Lebel_2							2
//#define Lebel_3							3

#define NUM_POINT_630						630

#define NUM_DRAW_90							90
#define NUM_DRAW_120						120
#define NUM_DRAW_150						150
#define NUM_DRAW_180						180
#define NUM_DRAW_210						210
#define NUM_DRAW_240						240
#define NUM_DRAW_270						270
#define NUM_DRAW_300						300
#define NUM_DRAW_330						330
#define NUM_DRAW_630						630
#define NUM_DRAW_665						665
#define NUM_DRAW_700						700
#define NUM_DRAW_735						735
#define NUM_DRAW_770						770
#define NUM_DRAW_805						805
#define NUM_DRAW_840						840
#define NUM_DRAW_875						875
#define NUM_DRAW_910						910
#define NUM_DRAW_945						945
#define NUM_DRAW_950						950

#define	ERROR_STS_REPAIR			0
#define	ERROR_STS_TRIGGER			1

#define	SIGNAL_OFF					0
#define	SIGNAL_ON					1

#define	DEVICE_TYPE_MT				1	/*蓮*/
#define	DEVICE_TYPE_AT				0	/**/


#define	ADD_NODE_ONEWAY(header, node)		\
{											\
	if (NULL == header->pTop)				\
	{										\
		header->pTop = node;				\
	}										\
	else									\
	{										\
		header->pTail->pNext = node;		\
	}										\
											\
	header->pTail = node;					\
}

#define	ADD_NODE_BOTHWAY(header, node)		\
{											\
	if (NULL == header->pTop)				\
	{										\
		header->pTop = node;				\
	}										\
	else									\
	{										\
		node->pPrev = header->pTail;		\
		header->pTail->pNext = node;		\
	}										\
	header->pTail = node;					\
	header->ucCount += 1;					\
}

#define	WRITE_RECODE(header, type, fname)							\
{																	\
	FILE* f;														\
	type* pNode;													\
	/* ̃t@CeNA */									\
	f = fopen(fname, "wb+");										\
	if (NULL != f)													\
	{																\
		/* t@C擪ɃR[h */					\
		fwrite(&(header->ucCount), sizeof(header->ucCount), 1, f);	\
		pNode = header->pTop;										\
		while(pNode)												\
		{															\
			/*R[h*/							\
			fwrite(&(pNode->data), sizeof(pNode->data), 1, f);		\
			pNode = pNode->pNext;									\
		}															\
		fclose(f);													\
	}																\
}

#define	READ_RECODE(header, header_type, node_type, fname)			\
{																	\
	node_type* pNode;												\
	GUInt8	ucCount;												\
	GUInt8	ucIndex;												\
	FILE*	f;														\
	/* Xgwb_[̏ */									\
	header = (header_type*)malloc(sizeof(header_type));				\
	header->pTop = NULL;											\
	header->pTail = NULL;											\
	header->ucCount = 0;											\
	f = fopen(fname, "rb");											\
	if (NULL != f)													\
	{																\
		/*܂R[hǂݏo*/								\
		if (1 == fread(&ucCount, sizeof(ucCount), 1, f))			\
		{															\
			for (ucIndex = 0; ucIndex < ucCount; ucIndex++)			\
			{														\
				/*R[hǂݏo*/						\
				pNode = (node_type*)malloc(sizeof(node_type));		\
				pNode->pNext = NULL;								\
				pNode->pPrev = NULL;								\
				fread(&(pNode->data), sizeof(pNode->data), 1, f);	\
				ADD_NODE_BOTHWAY(header, pNode);					\
			}														\
		}															\
		fclose(f);													\
	}																\
}

#define	PUSH_RECODE(pHeader, pNode, type, max_cnt)					\
{																	\
	type* pTop;														\
	/*擪̃m[h폜*/										\
	if (pHeader->ucCount >= max_cnt)								\
	{																\
		/*擪m[h܂L^Ă*/								\
		pTop = pHeader->pTop;										\
		/*Ԗڂ̃m[h擪Ƃ*/								\
		pHeader->pTop = pTop->pNext;								\
		pTop->pNext->pPrev = NULL;									\
		/*擪m[ḧJ*/								\
		free(pTop);													\
		pHeader->ucCount -= 1;										\
	}																\
	/*NXg̍Ōɒǉ*/									\
	ADD_NODE_BOTHWAY(pHeader, pNode);								\
}

#define CLEAR_RECODE(head, type)									\
{																	\
	type*	pNow;													\
	type*	pNext;													\
																	\
	pNow = head->pTop;												\
	/* obt@eNA */										\
	while(pNow)														\
	{																\
		pNext = pNow->pNext;										\
		free(pNow);													\
		pNow = pNext;												\
	}																\
	head->ucCount = 0;												\
	head->pTop = NULL;												\
	head->pTail = NULL;												\
}

#define CLEAR_FILE(head, type, fname)								\
{																	\
	FILE		*f;													\
	GUInt8		ucIndex;											\
	GUInt8		ucCount;											\
	type		nodeEmpty;											\
	/*m[h쐬*/												\
	memset(&nodeEmpty, 0, sizeof(nodeEmpty));						\
	f = fopen(fname, "wb");											\
	/*NA*/											\
	ucCount = 0;													\
	fwrite(&ucCount, sizeof(ucCount), 1, f);						\
	/*NA*/											\
	for(ucIndex = 0; ucIndex < head->ucCount; ucIndex++)			\
	{																\
		fwrite(&(nodeEmpty), sizeof(nodeEmpty), 1, f);				\
	}																\
	fclose(f);														\
}


enum {
	Lebel_NON,
	Lebel_1,
	Lebel_2,
	Lebel_3,
};

typedef struct _DATE_INFO
{
	unsigned short		usYear;
	unsigned short		usMonth;
	unsigned short		usDay;
}DATE_INFO;

typedef struct _TIME_INFO
{
	unsigned short		usHour;
	unsigned short		usMinute;
	unsigned short		usSecond;
}TIME_INFO;


/*MOfoCX*/
typedef struct _DEVICE_CSV_HEADER
{
	struct _DEVICE_CSV_NODE*		pTop;
	struct _DEVICE_CSV_NODE*		pTail;
}DEVICE_CSV_HEADER;

typedef struct _DEVICE_CSV_NODE
{
	GUInt16						usGdbID;
	struct _DEVICE_CSV_NODE*	pNext;
}DEVICE_CSV_NODE;

typedef struct _DEVICE_HISTORY_DATA
{
	GUInt16					device[LOGGING_DEVICE_MAX];
	GUInt16					usHour;
}DEVICE_HISTORY_DATA;

typedef struct _DEVICE_HISTORY_NODE
{
	struct _DEVICE_HISTORY_DATA		data;
	struct _DEVICE_HISTORY_NODE*	pNext;
	struct _DEVICE_HISTORY_NODE*	pPrev;
}DEVICE_HISTORY_NODE;

typedef struct _DEVICE_HISTORY_HEADER
{
	struct _DEVICE_HISTORY_NODE*		pTop;
	struct _DEVICE_HISTORY_NODE*		pTail;
	GUInt8								ucCount;
}DEVICE_HISTORY_HEADER;


typedef struct _OPERATE_HISTORY_DATA
{
	struct _DATE_INFO			date;
	struct _TIME_INFO			time;
	unsigned short				usStrID;
}OPERATE_HISTORY_DATA;

typedef struct _OPERATE_HISTORY_NODE
{
	struct _OPERATE_HISTORY_DATA	data;
	struct _OPERATE_HISTORY_NODE*	pNext;
	struct _OPERATE_HISTORY_NODE*	pPrev;
}OPERATE_HISTORY_NODE;

typedef struct _OPERATE_HISTORY_HEADER
{
	OPERATE_HISTORY_NODE*		pTop;
	OPERATE_HISTORY_NODE*		pTail;
	GUInt8						ucCount;
}OPERATE_HISTORY_HEADER;

/*G[CSVt@C֘A\*/
typedef struct _ERROR_CSV
{
	GUInt8		ucErrIndex;
	GUInt8		ucErrLevel;
	GUInt16		usErrCode;
	GUInt16		usStrID;
}ERROR_CSV;

typedef struct _ERROE_CSV_NODE
{
	struct _ERROR_CSV				pErrCsv;
	struct _ERROE_CSV_NODE*			pNext;
}ERROE_CSV_NODE;

typedef struct _ERROR_CSV_HEADER
{
	struct _ERROE_CSV_NODE*		pTop;
	struct _ERROE_CSV_NODE*		pTail;
}ERROR_CSV_HEADER;


typedef struct _ERROR_HISTORY_DATA
{
	struct _DATE_INFO		date;
	struct _TIME_INFO		timeTrigger;
	struct _TIME_INFO		timeRepair;
	unsigned short			usErrCode;
	unsigned short			usStrID;
	unsigned char			ucErrLevel;
	unsigned char			ucErrIndex;
	unsigned char			ucErrSts;			/*0:Ȃ/@1:*/
}ERROR_HISTORY_DATA;

typedef struct _ERROR_HISTORY_NODE
{
	struct _ERROR_HISTORY_DATA		data;
	struct _ERROR_HISTORY_NODE*		pNext;
	struct _ERROR_HISTORY_NODE*		pPrev;
}ERROR_HISTORY_NODE;

typedef struct _ERROR_HISTORY_HEADER
{
	struct _ERROR_HISTORY_NODE*		pTop;
	struct _ERROR_HISTORY_NODE*		pTail;
	GUInt8							ucCount;
}ERROR_HISTORY_HEADER;


/*O[oϐ*/
GTCHAR					g_szErrorMsg[64];							/*EBhEŕ\郁bZ[W*/
GUInt8					g_ucPermitLevel;							/*݋Ă郌x*/
GUInt8					g_gdbOldErrList[MONITOR_ERROR_COUNT_MAX];		/*ÕG[*/
GUInt32					g_afterTimeSecondTotal;						/*A삵Ȃb*/

OPERATE_HISTORY_HEADER	*g_pRecodeHeader_Operate;	/*엚NXgwb_[*/
ERROR_CSV_HEADER		*g_pCsvHeader_Error;		/*G[CSV񃊃NXgwb_[*/
ERROR_HISTORY_HEADER	*g_pRecodeHeader_Error;		/*G[NXgwb_[*/
DEVICE_CSV_HEADER		*g_pCsvHeader_Device;		/*MOfoCXCSV񃊃NXgwb_[*/
DEVICE_HISTORY_HEADER	*g_pRecodeHeader_Device;	/*MOf[^NXgwb_[*/
ERROR_HISTORY_NODE		*g_pNowErrNode;				/*G[m[h*/

/*O֐錾*/
GUInt8 CheckOperateLevel(void *pSelf, GUInt8 ucLevel);
void CompareOperateTime(void);
void GetDateInfo(DATE_INFO* pDate);
void GetTimeInfo(TIME_INFO* pTime);
void InitProfile();
void DoOperate(GUInt16 usCtrlID, void *pSelf);
void TriggerError(GUInt8 ucErrIndex);
void RepairError(GUInt8 ucErrIndex);
ERROE_CSV_NODE* IsMonitorError(GUInt8 ucErrIndex);
ERROR_HISTORY_NODE* GetRepairNode(GUInt8 ucErrIndex);
void GetNowErrString(GTCHAR *pErrString);
GInt8 CompareTime(ERROR_HISTORY_NODE *pNode, ERROR_HISTORY_NODE *pNextNode);
void SetNowErrNode(void);



#ifdef __cplusplus
}
#endif

#endif