#ifndef _GC_GUISCREEN_H_
#define _GC_GUISCREEN_H_
#include <genifa.h>
#include <gwin.h>
#include <gframeanimationscreen.h>
#include <gevent.h>
#include <gpanel.h>
#include "GUserEvent.h"
#include "GScript_def.h"

#ifdef __cplusplus
extern "C" {
#endif

//{{OBJECT_TYPE
#define GPANEL_MANUALOPERATION GUSERWINDOW_BASE+0
#define GPANEL_MONITOR GUSERWINDOW_BASE+1
#define GPANEL_ERRORMANAGEMENT GUSERWINDOW_BASE+2
#define GPANEL_OPERDATAMANAGEMENT GUSERWINDOW_BASE+3
#define GPANEL_MANUALMANAGEMENT GUSERWINDOW_BASE+4
#define GPANEL_MAINTENANCE GUSERWINDOW_BASE+5
#define GPANEL_OPERATIONHISTORY GUSERWINDOW_BASE+6
#define GPANEL_PARAMETERSETTING GUSERWINDOW_BASE+7
#define GWINDOW_MENU GUSERWINDOW_BASE+8
#define GWINDOW_MESSAGE GUSERWINDOW_BASE+9
#define GWINDOW_NUMERICKEYPAD GUSERWINDOW_BASE+10
//}}OBJECT_TYPE

//{{PAGE_ID
/* Panel ID */
#define ID_GPANEL_MANUALOPERATION 0
#define ID_GPANEL_MONITOR 1
#define ID_GPANEL_ERRORMANAGEMENT 2
#define ID_GPANEL_OPERDATAMANAGEMENT 3
#define ID_GPANEL_MANUALMANAGEMENT 4
#define ID_GPANEL_MAINTENANCE 5
#define ID_GPANEL_OPERATIONHISTORY 6
#define ID_GPANEL_PARAMETERSETTING 7

/* Window ID */
#define ID_GWINDOW_MENU 8
#define ID_GWINDOW_MESSAGE 9
#define ID_GWINDOW_NUMERICKEYPAD 10
//}}PAGE_ID

//{{MULTI_OUTPUT_ID
// Display output ID define.
//}}MULTI_OUTPUT_ID

typedef struct GC_GUIScreen_VMT{
	//{{FUNCTION_TABLE
	//GBaseWindow	>>
	GInt32 (*MessageProcedure)( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GInt32 (*CallBackMessageProcedure)( void* pSelf, GUInt16 usID, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GUInt16 (*GetType)( void* pSelf );
	GUInt16 (*GetID)( void* pSelf );
	GInt16 (*GetXPosition)( void* pSelf );
	GInt16 (*GetYPosition)( void* pSelf );
	void (*GetPosition)( void* pSelf, GPoint *pPosition );
	GInt16 (*GetWidth)( void* pSelf );
	GInt16 (*GetHeight)( void* pSelf );
	void (*GetSize)( void* pSelf, GPoint *pSize );
	void (*SetBounds)( void* pSelf, GRect *pBounds );
	void (*GetBounds)( void* pSelf, GRect *pBounds );
	void (*CalcClientRect)(  void*  pSelf, GRect *pClient );
	void (*GetClientRect)( void *pSelf, GRect *pClient );
	void (*ClientToScreen)( void *pSelf, GRect *pRect );
	GUInt32 (*GetStyle)(  void *pSelf );
	void (*SetVisibleStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetVisibleStatus)( void *pSelf );
	void (*SetEnableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetEnableStatus)( void *pSelf );
	void (*SetConsumableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetConsumableStatus)( void *pSelf );
	void (*SetCaptionStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetCaptionStatus)( void *pSelf );
	void (*SetFocusStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetFocusStatus)( void *pSelf );
	void (*SetStyleStatus)( void* pSelf, GUInt32 ulStyle, GInt16 fStatus );
	GInt16 (*GetStyleStatus)( void* pSelf, GUInt32 ulStyle );
	void (*SetParent)( void* pSelf, GBaseWindow *pParent);
	GBaseWindow* (*GetParent)( void* pSelf );
	void (*SetFocusInformation)( void * pSelf, GFocusInformation *pFocusInfo );
	GFocusInformation *(*GetFocusInformation)( void * pSelf );
	GInt16 (*Create)( void *pSelf, GBaseWindow *pParent );
	void (*Delete)( void *pSelf );
	GInt16 (*ImportProperty)( void *pSelf, const GBaseWindowProperty *pProperty );
	void (*ExportProperty)( void *pSelf, GBaseWindowProperty *pProperty );
	void (*Paint)( void *pSelf, GWDC *pDC );
	void (*OnDraw)( void *pSelf, GWDC *pDC );
	void (*OnNcDraw)( void *pSelf, GWDC *pDC );
	void (*AddRefreshRect)( void *pSelf, GRect *pRefresh, GInt16 nErase );
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GInt32 (*MouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_MOUSEMOVE_ */
	GInt32 (*LButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*LButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#ifdef _ENABLE_RBUTTON_
	GInt32 (*RButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*RButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GInt32 (*KeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*KeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*SetFocus)( void *pSelf );
	void (*KillFocus)( void *pSelf );
	void (*Timer)( void *pSelf, GUInt16 usTimerID );
	GInt32 (*User)( void *pSelf, GLParam lLParam, GUParam lUParam );
	void (*Char)( void * pSelf, GUInt16 usCharCode, GUInt32 ulStatus );
	void (*Close)( void * pSelf );
	void (*DeleteChild)( void * pSelf, GBaseWindow *pChild );
	void (*SetMemorySpace)( void *pSelf, GUInt8 ucType, GUInt8 ucPlane );
	void (*GetMemorySpace)( void *pSelf, GUInt8* ucType, GUInt8* ucPlane );
	void (*SetDrawForceStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetDrawForceStatus)( void *pSelf );	
	void (*SetRedrawStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetRedrawStatus)( void *pSelf );
	void (*ClearDrawStatus)( void *pSelf );
	void (*AddDirtyRect)(	 void *pSelf, GRect *pRefreshRect, GInt16 fErase );
	void (*SetPrevTimerObject)( void *pSelf, GBaseWindow *pbwPrev );
	GBaseWindow* (*GetPrevTimerObject)( void *pSelf );
	void (*SetNextTimerObject)( void *pSelf, GBaseWindow *pbwNext  );
	GBaseWindow* (*GetNextTimerObject)( void *pSelf );

#ifndef	_DISABLE_GLAYER_
	void (*AddDirtyRectLayer)( void *pSelf, GUInt16 usLayerID, GRect *pRefreshRect, GInt16 fErase );
	void (*SetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );		/* ݒ	*/
	GInt16 (*GetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );			/* ݒ	*/
	GInt16 (*GetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetLayerID)( void *pSelf, GUInt16 usLayerID );
	GUInt16 (*GetLayerID)( void *pSelf );
#endif /* _DISABLE_GLAYER_ */

	void *(*HoldImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void *(*GetImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void (*CleanImageData)(void *pSelf);
	void (*Active)( void *pSelf );
	void (*OnActive)( void *pSelf );
	void (*SetActiveStatus)( void *pSelf, GInt16 nActive );
	GInt16 (*GetActiveStatus)( void *pSelf );
	
	void (*OnCreate)( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue );
	void (*PreDelete)( void *pSelf );
	GInt16 (*PreKeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
	GInt16 (*PreKeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*OnUser)( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
	GInt16 (*PrePress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
	GInt16 (*PreRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
	GInt16 (*PrePaint)( void *pSelf, GWDC *pDC );
	void (*OnTimer)( void *pSelf, GUInt16 usTimerID );
#if		(_USE_MULTI_COORDINATE_ != 0)
	GInt16 (*SetActiveCoordinate)(void *pSelf, GInt16 nActive);
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	void (*OnUpdateDB)( void *pSelf, void* pParam );
	GInt16 (*IsMousePointInBounds)( void* pSelf, GPoint gptPoint );
	//GBaseWindow	<<

	GBaseWindow *(*CreateInstance)( void *pSelf, GUInt16 usType, const GBaseWindowProperty *pImport,	GBaseWindow *pParent );
	GInt16 (*ShowPanel)( void *pSelf, GInt32 lPage );
	GInt16 (*CreateGWindow)( void* pSelf, GInt32 lPage );
	GInt32 (*DispatchMessage)( void *pSelf, GEventMessage *gemMsg );
	GPanel* (*AttachPanel)( void *pSelf, GPanel *pPanel );
	GPanel* (*GetPanel)( void *pSelf );
#ifndef _DISABLE_POINTING_DEVICE_
	GInt32 (*LButtonPressPanel)( void *pSelf,GUInt32 ulStatus, GPoint gptPoint );
#ifdef _ENABLE_RBUTTON_
	GInt32 (*RButtonPressPanel)( void *pSelf,GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	void (*DrawPanel)( void *pSelf,GWDC *pDC );
	void (*DrawBackGround)( void *pSelf, GWDC *pDC );
	void (*ChangeFocus)( void *pSelf, GBaseWindow *pNewObject );
	GBaseWindow *(*GetFocus)( void *pSelf );
	void (*DrawFrame)( void* pSelf,GWDC *pDC );
#ifndef _DISABLE_POINTING_DEVICE_
	GInt32 (*LButtonPressFrame)( void* pSelf,GUInt32 ulStatus, GPoint gptPoint );
#ifdef _ENABLE_RBUTTON_
	GInt32 (*RButtonPressFrame)( void* pSelf,GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GInt16 (*AddWindow)( void *pSelf, GWindow *pWindow );
	GFrame *(*GetFrame)( void *pSelf );
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GInt32 (*MouseMoveFrame)( void* pSelf,GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*MouseMovePanel)( void* pSelf,GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	void (*SetBackGroundDesign)( void *pSelf, GDesign *pDesign );
	GDesign* (*GetBackGroundDesign)( void *pSelf );
	void (*SetSystemFontID)( void *pSelf, GUInt16 usID );
	GUInt16 (*GetSystemFontID)( void *pSelf );
/* F 2007/06/14 >> */
	void (*SetSystemBorderID)( void *pSelf, GUInt16 usLayerID, GUInt16 usID );
	GUInt16 (*GetSystemBorderID)( void *pSelf, GUInt16 usLayerID );
	void (*SetSystemForeColor)( void *pSelf, GUInt16 usLayerID, GColor gcColor );
	GColor (*GetSystemForeColor)( void *pSelf, GUInt16 usLayerID );
	void (*SetSystemBackColor)( void *pSelf, GUInt16 usLayerID, GColor gcColor );
	GColor (*GetSystemBackColor)( void *pSelf, GUInt16 usLayerID );
	void (*SetSystemActiveColor)( void *pSelf, GUInt16 usLayerID, GColor gcColor );
	GColor (*GetSystemActiveColor)( void *pSelf, GUInt16 usLayerID );
	void (*SetSystemInactiveColor)( void *pSelf, GUInt16 usLayerID, GColor gcColor );
	GColor (*GetSystemInactiveColor)( void *pSelf, GUInt16 usLayerID );
/* F 2007/06/14 << */
	GWDC *(*GetWDC)( void *pSelf);
	GInt16 (*ModalGWindow)( void* pSelf, GInt32 lPage );
	void (*SetPanelPlane)(  void *pSelf, GUInt8 ucIndex, GUInt8 ucFlag );
	GUInt8 (*GetPanelPlane)( void *pSelf, GUInt8 ucIndex );
	void (*SetWindowPlane)( void *pSelf, GUInt8 ucIndex, GUInt8 ucFlag );
	GUInt8 (*GetWindowPlane)( void *pSelf, GUInt8 ucIndex );
	void (*SetSystemStatus)( void *pSelf, GUInt32 ulSystem, GInt16 fStatus );
	GInt16 (*GetSystemStatus)( void *pSelf, GUInt32 ulSystem );
	void (*SetExitStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetExitStatus)( void *pSelf );
	GWindow* (*LoadGWindow)( void *pSelf, GInt32 lPage );
	GInt16 (*DoModal)( void *pSelf, GWindow *pWindow, GLParam lLParam, GUParam lUParam );
	void (*OnDrawWindow)( void *pSelf, GWDC *pDC, GInt32 lStart, GInt32 lEnd, GInt32 lNow, GBaseWindow **pWinArray, GRect *pClip );
	void (*SetPaletteStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetPaletteStatus)( void *pSelf );
	void (*SetSystemPaletteID)( void *pSelf, GUInt16 usID );
	GUInt16 (*GetSystemPaletteID)( void *pSelf );
	void (*SetPaletteColors)( void *pSelf, GUInt16 usPaletteColors );
	GUInt16 (*GetPaletteColors)( void *pSelf );
	void (*SetSystemPalette)( void *pSelf );
	void (*AddTimerObject)( void *pSelf, GBaseWindow *pObject );
	void (*RemoveTimerObject)( void *pSelf, GBaseWindow *pObject );
	void (*SetEventSearchStatus)( void *pSelf, GUInt8 ucEventSearch );
	GUInt8 (*GetEventSearchStatus)( void *pSelf );
#ifndef	_DISABLE_GLAYER_
	void (*SetLayerStatus)( void *pSelf, GInt16 nStatus );		/* ݒ	*/
	GInt16 (*GetLayerStatus)( void *pSelf );						/* 擾	*/
#endif /* _DISABLE_GLAYER_ */
	GInt16 (*CheckTransparentWindow)( void *pSelf, GWindow *pWindow );
	void (*AddBaseTimerControl)( void *pSelf );
	void (*RemoveBaseTimerControl)( void *pSelf );
#if		(_USE_MULTI_COORDINATE_ != 0)
	GInt16 (*GetActiveCoordinate)(void *pSelf);
	GInt16 (*GetNumCoordinate)(void *pSelf);
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GInt32 (*OnRequestUpdataDB)( void *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GUInt32 (*GetBaseTimerInterval)( void *pSelf );		/* x[X^C}XVԊu擾 */
	void (*SetReleaseType) (void *pSelf, GUInt8 ucType);
	void (*GetReleaseType) (void *pSelf, GUInt8 *ucType );
	void (*SetLButtonPressObject)(void *pSelf, GBaseWindow *pChild );
	GBaseWindow* (*GetLButtonPressObject)(void *pSelf );
	void (*SetPrevLButtonPressObject)(void *pSelf, GBaseWindow *pChild );
	GBaseWindow* (*GetPrevLButtonPressObject)(void *pSelf );
	GBaseWindow* (*GetKeyPressObject)(void *pSelf );			/* 擾 */
	void (*ChangeKeyPressObject)( void *pSelf, GBaseWindow* pObject );/* ؊ */
	GDBChgMgr* (*GetDBChgMgr)(void *pSelf ); /* GUIf[^x[XωǗ擾 */
	void (*SetCursorType) (void *pSelf, GUInt8 ucCursorType);
	void (*GetCursorType) (void *pSelf,GUInt8* ucCursorType);
	void (*PreActive) (void *pSelf, GUInt16 usPageID, GInt32 *pReturnValue);
	GInt16 (*ForcedRelease)( void *pSelf);
	GInt16 (*SetForcedReleaseStatus)(void *pSelf, GInt16 nFlag, GInt8 cStatus );
	GInt16 (*GetForcedReleaseStatus)( void *pSelf);
	GInt16 (*GetForcedReleaseTiming)( void *pSelf);
	GInt16 (*SetForcedReleaseTiming)(void *pSelf, GInt16 sTiming );
	GBaseWindow* (*GetLButtonPressPTObject)( void *pSelf);
	GInt16 (*SetLButtonPressPTObject)(void *pSelf, GBaseWindow *pChild );
	void (*SetLBPressPoint)( void *pSelf, GPoint *pptPoint );
	GPoint (*GetLBPressPoint)( void *pSelf );
	GInt16 (*CheckBeLBPChildOver)( void *pSelf, GBaseWindow *pBaseWindow );
	GInt16 (*MoveWindowListFirst)(void *pSelf, GWindow *pWindow);
	GInt16 (*MoveWindowListLast)(void *pSelf, GWindow *pWindow);
	GInt16 (*MoveWindowListPrev)(void *pSelf, GWindow *pWindow);
	GInt16 (*MoveWindowListNext)(void *pSelf, GWindow *pWindow);
	GInt16 (*MoveWindowList)(void *pSelf, GWindow *pWindow, GInt32 lIndex );
	GInt32 (*GetWindowIndex)(void *pSelf, GWindow *pWindow);
#ifndef	_DISABLE_GLAYER_
	GInt32 (*GetWindowCount)(void *pSelf, GUInt16 usLayerID);
	GUInt16 (*GetMaxLayer)(void *pSelf);
#endif /* _DISABLE_GLAYER_ */
	GPanel* (*CreateSubPanel)( void *pSelf, void *pParent, GInt32 lPage );
	void* (*CreateFrameAnimationInstance)( void *pSelf, GUInt16 usType, void *pProperty, GUInt32 ulKeyFrameNum, GKeyFrameProperty *pKeyFrame, GUInt8 ucMemorySpaceType, GUInt8 ucMemorySpacePlane  );
	void (*SetFPS)( void *pSelf, GUInt8 ucFPS );
	GUInt8 (*GetFPS)( void *pSelf );
	void (*SetPriority)( void *pSelf, GUInt8 ucPriority );
	GUInt8 (*GetPriority)( void *pSelf );
	GInt32 (*GUIScriptDispatcher)( void *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	//}}FUNCTION_TABLE
}GC_GUIScreen_VMT;

GDefClass( GC_GUIScreen, GFrameAnimationScreen )
GDefEnd

typedef struct GC_GUIScreen GC_GUIScreen;

//{{PUBLIC_METHOD
GC_GUIScreen *GWNewGC_GUIScreen( void );
const GC_GUIScreen_VMT *GWGetGC_GUIScreenVMT( void );
GInt16 GWInitGC_GUIScreen( GC_GUIScreen* pSelf );
GInt16 GC_GUIScreen_Create( void *pSelf, GBaseWindow *pParent );
GBaseWindow *GC_GUIScreen_CreateInstance( void *pSelf, GUInt16 usType, const GBaseWindowProperty *pImport, GBaseWindow *pParent );
GInt16 GC_GUIScreen_ShowPanel( void *pSelf, GInt32 lPage );
GInt16 GC_GUIScreen_CreateGWindow( void* pSelf, GInt32 lPage );
GInt16 GC_GUIScreen_ModalGWindow( void* pSelf, GInt32 lPage );
GWindow *GC_GUIScreen_LoadGWindow( void* pSelf, GInt32 lPage );
GInt32 GC_GUIScreen_MessageProcedure( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
void* GC_GUIScreen_CreateFrameAnimationInstance( void *pSelf, GUInt16 usType, void *pProperty, GUInt32 ulKeyFrameNum, GKeyFrameProperty *pKeyFrame, GUInt8 ucMemorySpaceType, GUInt8 ucMemorySpacePlane  );
GInt32 GC_GUIScreen_GUIScriptDispatcher( void *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GPanel* GC_GUIScreen_CreateSubPanel( void *pSelf, void *pParent, GInt32 lPage );
//}}PUBLIC_METHOD

//{{CALLBACK_METHOD
//}}CALLBACK_METHOD


//{{OVERRIDE_CONDITION
#define OnTimer_USE 1
#define OnUpdateDB_USE 1
//}}OVERRIDE_CONDITION

//{{OVERRIDE_METHOD
#ifdef PreKeyPress_USE
GInt16 GC_GUIScreen_PreKeyPress ( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
#endif
#ifdef PreKeyRelease_USE
GInt16 GC_GUIScreen_PreKeyRelease( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
#endif
#ifdef OnUser_USE
void GC_GUIScreen_OnUser( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
#endif
#ifdef PrePress_USE
GInt16 GC_GUIScreen_PrePress( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
#endif
#ifdef PreRelease_USE
GInt16 GC_GUIScreen_PreRelease( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#ifdef PrePaint_USE
GInt16 GC_GUIScreen_PrePaint( void *pSelf, GWDC *pDC );
#endif
#ifdef OnTimer_USE
void GC_GUIScreen_OnTimer( void *pSelf, GUInt16 usTimerID );
#endif
#ifdef OnUpdateDB_USE
void GC_GUIScreen_OnUpdateDB( void *pSelf, void* pParam );
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_	// 2006.03.20 }EXړCxgΉ>>
#ifdef OnMouseMove_USE
GInt32 GC_GUIScreen_OnMouseMove( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#ifdef PreActive_USE
void GC_GUIScreen_PreActive( void *pSelf, GUInt16 usPageID, GInt32 *pReturnValue );
#endif
#endif /* _ENABLE_MOUSEMOVE_ */	// 2006.03.20 }EXړCxgΉ<<
#endif /* _DISABLE_POINTING_DEVICE_ */
//}}OVERRIDE_METHOD

//{{PROTECTED_METHOD
/* p̏Ȃ֐͊֐̒`Ă */
//#define GC_GUIScreen_MessageProcedure		GFrameAnimationScreen_MessageProcedure
#define GC_GUIScreen_CallBackMessageProcedure	GFrameAnimationScreen_CallBackMessageProcedure
#define GC_GUIScreen_GetType					GFrameAnimationScreen_GetType
#define GC_GUIScreen_GetID						GFrameAnimationScreen_GetID
#define GC_GUIScreen_GetXPosition				GFrameAnimationScreen_GetXPosition
#define GC_GUIScreen_GetYPosition				GFrameAnimationScreen_GetYPosition
#define GC_GUIScreen_GetPosition				GFrameAnimationScreen_GetPosition
#define GC_GUIScreen_GetWidth					GFrameAnimationScreen_GetWidth
#define GC_GUIScreen_GetHeight					GFrameAnimationScreen_GetHeight
#define GC_GUIScreen_GetSize					GFrameAnimationScreen_GetSize
#define GC_GUIScreen_SetBounds					GFrameAnimationScreen_SetBounds
#define GC_GUIScreen_GetBounds					GFrameAnimationScreen_GetBounds
#define GC_GUIScreen_CalcClientRect			GFrameAnimationScreen_CalcClientRect
#define GC_GUIScreen_GetClientRect				GFrameAnimationScreen_GetClientRect
#define GC_GUIScreen_ClientToScreen			GFrameAnimationScreen_ClientToScreen
#define GC_GUIScreen_GetStyle					GFrameAnimationScreen_GetStyle
#define GC_GUIScreen_SetVisibleStatus			GFrameAnimationScreen_SetVisibleStatus
#define GC_GUIScreen_GetVisibleStatus			GFrameAnimationScreen_GetVisibleStatus
#define GC_GUIScreen_SetEnableStatus			GFrameAnimationScreen_SetEnableStatus
#define GC_GUIScreen_GetEnableStatus			GFrameAnimationScreen_GetEnableStatus
#define GC_GUIScreen_SetConsumableStatus		GFrameAnimationScreen_SetConsumableStatus
#define GC_GUIScreen_GetConsumableStatus		GFrameAnimationScreen_GetConsumableStatus
#define GC_GUIScreen_SetCaptionStatus			GFrameAnimationScreen_SetCaptionStatus
#define GC_GUIScreen_GetCaptionStatus			GFrameAnimationScreen_GetCaptionStatus
#define GC_GUIScreen_SetFocusStatus			GFrameAnimationScreen_SetFocusStatus
#define GC_GUIScreen_GetFocusStatus			GFrameAnimationScreen_GetFocusStatus
#define GC_GUIScreen_SetStyleStatus			GFrameAnimationScreen_SetStyleStatus
#define GC_GUIScreen_GetStyleStatus			GFrameAnimationScreen_GetStyleStatus
#define GC_GUIScreen_ImportProperty			GFrameAnimationScreen_ImportProperty
#define GC_GUIScreen_ExportProperty			GFrameAnimationScreen_ExportProperty
#define GC_GUIScreen_SetParent					GFrameAnimationScreen_SetParent
#define GC_GUIScreen_GetParent					GFrameAnimationScreen_GetParent
#define GC_GUIScreen_SetFocusInformation		GFrameAnimationScreen_SetFocusInformation
#define GC_GUIScreen_GetFocusInformation		GFrameAnimationScreen_GetFocusInformation
#define GC_GUIScreen_Delete					GFrameAnimationScreen_Delete
#define GC_GUIScreen_Paint						GFrameAnimationScreen_Paint
#define GC_GUIScreen_OnDraw					GFrameAnimationScreen_OnDraw
#define GC_GUIScreen_OnNcDraw					GFrameAnimationScreen_OnNcDraw
#define GC_GUIScreen_AddRefreshRect			GFrameAnimationScreen_AddRefreshRect
#define GC_GUIScreen_MouseMove					GFrameAnimationScreen_MouseMove
#define GC_GUIScreen_OnNcMouseMove				GFrameAnimationScreen_OnNcMouseMove
#define GC_GUIScreen_LButtonPress				GFrameAnimationScreen_LButtonPress
#define GC_GUIScreen_OnLButtonPress			GFrameAnimationScreen_OnLButtonPress
#define GC_GUIScreen_OnNcLButtonPress			GFrameAnimationScreen_OnNcLButtonPress
#define GC_GUIScreen_LButtonRelease			GFrameAnimationScreen_LButtonRelease
#define GC_GUIScreen_OnLButtonRelease			GFrameAnimationScreen_OnLButtonRelease
#define GC_GUIScreen_OnNcLButtonRelease		GFrameAnimationScreen_OnNcLButtonRelease
#define GC_GUIScreen_RButtonPress				GFrameAnimationScreen_RButtonPress
#define GC_GUIScreen_OnRButtonPress			GFrameAnimationScreen_OnRButtonPress
#define GC_GUIScreen_OnNcRButtonPress			GFrameAnimationScreen_OnNcRButtonPress
#define GC_GUIScreen_RButtonRelease			GFrameAnimationScreen_RButtonRelease
#define GC_GUIScreen_OnRButtonRelease			GFrameAnimationScreen_OnRButtonRelease
#define GC_GUIScreen_OnNcRButtonRelease		GFrameAnimationScreen_OnNcRButtonRelease
#define GC_GUIScreen_KeyPress					GFrameAnimationScreen_KeyPress
#define GC_GUIScreen_KeyRelease				GFrameAnimationScreen_KeyRelease
#define GC_GUIScreen_SetFocus					GFrameAnimationScreen_SetFocus
#define GC_GUIScreen_KillFocus					GFrameAnimationScreen_KillFocus
#define GC_GUIScreen_Timer						GFrameAnimationScreen_Timer
#define GC_GUIScreen_User						GFrameAnimationScreen_User
#define GC_GUIScreen_Char						GFrameAnimationScreen_Char
#define GC_GUIScreen_Close						GFrameAnimationScreen_Close
#define GC_GUIScreen_DeleteChild				GFrameAnimationScreen_DeleteChild
#define GC_GUIScreen_SetMemorySpace			GFrameAnimationScreen_SetMemorySpace
#define GC_GUIScreen_GetMemorySpace			GFrameAnimationScreen_GetMemorySpace
#define GC_GUIScreen_SetDrawForceStatus 		GFrameAnimationScreen_SetDrawForceStatus
#define GC_GUIScreen_GetDrawForceStatus 		GFrameAnimationScreen_GetDrawForceStatus
#define GC_GUIScreen_SetRedrawStatus 			GFrameAnimationScreen_SetRedrawStatus
#define GC_GUIScreen_GetRedrawStatus 			GFrameAnimationScreen_GetRedrawStatus
#define GC_GUIScreen_ClearDrawStatus 			GFrameAnimationScreen_ClearDrawStatus
#define GC_GUIScreen_AddDirtyRect 				GFrameAnimationScreen_AddDirtyRect
#define GC_GUIScreen_SetPrevTimerObject		GFrameAnimationScreen_SetPrevTimerObject
#define GC_GUIScreen_GetPrevTimerObject		GFrameAnimationScreen_GetPrevTimerObject
#define GC_GUIScreen_SetNextTimerObject		GFrameAnimationScreen_SetNextTimerObject
#define GC_GUIScreen_GetNextTimerObject		GFrameAnimationScreen_GetNextTimerObject

#define	GC_GUIScreen_DispatchMessage			GFrameAnimationScreen_DispatchMessage
#define	GC_GUIScreen_AttachPanel				GFrameAnimationScreen_AttachPanel
#define	GC_GUIScreen_GetPanel					GFrameAnimationScreen_GetPanel
#define	GC_GUIScreen_LButtonPressPanel			GFrameAnimationScreen_LButtonPressPanel
#define	GC_GUIScreen_LButtonReleasePanel		GFrameAnimationScreen_LButtonReleasePanel
#define	GC_GUIScreen_RButtonPressPanel			GFrameAnimationScreen_RButtonPressPanel
#define	GC_GUIScreen_RButtonReleasePanel		GFrameAnimationScreen_RButtonReleasePanel
#define	GC_GUIScreen_DrawPanel					GFrameAnimationScreen_DrawPanel
#define	GC_GUIScreen_DrawBackGround			GFrameAnimationScreen_DrawBackGround
#define	GC_GUIScreen_ChangeFocus				GFrameAnimationScreen_ChangeFocus
#define	GC_GUIScreen_GetFocus					GFrameAnimationScreen_GetFocus
#define	GC_GUIScreen_DrawFrame 				GFrameAnimationScreen_DrawFrame
#define	GC_GUIScreen_LButtonPressFrame 		GFrameAnimationScreen_LButtonPressFrame
#define	GC_GUIScreen_RButtonPressFrame 		GFrameAnimationScreen_RButtonPressFrame
#define	GC_GUIScreen_AddWindow 				GFrameAnimationScreen_AddWindow
#define	GC_GUIScreen_GetFrame 					GFrameAnimationScreen_GetFrame
#define	GC_GUIScreen_SetBackGroundDesign 		GFrameAnimationScreen_SetBackGroundDesign
#define	GC_GUIScreen_GetBackGroundDesign 		GFrameAnimationScreen_GetBackGroundDesign
#define	GC_GUIScreen_SetSystemFontID 			GFrameAnimationScreen_SetSystemFontID
#define	GC_GUIScreen_GetSystemFontID 			GFrameAnimationScreen_GetSystemFontID
#define	GC_GUIScreen_SetSystemBorderID 		GFrameAnimationScreen_SetSystemBorderID
#define	GC_GUIScreen_GetSystemBorderID 		GFrameAnimationScreen_GetSystemBorderID
#define	GC_GUIScreen_SetSystemForeColor 		GFrameAnimationScreen_SetSystemForeColor
#define	GC_GUIScreen_GetSystemForeColor		GFrameAnimationScreen_GetSystemForeColor
#define	GC_GUIScreen_SetSystemBackColor 		GFrameAnimationScreen_SetSystemBackColor
#define	GC_GUIScreen_GetSystemBackColor 		GFrameAnimationScreen_GetSystemBackColor
#define	GC_GUIScreen_SetSystemActiveColor 		GFrameAnimationScreen_SetSystemActiveColor
#define	GC_GUIScreen_GetSystemActiveColor 		GFrameAnimationScreen_GetSystemActiveColor
#define	GC_GUIScreen_SetSystemInactiveColor 	GFrameAnimationScreen_SetSystemInactiveColor
#define	GC_GUIScreen_GetSystemInactiveColor 	GFrameAnimationScreen_GetSystemInactiveColor
#define	GC_GUIScreen_GetWDC 					GFrameAnimationScreen_GetWDC
#define	GC_GUIScreen_SetPanelPlane				GFrameAnimationScreen_SetPanelPlane
#define	GC_GUIScreen_GetPanelPlane				GFrameAnimationScreen_GetPanelPlane
#define	GC_GUIScreen_SetWindowPlane			GFrameAnimationScreen_SetWindowPlane
#define	GC_GUIScreen_GetWindowPlane			GFrameAnimationScreen_GetWindowPlane
#define	GC_GUIScreen_SetSystemStatus			GFrameAnimationScreen_SetSystemStatus
#define	GC_GUIScreen_GetSystemStatus			GFrameAnimationScreen_GetSystemStatus
#define	GC_GUIScreen_SetExitStatus				GFrameAnimationScreen_SetExitStatus
#define	GC_GUIScreen_GetExitStatus				GFrameAnimationScreen_GetExitStatus
#define	GC_GUIScreen_DoModal					GFrameAnimationScreen_DoModal
#define	GC_GUIScreen_OnDrawWindow				GFrameAnimationScreen_OnDrawWindow
#define	GC_GUIScreen_SetPaletteStatus			GFrameAnimationScreen_SetPaletteStatus
#define	GC_GUIScreen_GetPaletteStatus			GFrameAnimationScreen_GetPaletteStatus
#define	GC_GUIScreen_SetSystemPaletteID		GFrameAnimationScreen_SetSystemPaletteID
#define	GC_GUIScreen_GetSystemPaletteID		GFrameAnimationScreen_GetSystemPaletteID
#define	GC_GUIScreen_SetPaletteColors			GFrameAnimationScreen_SetPaletteColors
#define	GC_GUIScreen_GetPaletteColors			GFrameAnimationScreen_GetPaletteColors
#define	GC_GUIScreen_SetSystemPalette			GFrameAnimationScreen_SetSystemPalette
#define	GC_GUIScreen_AddTimerObject			GFrameAnimationScreen_AddTimerObject
#define	GC_GUIScreen_RemoveTimerObject			GFrameAnimationScreen_RemoveTimerObject
#define	GC_GUIScreen_SetEventSearchStatus		GFrameAnimationScreen_SetEventSearchStatus
#define	GC_GUIScreen_GetEventSearchStatus		GFrameAnimationScreen_GetEventSearchStatus

#define	GC_GUIScreen_MouseMoveFrame			GFrameAnimationScreen_MouseMoveFrame
#define	GC_GUIScreen_MouseMovePanel			GFrameAnimationScreen_MouseMovePanel

#ifndef	_DISABLE_GLAYER_
	// CΉ >>
#define GC_GUIScreen_AddDirtyRectLayer			GFrameAnimationScreen_AddDirtyRectLayer
#define GC_GUIScreen_SetDrawForceStatusLayer	GFrameAnimationScreen_SetDrawForceStatusLayer
#define GC_GUIScreen_GetDrawForceStatusLayer	GFrameAnimationScreen_GetDrawForceStatusLayer
#define GC_GUIScreen_SetRedrawStatusLayer		GFrameAnimationScreen_SetRedrawStatusLayer
#define GC_GUIScreen_GetRedrawStatusLayer		GFrameAnimationScreen_GetRedrawStatusLayer
#define GC_GUIScreen_SetLayerID				GFrameAnimationScreen_SetLayerID
#define GC_GUIScreen_GetLayerID				GFrameAnimationScreen_GetLayerID
#define GC_GUIScreen_SetLayerStatus			GFrameAnimationScreen_SetLayerStatus
#define GC_GUIScreen_GetLayerStatus			GFrameAnimationScreen_GetLayerStatus
	// CΉ <<
#endif /* _DISABLE_GLAYER_ */
#define GC_GUIScreen_HoldImageData				GFrameAnimationScreen_HoldImageData
#define GC_GUIScreen_GetImageData				GFrameAnimationScreen_GetImageData
#define GC_GUIScreen_CleanImageData			GFrameAnimationScreen_CleanImageData
#define GC_GUIScreen_Active					GFrameAnimationScreen_Active
#ifndef OnActive_USE
#define GC_GUIScreen_OnActive					GFrameAnimationScreen_OnActive
#endif
#define GC_GUIScreen_SetActiveStatus			GFrameAnimationScreen_SetActiveStatus
#define GC_GUIScreen_GetActiveStatus			GFrameAnimationScreen_GetActiveStatus
#define GC_GUIScreen_CheckTransparentWindow	GFrameAnimationScreen_CheckTransparentWindow
#define GC_GUIScreen_AddBaseTimerControl		GFrameAnimationScreen_AddBaseTimerControl	
#define GC_GUIScreen_RemoveBaseTimerControl	GFrameAnimationScreen_RemoveBaseTimerControl	
#define GC_GUIScreen_OnCreate					GFrameAnimationScreen_OnCreate
#define GC_GUIScreen_PreDelete					GFrameAnimationScreen_PreDelete

#ifndef PreKeyPress_USE
#define GC_GUIScreen_PreKeyPress				GFrameAnimationScreen_PreKeyPress
#endif
#ifndef PreKeyRelease_USE
#define GC_GUIScreen_PreKeyRelease				GFrameAnimationScreen_PreKeyRelease
#endif
#ifndef OnUser_USE
#define GC_GUIScreen_OnUser					GFrameAnimationScreen_OnUser
#endif
#ifndef PrePress_USE
#define GC_GUIScreen_PrePress					GFrameAnimationScreen_PrePress
#endif
#ifndef PreRelease_USE
#define GC_GUIScreen_PreRelease				GFrameAnimationScreen_PreRelease
#endif
#ifndef PrePaint_USE
#define GC_GUIScreen_PrePaint					GFrameAnimationScreen_PrePaint
#endif
#ifndef OnTimer_USE
#define GC_GUIScreen_OnTimer					GFrameAnimationScreen_OnTimer
#endif
#ifndef OnUpdateDB_USE
#define GC_GUIScreen_OnUpdateDB					GFrameAnimationScreen_OnUpdateDB
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_	// 2006.03.20 }EXړCxgΉ>>
#ifndef OnMouseMove_USE
#define GC_GUIScreen_OnMouseMove					GFrameAnimationScreen_OnMouseMove
#endif
#ifndef PreActive_USE
#define GC_GUIScreen_PreActive					GFrameAnimationScreen_PreActive
#endif
#endif /* _ENABLE_MOUSEMOVE_ */	// 2006.03.20 }EXړCxgΉ<<
#endif /* _DISABLE_POINTING_DEVICE_ */
#if		(_USE_MULTI_COORDINATE_ != 0)
#define	GC_GUIScreen_SetActiveCoordinate		GFrameAnimationScreen_SetActiveCoordinate
#define	GC_GUIScreen_GetActiveCoordinate		GFrameAnimationScreen_GetActiveCoordinate
#define	GC_GUIScreen_GetNumCoordinate		GFrameAnimationScreen_GetNumCoordinate
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
#define GC_GUIScreen_SetFPS					GFrameAnimationScreen_SetFPS
#define GC_GUIScreen_GetFPS					GFrameAnimationScreen_GetFPS
#define GC_GUIScreen_SetPriority				GFrameAnimationScreen_SetPriority
#define GC_GUIScreen_GetPriority				GFrameAnimationScreen_GetPriority
#define	GC_GUIScreen_OnRequestUpdataDB			GFrameAnimationScreen_OnRequestUpdataDB
#define	GC_GUIScreen_GetBaseTimerInterval			GFrameAnimationScreen_GetBaseTimerInterval
#define GC_GUIScreen_IsMousePointInBounds		GFrameAnimationScreen_IsMousePointInBounds
#define GC_GUIScreen_SetReleaseType		GFrameAnimationScreen_SetReleaseType
#define GC_GUIScreen_GetReleaseType		GFrameAnimationScreen_GetReleaseType
#define GC_GUIScreen_SetLButtonPressObject	GFrameAnimationScreen_SetLButtonPressObject
#define GC_GUIScreen_GetLButtonPressObject	GFrameAnimationScreen_GetLButtonPressObject
#define GC_GUIScreen_SetPrevLButtonPressObject	GFrameAnimationScreen_SetPrevLButtonPressObject
#define GC_GUIScreen_GetPrevLButtonPressObject	GFrameAnimationScreen_GetPrevLButtonPressObject
#define GC_GUIScreen_GetKeyPressObject			GFrameAnimationScreen_GetKeyPressObject
#define GC_GUIScreen_ChangeKeyPressObject		GFrameAnimationScreen_ChangeKeyPressObject
#define GC_GUIScreen_GetDBChgMgr 		GFrameAnimationScreen_GetDBChgMgr
#define GC_GUIScreen_SetCursorType	GFrameAnimationScreen_SetCursorType
#define GC_GUIScreen_GetCursorType	GFrameAnimationScreen_GetCursorType
#define GC_GUIScreen_ForcedRelease  GFrameAnimationScreen_ForcedRelease 
#define GC_GUIScreen_SetForcedReleaseStatus  GFrameAnimationScreen_SetForcedReleaseStatus 
#define GC_GUIScreen_GetForcedReleaseStatus  GFrameAnimationScreen_GetForcedReleaseStatus 
#define GC_GUIScreen_GetForcedReleaseTiming GFrameAnimationScreen_GetForcedReleaseTiming 
#define GC_GUIScreen_SetForcedReleaseTiming GFrameAnimationScreen_SetForcedReleaseTiming 
#define GC_GUIScreen_GetLButtonPressPTObject  GFrameAnimationScreen_GetLButtonPressPTObject 
#define GC_GUIScreen_SetLButtonPressPTObject  GFrameAnimationScreen_SetLButtonPressPTObject 
#define GC_GUIScreen_SetLBPressPoint  GFrameAnimationScreen_SetLBPressPoint 
#define GC_GUIScreen_GetLBPressPoint  GFrameAnimationScreen_GetLBPressPoint 
#define GC_GUIScreen_CheckBeLBPChildOver  GFrameAnimationScreen_CheckBeLBPChildOver 

#define GC_GUIScreen_MoveWindowListFirst GFrameAnimationScreen_MoveWindowListFirst
#define GC_GUIScreen_MoveWindowListLast GFrameAnimationScreen_MoveWindowListLast
#define GC_GUIScreen_MoveWindowListPrev GFrameAnimationScreen_MoveWindowListPrev
#define GC_GUIScreen_MoveWindowListNext GFrameAnimationScreen_MoveWindowListNext
#define GC_GUIScreen_MoveWindowList GFrameAnimationScreen_MoveWindowList
#define GC_GUIScreen_GetWindowIndex GFrameAnimationScreen_GetWindowIndex
#ifndef _DISABLE_GLAYER_
#define GC_GUIScreen_GetWindowCount GFrameAnimationScreen_GetWindowCount
#define GC_GUIScreen_GetMaxLayer GFrameAnimationScreen_GetMaxLayer
#endif /* _DISABLE_GLAYER_ */
//}}PROTECTED_METHOD

//{{UNDEF_OVERRIDE_CONDITION
#undef PreKeyPress_USE
#undef PreKeyRelease_USE
#undef OnUser_USE
#undef PrePress_USE
#undef PreRelease_USE
#undef PrePaint_USE
#undef OnTimer_USE
#undef OnUpdateDB_USE
#undef OnMouseMove_USE
#undef PreActive_USE
//}}UNDEF_OVERRIDE_CONDITION
#ifdef __cplusplus
}
#endif

#endif /* _GC_GUISCREEN_H_ */
