#ifndef _GPANEL_MONITOR_H_
#define _GPANEL_MONITOR_H_
#include <genifa.h>
#include <gframeanimationpanel.h>

#ifdef __cplusplus
extern "C" {
#endif

//{{CONTROL_ID
enum{
	GPANEL_MONITOR_GDUMMYTERMINATOR
};
//}}CONTROL_ID
//{{ANIMATION_ID
enum{
	GPANEL_MONITOR_ANIMATION000 = 1,
	GPANEL_MONITOR_GANIMATIONTERMINATOR
};
//}}ANIMATION_ID

typedef struct GPanel_Monitor_VMT{
	//{{FUNCTION_TABLE
	GInt32 (*MessageProcedure)( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GInt32 (*CallBackMessageProcedure)( void* pSelf, GUInt16 usID, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GUInt16 (*GetType)( void* pSelf );
	GUInt16 (*GetID)( void* pSelf );
	GInt16 (*GetXPosition)( void* pSelf );
	GInt16 (*GetYPosition)( void* pSelf );
	void (*GetPosition)( void* pSelf, GPoint *pPosition );
	GInt16 (*GetWidth)( void* pSelf );
	GInt16 (*GetHeight)( void* pSelf );
	void (*GetSize)( void* pSelf, GPoint *pSize );
	void (*SetBounds)( void* pSelf, GRect *pBounds );
	void (*GetBounds)( void* pSelf, GRect *pBounds );
	void (*CalcClinetRect)(  void* pSelf, GRect *pClient );
	void (*GetClientRect)( void *pSelf, GRect *pClient );
	void (*ClientToScreen)( void *pSelf, GRect *pRect );
	GUInt32 (*GetStyle)(  void *pSelf );
	void (*SetVisibleStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetVisibleStatus)( void *pSelf );
	void (*SetEnableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetEnableStatus)( void *pSelf );
	void (*SetConsumableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetConsumableStatus)( void *pSelf );
	void (*SetCaptionStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetCaptionStatus)( void *pSelf );
	void (*SetFocusStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetFocusStatus)( void *pSelf );
	void (*SetStyleStatus)( void* pSelf, GUInt32 ulStyle, GInt16 fStatus );
	GInt16 (*GetStyleStatus)( void* pSelf, GUInt32 ulStyle );
	void (*SetParent)( void* pSelf, GBaseWindow *pParent);
	GBaseWindow* (*GetParent)( void* pSelf );
	void (*SetFocusInformation)( void * pSelf, GFocusInformation *pFocusInfo );
	GFocusInformation *(*GetFocusInformation)( void * pSelf );
	GInt16 (*Create)( void *pSelf, GBaseWindow *pParent );
	void (*Delete)( void *pSelf );
	GInt16 (*ImportProperty)( void *pSelf, const GBaseWindowProperty *pProperty );
	void (*ExportProperty)( void *pSelf, GBaseWindowProperty *pProperty );
	void (*Paint)( void *pSelf, GWDC *pDC );
	void (*OnDraw)( void *pSelf, GWDC *pDC );
	void (*OnNcDraw)( void *pSelf, GWDC *pDC );
	void (*AddRefreshRect)( void *pSelf, GRect *pRefresh, GInt16 nErase );
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GInt32 (*MouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_MOUSEMOVE_ */
	GInt32 (*LButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*LButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#ifdef _ENABLE_RBUTTON_
	GInt32 (*RButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*RButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GInt32 (*KeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*KeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*SetFocus)( void *pSelf );
	void (*KillFocus)( void *pSelf );
	void (*Timer)( void *pSelf, GUInt16 usTimerID );
	GInt32 (*User)( void *pSelf, GLParam lLParam, GUParam lUParam );
	void (*Char)( void * pSelf, GUInt16 usCharCode, GUInt32 ulStatus );
	void (*Close)( void * pSelf );
	void (*DeleteChild)( void * pSelf, GBaseWindow *pChild );
	void (*SetMemorySpace)( void *pSelf, GUInt8 ucType, GUInt8 ucPlane );
	void (*GetMemorySpace)( void *pSelf, GUInt8* ucType, GUInt8* ucPlane );
	void (*SetDrawForceStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetDrawForceStatus)( void *pSelf );	
	void (*SetRedrawStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetRedrawStatus)( void *pSelf );
	void (*ClearDrawStatus)( void *pSelf );
	void (*AddDirtyRect)(	 void *pSelf, GRect *pRefreshRect, GInt16 fErase );
	void (*SetPrevTimerObject)( void *pSelf, GBaseWindow *pbwPrev );
	GBaseWindow* (*GetPrevTimerObject)( void *pSelf );
	void (*SetNextTimerObject)( void *pSelf, GBaseWindow *pbwNext  );
	GBaseWindow* (*GetNextTimerObject)( void *pSelf );
#ifndef	_DISABLE_GLAYER_
	// CΉ >>
	void (*AddDirtyRectLayer)( void *pSelf, GUInt16 usLayerID, GRect *pRefreshRect, GInt16 fErase );
	void (*SetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );		/* ݒ	*/
	GInt16 (*GetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );			/* ݒ	*/
	GInt16 (*GetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetLayerID)( void *pSelf, GUInt16 usLayerID );
	GUInt16 (*GetLayerID)( void *pSelf );
	// CΉ <<
#endif /* _DISABLE_GLAYER_ */
	void *(*HoldImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void *(*GetImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void (*CleanImageData)(void *pSelf);
	void (*Active)( void *pSelf );
	void (*OnActive)( void *pSelf );
	void (*SetActiveStatus)( void *pSelf, GInt16 nActive );
	GInt16 (*GetActiveStatus)( void *pSelf );

	void (*OnCreate)( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue );
	void (*PreDelete)( void *pSelf );
	GInt16 (*PreKeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
	GInt16 (*PreKeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*OnUser)( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
	GInt16 (*PrePress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
	GInt16 (*PreRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
	GInt16 (*PrePaint)( void *pSelf, GWDC *pDC );
	void (*OnTimer)( void *pSelf, GUInt16 usTimerID );
#if		(_USE_MULTI_COORDINATE_ != 0)
	GInt16 (*SetActiveCoordinate)( void *pSelf, GInt16 nActive );
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	void (*OnUpdateDB)( void *pSelf, void* pParam );
	GInt16 (*IsMousePointInBounds)( void* pSelf, GPoint gptPoint );

	// GPanel
	void (*SetBackGroundDesign)( void *pSelf, GDesign *pDesign );
	GDesign *(*GetBackGroundDesign)( void *pSelf );
	GInt16 (*CreateChildren)( void *pSelf );
	GInt16 (*AddChild)( void *pSelf, GBaseWindow *pChild );
	void (*DeleteAllChildren)( void *pSelf );
	GBaseWindow *(*GetChild)( void *pSelf, GUInt16 usID );
	GBaseWindowList* (*GetChildList)( void *pSelf );
	void (*DrawChildren)( void *pSelf, GWDC *pDC );
	void (*DrawBackGround)( void *pSelf, GWDC *pDC );
	GInt16 (*SetActiveChild)( void *pSelf, GInt16 nSearch, GBaseWindow *pActiveChild );
	GBaseWindow* (*GetActiveChild)( void *pSelf );
	void (*EndModal)( void *pSelf, GInt16 nRetValue );
	void (*AddBlinkControl)( void *pSelf, GControl *pControl );
	void (*RemoveBlinkControl)( void *pSelf, GControl *pControl );
	void (*AddScrollControl)( void *pSelf, GControl *pControl );
	void (*RemoveScrollControl)( void *pSelf, GControl *pControl );
	GImage *(*SetPictureData)( void *pSelf, GImage *pPictureData );
	GImage *(*GetPictureData)( void *pSelf );
	GBaseWindow* (*GetPositionChild)( void *pSelf, GPoint gptPoint);
	void (*SetNoResponseBaseArea)( void *pSelf, GUInt16 usArea, GInt32 lLength );
	void (*GetNoResponseBaseArea)(void *pSelf, GUInt16 usArea, GInt32 *lLength );
	void (*SetReleaseType) (void *pSelf, GUInt8 ucType);
	void (*GetReleaseType) (void *pSelf, GUInt8 *ucType );
	GBaseWindow* (*GetChildAt)( void *pSelf, GUInt16 usIdx );
	void (*OnShowPage) (void *pSelf );
	void (*OnHidePage) (void *pSelf );
	GInt16 (*MoveChildListFirst)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListLast)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListPrev)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListNext)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildList)(void *pSelf, GBaseWindow *pChild, GInt32 lIndex );
	GInt32 (*GetChildIndex)(void *pSelf, GBaseWindow *pChild);
	GBaseWindow* (*GetPrevChild)( void *pSelf, GBaseWindow* pChild );
	GBaseWindow* (*GetNextChild)( void *pSelf, GBaseWindow* pChild );
#ifndef	_DISABLE_GLAYER_
	GInt32 (*GetChildCount)(void *pSelf, GUInt16 usLayerID);
	GBaseWindow* (*GetFirstChildInLayer)( void *pSelf, GUInt16 usLayerID );
	GBaseWindow* (*GetLastChildInLayer)( void *pSelf, GUInt16 usLayerID );
	GBaseWindow* (*GetChildInLayer)( void *pSelf, GInt32 lIndexInLayer, GUInt16 usLayerID );
#endif /* _DISABLE_GLAYER_ */
	// GFrameAnimationPanel
	void (*AddFrameAnimation)( void *pSelf, GFrameAnimation* pFrameAnimation );
	void (*RemoveFrameAnimation)( void *pSelf, GFrameAnimation* pFrameAnimation );
	void (*StartAutoPlayFrameAnimation)( void *pSelf );
	GInt16 (*StartFrameAnimation)( void *pSelf );
	GInt16 (*ResetFrameAnimation)( void *pSelf );
	GInt16 (*StopFrameAnimation)( void *pSelf );
	GInt16 (*ResumeFrameAnimation)( void *pSelf );
	GFrameAnimation* (*FindFrameAnimation)( void *pSelf, GUInt16 usID );
	void (*SetFrameAnimationSet)( void *pSelf, const GFrameAnimationSetProperty *pAnimeSet );
	GInt16 (*SelectFrameAnimation)( void *pSelf, GUInt16 usID );
	void (*SetAsyncAnimationStatus)( void *pSelf, GUInt8 ucStatus );
	GUInt8 (*GetAsyncAnimationStatus)( void *pSelf );
	GInt16 (*StartAsyncFrameAnimation)( void *pSelf, GUInt16 usID );
	GInt16 (*ResetAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*StopAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*ResumeAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*RestartAsyncFrameAnimation)( void *pSelf, GUInt16 usID, GUInt32 ulKeyFrame );
	//}}FUNCTION_TABLE
}GPanel_Monitor_VMT;

GDefClass( GPanel_Monitor, GFrameAnimationPanel )
	//{{NATIVE_OBJECT_TABLE
	GBaseWindow* m_pObjectTable[33];
	//}}NATIVE_OBJECT_TABLE
GDefEnd

typedef struct GPanel_Monitor GPanel_Monitor;

//{{PUBLIC_METHOD
GPanel_Monitor *GWNewGPanel_Monitor( void );
const GPanel_Monitor_VMT *GWGetGPanel_MonitorVMT( void );
GInt16 GWInitGPanel_Monitor( GPanel_Monitor* pSelf );
GInt32 GPanel_Monitor_MessageProcedure( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPanel_Monitor_CallBackMessageProcedure( void* pSelf, GUInt16 usID, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt16 GPanel_Monitor_CreateChildren( void *pSelf );
GBaseWindow* GPanel_Monitor_GetChildAt( void *pSelf, GUInt16 usIdx );
//}}PUBLIC_METHOD

//{{CALLBACK_METHOD
GInt32 GPANEL_MONITOR_BTNALARMRELEASEOnPress( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNALARMRELEASEOnRelease( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNBUZZERRELEASEOnPress( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNBUZZERRELEASEOnRelease( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNINSPECTIONAUTOOnClick( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNINSPECTIONMANUALOnClick( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNMARKINGAUTOOnClick( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNMARKINGMANUALOnClick( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNMONITORMENUOnClick( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNPOSITIONINGAUTOOnClick( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GPANEL_MONITOR_BTNPOSITIONINGMANUALOnClick( GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
//}}CALLBACK_METHOD

//{{OVERRIDE_CONDITION
#define OnCreate_USE 1
#define OnTimer_USE 1
#define OnUpdateDB_USE 1
//}}OVERRIDE_CONDITION

//{{OVERRIDE_METHOD
#ifdef OnCreate_USE
void GPanel_Monitor_OnCreate( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue );
#endif
#ifdef PreDelete_USE
void GPanel_Monitor_PreDelete( void *pSelf );
#endif
#ifdef PreKeyPress_USE
GInt16 GPanel_Monitor_PreKeyPress ( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
#endif
#ifdef PreKeyRelease_USE
GInt16 GPanel_Monitor_PreKeyRelease( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
#endif
#ifdef OnUser_USE
void GPanel_Monitor_OnUser( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
#endif
#ifdef PrePress_USE
GInt16 GPanel_Monitor_PrePress( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
#endif
#ifdef PreRelease_USE
GInt16 GPanel_Monitor_PreRelease( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#ifdef PrePaint_USE
GInt16 GPanel_Monitor_PrePaint( void *pSelf, GWDC *pDC );
#endif
#ifdef OnTimer_USE
void GPanel_Monitor_OnTimer( void *pSelf, GUInt16 usTimerID );
#endif
#ifdef OnActive_USE
void GPanel_Monitor_OnActive( void *pSelf );
#endif
#ifdef OnUpdateDB_USE
void GPanel_Monitor_OnUpdateDB( void *pSelf, void *pParam );
#endif
#ifdef OnShowPage_USE
void GPanel_Monitor_OnShowPage( void *pSelf );
#endif
#ifdef OnHidePage_USE
void GPanel_Monitor_OnHidePage( void *pSelf );
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
#ifdef OnMouseMove_USE
GInt32 GPanel_Monitor_OnMouseMove( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
//}}OVERRIDE_METHOD

//{{PROTECTED_METHOD
/* p̏Ȃ֐͊֐̒`Ă */
#define GPanel_Monitor_GetType					GFrameAnimationPanel_GetType
#define GPanel_Monitor_GetID						GFrameAnimationPanel_GetID
#define GPanel_Monitor_GetXPosition				GFrameAnimationPanel_GetXPosition
#define GPanel_Monitor_GetYPosition				GFrameAnimationPanel_GetYPosition
#define GPanel_Monitor_GetPosition				GFrameAnimationPanel_GetPosition
#define GPanel_Monitor_GetWidth					GFrameAnimationPanel_GetWidth
#define GPanel_Monitor_GetHeight					GFrameAnimationPanel_GetHeight
#define GPanel_Monitor_GetSize					GFrameAnimationPanel_GetSize
#define GPanel_Monitor_SetBounds					GFrameAnimationPanel_SetBounds
#define GPanel_Monitor_GetBounds					GFrameAnimationPanel_GetBounds
#define GPanel_Monitor_CalcClientRect			GFrameAnimationPanel_CalcClientRect
#define GPanel_Monitor_GetClientRect				GFrameAnimationPanel_GetClientRect
#define GPanel_Monitor_ClientToScreen			GFrameAnimationPanel_ClientToScreen
#define GPanel_Monitor_GetStyle					GFrameAnimationPanel_GetStyle
#define GPanel_Monitor_SetVisibleStatus			GFrameAnimationPanel_SetVisibleStatus
#define GPanel_Monitor_GetVisibleStatus			GFrameAnimationPanel_GetVisibleStatus
#define GPanel_Monitor_SetEnableStatus			GFrameAnimationPanel_SetEnableStatus
#define GPanel_Monitor_GetEnableStatus			GFrameAnimationPanel_GetEnableStatus
#define GPanel_Monitor_SetConsumableStatus		GFrameAnimationPanel_SetConsumableStatus
#define GPanel_Monitor_GetConsumableStatus		GFrameAnimationPanel_GetConsumableStatus
#define GPanel_Monitor_SetCaptionStatus			GFrameAnimationPanel_SetCaptionStatus
#define GPanel_Monitor_GetCaptionStatus			GFrameAnimationPanel_GetCaptionStatus
#define GPanel_Monitor_SetFocusStatus			GFrameAnimationPanel_SetFocusStatus
#define GPanel_Monitor_GetFocusStatus			GFrameAnimationPanel_GetFocusStatus
#define GPanel_Monitor_SetStyleStatus			GFrameAnimationPanel_SetStyleStatus
#define GPanel_Monitor_GetStyleStatus			GFrameAnimationPanel_GetStyleStatus
#define GPanel_Monitor_SetParent					GFrameAnimationPanel_SetParent
#define GPanel_Monitor_GetParent					GFrameAnimationPanel_GetParent
#define GPanel_Monitor_SetFocusInformation		GFrameAnimationPanel_SetFocusInformation
#define GPanel_Monitor_GetFocusInformation		GFrameAnimationPanel_GetFocusInformation
#define GPanel_Monitor_ImportProperty			GFrameAnimationPanel_ImportProperty
#define GPanel_Monitor_ExportProperty			GFrameAnimationPanel_ExportProperty
#define GPanel_Monitor_Create					GFrameAnimationPanel_Create
#define GPanel_Monitor_Delete					GFrameAnimationPanel_Delete
#define GPanel_Monitor_Paint						GFrameAnimationPanel_Paint
#define GPanel_Monitor_OnDraw					GFrameAnimationPanel_OnDraw
#define GPanel_Monitor_OnNcDraw					GFrameAnimationPanel_OnNcDraw
#define GPanel_Monitor_AddRefreshRect			GFrameAnimationPanel_AddRefreshRect
#define GPanel_Monitor_MouseMove					GFrameAnimationPanel_MouseMove
#define GPanel_Monitor_OnNcMouseMove				GFrameAnimationPanel_OnNcMouseMove
#define GPanel_Monitor_LButtonPress				GFrameAnimationPanel_LButtonPress
#define GPanel_Monitor_OnLButtonPress			GFrameAnimationPanel_OnLButtonPress
#define GPanel_Monitor_OnNcLButtonPress			GFrameAnimationPanel_OnNcLButtonPress
#define GPanel_Monitor_LButtonRelease			GFrameAnimationPanel_LButtonRelease
#define GPanel_Monitor_OnLButtonRelease			GFrameAnimationPanel_OnLButtonRelease
#define GPanel_Monitor_OnNcLButtonRelease		GFrameAnimationPanel_OnNcLButtonRelease
#define GPanel_Monitor_RButtonPress				GFrameAnimationPanel_RButtonPress
#define GPanel_Monitor_OnRButtonPress			GFrameAnimationPanel_OnRButtonPress
#define GPanel_Monitor_OnNcRButtonPress			GFrameAnimationPanel_OnNcRButtonPress
#define GPanel_Monitor_RButtonRelease			GFrameAnimationPanel_RButtonRelease
#define GPanel_Monitor_OnRButtonRelease			GFrameAnimationPanel_OnRButtonRelease
#define GPanel_Monitor_OnNcRButtonRelease		GFrameAnimationPanel_OnNcRButtonRelease
#define GPanel_Monitor_KeyPress					GFrameAnimationPanel_KeyPress
#define GPanel_Monitor_KeyRelease				GFrameAnimationPanel_KeyRelease
#define GPanel_Monitor_SetFocus					GFrameAnimationPanel_SetFocus
#define GPanel_Monitor_KillFocus					GFrameAnimationPanel_KillFocus
#define GPanel_Monitor_Timer						GFrameAnimationPanel_Timer
#define GPanel_Monitor_User						GFrameAnimationPanel_User
#define GPanel_Monitor_Char						GFrameAnimationPanel_Char
#define GPanel_Monitor_Close						GFrameAnimationPanel_Close
#define GPanel_Monitor_DeleteChild				GFrameAnimationPanel_DeleteChild
#define GPanel_Monitor_SetMemorySpace			GFrameAnimationPanel_SetMemorySpace
#define GPanel_Monitor_GetMemorySpace			GFrameAnimationPanel_GetMemorySpace
#define GPanel_Monitor_SetDrawForceStatus 		GFrameAnimationPanel_SetDrawForceStatus
#define GPanel_Monitor_GetDrawForceStatus 		GFrameAnimationPanel_GetDrawForceStatus
#define GPanel_Monitor_SetRedrawStatus 			GFrameAnimationPanel_SetRedrawStatus
#define GPanel_Monitor_GetRedrawStatus 			GFrameAnimationPanel_GetRedrawStatus
#define GPanel_Monitor_ClearDrawStatus 			GFrameAnimationPanel_ClearDrawStatus
#define GPanel_Monitor_AddDirtyRect 				GFrameAnimationPanel_AddDirtyRect
#define GPanel_Monitor_SetPrevTimerObject GFrameAnimationPanel_SetPrevTimerObject
#define GPanel_Monitor_GetPrevTimerObject GFrameAnimationPanel_GetPrevTimerObject
#define GPanel_Monitor_SetNextTimerObject GFrameAnimationPanel_SetNextTimerObject
#define GPanel_Monitor_GetNextTimerObject GFrameAnimationPanel_GetNextTimerObject

#define GPanel_Monitor_MoveChildListFirst GFrameAnimationPanel_MoveChildListFirst
#define GPanel_Monitor_MoveChildListLast GFrameAnimationPanel_MoveChildListLast
#define GPanel_Monitor_MoveChildListPrev GFrameAnimationPanel_MoveChildListPrev
#define GPanel_Monitor_MoveChildListNext GFrameAnimationPanel_MoveChildListNext
#define GPanel_Monitor_MoveChildList GFrameAnimationPanel_MoveChildList
#define GPanel_Monitor_GetChildIndex GFrameAnimationPanel_GetChildIndex
#define GPanel_Monitor_GetPrevChild	GFrameAnimationPanel_GetPrevChild
#define GPanel_Monitor_GetNextChild	GFrameAnimationPanel_GetNextChild
#ifndef _DISABLE_GLAYER_
#define GPanel_Monitor_GetChildCount GFrameAnimationPanel_GetChildCount
#define GPanel_Monitor_GetFirstChildInLayer	GFrameAnimationPanel_GetFirstChildInLayer
#define GPanel_Monitor_GetLastChildInLayer	GFrameAnimationPanel_GetLastChildInLayer
#define GPanel_Monitor_GetChildInLayer		GFrameAnimationPanel_GetChildInLayer
#endif /* _DISABLE_GLAYER_ */

#define	GPanel_Monitor_SetBackGroundDesign		GFrameAnimationPanel_SetBackGroundDesign
#define	GPanel_Monitor_GetBackGroundDesign		GFrameAnimationPanel_GetBackGroundDesign
#define	GPanel_Monitor_AddChild					GFrameAnimationPanel_AddChild
#define	GPanel_Monitor_DeleteAllChildren			GFrameAnimationPanel_DeleteAllChildren
#define	GPanel_Monitor_GetChild					GFrameAnimationPanel_GetChild
#define	GPanel_Monitor_GetChildList				GFrameAnimationPanel_GetChildList
#define	GPanel_Monitor_DrawChildren				GFrameAnimationPanel_DrawChildren
#define	GPanel_Monitor_DrawBackGround			GFrameAnimationPanel_DrawBackGround
#define	GPanel_Monitor_SetActiveChild			GFrameAnimationPanel_SetActiveChild
#define	GPanel_Monitor_GetActiveChild			GFrameAnimationPanel_GetActiveChild
#define	GPanel_Monitor_EndModal					GFrameAnimationPanel_EndModal
#define	GPanel_Monitor_AddBlinkControl			GFrameAnimationPanel_AddBlinkControl
#define	GPanel_Monitor_RemoveBlinkControl		GFrameAnimationPanel_RemoveBlinkControl
#define	GPanel_Monitor_AddScrollControl			GFrameAnimationPanel_AddScrollControl
#define	GPanel_Monitor_RemoveScrollControl		GFrameAnimationPanel_RemoveScrollControl
#define GPanel_Monitor_SetPictureData			GFrameAnimationPanel_SetPictureData
#define GPanel_Monitor_GetPictureData			GFrameAnimationPanel_GetPictureData
#define GPanel_Monitor_GetPositionChild			GFrameAnimationPanel_GetPositionChild
#define GPanel_Monitor_AddFrameAnimation				GFrameAnimationPanel_AddFrameAnimation
#define GPanel_Monitor_RemoveFrameAnimation			GFrameAnimationPanel_RemoveFrameAnimation
#define GPanel_Monitor_StartAutoPlayFrameAnimation	GFrameAnimationPanel_StartAutoPlayFrameAnimation
#define GPanel_Monitor_StartFrameAnimation			GFrameAnimationPanel_StartFrameAnimation
#define GPanel_Monitor_ResetFrameAnimation			GFrameAnimationPanel_ResetFrameAnimation
#define GPanel_Monitor_StopFrameAnimation			GFrameAnimationPanel_StopFrameAnimation
#define GPanel_Monitor_ResumeFrameAnimation			GFrameAnimationPanel_ResumeFrameAnimation
#define GPanel_Monitor_FindFrameAnimation			GFrameAnimationPanel_FindFrameAnimation
#define GPanel_Monitor_SetFrameAnimationSet			GFrameAnimationPanel_SetFrameAnimationSet
#define GPanel_Monitor_SelectFrameAnimation			GFrameAnimationPanel_SelectFrameAnimation
#define GPanel_Monitor_SetAsyncAnimationStatus		GFrameAnimationPanel_SetAsyncAnimationStatus
#define GPanel_Monitor_GetAsyncAnimationStatus		GFrameAnimationPanel_GetAsyncAnimationStatus
#define GPanel_Monitor_StartAsyncFrameAnimation 		GFrameAnimationPanel_StartAsyncFrameAnimation
#define GPanel_Monitor_ResetAsyncFrameAnimation 		GFrameAnimationPanel_ResetAsyncFrameAnimation
#define GPanel_Monitor_StopAsyncFrameAnimation 		GFrameAnimationPanel_StopAsyncFrameAnimation
#define GPanel_Monitor_ResumeAsyncFrameAnimation 	GFrameAnimationPanel_ResumeAsyncFrameAnimation
#define GPanel_Monitor_RestartAsyncFrameAnimation	GFrameAnimationPanel_RestartAsyncFrameAnimation

#ifndef	_DISABLE_GLAYER_
	// CΉ >>
#define GPanel_Monitor_AddDirtyRectLayer			GFrameAnimationPanel_AddDirtyRectLayer
#define GPanel_Monitor_SetDrawForceStatusLayer	GFrameAnimationPanel_SetDrawForceStatusLayer
#define GPanel_Monitor_GetDrawForceStatusLayer	GFrameAnimationPanel_GetDrawForceStatusLayer
#define GPanel_Monitor_SetRedrawStatusLayer		GFrameAnimationPanel_SetRedrawStatusLayer
#define GPanel_Monitor_GetRedrawStatusLayer		GFrameAnimationPanel_GetRedrawStatusLayer
#define GPanel_Monitor_SetLayerID				GFrameAnimationPanel_SetLayerID
#define GPanel_Monitor_GetLayerID				GFrameAnimationPanel_GetLayerID
	// CΉ <<
#endif /* _DISABLE_GLAYER_ */
#define GPanel_Monitor_HoldImageData				GFrameAnimationPanel_HoldImageData
#define GPanel_Monitor_GetImageData				GFrameAnimationPanel_GetImageData
#define GPanel_Monitor_CleanImageData			GFrameAnimationPanel_CleanImageData
#define GPanel_Monitor_Active					GFrameAnimationPanel_Active
#define GPanel_Monitor_SetActiveStatus			GFrameAnimationPanel_SetActiveStatus
#define GPanel_Monitor_GetActiveStatus			GFrameAnimationPanel_GetActiveStatus

#ifndef OnCreate_USE
#define GPanel_Monitor_OnCreate					GFrameAnimationPanel_OnCreate
#endif
#ifndef PreDelete_USE
#define GPanel_Monitor_PreDelete					GFrameAnimationPanel_PreDelete
#endif
#ifndef PreKeyPress_USE
#define GPanel_Monitor_PreKeyPress				GFrameAnimationPanel_PreKeyPress
#endif
#ifndef PreKeyRelease_USE
#define GPanel_Monitor_PreKeyRelease				GFrameAnimationPanel_PreKeyRelease
#endif
#ifndef OnUser_USE
#define GPanel_Monitor_OnUser					GFrameAnimationPanel_OnUser
#endif
#ifndef PrePress_USE
#define GPanel_Monitor_PrePress					GFrameAnimationPanel_PrePress
#endif
#ifndef PreRelease_USE
#define GPanel_Monitor_PreRelease				GFrameAnimationPanel_PreRelease
#endif
#ifndef PrePaint_USE
#define GPanel_Monitor_PrePaint					GFrameAnimationPanel_PrePaint
#endif
#ifndef OnTimer_USE
#define GPanel_Monitor_OnTimer					GFrameAnimationPanel_OnTimer
#endif
#ifndef OnActive_USE
#define GPanel_Monitor_OnActive					GFrameAnimationPanel_OnActive
#endif
#ifndef OnUpdateDB_USE
#define GPanel_Monitor_OnUpdateDB				GFrameAnimationPanel_OnUpdateDB
#endif
#ifndef OnShowPage_USE
#define GPanel_Monitor_OnShowPage				GFrameAnimationPanel_OnShowPage
#endif
#ifndef OnHidePage_USE
#define GPanel_Monitor_OnHidePage				GFrameAnimationPanel_OnHidePage
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
#ifndef OnMouseMove_USE
#define GPanel_Monitor_OnMouseMove				GFrameAnimationPanel_OnMouseMove
#endif
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */

#if		(_USE_MULTI_COORDINATE_ != 0)
#define	GPanel_Monitor_SetActiveCoordinate		GFrameAnimationPanel_SetActiveCoordinate
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
#define GPanel_Monitor_IsMousePointInBounds		GFrameAnimationPanel_IsMousePointInBounds
#define GPanel_Monitor_SetNoResponseBaseArea		GFrameAnimationPanel_SetNoResponseBaseArea
#define GPanel_Monitor_GetNoResponseBaseArea		GFrameAnimationPanel_GetNoResponseBaseArea
#define GPanel_Monitor_SetReleaseType			GFrameAnimationPanel_SetReleaseType
#define GPanel_Monitor_GetReleaseType			GFrameAnimationPanel_GetReleaseType
//#define GPanel_Monitor_GetChildAt				GFrameAnimationPanel_GetChildAt
//}}PROTECTED_METHOD

//{{UNDEF_OVERRIDE_CONDITION
#undef OnCreate_USE
#undef PreDelete_USE
#undef PreKeyPress_USE
#undef PreKeyRelease_USE
#undef OnUser_USE
#undef PrePress_USE
#undef PreRelease_USE
#undef PrePaint_USE
#undef OnTimer_USE
#undef OnActive_USE
#undef OnUpdateDB_USE
#undef OnMouseMove_USE
//}}UNDEF_OVERRIDE_CONDITION
#ifdef __cplusplus
}
#endif

#endif /* _GPANEL_MONITOR_H_ */
