#ifndef _GWINDOW_NUMERICKEYPAD_H_
#define _GWINDOW_NUMERICKEYPAD_H_
#include <genifa.h>
#include <gframeanimationpanel.h>

#ifdef __cplusplus
extern "C" {
#endif

//{{CONTROL_ID
enum{
	GWINDOW_NUMERICKEYPAD_GDUMMYTERMINATOR
};
//}}CONTROL_ID
//{{ANIMATION_ID
enum{
	GWINDOW_NUMERICKEYPAD_GANIMATIONTERMINATOR
};
//}}ANIMATION_ID

typedef struct GWindow_NumericKeypad_VMT{
	//{{FUNCTION_TABLE
	GInt32 (*MessageProcedure)( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GInt32 (*CallBackMessageProcedure)( void* pSelf, GUInt16 usID, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GUInt16 (*GetType)( void* pSelf );
	GUInt16 (*GetID)( void* pSelf );
	GInt16 (*GetXPosition)( void* pSelf );
	GInt16 (*GetYPosition)( void* pSelf );
	void (*GetPosition)( void* pSelf, GPoint *pPosition );
	GInt16 (*GetWidth)( void* pSelf );
	GInt16 (*GetHeight)( void* pSelf );
	void (*GetSize)( void* pSelf, GPoint *pSize );
	void (*SetBounds)( void* pSelf, GRect *pBounds );
	void (*GetBounds)( void* pSelf, GRect *pBounds );
	void (*CalcClinetRect)(  void* pSelf, GRect *pClient );
	void (*GetClientRect)( void *pSelf, GRect *pClient );
	void (*ClientToScreen)( void *pSelf, GRect *pRect );
	GUInt32 (*GetStyle)(  void *pSelf );
	void (*SetVisibleStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetVisibleStatus)( void *pSelf );
	void (*SetEnableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetEnableStatus)( void *pSelf );
	void (*SetConsumableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetConsumableStatus)( void *pSelf );
	void (*SetCaptionStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetCaptionStatus)( void *pSelf );
	void (*SetFocusStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetFocusStatus)( void *pSelf );
	void (*SetStyleStatus)( void* pSelf, GUInt32 ulStyle, GInt16 fStatus );
	GInt16 (*GetStyleStatus)( void* pSelf, GUInt32 ulStyle );
	void (*SetParent)( void* pSelf, GBaseWindow *pParent);
	GBaseWindow* (*GetParent)( void* pSelf );
	void (*SetFocusInformation)( void * pSelf, GFocusInformation *pFocusInfo );
	GFocusInformation *(*GetFocusInformation)( void * pSelf );
	GInt16 (*Create)( void *pSelf, GBaseWindow *pParent );
	void (*Delete)( void *pSelf );
	GInt16 (*ImportProperty)( void *pSelf, const GBaseWindowProperty *pProperty );
	void (*ExportProperty)( void *pSelf, GBaseWindowProperty *pProperty );
	void (*Paint)( void *pSelf, GWDC *pDC );
	void (*OnDraw)( void *pSelf, GWDC *pDC );
	void (*OnNcDraw)( void *pSelf, GWDC *pDC );
	void (*AddRefreshRect)( void *pSelf, GRect *pRefresh, GInt16 nErase );
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GInt32 (*MouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_MOUSEMOVE_ */
	GInt32 (*LButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*LButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#ifdef _ENABLE_RBUTTON_
	GInt32 (*RButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*RButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GInt32 (*KeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*KeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*SetFocus)( void *pSelf );
	void (*KillFocus)( void *pSelf );
	void (*Timer)( void *pSelf, GUInt16 usTimerID );
	GInt32 (*User)( void *pSelf, GLParam lLParam, GUParam lUParam );
	void (*Char)( void * pSelf, GUInt16 usCharCode, GUInt32 ulStatus );
	void (*Close)( void * pSelf );
	void (*DeleteChild)( void * pSelf, GBaseWindow *pChild );
	void (*SetMemorySpace)( void *pSelf, GUInt8 ucType, GUInt8 ucPlane );
	void (*GetMemorySpace)( void *pSelf, GUInt8* ucType, GUInt8* ucPlane );
	void (*SetDrawForceStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetDrawForceStatus)( void *pSelf );	
	void (*SetRedrawStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetRedrawStatus)( void *pSelf );
	void (*ClearDrawStatus)( void *pSelf );
	void (*AddDirtyRect)(	 void *pSelf, GRect *pRefreshRect, GInt16 fErase );
	void (*SetPrevTimerObject)( void *pSelf, GBaseWindow *pbwPrev );
	GBaseWindow* (*GetPrevTimerObject)( void *pSelf );
	void (*SetNextTimerObject)( void *pSelf, GBaseWindow *pbwNext  );
	GBaseWindow* (*GetNextTimerObject)( void *pSelf );
#ifndef	_DISABLE_GLAYER_
	// CΉ >>
	void (*AddDirtyRectLayer)( void *pSelf, GUInt16 usLayerID, GRect *pRefreshRect, GInt16 fErase );
	void (*SetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );		/* ݒ	*/
	GInt16 (*GetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );			/* ݒ	*/
	GInt16 (*GetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetLayerID)( void *pSelf, GUInt16 usLayerID );
	GUInt16 (*GetLayerID)( void *pSelf );
	// CΉ <<
#endif /* _DISABLE_GLAYER_ */
	void *(*HoldImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void *(*GetImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void (*CleanImageData)(void *pSelf);
	void (*Active)( void *pSelf );
	void (*OnActive)( void *pSelf );
	void (*SetActiveStatus)( void *pSelf, GInt16 nActive );
	GInt16 (*GetActiveStatus)( void *pSelf );

	void (*OnCreate)( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue );
	void (*PreDelete)( void *pSelf );
	GInt16 (*PreKeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
	GInt16 (*PreKeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*OnUser)( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
	GInt16 (*PrePress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
	GInt16 (*PreRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
	GInt16 (*PrePaint)( void *pSelf, GWDC *pDC );
	void (*OnTimer)( void *pSelf, GUInt16 usTimerID );
#if		(_USE_MULTI_COORDINATE_ != 0)
	GInt16 (*SetActiveCoordinate)( void *pSelf, GInt16 nActive );
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	void (*OnUpdateDB)( void *pSelf, void* pParam );
	GInt16 (*IsMousePointInBounds)( void* pSelf, GPoint gptPoint );

	// GPanel
	void (*SetBackGroundDesign)( void *pSelf, GDesign *pDesign );
	GDesign *(*GetBackGroundDesign)( void *pSelf );
	GInt16 (*CreateChildren)( void *pSelf );
	GInt16 (*AddChild)( void *pSelf, GBaseWindow *pChild );
	void (*DeleteAllChildren)( void *pSelf );
	GBaseWindow *(*GetChild)( void *pSelf, GUInt16 usID );
	GBaseWindowList* (*GetChildList)( void *pSelf );
	void (*DrawChildren)( void *pSelf, GWDC *pDC );
	void (*DrawBackGround)( void *pSelf, GWDC *pDC );
	GInt16 (*SetActiveChild)( void *pSelf, GInt16 nSearch, GBaseWindow *pActiveChild );
	GBaseWindow* (*GetActiveChild)( void *pSelf );
	void (*EndModal)( void *pSelf, GInt16 nRetValue );
	void (*AddBlinkControl)( void *pSelf, GControl *pControl );
	void (*RemoveBlinkControl)( void *pSelf, GControl *pControl );
	void (*AddScrollControl)( void *pSelf, GControl *pControl );
	void (*RemoveScrollControl)( void *pSelf, GControl *pControl );
	GImage *(*SetPictureData)( void *pSelf, GImage *pPictureData );
	GImage *(*GetPictureData)( void *pSelf );
	GBaseWindow* (*GetPositionChild)( void *pSelf, GPoint gptPoint);
	void (*SetNoResponseBaseArea)( void *pSelf, GUInt16 usArea, GInt32 lLength );
	void (*GetNoResponseBaseArea)(void *pSelf, GUInt16 usArea, GInt32 *lLength );
	void (*SetReleaseType) (void *pSelf, GUInt8 ucType);
	void (*GetReleaseType) (void *pSelf, GUInt8 *ucType );
	GBaseWindow* (*GetChildAt)( void *pSelf, GUInt16 usIdx );
	void (*OnShowPage) (void *pSelf );
	void (*OnHidePage) (void *pSelf );
	GInt16 (*MoveChildListFirst)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListLast)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListPrev)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListNext)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildList)(void *pSelf, GBaseWindow *pChild, GInt32 lIndex );
	GInt32 (*GetChildIndex)(void *pSelf, GBaseWindow *pChild);
	GBaseWindow* (*GetPrevChild)( void *pSelf, GBaseWindow* pChild );
	GBaseWindow* (*GetNextChild)( void *pSelf, GBaseWindow* pChild );
#ifndef	_DISABLE_GLAYER_
	GInt32 (*GetChildCount)(void *pSelf, GUInt16 usLayerID);
	GBaseWindow* (*GetFirstChildInLayer)( void *pSelf, GUInt16 usLayerID );
	GBaseWindow* (*GetLastChildInLayer)( void *pSelf, GUInt16 usLayerID );
	GBaseWindow* (*GetChildInLayer)( void *pSelf, GInt32 lIndexInLayer, GUInt16 usLayerID );
#endif /* _DISABLE_GLAYER_ */
	// GFrameAnimationPanel
	void (*AddFrameAnimation)( void *pSelf, GFrameAnimation* pFrameAnimation );
	void (*RemoveFrameAnimation)( void *pSelf, GFrameAnimation* pFrameAnimation );
	void (*StartAutoPlayFrameAnimation)( void *pSelf );
	GInt16 (*StartFrameAnimation)( void *pSelf );
	GInt16 (*ResetFrameAnimation)( void *pSelf );
	GInt16 (*StopFrameAnimation)( void *pSelf );
	GInt16 (*ResumeFrameAnimation)( void *pSelf );
	GFrameAnimation* (*FindFrameAnimation)( void *pSelf, GUInt16 usID );
	void (*SetFrameAnimationSet)( void *pSelf, const GFrameAnimationSetProperty *pAnimeSet );
	GInt16 (*SelectFrameAnimation)( void *pSelf, GUInt16 usID );
	void (*SetAsyncAnimationStatus)( void *pSelf, GUInt8 ucStatus );
	GUInt8 (*GetAsyncAnimationStatus)( void *pSelf );
	GInt16 (*StartAsyncFrameAnimation)( void *pSelf, GUInt16 usID );
	GInt16 (*ResetAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*StopAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*ResumeAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*RestartAsyncFrameAnimation)( void *pSelf, GUInt16 usID, GUInt32 ulKeyFrame );
	//}}FUNCTION_TABLE
}GWindow_NumericKeypad_VMT;

GDefClass( GWindow_NumericKeypad, GFrameAnimationPanel )
	//{{NATIVE_OBJECT_TABLE
	GBaseWindow* m_pObjectTable[20];
	//}}NATIVE_OBJECT_TABLE
GDefEnd

typedef struct GWindow_NumericKeypad GWindow_NumericKeypad;

//{{PUBLIC_METHOD
GWindow_NumericKeypad *GWNewGWindow_NumericKeypad( void );
const GWindow_NumericKeypad_VMT *GWGetGWindow_NumericKeypadVMT( void );
GInt16 GWInitGWindow_NumericKeypad( GWindow_NumericKeypad* pSelf );
GInt32 GWindow_NumericKeypad_MessageProcedure( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWindow_NumericKeypad_CallBackMessageProcedure( void* pSelf, GUInt16 usID, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt16 GWindow_NumericKeypad_CreateChildren( void *pSelf );
GBaseWindow* GWindow_NumericKeypad_GetChildAt( void *pSelf, GUInt16 usIdx );
//}}PUBLIC_METHOD

//{{CALLBACK_METHOD
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM0OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM1OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM2OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM3OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM4OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM5OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM6OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM7OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM8OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUM9OnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMAOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMBOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMCONFIGOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMCORRECTIONOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMCOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMDOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMEOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYNUMFOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_NUMERICKEYPAD_BTNKEYPOSITIVEORNEGATIVEOnClick( GWindow_NumericKeypad *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
//}}CALLBACK_METHOD

//{{OVERRIDE_CONDITION
#define OnCreate_USE 1
//}}OVERRIDE_CONDITION

//{{OVERRIDE_METHOD
#ifdef OnCreate_USE
void GWindow_NumericKeypad_OnCreate( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue );
#endif
#ifdef PreDelete_USE
void GWindow_NumericKeypad_PreDelete( void *pSelf );
#endif
#ifdef PreKeyPress_USE
GInt16 GWindow_NumericKeypad_PreKeyPress ( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
#endif
#ifdef PreKeyRelease_USE
GInt16 GWindow_NumericKeypad_PreKeyRelease( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
#endif
#ifdef OnUser_USE
void GWindow_NumericKeypad_OnUser( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
#endif
#ifdef PrePress_USE
GInt16 GWindow_NumericKeypad_PrePress( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
#endif
#ifdef PreRelease_USE
GInt16 GWindow_NumericKeypad_PreRelease( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#ifdef PrePaint_USE
GInt16 GWindow_NumericKeypad_PrePaint( void *pSelf, GWDC *pDC );
#endif
#ifdef OnTimer_USE
void GWindow_NumericKeypad_OnTimer( void *pSelf, GUInt16 usTimerID );
#endif
#ifdef OnActive_USE
void GWindow_NumericKeypad_OnActive( void *pSelf );
#endif
#ifdef OnUpdateDB_USE
void GWindow_NumericKeypad_OnUpdateDB( void *pSelf, void *pParam );
#endif
#ifdef OnShowPage_USE
void GWindow_NumericKeypad_OnShowPage( void *pSelf );
#endif
#ifdef OnHidePage_USE
void GWindow_NumericKeypad_OnHidePage( void *pSelf );
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
#ifdef OnMouseMove_USE
GInt32 GWindow_NumericKeypad_OnMouseMove( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
//}}OVERRIDE_METHOD

//{{PROTECTED_METHOD
/* p̏Ȃ֐͊֐̒`Ă */
#define GWindow_NumericKeypad_GetType					GFrameAnimationPanel_GetType
#define GWindow_NumericKeypad_GetID						GFrameAnimationPanel_GetID
#define GWindow_NumericKeypad_GetXPosition				GFrameAnimationPanel_GetXPosition
#define GWindow_NumericKeypad_GetYPosition				GFrameAnimationPanel_GetYPosition
#define GWindow_NumericKeypad_GetPosition				GFrameAnimationPanel_GetPosition
#define GWindow_NumericKeypad_GetWidth					GFrameAnimationPanel_GetWidth
#define GWindow_NumericKeypad_GetHeight					GFrameAnimationPanel_GetHeight
#define GWindow_NumericKeypad_GetSize					GFrameAnimationPanel_GetSize
#define GWindow_NumericKeypad_SetBounds					GFrameAnimationPanel_SetBounds
#define GWindow_NumericKeypad_GetBounds					GFrameAnimationPanel_GetBounds
#define GWindow_NumericKeypad_CalcClientRect			GFrameAnimationPanel_CalcClientRect
#define GWindow_NumericKeypad_GetClientRect				GFrameAnimationPanel_GetClientRect
#define GWindow_NumericKeypad_ClientToScreen			GFrameAnimationPanel_ClientToScreen
#define GWindow_NumericKeypad_GetStyle					GFrameAnimationPanel_GetStyle
#define GWindow_NumericKeypad_SetVisibleStatus			GFrameAnimationPanel_SetVisibleStatus
#define GWindow_NumericKeypad_GetVisibleStatus			GFrameAnimationPanel_GetVisibleStatus
#define GWindow_NumericKeypad_SetEnableStatus			GFrameAnimationPanel_SetEnableStatus
#define GWindow_NumericKeypad_GetEnableStatus			GFrameAnimationPanel_GetEnableStatus
#define GWindow_NumericKeypad_SetConsumableStatus		GFrameAnimationPanel_SetConsumableStatus
#define GWindow_NumericKeypad_GetConsumableStatus		GFrameAnimationPanel_GetConsumableStatus
#define GWindow_NumericKeypad_SetCaptionStatus			GFrameAnimationPanel_SetCaptionStatus
#define GWindow_NumericKeypad_GetCaptionStatus			GFrameAnimationPanel_GetCaptionStatus
#define GWindow_NumericKeypad_SetFocusStatus			GFrameAnimationPanel_SetFocusStatus
#define GWindow_NumericKeypad_GetFocusStatus			GFrameAnimationPanel_GetFocusStatus
#define GWindow_NumericKeypad_SetStyleStatus			GFrameAnimationPanel_SetStyleStatus
#define GWindow_NumericKeypad_GetStyleStatus			GFrameAnimationPanel_GetStyleStatus
#define GWindow_NumericKeypad_SetParent					GFrameAnimationPanel_SetParent
#define GWindow_NumericKeypad_GetParent					GFrameAnimationPanel_GetParent
#define GWindow_NumericKeypad_SetFocusInformation		GFrameAnimationPanel_SetFocusInformation
#define GWindow_NumericKeypad_GetFocusInformation		GFrameAnimationPanel_GetFocusInformation
#define GWindow_NumericKeypad_ImportProperty			GFrameAnimationPanel_ImportProperty
#define GWindow_NumericKeypad_ExportProperty			GFrameAnimationPanel_ExportProperty
#define GWindow_NumericKeypad_Create					GFrameAnimationPanel_Create
#define GWindow_NumericKeypad_Delete					GFrameAnimationPanel_Delete
#define GWindow_NumericKeypad_Paint						GFrameAnimationPanel_Paint
#define GWindow_NumericKeypad_OnDraw					GFrameAnimationPanel_OnDraw
#define GWindow_NumericKeypad_OnNcDraw					GFrameAnimationPanel_OnNcDraw
#define GWindow_NumericKeypad_AddRefreshRect			GFrameAnimationPanel_AddRefreshRect
#define GWindow_NumericKeypad_MouseMove					GFrameAnimationPanel_MouseMove
#define GWindow_NumericKeypad_OnNcMouseMove				GFrameAnimationPanel_OnNcMouseMove
#define GWindow_NumericKeypad_LButtonPress				GFrameAnimationPanel_LButtonPress
#define GWindow_NumericKeypad_OnLButtonPress			GFrameAnimationPanel_OnLButtonPress
#define GWindow_NumericKeypad_OnNcLButtonPress			GFrameAnimationPanel_OnNcLButtonPress
#define GWindow_NumericKeypad_LButtonRelease			GFrameAnimationPanel_LButtonRelease
#define GWindow_NumericKeypad_OnLButtonRelease			GFrameAnimationPanel_OnLButtonRelease
#define GWindow_NumericKeypad_OnNcLButtonRelease		GFrameAnimationPanel_OnNcLButtonRelease
#define GWindow_NumericKeypad_RButtonPress				GFrameAnimationPanel_RButtonPress
#define GWindow_NumericKeypad_OnRButtonPress			GFrameAnimationPanel_OnRButtonPress
#define GWindow_NumericKeypad_OnNcRButtonPress			GFrameAnimationPanel_OnNcRButtonPress
#define GWindow_NumericKeypad_RButtonRelease			GFrameAnimationPanel_RButtonRelease
#define GWindow_NumericKeypad_OnRButtonRelease			GFrameAnimationPanel_OnRButtonRelease
#define GWindow_NumericKeypad_OnNcRButtonRelease		GFrameAnimationPanel_OnNcRButtonRelease
#define GWindow_NumericKeypad_KeyPress					GFrameAnimationPanel_KeyPress
#define GWindow_NumericKeypad_KeyRelease				GFrameAnimationPanel_KeyRelease
#define GWindow_NumericKeypad_SetFocus					GFrameAnimationPanel_SetFocus
#define GWindow_NumericKeypad_KillFocus					GFrameAnimationPanel_KillFocus
#define GWindow_NumericKeypad_Timer						GFrameAnimationPanel_Timer
#define GWindow_NumericKeypad_User						GFrameAnimationPanel_User
#define GWindow_NumericKeypad_Char						GFrameAnimationPanel_Char
#define GWindow_NumericKeypad_Close						GFrameAnimationPanel_Close
#define GWindow_NumericKeypad_DeleteChild				GFrameAnimationPanel_DeleteChild
#define GWindow_NumericKeypad_SetMemorySpace			GFrameAnimationPanel_SetMemorySpace
#define GWindow_NumericKeypad_GetMemorySpace			GFrameAnimationPanel_GetMemorySpace
#define GWindow_NumericKeypad_SetDrawForceStatus 		GFrameAnimationPanel_SetDrawForceStatus
#define GWindow_NumericKeypad_GetDrawForceStatus 		GFrameAnimationPanel_GetDrawForceStatus
#define GWindow_NumericKeypad_SetRedrawStatus 			GFrameAnimationPanel_SetRedrawStatus
#define GWindow_NumericKeypad_GetRedrawStatus 			GFrameAnimationPanel_GetRedrawStatus
#define GWindow_NumericKeypad_ClearDrawStatus 			GFrameAnimationPanel_ClearDrawStatus
#define GWindow_NumericKeypad_AddDirtyRect 				GFrameAnimationPanel_AddDirtyRect
#define GWindow_NumericKeypad_SetPrevTimerObject GFrameAnimationPanel_SetPrevTimerObject
#define GWindow_NumericKeypad_GetPrevTimerObject GFrameAnimationPanel_GetPrevTimerObject
#define GWindow_NumericKeypad_SetNextTimerObject GFrameAnimationPanel_SetNextTimerObject
#define GWindow_NumericKeypad_GetNextTimerObject GFrameAnimationPanel_GetNextTimerObject

#define GWindow_NumericKeypad_MoveChildListFirst GFrameAnimationPanel_MoveChildListFirst
#define GWindow_NumericKeypad_MoveChildListLast GFrameAnimationPanel_MoveChildListLast
#define GWindow_NumericKeypad_MoveChildListPrev GFrameAnimationPanel_MoveChildListPrev
#define GWindow_NumericKeypad_MoveChildListNext GFrameAnimationPanel_MoveChildListNext
#define GWindow_NumericKeypad_MoveChildList GFrameAnimationPanel_MoveChildList
#define GWindow_NumericKeypad_GetChildIndex GFrameAnimationPanel_GetChildIndex
#define GWindow_NumericKeypad_GetPrevChild	GFrameAnimationPanel_GetPrevChild
#define GWindow_NumericKeypad_GetNextChild	GFrameAnimationPanel_GetNextChild
#ifndef _DISABLE_GLAYER_
#define GWindow_NumericKeypad_GetChildCount GFrameAnimationPanel_GetChildCount
#define GWindow_NumericKeypad_GetFirstChildInLayer	GFrameAnimationPanel_GetFirstChildInLayer
#define GWindow_NumericKeypad_GetLastChildInLayer	GFrameAnimationPanel_GetLastChildInLayer
#define GWindow_NumericKeypad_GetChildInLayer		GFrameAnimationPanel_GetChildInLayer
#endif /* _DISABLE_GLAYER_ */

#define	GWindow_NumericKeypad_SetBackGroundDesign		GFrameAnimationPanel_SetBackGroundDesign
#define	GWindow_NumericKeypad_GetBackGroundDesign		GFrameAnimationPanel_GetBackGroundDesign
#define	GWindow_NumericKeypad_AddChild					GFrameAnimationPanel_AddChild
#define	GWindow_NumericKeypad_DeleteAllChildren			GFrameAnimationPanel_DeleteAllChildren
#define	GWindow_NumericKeypad_GetChild					GFrameAnimationPanel_GetChild
#define	GWindow_NumericKeypad_GetChildList				GFrameAnimationPanel_GetChildList
#define	GWindow_NumericKeypad_DrawChildren				GFrameAnimationPanel_DrawChildren
#define	GWindow_NumericKeypad_DrawBackGround			GFrameAnimationPanel_DrawBackGround
#define	GWindow_NumericKeypad_SetActiveChild			GFrameAnimationPanel_SetActiveChild
#define	GWindow_NumericKeypad_GetActiveChild			GFrameAnimationPanel_GetActiveChild
#define	GWindow_NumericKeypad_EndModal					GFrameAnimationPanel_EndModal
#define	GWindow_NumericKeypad_AddBlinkControl			GFrameAnimationPanel_AddBlinkControl
#define	GWindow_NumericKeypad_RemoveBlinkControl		GFrameAnimationPanel_RemoveBlinkControl
#define	GWindow_NumericKeypad_AddScrollControl			GFrameAnimationPanel_AddScrollControl
#define	GWindow_NumericKeypad_RemoveScrollControl		GFrameAnimationPanel_RemoveScrollControl
#define GWindow_NumericKeypad_SetPictureData			GFrameAnimationPanel_SetPictureData
#define GWindow_NumericKeypad_GetPictureData			GFrameAnimationPanel_GetPictureData
#define GWindow_NumericKeypad_GetPositionChild			GFrameAnimationPanel_GetPositionChild
#define GWindow_NumericKeypad_AddFrameAnimation				GFrameAnimationPanel_AddFrameAnimation
#define GWindow_NumericKeypad_RemoveFrameAnimation			GFrameAnimationPanel_RemoveFrameAnimation
#define GWindow_NumericKeypad_StartAutoPlayFrameAnimation	GFrameAnimationPanel_StartAutoPlayFrameAnimation
#define GWindow_NumericKeypad_StartFrameAnimation			GFrameAnimationPanel_StartFrameAnimation
#define GWindow_NumericKeypad_ResetFrameAnimation			GFrameAnimationPanel_ResetFrameAnimation
#define GWindow_NumericKeypad_StopFrameAnimation			GFrameAnimationPanel_StopFrameAnimation
#define GWindow_NumericKeypad_ResumeFrameAnimation			GFrameAnimationPanel_ResumeFrameAnimation
#define GWindow_NumericKeypad_FindFrameAnimation			GFrameAnimationPanel_FindFrameAnimation
#define GWindow_NumericKeypad_SetFrameAnimationSet			GFrameAnimationPanel_SetFrameAnimationSet
#define GWindow_NumericKeypad_SelectFrameAnimation			GFrameAnimationPanel_SelectFrameAnimation
#define GWindow_NumericKeypad_SetAsyncAnimationStatus		GFrameAnimationPanel_SetAsyncAnimationStatus
#define GWindow_NumericKeypad_GetAsyncAnimationStatus		GFrameAnimationPanel_GetAsyncAnimationStatus
#define GWindow_NumericKeypad_StartAsyncFrameAnimation 		GFrameAnimationPanel_StartAsyncFrameAnimation
#define GWindow_NumericKeypad_ResetAsyncFrameAnimation 		GFrameAnimationPanel_ResetAsyncFrameAnimation
#define GWindow_NumericKeypad_StopAsyncFrameAnimation 		GFrameAnimationPanel_StopAsyncFrameAnimation
#define GWindow_NumericKeypad_ResumeAsyncFrameAnimation 	GFrameAnimationPanel_ResumeAsyncFrameAnimation
#define GWindow_NumericKeypad_RestartAsyncFrameAnimation	GFrameAnimationPanel_RestartAsyncFrameAnimation

#ifndef	_DISABLE_GLAYER_
	// CΉ >>
#define GWindow_NumericKeypad_AddDirtyRectLayer			GFrameAnimationPanel_AddDirtyRectLayer
#define GWindow_NumericKeypad_SetDrawForceStatusLayer	GFrameAnimationPanel_SetDrawForceStatusLayer
#define GWindow_NumericKeypad_GetDrawForceStatusLayer	GFrameAnimationPanel_GetDrawForceStatusLayer
#define GWindow_NumericKeypad_SetRedrawStatusLayer		GFrameAnimationPanel_SetRedrawStatusLayer
#define GWindow_NumericKeypad_GetRedrawStatusLayer		GFrameAnimationPanel_GetRedrawStatusLayer
#define GWindow_NumericKeypad_SetLayerID				GFrameAnimationPanel_SetLayerID
#define GWindow_NumericKeypad_GetLayerID				GFrameAnimationPanel_GetLayerID
	// CΉ <<
#endif /* _DISABLE_GLAYER_ */
#define GWindow_NumericKeypad_HoldImageData				GFrameAnimationPanel_HoldImageData
#define GWindow_NumericKeypad_GetImageData				GFrameAnimationPanel_GetImageData
#define GWindow_NumericKeypad_CleanImageData			GFrameAnimationPanel_CleanImageData
#define GWindow_NumericKeypad_Active					GFrameAnimationPanel_Active
#define GWindow_NumericKeypad_SetActiveStatus			GFrameAnimationPanel_SetActiveStatus
#define GWindow_NumericKeypad_GetActiveStatus			GFrameAnimationPanel_GetActiveStatus

#ifndef OnCreate_USE
#define GWindow_NumericKeypad_OnCreate					GFrameAnimationPanel_OnCreate
#endif
#ifndef PreDelete_USE
#define GWindow_NumericKeypad_PreDelete					GFrameAnimationPanel_PreDelete
#endif
#ifndef PreKeyPress_USE
#define GWindow_NumericKeypad_PreKeyPress				GFrameAnimationPanel_PreKeyPress
#endif
#ifndef PreKeyRelease_USE
#define GWindow_NumericKeypad_PreKeyRelease				GFrameAnimationPanel_PreKeyRelease
#endif
#ifndef OnUser_USE
#define GWindow_NumericKeypad_OnUser					GFrameAnimationPanel_OnUser
#endif
#ifndef PrePress_USE
#define GWindow_NumericKeypad_PrePress					GFrameAnimationPanel_PrePress
#endif
#ifndef PreRelease_USE
#define GWindow_NumericKeypad_PreRelease				GFrameAnimationPanel_PreRelease
#endif
#ifndef PrePaint_USE
#define GWindow_NumericKeypad_PrePaint					GFrameAnimationPanel_PrePaint
#endif
#ifndef OnTimer_USE
#define GWindow_NumericKeypad_OnTimer					GFrameAnimationPanel_OnTimer
#endif
#ifndef OnActive_USE
#define GWindow_NumericKeypad_OnActive					GFrameAnimationPanel_OnActive
#endif
#ifndef OnUpdateDB_USE
#define GWindow_NumericKeypad_OnUpdateDB				GFrameAnimationPanel_OnUpdateDB
#endif
#ifndef OnShowPage_USE
#define GWindow_NumericKeypad_OnShowPage				GFrameAnimationPanel_OnShowPage
#endif
#ifndef OnHidePage_USE
#define GWindow_NumericKeypad_OnHidePage				GFrameAnimationPanel_OnHidePage
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
#ifndef OnMouseMove_USE
#define GWindow_NumericKeypad_OnMouseMove				GFrameAnimationPanel_OnMouseMove
#endif
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */

#if		(_USE_MULTI_COORDINATE_ != 0)
#define	GWindow_NumericKeypad_SetActiveCoordinate		GFrameAnimationPanel_SetActiveCoordinate
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
#define GWindow_NumericKeypad_IsMousePointInBounds		GFrameAnimationPanel_IsMousePointInBounds
#define GWindow_NumericKeypad_SetNoResponseBaseArea		GFrameAnimationPanel_SetNoResponseBaseArea
#define GWindow_NumericKeypad_GetNoResponseBaseArea		GFrameAnimationPanel_GetNoResponseBaseArea
#define GWindow_NumericKeypad_SetReleaseType			GFrameAnimationPanel_SetReleaseType
#define GWindow_NumericKeypad_GetReleaseType			GFrameAnimationPanel_GetReleaseType
//#define GWindow_NumericKeypad_GetChildAt				GFrameAnimationPanel_GetChildAt
//}}PROTECTED_METHOD

//{{UNDEF_OVERRIDE_CONDITION
#undef OnCreate_USE
#undef PreDelete_USE
#undef PreKeyPress_USE
#undef PreKeyRelease_USE
#undef OnUser_USE
#undef PrePress_USE
#undef PreRelease_USE
#undef PrePaint_USE
#undef OnTimer_USE
#undef OnActive_USE
#undef OnUpdateDB_USE
#undef OnMouseMove_USE
//}}UNDEF_OVERRIDE_CONDITION
#ifdef __cplusplus
}
#endif

#endif /* _GWINDOW_NUMERICKEYPAD_H_ */
