#include "GAction.h"
#include "gbasiccontrol.h"
#include "gbutton.h"
#include "gcheckbox.h"
#include "glabel.h"
#include "glist.h"
#include "gpicture.h"
#include "gprogressbar.h"
#include "gradiobutton.h"
#include "gtextbox.h"
#include "gtextboxex.h"
#include "gscrollbarex.h"
#include "ggrid.h"
#include "gstatictext.h"
#include "gnumbmp.h"
#include "gcachetext.h"
#include "gpanel.h"
#include "gwindow.h"
#include "gscreen.h"
#include "gsvframe.h"
#include "genifa.h"
#include "gwin.h"
#include "gframeanimationpanel.h"

/* NULL `FbN}N */
#ifdef _DEBUG

#define ACTION_OBJ_CHECK( pObject )						\
{														\
	GInt32	nCondition = 1;									\
	if( pObject == NULL ){								\
		GABORTERROR (nCondition, GERROR_BAD_PARAMETER);	\
		GDSetGlobalError (GERROR_BAD_PARAMETER);		\
		return;											\
	}													\
}														\

#else/*_DEBUG*/

#define ACTION_OBJ_CHECK( pObject )						\
{														\
	if( pObject == NULL ){								\
		GDSetGlobalError (GERROR_BAD_PARAMETER);		\
		return;											\
	}													\
}														\

#endif/*_DEBUG*/

/*
 *	<summary>		:	y[W|C^ƃt[IDсAt[̃plNoAt[pl̃|C^Ԃ
 *
 *	<parameter>		:	(i)GPanel* pPanel				:pl/EBhẼ|C^
 *						(i)GInt16 usFrameid		 		:t[ID
 *						(i)GUInt16 usFramePageNo :t[̃plNo
 *
 *	<return>		:	t[pl̃|C^(0ȊO)		:
 *						NULL								:s(s or t[pl݂Ȃ)
 *
 *	<description>	:	y[W|C^ƃt[IDсAt[̃plNoAt[pl̃|C^Ԃ
 *						IuWFNg擾łȂƂNULLԂ
 *
 *
 */
GPanel* GSGetFramePanel( GPanel* pPanel ,GInt16 usFrameid,GUInt16 usFramePageNo )
{
	GSVFrame *pSvFrame; /*r[t[iejIuWFNg*/
	pSvFrame = (GSVFrame *)GWGetVmt( GPanel_VMT, pPanel )->GetChild( pPanel, usFrameid);
	return (GPanel *)GWGetVmt( GPanel_VMT, pSvFrame )->GetChild( pSvFrame, usFramePageNo);
}

/*
 *	<summary>		:	pl/EBhENoƃRg[IDAIuWFNg̃|C^Ԃ
 *
 *	<parameter>		:	(i)GUInt16 usPangeId		:pl/EBhẼy[W
 *						(i)GUInt16 usChild 		:Rg[ID
 *
 *	<return>		:	Rg[̃|C^(0ȊO)		:
 *						NULL								:s(s or pl/EBhE݂Ȃ)
 *
 *	<description>	:	pl/EBhENoƃRg[IDARg[̃|C^Ԃ
 *						pl/EBhE݂ȂƂ́AIuWFNg擾łȂ̂
 *						NULLԂ
 *
 *
 */
GBaseWindow* GSGetPageChild( GUInt16 usPageNo,GInt16 usFrameid,GUInt16 usFramePageNo, GUInt16 usChild )
{
	GScreen *	pScreen = (GScreen *)GWGetScreen();
	GFrame *	pFrame;
	GPanel *	pPanel;
	GBaseWindowList *	pWindowList;
	GBaseWindow *		pWindow;
	void *				pvItem;

	/* plIuWFNg擾			*/
	pPanel = GWGetVmt(GScreen_VMT, pScreen)->GetPanel(pScreen);
	if( pPanel == NULL ){
		return NULL;
	}

	/* ݕ\̃plǂmF */
	if( GWGetVmt( GPanel_VMT, pPanel)->GetID( pPanel ) == ( usPageNo - GUSERWINDOW_BASE + 1 ) ){
		/* JĂplƈv̂ŁAΉRg[Ԃ */
		if( usFrameid != -1 ){
			pPanel = GSGetFramePanel( pPanel, usFrameid ,usFramePageNo);
		}
		 return (GBaseWindow *)GWGetVmt( GPanel_VMT, pPanel )->GetChildAt( pPanel, usChild);
	}

	/* EBhEXg擾			*/
	pFrame = GWGetVmt(GScreen_VMT, pScreen)->GetFrame(pScreen);
	pWindowList = GWGetVmt(GFrame_VMT, pFrame)->GetChildList(pFrame);
	/* EBhEXg				*/
	pvItem = FindLastItemGBaseWindowList(pWindowList);
	if(pvItem != NULL) {
		while((pvItem = FindPrevItemGBaseWindowList(pWindowList, pvItem, &pWindow)) != NULL) {
			pPanel = GWGetVmt( GWindow_VMT, pWindow )->GetPanel( pWindow );
			if( GWGetVmt( GPanel_VMT, pPanel)->GetType( pPanel ) == usPageNo ){
				pWindow = (GBaseWindow *)GWGetVmt( GWindow_VMT, pWindow )->GetPanel( (GWindow *)pWindow );
				/* JĂEBhEƈv̂ŁAΉRg[Ԃ */
				if( usFrameid != -1 ){
					pWindow = (GBaseWindow *)GSGetFramePanel( (GPanel *)pWindow, usFrameid ,usFramePageNo);
				}
				 return (GBaseWindow *)GWGetVmt( GPanel_VMT, pWindow )->GetChildAt( pWindow, usChild);
			}
		}
	}

	/* Ώۂ̃plEEBhE𔭌ł */
	return NULL;
}

/*
 *	<summary>		:	pl/EBhENoAy[W̃|C^Ԃ
 *
 *	<parameter>		:	(i)GUInt16 usPangeId		:pl/EBhẼy[W
 *
 *	<return>		:	y[W̃|C^(0ȊO)		:
 *						NULL								:s(s or pl/EBhE݂Ȃ)
 *
 *	<description>	:	pl/EBhENoAy[W̃|C^Ԃ
 *						pl/EBhE݂ȂƂ́AIuWFNg擾łȂ̂
 *						NULLԂ
 *
 *
 */
GPanel* GSGetPageNo( GUInt16 usPageNo,GInt16 usFrameid,GUInt16 usFramePageNo)
{
	GScreen *	pScreen = (GScreen *)GWGetScreen();
	GFrame *	pFrame;
	GPanel *	pPanel;
	GBaseWindowList *	pWindowList;
	GBaseWindow *		pWindow;
	void *				pvItem;

	/* plIuWFNg擾			*/
	pPanel = GWGetVmt(GScreen_VMT, pScreen)->GetPanel(pScreen);
	if( pPanel == NULL ){
		return NULL;
	}

	/* ݕ\̃plǂmF */
	if( GWGetVmt( GPanel_VMT, pPanel)->GetID( pPanel ) == ( usPageNo - GUSERWINDOW_BASE + 1 ) ){
		/* JĂplƈv̂ŁAΉRg[Ԃ */
		if( usFrameid != -1 ){
			pPanel = GSGetFramePanel( pPanel, usFrameid ,usFramePageNo);
		}
		 return (GPanel *)pPanel;
	}

	/* EBhEXg擾			*/
	pFrame = GWGetVmt(GScreen_VMT, pScreen)->GetFrame(pScreen);
	pWindowList = GWGetVmt(GFrame_VMT, pFrame)->GetChildList(pFrame);
	/* EBhEXg				*/
	pvItem = FindLastItemGBaseWindowList(pWindowList);
	if(pvItem != NULL) {
		while((pvItem = FindPrevItemGBaseWindowList(pWindowList, pvItem, &pWindow)) != NULL) {
			pPanel = GWGetVmt( GWindow_VMT, pWindow )->GetPanel( pWindow );
			if( GWGetVmt( GPanel_VMT, pPanel)->GetType( pPanel ) == usPageNo ){
				/* JĂEBhEƈv̂ŁAΉRg[Ԃ */
				if( usFrameid != -1 ){
					pPanel= GSGetFramePanel( pPanel, usFrameid ,usFramePageNo);
				}
				return pPanel;
			}
		}
	}

	/* Ώۂ̃plEEBhE𔭌ł */
	return NULL;
}

/*
 *	<summary>		:	pl/r[t[񂩂Ay[W̃|C^Ԃ
 *
 *	<parameter>		:	(i)GUInt16 usPangeId		:pl/EBhẼy[W
 *
 *	<return>		:	y[W̃|C^(0ȊO)		:
 *						NULL								:s(s or pl/EBhE݂Ȃ)
 *
 *	<description>	:	pl/EBhENoAy[W̃|C^Ԃ
 *						pl/EBhE݂ȂƂ́AIuWFNg擾łȂ̂
 *						NULLԂ
 *
 *
 */
GPanel* GSGetPanel( GUInt16 usPageNo,GInt16 usFrameid,GUInt16 usFramePageNo)
{
	GScreen *	pScreen = (GScreen *)GWGetScreen();
	GPanel *	pPanel;

	/* plIuWFNg擾			*/
	pPanel = GWGetVmt(GScreen_VMT, pScreen)->GetPanel(pScreen);
	if( pPanel == NULL ){
		return NULL;
	}

	/* ݕ\̃plǂmF */
	if( GWGetVmt( GPanel_VMT, pPanel)->GetID( pPanel ) == ( usPageNo - GUSERWINDOW_BASE + 1 ) ){
		/* JĂplƈv̂ŁAΉRg[Ԃ */
		if( usFrameid != -1 ){
			pPanel = GSGetFramePanel( pPanel, usFrameid ,usFramePageNo);
		}
		 return (GPanel *)pPanel;
	}

	/* Ώۂ̃plEEBhE𔭌ł */
	return NULL;
}

/*
 *	<summary>		:	EBhE/r[t[񂩂炩Ay[W̃|C^Ԃ
 *
 *	<parameter>		:	(i)GUInt16 usPangeId		:pl/EBhẼy[W
 *
 *	<return>		:	y[W̃|C^(0ȊO)		:
 *						NULL								:s(s or pl/EBhE݂Ȃ)
 *
 *	<description>	:	pl/EBhENoAy[W̃|C^Ԃ
 *						pl/EBhE݂ȂƂ́AIuWFNg擾łȂ̂
 *						NULLԂ
 *
 *
 */
GPanel* GSGetWindow( GUInt16 usPageNo,GInt16 usFrameid,GUInt16 usFramePageNo)
{
	GScreen *	pScreen = (GScreen *)GWGetScreen();
	GFrame *	pFrame;
	GBaseWindowList *	pWindowList;
	GBaseWindow *		pWindow;
	GPanel *			pPanel;
	void *				pvItem;

	/* EBhEXg擾			*/
	pFrame = GWGetVmt(GScreen_VMT, pScreen)->GetFrame(pScreen);
	pWindowList = GWGetVmt(GFrame_VMT, pFrame)->GetChildList(pFrame);
	/* EBhEXg				*/
	pvItem = FindLastItemGBaseWindowList(pWindowList);
	if(pvItem != NULL) {
		while((pvItem = FindPrevItemGBaseWindowList(pWindowList, pvItem, &pWindow)) != NULL) {
			pPanel = GWGetVmt( GWindow_VMT, pWindow )->GetPanel( pWindow );
			if( GWGetVmt( GPanel_VMT, pPanel)->GetType( pPanel ) == usPageNo ){
				 return (GPanel *)pWindow;
			}
		}
	}

	/* Ώۂ̃plEEBhE𔭌ł */
	return NULL;
}


/*
 *	<summary>		:	XN[̃|C^Ԃ
 *
 *	<parameter>		:	Ȃ
 *
 *	<return>		:	XN[̃|C^(0ȊO)		:
 *
 *	<description>	:	XN[̃|C^Ԃ
 *
 *
 */
GScreen* GSGetScreen( void )
{
	return  (GScreen *)GWGetScreen();
}

void GActSetVisibleStatus(void* pObject)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GBaseWindow_VMT, pObject )->SetVisibleStatus( pObject , G_TRUE );
}
void GActSetHiddenStatus(void* pObject)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GBaseWindow_VMT, pObject )->SetVisibleStatus( pObject , G_FALSE );
}
void GActSetSize(void* pObject, GInt16 param1, GInt16 param2)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GRect gRect;
		GWGetVmt( GBaseWindow_VMT, pObject )->GetBounds( pObject, &gRect );
		gRect.nXmax = gRect.nXmin + param1 -1;
		gRect.nYmax = gRect.nYmin + param2 -1;

		GWGetVmt( GBaseWindow_VMT, pObject )->AddRefreshRect( pObject, NULL, GW_REFRESH_BGERASE );
		GWGetVmt( GBaseWindow_VMT, pObject )->SetBounds( pObject , &gRect );
		GWGetVmt( GBaseWindow_VMT, pObject )->AddRefreshRect( pObject, NULL, GW_REFRESH_BGNOERASE );
	}
}
void GActSetPosition(void* pObject, GInt16 param1, GInt16 param2)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GRect gRect;
		GInt16 w,h;
		GWGetVmt( GBaseWindow_VMT, pObject )->GetBounds( pObject, &gRect );
		w = gRect.nXmax - gRect.nXmin;
		h = gRect.nYmax - gRect.nYmin;

		gRect.nXmin = param1;
		gRect.nYmin = param2;
		gRect.nXmax = param1+w;
		gRect.nYmax = param2+h;

		GWGetVmt( GBaseWindow_VMT, pObject )->AddRefreshRect( pObject, NULL, GW_REFRESH_BGERASE );
		GWGetVmt( GBaseWindow_VMT, pObject )->SetBounds( pObject , &gRect );
		GWGetVmt( GBaseWindow_VMT, pObject )->AddRefreshRect( pObject, NULL, GW_REFRESH_BGNOERASE );
	}
}
void GActPanelSetBackGroundImageID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GDesign* pDesign;
		pDesign = GWGetVmt( GPanel_VMT, pObject )->GetBackGroundDesign( pObject );
		pDesign->usImageID = param1; /*C[W\[XIDw*/
		GWGetVmt( GPanel_VMT, pObject )->SetBackGroundDesign( pObject, pDesign );
		GWGetVmt( GPanel_VMT, pObject )->AddRefreshRect( pObject, NULL, G_FALSE );
	}
}
void GActWindowSetBackGroundImageID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GDesign* pDesign;
		GPanel* pPanel;
		pPanel = GWGetVmt( GWindow_VMT, pObject )->GetPanel( pObject );
		pDesign = GWGetVmt( GPanel_VMT, pPanel )->GetBackGroundDesign( pPanel );
		pDesign->usImageID = param1; /*C[W\[XIDw*/
		GWGetVmt( GPanel_VMT, pPanel )->SetBackGroundDesign( pPanel, pDesign );
		GWGetVmt( GPanel_VMT, pPanel )->AddRefreshRect( pPanel, NULL, G_FALSE );
	}
}
void GActPictureSetStatus(void* pObject, GUInt8 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GPicture_VMT, pObject )->SetStatus( pObject, param1 );
}
void GActButtonSetStringID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GButton_VMT, pObject )->SetStringID( pObject, param1 );
}
void GActCacheTextSetStringID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GCacheText_VMT, pObject )->SetStringID( pObject, param1 );
}
void GActCheckBoxSetStringID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GCheckBox_VMT, pObject )->SetStringID( pObject, param1 );
}
void GActLabelSetStringID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GLabel_VMT, pObject )->SetStringID( pObject, param1 );
}
void GActPictureSetStringID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GPicture_VMT, pObject )->SetStringID( pObject, param1 );
}
void GActRadioButtonSetStringID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GRadioButton_VMT, pObject )->SetStringID( pObject, param1 );
}
void GActStaticTextSetStringID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GStaticText_VMT, pObject )->SetStringID( pObject, param1 );
}
void GActCacheTextSetString(void* pObject, GTCHAR* param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GCacheText_VMT, pObject )->SetString( pObject, param1 );
}
void GActNumBitMapSetString(void* pObject, GTCHAR* param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GNumbmp_VMT, pObject )->SetNumberString( pObject, param1 );
}
void GActStaticTextSetString(void* pObject, GTCHAR* param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GStaticText_VMT, pObject )->SetString( pObject, param1 );
}
void GActTextBoxExSetString(void* pObject, GTCHAR* param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GTextBoxEx_VMT, pObject )->SetString( pObject, param1 );
}
void GActTextSetString(void* pObject, GTCHAR* param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GTextBox_VMT, pObject )->SetString( pObject, param1 );
}
void GActProgressBarSetValue(void* pObject, GInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GProgressBar_VMT, pObject )->SetValue( pObject, param1 );
}
void GActTextBoxSetValue(void* pObject, GUInt8 param1, GUInt8 param2, GInt32 param3)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GValue gValue;
		switch( param1 ){
			case GTEXT_TYPE_SHORT:
				gValue.nValue = (GInt16)param3;
				break;
			case GTEXT_TYPE_USHORT:
				gValue.usValue = (GUInt16)param3;
				break;
			case GTEXT_TYPE_LONG:
				gValue.lValue = (GInt32)param3;
				break;
			case GTEXT_TYPE_ULONG:
				gValue.ulValue = (GUInt32)param3;
				break;
	#ifndef PROHIBIT_FLOATING_DECIMAL
			case GTEXT_TYPE_FLOAT:
				gValue.fValue = (GFloat)param3;
				break;
	#endif
			default:
				return;
		}
		GWGetVmt( GTextBox_VMT, pObject )->SetTextType( pObject, param1 );
		GWGetVmt( GTextBox_VMT, pObject )->SetFormatID( pObject, param2 );
		GWGetVmt( GTextBox_VMT, pObject )->SetValue( pObject, gValue );
	}
}
void GActPanelSetBackGroundColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GDesign* pDesign;
		pDesign = GWGetVmt( GPanel_VMT, pObject )->GetBackGroundDesign( pObject );
		pDesign->gbBrush.gcBackColor = param1; /*wiFw*/
		GWGetVmt( GPanel_VMT, pObject )->SetBackGroundDesign( pObject, pDesign );
		GWGetVmt( GPanel_VMT, pObject )->AddRefreshRect( pObject, NULL, G_FALSE );
	}
}
void GActWindowSetBackGroundColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
	GDesign* pDesign;
	GPanel* pPanel;
	pPanel = GWGetVmt( GWindow_VMT, pObject )->GetPanel( pObject );
	pDesign = GWGetVmt( GPanel_VMT, pPanel )->GetBackGroundDesign( pPanel );
	pDesign->gbBrush.gcBackColor = param1; /*wiFw*/
	GWGetVmt( GPanel_VMT, pPanel )->SetBackGroundDesign( pPanel, pDesign );
	GWGetVmt( GPanel_VMT, pPanel )->AddRefreshRect( pPanel, NULL, G_FALSE );
	}
}
void GActSVFrameShowPanel(void* pObject, GUInt8 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GSVFrame_VMT, pObject )->ShowPanel( pObject, param1 );
}
void GActFrameAnimationPanelStartAnimation(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GFrameAnimationPanel_VMT, pObject )->StopFrameAnimation( pObject );
	GWGetVmt( GFrameAnimationPanel_VMT, pObject )->ResetFrameAnimation( pObject );

	GWGetVmt( GFrameAnimationPanel_VMT, pObject )->SelectFrameAnimation( pObject, param1 );

	GWGetVmt( GFrameAnimationPanel_VMT, pObject )->StartFrameAnimation( pObject );
	
}
void GActFrameAnimationWindowStartAnimation(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GBaseWindow *		pPanel;
		pPanel = (GBaseWindow *)GWGetVmt( GWindow_VMT, pObject )->GetPanel( (GWindow *)pObject );

		GWGetVmt( GFrameAnimationPanel_VMT, pPanel )->StopFrameAnimation( pPanel );
		GWGetVmt( GFrameAnimationPanel_VMT, pPanel )->ResetFrameAnimation( pPanel );

		GWGetVmt( GFrameAnimationPanel_VMT, pPanel )->SelectFrameAnimation( pPanel, param1 );

		GWGetVmt( GFrameAnimationPanel_VMT, pPanel )->StartFrameAnimation( pPanel );
	}
}
void GActFrameAnimationPanelStopAnimation(void* pObject)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GFrameAnimationPanel_VMT, pObject )->StopFrameAnimation( pObject );
	GWGetVmt( GFrameAnimationPanel_VMT, pObject )->ResetFrameAnimation( pObject );
}
void GActFrameAnimationWindowStopAnimation(void* pObject)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GBaseWindow *		pPanel;
		pPanel = (GBaseWindow *)GWGetVmt( GWindow_VMT, pObject )->GetPanel( (GWindow *)pObject );

		GWGetVmt( GFrameAnimationPanel_VMT, pPanel )->StopFrameAnimation( pPanel );
		GWGetVmt( GFrameAnimationPanel_VMT, pPanel )->ResetFrameAnimation( pPanel );
	}
}
void GActScreenShowPanel(void* pObject, GInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GScreen_VMT, GWGetScreen() )->ShowPanel( GWGetScreen(), param1 );
}
void GActScreenOpenWindow(void* pObject, GInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GScreen_VMT, GWGetScreen() )->CreateGWindow( GWGetScreen(), param1 );
}
void GActScreenCloseWindow(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GFrame *pFrame = NULL;
		GWindow *pWindow = NULL;
		GPanel *pPanel = NULL;

		pFrame = GWGetVmt( GScreen_VMT, GWGetScreen() )->GetFrame( GWGetScreen() );
		if( pFrame ){
			pWindow = (GWindow*)GWGetVmt( GFrame_VMT, pFrame )->GetChild( pFrame, (GUInt16)( param1 +1) );
			if( pWindow ){
				pPanel = (GPanel*)GWGetVmt( GWindow_VMT, pWindow )->GetPanel( pWindow );
				GWGetVmt( GPanel_VMT, pPanel )->Close( pPanel );
			}
		}
	}
}
void GActScreenCloseAllWindow(void* pObject)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GScreen *pScreen = (GScreen *)GWGetScreen();
		GFrame *pFrame;
		GPanel *pPanel;
		GBaseWindowList *pWindowList;
		GBaseWindow *pWindow;
		void *pvItem;


		/* EBhEXg擾			*/
		pFrame = GWGetVmt(GScreen_VMT, pScreen)->GetFrame(pScreen);
		if( pFrame ){
			pWindowList = GWGetVmt(GFrame_VMT, pFrame)->GetChildList(pFrame);
			if( ( pvItem = FindLastItemGBaseWindowList( pWindowList ) ) == NULL ){
				return;
			}
			/* EBhEXg				*/
			while( (pvItem = FindPrevItemGBaseWindowList( pWindowList, pvItem, &pWindow )) != NULL ){
				pPanel = (GPanel*)GWGetVmt( GWindow_VMT, pWindow )->GetPanel( pWindow );
				GWGetVmt( GWindow_VMT, (GWindow*)pPanel )->Close( (GWindow*)pPanel );
			}
		}
	}
}
void GActSetLocale(void* pObject, GUInt8 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GRCSetLocale( param1 );
	GWGetVmt( GBaseWindow_VMT, GWGetScreen() )->AddRefreshRect( GWGetScreen(), NULL, G_FALSE );
}
void GActButtonSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GButton_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActCheckBoxSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GCheckBox_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActGridSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GGrid_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActHScrollSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GScrollBar_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActListSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GList_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActPictureSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GPicture_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActRadioButtonSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GRadioButton_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActStaticTextSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GStaticText_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActTextBoxExSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GTextBoxEx_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActTextBoxSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GTextBox_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActVScrollSetBorderID(void* pObject, GUInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GScrollBar_VMT, pObject )->SetBorderID( pObject, param1 );
}
void GActSetEnableStatus(void* pObject)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GBaseWindow_VMT, pObject )->SetEnableStatus( pObject , G_TRUE );
}
void GActSetDisableStatus(void* pObject)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GBaseWindow_VMT, pObject )->SetEnableStatus( pObject , G_FALSE );
}
void GActDiectWrite(void* pObject, GTCHAR* param1)
{

}
void GActButtonSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GButton_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GButton_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActCheckBoxSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GCheckBox_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GCheckBox_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActLabelSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GLabel_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GLabel_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActPictureSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GPicture_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GPicture_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActRadioButtonSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GRadioButton_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GRadioButton_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActStaticTextSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GStaticText_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GStaticText_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActTextBoxExSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GTextBoxEx_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GTextBoxEx_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActTextSetStringColor(void* pObject, GUInt32 param1)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GCaption *pCaption;

		/* LvVԎ擾*/
		pCaption = GWGetVmt( GTextBox_VMT, pObject )->GetCaption( pObject );
		pCaption->gcColor = param1; /*FύX@*/
		GWGetVmt( GTextBox_VMT, pObject )->SetCaption( pObject, pCaption );
	}
}
void GActControlStartTimer(void* pObject, GUInt16 param1, GUInt32 param2)
{
	ACTION_OBJ_CHECK( pObject );
		GESetTimer( pObject, param1, param2 );
}
void GActControlStopTimer(void* pObject, GInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
		GEKillTimer( pObject, param1 );
}
void GActPanelStopTimer(void* pObject, GInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
		GEKillTimer( pObject, param1 );
}
void GActWindowStopTimer(void* pObject, GInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
		GEKillTimer( GWGetVmt( GWindow_VMT, pObject )->GetPanel( pObject ), param1 );
}
void GActPanelStartTimer(void* pObject, GUInt16 param1, GUInt32 param2)
{
	ACTION_OBJ_CHECK( pObject );
		GESetTimer( pObject, param1, param2 );
}
void GActWindowStartTimer(void* pObject, GUInt16 param1, GUInt32 param2)
{
	ACTION_OBJ_CHECK( pObject );
		GESetTimer( GWGetVmt( GWindow_VMT, pObject )->GetPanel( pObject ), param1, param2 );
}
void GActScreenStopTimer(void* pObject, GInt16 param1)
{
	ACTION_OBJ_CHECK( pObject );
		GEKillTimer( pObject, param1 );
}
void GActScreenStartTimer(void* pObject, GUInt16 param1, GUInt32 param2)
{
	ACTION_OBJ_CHECK( pObject );
		GESetTimer( pObject, param1, param2 );
}
void GActButtonSetStatus(void* pObject, GUInt8 param1)
{
	ACTION_OBJ_CHECK( pObject );
	GWGetVmt( GButton_VMT, pObject )->SetStatus( pObject, param1 );
}
void GActRDSetEvent(void* pObject, GInt32 param1, GInt32 param2, GInt32 param3)
{
	ACTION_OBJ_CHECK( pObject );
	{
		GInt16 nMarge = G_FALSE;
		GESetEvent( GECreateEventMessage( param1, pObject, param2, param3 ), nMarge );
	}
}
