#ifdef WIN32
#include "windows.h"
#endif/*WIN32*/
#include "genifa.h"
#include "gevent.h"
#include "GC_GUI.h"
#include "GC_GUIScreen.h"
#include "GResource.h"
#ifdef  _RD_DEBUG_
#include <stdio.h>
#endif/*_RD_DEBUG_*/

#ifndef WIN32
#include "GC_GUIScreen.prc"
#include "task_common.h"
#include "dataaccessapi.h"
#endif /* WIN32 */

//{{GUISTATE_CONDITION
#define GUISTATE_USE 0
//}}GUISTATE_CONDITION

#if		(GUISTATE_USE != 0)
#include "RDState.h"

//{{INCLUDE_GUISTATE
//}}INCLUDE_GUISTATE
#endif/*(GUISTATE_USE != 0)*/
#include "GDBObject.h"
#include "GDBObject.prc"

#ifndef WIN32
/* input emulator task info */
#define TASK_NAME_INPUT_EMU			"tQ24_input_emu"	/* task name */
#define TASK_PRIORITY_INPUT_EMU		109					/* task priority */
#define TASK_STACKSIZE_INPUT_EMU	10000				/* stack size */
/* gui task info */
#define TASK_NAME_GUI				"tQ24_gui_task"		/* task name */
#define TASK_PRIORITY_GUI			110					/* task priority */
#define TASK_STACKSIZE_GUI			10000				/* stack size */
#endif/*WIN32*/

#include "Common.h"

static GInt32 acMemory0[GMEM_GDRAW_SIZE/4];
static GInt32 acMemory1[GMEM_GEVENT_SIZE/4];
static GInt32 acMemory2[GMEM_GRESOURCE_SIZE/4];
static GInt32 acMemory3[GMEM_GPI_SIZE/4];
static GInt32 acMemory4[GMEM_GWIN_SIZE/4];
static GInt32 acMemory5[GMEM_GWIN_PANEL_SIZE/4];
static GInt32 acMemory6[GMEM_GWIN_PANEL_SIZE/4];
static GInt32 acMemory7[GMEM_GWIN_WINDOW_SIZE0/4];
static GInt32 acMemory8[GMEM_GWIN_WINDOW_SIZE1/4];
static GInt32 acMemory9[GMEM_GWIN_WINDOW_SIZE2/4];
static GInt32 acMemory10[GMEM_GWIN_WINDOW_SIZE3/4];
static GInt32 acMemory11[GMEM_GWIN_WINDOW_SIZE4/4];
static GInt32 acMemory12[GMEM_GWIN_WINDOW_SIZE5/4];
static GInt32 acMemory13[GMEM_GWIN_WINDOW_SIZE6/4];
static GInt32 acMemory14[GMEM_GWIN_WINDOW_SIZE7/4];
static GInt32 acMemory15[GMEM_GWIN_WINDOW_SIZE8/4];
static GInt32 acMemory16[GMEM_GWIN_WINDOW_SIZE9/4];
static GInt32 acMemory17[GMEM_USER_SIZE/4];

#ifndef WIN32
/* initial infomation resource setting data */
extern GUInt32 ulMaxStringResource;
extern GUInt32 ulMaxFontResource;
extern GSimpleFont **pFontsList;
extern GUInt8 ucMaxLocale;
extern GTCHAR ***pStringsList;
extern GNumBitmapData **pNumBmps;
extern GPaletteHeader **pPalette;
extern GLayer pLayers[][MAX_LAYER_NUM + 1];
extern GIncreaseTable *pIncreaseTables;
extern GImage *pImages;
extern GUInt32	ulMaxImageResource;
extern GChangePaletteData *pChangePalettes;
extern GBorder ***pBorders;
extern GUInt32	ulMaxBorderResource;
extern GImage *pBlendMask;
#endif /* WIN32 */

#if		(GUISTATE_USE != 0)
static RDSTATE thisState;
static HRDSTATE hThisState = NULL;
#endif/*(GUISTATE_USE != 0)*/

#ifndef	WIN32
DATAACCESSGDBID stGDBID[35];
#endif

#ifndef WIN32
void WinMain(void);
#endif /* WIN32 */

#ifndef WIN32
void GuiMain(void)
{
	GTCreateGuiTask(TASK_NAME_GUI, (void *)WinMain, TASK_PRIORITY_GUI, TASK_STACKSIZE_GUI);
}
#endif/*#ifndef WIN32*/

#ifdef WIN32
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
#else/*WIN32*/
void WinMain(void)
#endif/*WIN32*/
{
 	// TODO: ̈ʒuɃR[hLqĂB
	GEventMessage msg;
//{{SCREEN_PROPERTY_INFO
GFrameAnimationScreenProperty gpScreen={{{GSCREEN,1,0,0,1024,768,GW_STYLE_VISIBLE|GW_STYLE_ENABLE|GW_STYLE_CONSUMABLE|GSCREEN_USE_LAYER,NULL,ID_PLANE1},{{FILL_BACK_COLOR,0,0},0},ID_FONT00000,0,RGB16(255,255,255),RGB16(212,208,200),RGB16(10,36,106),RGB16(128,128,128),256,ID_PALETTE00000,1,80,GSCREEN_CURSOR_TYPE_V2},10,0,0,0};
//}}SCREEN_PROPERTY_INFO

	GMemorySpaceInformation gmsiMemory[18]=
	{
		{GMEM_SPACE_GDRAW,0,{0,0},(GInt8*)acMemory0,GMEM_GDRAW_SIZE,NULL},
		{GMEM_SPACE_GEVENT,0,{0,0},(GInt8*)acMemory1,GMEM_GEVENT_SIZE,NULL},
		{GMEM_SPACE_GRESOURCE,0,{0,0},(GInt8*)acMemory2,GMEM_GRESOURCE_SIZE,NULL},
		{GMEM_SPACE_GPI,0,{0,0},(GInt8*)acMemory3,GMEM_GPI_SIZE,NULL},
		{GMEM_SPACE_GWIN,0,{0,0},(GInt8*)acMemory4,GMEM_GWIN_SIZE,NULL},
		{GMEM_SPACE_GWIN_PANEL,0,{0,0},(GInt8*)acMemory5,GMEM_GWIN_PANEL_SIZE,NULL},
		{GMEM_SPACE_GWIN_PANEL,1,{0,0},(GInt8*)acMemory6,GMEM_GWIN_PANEL_SIZE,NULL},
		{GMEM_SPACE_GWIN_WINDOW,0,{0,0},(GInt8*)acMemory7,GMEM_GWIN_WINDOW_SIZE0,NULL},
		{GMEM_SPACE_GWIN_WINDOW,1,{0,0},(GInt8*)acMemory8,GMEM_GWIN_WINDOW_SIZE1,NULL},
		{GMEM_SPACE_GWIN_WINDOW,2,{0,0},(GInt8*)acMemory9,GMEM_GWIN_WINDOW_SIZE2,NULL},
		{GMEM_SPACE_GWIN_WINDOW,3,{0,0},(GInt8*)acMemory10,GMEM_GWIN_WINDOW_SIZE3,NULL},
		{GMEM_SPACE_GWIN_WINDOW,4,{0,0},(GInt8*)acMemory11,GMEM_GWIN_WINDOW_SIZE4,NULL},
		{GMEM_SPACE_GWIN_WINDOW,5,{0,0},(GInt8*)acMemory12,GMEM_GWIN_WINDOW_SIZE5,NULL},
		{GMEM_SPACE_GWIN_WINDOW,6,{0,0},(GInt8*)acMemory13,GMEM_GWIN_WINDOW_SIZE6,NULL},
		{GMEM_SPACE_GWIN_WINDOW,7,{0,0},(GInt8*)acMemory14,GMEM_GWIN_WINDOW_SIZE7,NULL},
		{GMEM_SPACE_GWIN_WINDOW,8,{0,0},(GInt8*)acMemory15,GMEM_GWIN_WINDOW_SIZE8,NULL},
		{GMEM_SPACE_GWIN_WINDOW,9,{0,0},(GInt8*)acMemory16,GMEM_GWIN_WINDOW_SIZE9,NULL},
		{GMEM_SPACE_USER,0,{0,0},(GInt8*)acMemory17,GMEM_USER_SIZE,NULL}
	};

#if		(GUISTATE_USE != 0)
#ifdef  _RD_DEBUG_
	static RDST_HANDLER_RET oldState = 0;
	static RDST_HANDLER_RET nowState = 0;
	static UINT32 nCnt = 0;
#endif/*_RD_DEBUG_*/
#endif/*(GUISTATE_USE != 0)*/
	
#ifndef WIN32
	GInt16 rc = 0;

	/*ʕ\*/
	rc = common_initialize();
	if (rc != 0) {
		gui_task_terminate();
		return;
	}

	/*}EXAL[{[h̓G~[gp^XNN*/
	GTCreateInputEmulatorTask(TASK_NAME_INPUT_EMU, TASK_PRIORITY_INPUT_EMU, TASK_STACKSIZE_INPUT_EMU);

	/*GUI^XNs*/
	rc = gui_task_initialize();
	if (rc != 0) {
		gui_task_terminate();
		return;
	}
#endif /*#ifndef WIN32*/

	GMSetMemorySpace( 18, gmsiMemory );
	
#ifndef WIN32
	/* setting of screen infomation */
	GWSetScreen( (void *)&theScreen );
	
	/* setting of initial resource infomation */
	GRCSetSimpleFont( (void *)&pFontsList );
	GRCSetMaxLocale( ucMaxLocale );
	GRCSetStringsList( (void *)&pStringsList );
	GRCSetPalette( (void *)&pPalette );
	GRCSetNumBitmapData( (void *)&pNumBmps );
	GRCSetLayers( pLayers );
	GRCSetIncreaseTable( (void *)&pIncreaseTables );
	GRCSetImages( (void *)&pImages );
	GRCSetMaxImageResource( ulMaxImageResource );
	GRCSetChangePaletteData( (void *)&pChangePalettes );
	GRCSetBorders( (void *)&pBorders );
	GRCSetMaxBorderResource( ulMaxBorderResource );
	GRCSetBlendMask( (void *)&pBlendMask );
	GRCMaxStringResource( ulMaxStringResource );
#endif/*WIN32*/
	
#ifdef WIN32
	GDInitPlatform( hInstance );
#else/*WIN32*/
	GDInitPlatform( NULL );
#if _USE_FONT_CACHE_
	GRCSetCacheFont( (void *)&pFontsList, ucMaxLocale, ulMaxFontResource );
#endif/*_USE_FONT_CACHE_*/
#endif/*WIN32*/
	GEInitEvent();

#if		(GUISTATE_USE != 0)
#ifdef  _RD_DEBUG_
	RDInitDebug(NULL);
#endif/*_RD_DEBUG_*/

//{{GUISTATE_MODEGENERATESTRING_INIT
	StMachineInit( &thisState );
//}}GUISTATE_MODEGENERATESTRING_INIT
    hThisState = &thisState;

//{{GUISTATE_MODEGENERATESTRING_SETHANDLE
	SetStateHandle( &thisState );
//}}GUISTATE_MODEGENERATESTRING_SETHANDLE
#ifdef  _RD_DEBUG_
	oldState = RDSTGetState( hThisState );
#endif/*_RD_DEBUG_*/
#endif/*(GUISTATE_USE != 0)*/

//{{GUIDATABASE_INIT
	GWDBInit(pGDBObjectTable, sizeof(pGDBObjectTable)/sizeof(GDBObject));
//}}GUIDATABASE_INIT
#ifndef	WIN32
	DataAccessStart();
#endif	
	InitProfile();

	GWInitGC_GUIScreen( (GC_GUIScreen*)GWGetScreen() );
	GWGetVmt( GC_GUIScreen_VMT, (GC_GUIScreen*)GWGetScreen())->ImportProperty( (GC_GUIScreen*)GWGetScreen(),(GBaseWindowProperty*)&gpScreen );
	GWGetVmt( GC_GUIScreen_VMT, (GC_GUIScreen*)GWGetScreen())->Create( (GC_GUIScreen*)GWGetScreen(),NULL );

	GWGetVmt( GC_GUIScreen_VMT, (GC_GUIScreen*)GWGetScreen())->SetVisibleStatus( (GC_GUIScreen*)GWGetScreen(),G_TRUE );
	while(GWGetVmt( GC_GUIScreen_VMT, (GC_GUIScreen*)GWGetScreen())->GetExitStatus(GWGetScreen()) == G_FALSE){
		if( !GEGetEvent( &msg,-1 ) ){
			continue;
		}
#if		(GUISTATE_USE != 0)
		if( msg.ulMessage >= GM_STATE_EVENT ){
			RDSTDoEvent( hThisState, msg.ulMessage, (RDST_LPARAM)msg.lLParam, (RDST_UPARAM)msg.lUParam );
#ifdef  _RD_DEBUG_
			/* ԑJڃOo͏ */
			nowState = RDSTGetState( hThisState );

//{{GUISTATE_MODENAME
			RDOutputDebug( (UINT8*)"", nCnt, oldState, nowState, msg.ulMessage, (RDST_LPARAM)msg.lLParam, (RDST_UPARAM)msg.lUParam, hThisState->divInfo, hThisState->divInfoEntry, hThisState->divInfoExit );
//}}GUISTATE_MODENAME
			nCnt++;
			oldState = nowState;
#endif/*_RD_DEBUG_*/
			continue;
		}
#endif/*(GUISTATE_USE != 0)*/
		if( msg.ulMessage == GM_QUIT ){
			GWGetVmt( GC_GUIScreen_VMT, (GC_GUIScreen*)GWGetScreen())->SetExitStatus( GWGetScreen(), G_TRUE );
			break;
		}
		GWGetVmt( GC_GUIScreen_VMT, (GC_GUIScreen*)GWGetScreen())->DispatchMessage( (GC_GUIScreen*)GWGetScreen(),&msg );
	}

	GWGetVmt( GC_GUIScreen_VMT, (GC_GUIScreen*)GWGetScreen())->Delete( GWGetScreen() );
#ifndef	WIN32	
	DataAccessEnd();
#endif
//{{GUIDATABASE_QUIT
	GWDBQuit();
//}}GUIDATABASE_QUIT
	
#if		(GUISTATE_USE != 0)
	RDSTQuit( hThisState );
#ifdef  _RD_DEBUG_
	RDQuitDebug(NULL);
#endif/*_RD_DEBUG_*/
#endif/*(GUISTATE_USE != 0)*/

	GEQuitEvent();
	GDQuitPlatform();

#ifndef WIN32
	gui_task_terminate();
#endif /*#ifndef WIN32*/

#ifdef WIN32
	return 0;
#endif/*WIN32*/
}

#if		(GUISTATE_USE != 0)
void sendEventToStateMachine(INT8 *szRcvString)
{
#ifdef  _RD_DEBUG_
	GUInt32 eventID;
	sscanf((const char*)szRcvString, "rdevPost %x", &eventID);

	GESetEvent( GECreateEventMessage( eventID, NULL,  0, 0 ) , G_FALSE );
#endif/*_RD_DEBUG_*/
}
#endif/*(GUISTATE_USE != 0)*/
