#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "GC_GUIScreen.h"
#include "gwin.h"
#include "gbasiccontrol.h"
#include "gbutton.h"
#include "glabel.h"
#include "glist.h"
#include "gpicture.h"
#include "gtextbox.h"
#include "gtextboxex.h"
#include "gcheckbox.h"
#include "gradiobutton.h"
#include "gprogressbar.h"
#include "gscrollbarex.h"
#include "ggrid.h"
#include "gstatictext.h"
#include "gnumbmp.h"
#include "gsline.h"
#include "gslines.h"
#include "gsarc.h"
#include "gsrect.h"
#include "gsrrect.h"
#include "gsoval.h"
#include "gspoly.h"
#include "gspie.h"
#include "gdispsubpnl.h"
#include "gwindow.h"
#include "gevent.h"
#include "GResource.h"
#include "geffectalpha.h"
#include "geffectalphagradation.h"
#include "geffectblendmask.h"
#include "geffectchange.h"
#include "geffectcolormode.h"
#include "geffectdrawingmode.h"
#include "geffectedgeshade.h"
#include "geffectfocusshade.h"
#include "geffectmove.h"
#include "geffectresize.h"
#include "geffectrotate.h"
#include "geffectslant.h"
#include "geffectstretch.h"
#include "geffecttextalpha.h"
#include "geffecttextshade.h"
#include "geffecttransparentcolor.h"
#include "geffectviewchange.h"
#include "geffectvisible.h"
#include "gcachetext.h"
#include "GScript.h"
#include "GDBObject.h"

#define GLOBAL_DECL_COMMON
#include "GC_GUIScreen.prc"
#include "Common.h"
#ifdef WIN32 
#include "windows.h"
#endif
#include "GControlID.h"
#include "dataaccessapi.h"

//{{FUNCTION_TABLE_TABLE
static const GC_GUIScreen_VMT vmt=
{
//{{FUNCTION_TABLE_FUNCTION
	GC_GUIScreen_MessageProcedure,
	GC_GUIScreen_CallBackMessageProcedure,
	GC_GUIScreen_GetType,
	GC_GUIScreen_GetID,
	GC_GUIScreen_GetXPosition,
	GC_GUIScreen_GetYPosition,
	GC_GUIScreen_GetPosition,
	GC_GUIScreen_GetWidth,
	GC_GUIScreen_GetHeight,
	GC_GUIScreen_GetSize,
	GC_GUIScreen_SetBounds,
	GC_GUIScreen_GetBounds,
	GC_GUIScreen_CalcClientRect,
	GC_GUIScreen_GetClientRect,
	GC_GUIScreen_ClientToScreen,
	GC_GUIScreen_GetStyle,
	GC_GUIScreen_SetVisibleStatus,
	GC_GUIScreen_GetVisibleStatus,
	GC_GUIScreen_SetEnableStatus,
	GC_GUIScreen_GetEnableStatus,
	GC_GUIScreen_SetConsumableStatus,
	GC_GUIScreen_GetConsumableStatus,
	GC_GUIScreen_SetCaptionStatus,
	GC_GUIScreen_GetCaptionStatus,
	GC_GUIScreen_SetFocusStatus,
	GC_GUIScreen_GetFocusStatus,
	GC_GUIScreen_SetStyleStatus,
	GC_GUIScreen_GetStyleStatus,
	GC_GUIScreen_SetParent,
	GC_GUIScreen_GetParent,
	GC_GUIScreen_SetFocusInformation,
	GC_GUIScreen_GetFocusInformation,
	GC_GUIScreen_Create,
	GC_GUIScreen_Delete,
	GC_GUIScreen_ImportProperty,
	GC_GUIScreen_ExportProperty,
	GC_GUIScreen_Paint,
	GC_GUIScreen_OnDraw,
	GC_GUIScreen_OnNcDraw,
	GC_GUIScreen_AddRefreshRect,
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GC_GUIScreen_MouseMove,
	GC_GUIScreen_OnMouseMove,
	GC_GUIScreen_OnNcMouseMove,
#endif /* _ENABLE_MOUSEMOVE_ */
	GC_GUIScreen_LButtonPress,
	GC_GUIScreen_OnLButtonPress,
	GC_GUIScreen_OnNcLButtonPress,
	GC_GUIScreen_LButtonRelease,
	GC_GUIScreen_OnLButtonRelease,
	GC_GUIScreen_OnNcLButtonRelease,
#ifdef _ENABLE_RBUTTON_
	GC_GUIScreen_RButtonPress,
	GC_GUIScreen_OnRButtonPress,
	GC_GUIScreen_OnNcRButtonPress,
	GC_GUIScreen_RButtonRelease,
	GC_GUIScreen_OnRButtonRelease,
	GC_GUIScreen_OnNcRButtonRelease,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GC_GUIScreen_KeyPress,
	GC_GUIScreen_KeyRelease,
	GC_GUIScreen_SetFocus,
	GC_GUIScreen_KillFocus,
	GC_GUIScreen_Timer,
	GC_GUIScreen_User,
	GC_GUIScreen_Char,
	GC_GUIScreen_Close,
	GC_GUIScreen_DeleteChild,
	GC_GUIScreen_SetMemorySpace,
	GC_GUIScreen_GetMemorySpace,
	GC_GUIScreen_SetDrawForceStatus,
	GC_GUIScreen_GetDrawForceStatus,
	GC_GUIScreen_SetRedrawStatus,
	GC_GUIScreen_GetRedrawStatus,
	GC_GUIScreen_ClearDrawStatus,
	GC_GUIScreen_AddDirtyRect,
	GC_GUIScreen_SetPrevTimerObject,
	GC_GUIScreen_GetPrevTimerObject,
	GC_GUIScreen_SetNextTimerObject,
	GC_GUIScreen_GetNextTimerObject,
#ifndef	_DISABLE_GLAYER_
	GC_GUIScreen_AddDirtyRectLayer,
	GC_GUIScreen_SetDrawForceStatusLayer,
	GC_GUIScreen_GetDrawForceStatusLayer,
	GC_GUIScreen_SetRedrawStatusLayer,
	GC_GUIScreen_GetRedrawStatusLayer,
	GC_GUIScreen_SetLayerID,
	GC_GUIScreen_GetLayerID,
#endif /* _DISABLE_GLAYER_ */
	GC_GUIScreen_HoldImageData,
	GC_GUIScreen_GetImageData,
	GC_GUIScreen_CleanImageData,
	GC_GUIScreen_Active,
	GC_GUIScreen_OnActive,
	GC_GUIScreen_SetActiveStatus,
	GC_GUIScreen_GetActiveStatus,

	GC_GUIScreen_OnCreate,
	GC_GUIScreen_PreDelete,
	GC_GUIScreen_PreKeyPress,
	GC_GUIScreen_PreKeyRelease,
	GC_GUIScreen_OnUser,
	GC_GUIScreen_PrePress,
	GC_GUIScreen_PreRelease,
	GC_GUIScreen_PrePaint,
	GC_GUIScreen_OnTimer,
#if		(_USE_MULTI_COORDINATE_ != 0)
	GC_GUIScreen_SetActiveCoordinate,
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GC_GUIScreen_OnUpdateDB,
	GC_GUIScreen_IsMousePointInBounds,

	GC_GUIScreen_CreateInstance,
	GC_GUIScreen_ShowPanel,
	GC_GUIScreen_CreateGWindow,
	GC_GUIScreen_DispatchMessage,
	GC_GUIScreen_AttachPanel,
	GC_GUIScreen_GetPanel,
#ifndef _DISABLE_POINTING_DEVICE_
	GC_GUIScreen_LButtonPressPanel,
#ifdef _ENABLE_RBUTTON_
	GC_GUIScreen_RButtonPressPanel,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GC_GUIScreen_DrawPanel,
	GC_GUIScreen_DrawBackGround,
	GC_GUIScreen_ChangeFocus,
	GC_GUIScreen_GetFocus,
	GC_GUIScreen_DrawFrame,
#ifndef _DISABLE_POINTING_DEVICE_
	GC_GUIScreen_LButtonPressFrame,
#ifdef _ENABLE_RBUTTON_
	GC_GUIScreen_RButtonPressFrame,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GC_GUIScreen_AddWindow,
	GC_GUIScreen_GetFrame,

#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GC_GUIScreen_MouseMoveFrame,
	GC_GUIScreen_MouseMovePanel,
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */

	GC_GUIScreen_SetBackGroundDesign,
	GC_GUIScreen_GetBackGroundDesign,
	GC_GUIScreen_SetSystemFontID,
	GC_GUIScreen_GetSystemFontID,
	GC_GUIScreen_SetSystemBorderID,
	GC_GUIScreen_GetSystemBorderID,
	GC_GUIScreen_SetSystemForeColor,
	GC_GUIScreen_GetSystemForeColor,
	GC_GUIScreen_SetSystemBackColor,
	GC_GUIScreen_GetSystemBackColor,
	GC_GUIScreen_SetSystemActiveColor,
	GC_GUIScreen_GetSystemActiveColor,
	GC_GUIScreen_SetSystemInactiveColor,
	GC_GUIScreen_GetSystemInactiveColor,
	GC_GUIScreen_GetWDC,
	GC_GUIScreen_ModalGWindow,
	GC_GUIScreen_SetPanelPlane,
	GC_GUIScreen_GetPanelPlane,
	GC_GUIScreen_SetWindowPlane,
	GC_GUIScreen_GetWindowPlane,
	GC_GUIScreen_SetSystemStatus,
	GC_GUIScreen_GetSystemStatus,
	GC_GUIScreen_SetExitStatus,
	GC_GUIScreen_GetExitStatus,
	GC_GUIScreen_LoadGWindow,
	GC_GUIScreen_DoModal,
	GC_GUIScreen_OnDrawWindow,
	GC_GUIScreen_SetPaletteStatus,
	GC_GUIScreen_GetPaletteStatus,
	GC_GUIScreen_SetSystemPaletteID,
	GC_GUIScreen_GetSystemPaletteID,
	GC_GUIScreen_SetPaletteColors,
	GC_GUIScreen_GetPaletteColors,
	GC_GUIScreen_SetSystemPalette,
	GC_GUIScreen_AddTimerObject,
	GC_GUIScreen_RemoveTimerObject,
	GC_GUIScreen_SetEventSearchStatus,
	GC_GUIScreen_GetEventSearchStatus,
#ifndef	_DISABLE_GLAYER_
	GC_GUIScreen_SetLayerStatus,
	GC_GUIScreen_GetLayerStatus,
#endif /* _DISABLE_GLAYER_ */
	GC_GUIScreen_CheckTransparentWindow,
	GC_GUIScreen_AddBaseTimerControl,
	GC_GUIScreen_RemoveBaseTimerControl,
#if		(_USE_MULTI_COORDINATE_ != 0)
	GC_GUIScreen_GetActiveCoordinate,
	GC_GUIScreen_GetNumCoordinate,
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GC_GUIScreen_OnRequestUpdataDB,
	GC_GUIScreen_GetBaseTimerInterval,
	GC_GUIScreen_SetReleaseType,
	GC_GUIScreen_GetReleaseType,
	GC_GUIScreen_SetLButtonPressObject,
	GC_GUIScreen_GetLButtonPressObject,
	GC_GUIScreen_SetPrevLButtonPressObject,
	GC_GUIScreen_GetPrevLButtonPressObject,
	GC_GUIScreen_GetKeyPressObject,
	GC_GUIScreen_ChangeKeyPressObject,
	GC_GUIScreen_GetDBChgMgr,
	GC_GUIScreen_SetCursorType,
	GC_GUIScreen_GetCursorType,
	GC_GUIScreen_PreActive,
	GC_GUIScreen_ForcedRelease,
	GC_GUIScreen_SetForcedReleaseStatus,
	GC_GUIScreen_GetForcedReleaseStatus,
	GC_GUIScreen_GetForcedReleaseTiming,
	GC_GUIScreen_SetForcedReleaseTiming,
	GC_GUIScreen_GetLButtonPressPTObject,
	GC_GUIScreen_SetLButtonPressPTObject,
	GC_GUIScreen_SetLBPressPoint,
	GC_GUIScreen_GetLBPressPoint,
	GC_GUIScreen_CheckBeLBPChildOver,
	GC_GUIScreen_MoveWindowListFirst, 
	GC_GUIScreen_MoveWindowListLast,
	GC_GUIScreen_MoveWindowListPrev,
	GC_GUIScreen_MoveWindowListNext,
	GC_GUIScreen_MoveWindowList,
	GC_GUIScreen_GetWindowIndex,
#ifndef _DISABLE_GLAYER_
	GC_GUIScreen_GetWindowCount,
	GC_GUIScreen_GetMaxLayer,
#endif /* _DISABLE_GLAYER_ */
	GC_GUIScreen_CreateSubPanel,

	GC_GUIScreen_CreateFrameAnimationInstance,
	GC_GUIScreen_SetFPS,
	GC_GUIScreen_GetFPS,
	GC_GUIScreen_SetPriority,
	GC_GUIScreen_GetPriority,
	GC_GUIScreen_GUIScriptDispatcher
//}}FUNCTION_TABLE_FUNCTION
};
//}}FUNCTION_TABLE_TABLE

const GC_GUIScreen_VMT *GWGetGC_GUIScreenVMT( void )
{
	return &vmt;
}
/*
 *	<summary>		:	IuWFNgB
 *
 *	<parameter>		:	Ȃ
 *
 *	<return>		:	NULL:		s
 *						NULLȊO:	IuWFNgւ̃|C^
 *
 *	<Explanation>	:	GC_GUIScreenIuWFNg̃mۂA{B
 */
GC_GUIScreen* GWNewGC_GUIScreen( void )
{
	GC_GUIScreen *pNewObject;

	pNewObject = (GC_GUIScreen*)GMMemoryAlloc( GMEM_SPACE_GWIN, 0, sizeof(GC_GUIScreen));
	if( pNewObject == NULL ){
		return NULL;
	}

	memset( pNewObject, 0, sizeof(GC_GUIScreen) );
	GWInitGC_GUIScreen( pNewObject );
	
	return pNewObject;
}

/*
 *	<summary>		:	B
 *
 *	<parameter>		:	(i)GC_GUIScreen* pSelf;	sIuWFNg
 *
 *	<return>		:	G_FALSE:	s
 *						G_TRUE:	
 *
 *	<Explanation>	:	GC_GUIScreenIuWFNg̏sB
 *						֐\(VMT)IuWFNgɊ֘AtB
 */
GInt16 GWInitGC_GUIScreen( GC_GUIScreen* pSelf )
{
	if(pSelf == NULL){
		return G_FALSE;
	}

	GWInitGFrameAnimationScreen( (GFrameAnimationScreen*)pSelf );
	((GObject*)pSelf)->vmt = (const GObject_VMT*)&vmt;
	return G_TRUE;
}

GClassMP( GC_GUIScreen )
//{{MESSAGEPROCEDURE
//}}MESSAGEPROCEDURE
	GDefMsg( GC_GUIScreen, GM_SCENARIO_EXEC, GUIScriptDispatcher )
GInheritMP( GFrameAnimationScreen )

GClassGUIScriptMP( GC_GUIScreen )
//{{GUI_SCRIPT_MESSAGEPROCEDURE
//}}GUI_SCRIPT_MESSAGEPROCEDURE
GEndClassGUIScriptMP()

#ifdef __cplusplus
extern "C" {
#endif
extern const GUInt8 cFillPatterns[][8];
extern const GUInt8 cLinePatterns[][8];
#ifdef __cplusplus
}
#endif
/*
 *	<summary>		:	B
 *
 *	<parameter>		:	(i)GScreen *pSelf;		:IuWFNg
 *						(i)GBaseWindow *pParent;	:eIuWFNgւ̃|C^
 *
 *	<return>		:	G_FALSE	:s
 *						G_TRUE	:
 *
 *	<Explanation>	:	IuWFNg̐sB
 */
GInt16 GC_GUIScreen_Create( void *pSelf, GBaseWindow *pParent )
{
	GInt16 idx;

	if( !GWGetGFrameAnimationScreenVMT()->Create( pSelf, pParent ) ){
		return G_FALSE;
	}

	for( idx = 0; idx < NUM_FILL_PATS; idx++ ){ 
		GDDefineFillPattern( ((GScreen*)pSelf)->hDraw, idx, (GInt8*)cFillPatterns[idx] );
		GDDefineFillPattern( ((GFrameAnimationScreen*)pSelf)->hVDraw, idx, (GInt8*)cFillPatterns[idx] );
	}
	for( idx = 0; idx < NUM_DASH_PATS; idx++ ){ 
		GDDefinePenDash( ((GScreen*)pSelf)->hDraw, (GInt16)(idx+1), (GInt8*)cLinePatterns[idx] );
		GDDefinePenDash( ((GFrameAnimationScreen*)pSelf)->hVDraw, (GInt16)(idx+1), (GInt8*)cLinePatterns[idx] );
	}

	//{{INITIAL_LOCALE
	GRCSetLocale( ID_LOC_LOCALE0 );
	//}}INITIAL_LOCALE

	//{{INITIAL_PANEL
	GWGetVmt(GC_GUIScreen_VMT,(GC_GUIScreen*)GWGetScreen())->ShowPanel( pSelf, 0 );
	//}}INITIAL_PANEL

	GESetTimer( pSelf, GSCREEN_BASE_TIMER_ID, GWGetVmt( GScreen_VMT, pSelf)->GetBaseTimerInterval( pSelf ) );

	GESetTimer( pSelf, ID_TIMER_DATA_LOGGING, LOGGING_DATA_CYCLE );

	GESetTimer( pSelf, ID_TIMER_FIVE_MINUTE, CHECK_HOLD_TIME_FREQUENCY );

	g_ucPermitLevel = Lebel_NON;

	return G_TRUE;
}


void DoLoggingData()
{
	DEVICE_HISTORY_NODE *pNode;
	DEVICE_CSV_NODE	*pCsvNode;
	USHORT		usData;
	TIME_INFO	time;
	GUInt8		ucIndex;
	DATAACCESSGDBID lstGDBID[4];
	
	pNode = (DEVICE_HISTORY_NODE*)malloc(sizeof(DEVICE_HISTORY_NODE));
	memset(&(pNode->data), 0, sizeof(pNode->data));
	pNode->pNext = 0;
	pNode->pPrev = 0;
	sprintf(lstGDBID[0].cObjectName,"%s","GDB_ELEC_IMPRINT");
	lstGDBID[0].usGDBID = ID_GDB_ELEC_IMPRINT;
	lstGDBID[0].sDataSize = 1;
	sprintf(lstGDBID[1].cObjectName,"%s","GDB_VOL_IMPRINT");
	lstGDBID[1].usGDBID = ID_GDB_VOL_IMPRINT;
	lstGDBID[1].sDataSize = 1;
	sprintf(lstGDBID[2].cObjectName,"%s","GDB_ELEC_DELIVERY");
	lstGDBID[2].usGDBID = ID_GDB_ELEC_DELIVERY;
	lstGDBID[2].sDataSize = 1;
	sprintf(lstGDBID[3].cObjectName,"%s","GDB_VOL_DELIVERY");
	lstGDBID[3].usGDBID = ID_GDB_VOL_DELIVERY;
	lstGDBID[3].sDataSize = 1;
	for(pCsvNode = g_pCsvHeader_Device->pTop,ucIndex = 0; NULL != pCsvNode; pCsvNode = pCsvNode->pNext, ucIndex++){
		/*GUIDBf[^擾*/
		DataAccessRead(&lstGDBID[ucIndex],1);
		GWDBReadData(pCsvNode->usGdbID, &usData, sizeof(USHORT));
		pNode->data.device[ucIndex] = usData;
	}
	/*ݎԎ擾*/
	GetTimeInfo(&time);
	pNode->data.usHour = time.usHour;

	PUSH_RECODE(g_pRecodeHeader_Device, pNode, DEVICE_HISTORY_NODE, RECODE_COUNT_MAX_DEVICE);

	WRITE_RECODE(g_pRecodeHeader_Device, DEVICE_HISTORY_NODE, DEVIVE_HISTORY_FILE_NAME);
}

void GC_GUIScreen_OnTimer( void *pSelf, GUInt16 usTimerID )
{
	GButton *pButton;
	GDesign *pDesign;
	GInt8 ucIndex;
	DATAACCESSGDBID lstGDBID[1];


	GPanel *pPanel;
	/*MOf[^*/
	if (ID_TIMER_DATA_LOGGING == usTimerID){
		DoLoggingData();
	}
	/*A삵ȂԃJEgAbv*/
	if (ID_TIMER_FIVE_MINUTE == usTimerID){
		if(g_ucPermitLevel != Lebel_NON){
			g_afterTimeSecondTotal++;
			if(CHECK_HOLD_FIVE_MINUTE == g_afterTimeSecondTotal){
				pPanel = GWGetVmt( GScreen_VMT, GWGetScreen() )->GetPanel( GWGetScreen() );
				if(GPANEL_MAINTENANCE == pPanel->gscBase.usType){
					for(ucIndex = g_ucPermitLevel; ucIndex > 0; ucIndex--){
						pButton = (GButton*)GWGetVmt(GPanel_VMT, pPanel)->GetChild( pPanel, (BTNSHOWLEVEL1 + ucIndex - NUM_DATA_1) );
						GWGetVmt( GButton_VMT, pButton )->SetStringID(pButton, ID_STRING_MaintenanceNotpermitted );
						pDesign = GWGetVmt( GButton_VMT, pButton )->GetOffDesign(pButton);
						pDesign->gbBrush.gcBackColor = RGB16(0xC0, 0xC0, 0xC0);
						GWGetVmt( GButton_VMT, pButton )->SetOffDesign(pButton, pDesign);
					}
				}
				g_ucPermitLevel = Lebel_NON;
				g_afterTimeSecondTotal = 0;
			}
		}
		// G[ǗʗpɃA[̊Ď
		sprintf(lstGDBID[0].cObjectName,"%s","GDB_ERR_LIST");
		lstGDBID[0].usGDBID = ID_GDB_ERR_LIST;
		lstGDBID[0].sDataSize = 50;
		DataAccessRead(lstGDBID,1);
	}

	return;
}

void GC_GUIScreen_OnUpdateDB( void *pSelf, void* pParam )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GC_GUIScreen_OnUpdateDB)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GC_GUIScreen_OnUpdateDB)
	GDBChgMgr	*pGDBChgMgr;
	GUInt8 ucIndex;
	unsigned short dbErrList[MONITOR_ERROR_COUNT_MAX] = {NUM_INIT_0};

	pGDBChgMgr = (GDBChgMgr*)pParam;
	/*G[Ǘ*/
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_ERR_LIST ) ){
		GWDBReadData(ID_GDB_ERR_LIST, dbErrList, sizeof(dbErrList)); 
		for(ucIndex = NUM_INIT_0; ucIndex < MONITOR_ERROR_COUNT_MAX; ucIndex++){
			if (dbErrList[ucIndex] != g_gdbOldErrList[ucIndex]){
				/*G[*/
				if (1 == dbErrList[ucIndex]){
					/*G[ɒǉ*/
					TriggerError(ucIndex);
				}
				/*G[*/
				else{
					/*ǉ*/
					RepairError(ucIndex);
				}
				g_gdbOldErrList[ucIndex] = dbErrList[ucIndex];
			}
		}
	}
	return;
}
