#include <stdlib.h>
#include <string.h>
#include "GPanel_ErrorManagement.h"
#include "gbasiccontrol.h"
#include "gbutton.h"
#include "gcheckbox.h"
#include "glabel.h"
#include "glist.h"
#include "gpicture.h"
#include "gprogressbar.h"
#include "gradiobutton.h"
#include "gtextbox.h"
#include "gtextboxex.h"
#include "gscrollbarex.h"
#include "ggrid.h"
#include "gstatictext.h"
#include "gnumbmp.h"
#include "GC_GUIScreen.h"
#include "gevent.h"
#include "GResource.h"
#include "GControlID.h"
#include "gcachetext.h"
#include "GScript.h"
#include "GDBObject.h"
#include "gsvframe.h"
#include "gdispsubpnl.h"
#include "GPanel_ErrorManagement.prc"
#include "Common.h"
#include "stdio.h"

#define	ERROR_ITEM_STRING_SIZE		128
#define	ERROR_LIST_ITEM_COUNT		15

typedef enum _ERROR_SORT_TYPE
{
	SORT_TYPE_OLD_TO_NEW,
	SORT_TYPE_NEW_TO_OLD,
	SORT_TYPE_HIGH_TO_LOW,
	SORT_TYPE_LOW_TO_HIGH
}ERROR_SORT_TYPE;

static void SortRecode(ERROR_SORT_TYPE sortType);
static GInt16 GetErrorHistoryString(GInt32 ucIndex, GTCHAR* pString);
static void RefreshErrorList(void *pSelf);


//{{FUNCTION_TABLE_TABLE
static const GPanel_ErrorManagement_VMT vmt=
{
//{{FUNCTION_TABLE_FUNCTION
	GPanel_ErrorManagement_MessageProcedure,
	GPanel_ErrorManagement_CallBackMessageProcedure,
	GPanel_ErrorManagement_GetType,
	GPanel_ErrorManagement_GetID,
	GPanel_ErrorManagement_GetXPosition,
	GPanel_ErrorManagement_GetYPosition,
	GPanel_ErrorManagement_GetPosition,
	GPanel_ErrorManagement_GetWidth,
	GPanel_ErrorManagement_GetHeight,
	GPanel_ErrorManagement_GetSize,
	GPanel_ErrorManagement_SetBounds,
	GPanel_ErrorManagement_GetBounds,
	GPanel_ErrorManagement_CalcClientRect,
	GPanel_ErrorManagement_GetClientRect,
	GPanel_ErrorManagement_ClientToScreen,
	GPanel_ErrorManagement_GetStyle,
	GPanel_ErrorManagement_SetVisibleStatus,
	GPanel_ErrorManagement_GetVisibleStatus,
	GPanel_ErrorManagement_SetEnableStatus,
	GPanel_ErrorManagement_GetEnableStatus,
	GPanel_ErrorManagement_SetConsumableStatus,
	GPanel_ErrorManagement_GetConsumableStatus,
	GPanel_ErrorManagement_SetCaptionStatus,
	GPanel_ErrorManagement_GetCaptionStatus,
	GPanel_ErrorManagement_SetFocusStatus,
	GPanel_ErrorManagement_GetFocusStatus,
	GPanel_ErrorManagement_SetStyleStatus,
	GPanel_ErrorManagement_GetStyleStatus,
	GPanel_ErrorManagement_SetParent,
	GPanel_ErrorManagement_GetParent,
	GPanel_ErrorManagement_SetFocusInformation,
	GPanel_ErrorManagement_GetFocusInformation,
	GPanel_ErrorManagement_Create,
	GPanel_ErrorManagement_Delete,
	GPanel_ErrorManagement_ImportProperty,
	GPanel_ErrorManagement_ExportProperty,
	GPanel_ErrorManagement_Paint,
	GPanel_ErrorManagement_OnDraw,
	GPanel_ErrorManagement_OnNcDraw,
	GPanel_ErrorManagement_AddRefreshRect,
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GPanel_ErrorManagement_MouseMove,
	GPanel_ErrorManagement_OnMouseMove,
	GPanel_ErrorManagement_OnNcMouseMove,
#endif /* _ENABLE_MOUSEMOVE_ */
	GPanel_ErrorManagement_LButtonPress,
	GPanel_ErrorManagement_OnLButtonPress,
	GPanel_ErrorManagement_OnNcLButtonPress,
	GPanel_ErrorManagement_LButtonRelease,
	GPanel_ErrorManagement_OnLButtonRelease,
	GPanel_ErrorManagement_OnNcLButtonRelease,
#ifdef _ENABLE_RBUTTON_
	GPanel_ErrorManagement_RButtonPress,
	GPanel_ErrorManagement_OnRButtonPress,
	GPanel_ErrorManagement_OnNcRButtonPress,
	GPanel_ErrorManagement_RButtonRelease,
	GPanel_ErrorManagement_OnRButtonRelease,
	GPanel_ErrorManagement_OnNcRButtonRelease,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GPanel_ErrorManagement_KeyPress,
	GPanel_ErrorManagement_KeyRelease,
	GPanel_ErrorManagement_SetFocus,
	GPanel_ErrorManagement_KillFocus,
	GPanel_ErrorManagement_Timer,
	GPanel_ErrorManagement_User,
	GPanel_ErrorManagement_Char,
	GPanel_ErrorManagement_Close,
	GPanel_ErrorManagement_DeleteChild,
	GPanel_ErrorManagement_SetMemorySpace,
	GPanel_ErrorManagement_GetMemorySpace,
	GPanel_ErrorManagement_SetDrawForceStatus,
	GPanel_ErrorManagement_GetDrawForceStatus,
	GPanel_ErrorManagement_SetRedrawStatus,
	GPanel_ErrorManagement_GetRedrawStatus,
	GPanel_ErrorManagement_ClearDrawStatus,
	GPanel_ErrorManagement_AddDirtyRect,
	GPanel_ErrorManagement_SetPrevTimerObject,
	GPanel_ErrorManagement_GetPrevTimerObject,
	GPanel_ErrorManagement_SetNextTimerObject,
	GPanel_ErrorManagement_GetNextTimerObject,
#ifndef	_DISABLE_GLAYER_
	GPanel_ErrorManagement_AddDirtyRectLayer,
	GPanel_ErrorManagement_SetDrawForceStatusLayer,
	GPanel_ErrorManagement_GetDrawForceStatusLayer,
	GPanel_ErrorManagement_SetRedrawStatusLayer,
	GPanel_ErrorManagement_GetRedrawStatusLayer,
	GPanel_ErrorManagement_SetLayerID,
	GPanel_ErrorManagement_GetLayerID,
#endif/*_DISABLE_GLAYER_*/
	GPanel_ErrorManagement_HoldImageData,
	GPanel_ErrorManagement_GetImageData,
	GPanel_ErrorManagement_CleanImageData,
	GPanel_ErrorManagement_Active,
	GPanel_ErrorManagement_OnActive,
	GPanel_ErrorManagement_SetActiveStatus,
	GPanel_ErrorManagement_GetActiveStatus,

	GPanel_ErrorManagement_OnCreate,
	GPanel_ErrorManagement_PreDelete,
	GPanel_ErrorManagement_PreKeyPress,
	GPanel_ErrorManagement_PreKeyRelease,
	GPanel_ErrorManagement_OnUser,
	GPanel_ErrorManagement_PrePress,
	GPanel_ErrorManagement_PreRelease,
	GPanel_ErrorManagement_PrePaint,
	GPanel_ErrorManagement_OnTimer,
#if		(_USE_MULTI_COORDINATE_ != 0)
	GPanel_ErrorManagement_SetActiveCoordinate,
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GPanel_ErrorManagement_OnUpdateDB,
	GPanel_ErrorManagement_IsMousePointInBounds,

	GPanel_ErrorManagement_SetBackGroundDesign,
	GPanel_ErrorManagement_GetBackGroundDesign,
	GPanel_ErrorManagement_CreateChildren,
	GPanel_ErrorManagement_AddChild,
	GPanel_ErrorManagement_DeleteAllChildren,
	GPanel_ErrorManagement_GetChild,
	GPanel_ErrorManagement_GetChildList,
	GPanel_ErrorManagement_DrawChildren,
	GPanel_ErrorManagement_DrawBackGround,
	GPanel_ErrorManagement_SetActiveChild,
	GPanel_ErrorManagement_GetActiveChild,
	GPanel_ErrorManagement_EndModal,
	GPanel_ErrorManagement_AddBlinkControl,
	GPanel_ErrorManagement_RemoveBlinkControl,
	GPanel_ErrorManagement_AddScrollControl,
	GPanel_ErrorManagement_RemoveScrollControl,
	GPanel_ErrorManagement_SetPictureData,
	GPanel_ErrorManagement_GetPictureData,
	GPanel_ErrorManagement_GetPositionChild,
	GPanel_ErrorManagement_SetNoResponseBaseArea,
	GPanel_ErrorManagement_GetNoResponseBaseArea,
	GPanel_ErrorManagement_SetReleaseType,
	GPanel_ErrorManagement_GetReleaseType,
	GPanel_ErrorManagement_GetChildAt,
	GPanel_ErrorManagement_OnShowPage,
	GPanel_ErrorManagement_OnHidePage,
	GPanel_ErrorManagement_MoveChildListFirst,
	GPanel_ErrorManagement_MoveChildListLast,
	GPanel_ErrorManagement_MoveChildListPrev,
	GPanel_ErrorManagement_MoveChildListNext,
	GPanel_ErrorManagement_MoveChildList,
	GPanel_ErrorManagement_GetChildIndex,
	GPanel_ErrorManagement_GetPrevChild,
	GPanel_ErrorManagement_GetNextChild,
#ifndef	_DISABLE_GLAYER_
	GPanel_ErrorManagement_GetChildCount,
	GPanel_ErrorManagement_GetFirstChildInLayer,
	GPanel_ErrorManagement_GetLastChildInLayer,
	GPanel_ErrorManagement_GetChildInLayer,
#endif/*_DISABLE_GLAYER_*/
	GPanel_ErrorManagement_AddFrameAnimation,
	GPanel_ErrorManagement_RemoveFrameAnimation,
	GPanel_ErrorManagement_StartAutoPlayFrameAnimation,
	GPanel_ErrorManagement_StartFrameAnimation,
	GPanel_ErrorManagement_ResetFrameAnimation,
	GPanel_ErrorManagement_StopFrameAnimation,
	GPanel_ErrorManagement_ResumeFrameAnimation,
	GPanel_ErrorManagement_FindFrameAnimation,
	GPanel_ErrorManagement_SetFrameAnimationSet,
	GPanel_ErrorManagement_SelectFrameAnimation,
	GPanel_ErrorManagement_SetAsyncAnimationStatus,
	GPanel_ErrorManagement_GetAsyncAnimationStatus,
	GPanel_ErrorManagement_StartAsyncFrameAnimation,
	GPanel_ErrorManagement_ResetAsyncFrameAnimation,
	GPanel_ErrorManagement_StopAsyncFrameAnimation,
	GPanel_ErrorManagement_ResumeAsyncFrameAnimation,
	GPanel_ErrorManagement_RestartAsyncFrameAnimation
//}}FUNCTION_TABLE_FUNCTION
};
//}}FUNCTION_TABLE_TABLE

const GPanel_ErrorManagement_VMT *GWGetGPanel_ErrorManagementVMT( void )
{
	return &vmt;
}
/*
 *	<summary>		:	IuWFNgB
 *
 *	<parameter>		:	Ȃ
 *
 *	<return>		:	NULL:		s
 *						NULLȊO:	IuWFNgւ̃|C^
 *
 *	<Explanation>	:	GPanel_ErrorManagementIuWFNg̃mۂA{B
 */
GPanel_ErrorManagement* GWNewGPanel_ErrorManagement( void )
{
	GUInt8 ucType,ucPlane;
	GPanel_ErrorManagement *pNewObject;

	GWGetVmt( GScreen_VMT, GWGetScreen() )->GetMemorySpace( GWGetScreen(), &ucType, &ucPlane );
	pNewObject = (GPanel_ErrorManagement*)GMMemoryAlloc( ucType, ucPlane, sizeof(GPanel_ErrorManagement));
	if( pNewObject == NULL ){
		return NULL;
	}

	memset( pNewObject, 0, sizeof(GPanel_ErrorManagement) );
	GWInitGPanel_ErrorManagement( pNewObject );
	
	return pNewObject;
}

/*
 *	<summary>		:	B
 *
 *	<parameter>		:	(i)GPanel_ErrorManagement* pSelf;	sIuWFNg
 *
 *	<return>		:	G_FALSE:	s
 *						G_TRUE:	
 *
 *	<Explanation>	:	GPanel_ErrorManagementIuWFNg̏sB
 *						֐\(VMT)IuWFNgɊ֘AtB
 */
GInt16 GWInitGPanel_ErrorManagement( GPanel_ErrorManagement* pSelf )
{
	if(pSelf == NULL){
		return G_FALSE;
	}

	GWInitGFrameAnimationPanel( (GFrameAnimationPanel*)pSelf );
	((GObject*)pSelf)->vmt = (const GObject_VMT*)&vmt;

	return G_TRUE;
}

/*
 *	<summary>		:	CxgbZ[WvV[WB
 *
 *	<parameter>		:	(i)GBaseWindow* pSelf;	IuWFNg
 *						(i)GUInt16 usMessage;	CxgbZ[W
 *						(i)GLParam lLParam;		t񉺈
 *						(i)GUParam lUParam;		t
 *
 *	<return>		:	-1:		ΉCxg݂ȂB
 *						0ȏ:	CxgɈˑ
 *
 *	<description>	:	CxgbZ[WɑΉ֐̌ĂяosB
 *						
 */
GClassMP( GPanel_ErrorManagement )
//{{MESSAGEPROCEDURE
//}}MESSAGEPROCEDURE
GInheritMP( GFrameAnimationPanel )


/*
 *	<summary>		:	qIuWFNǧ
 *
 *	<parameter>		:	(i)void *pSelf;		:IuWFNg
 *						(i)GUInt16 usIdx;	:qIuWFNg̃CfbNX
 *
 *	<return>		:	CfbNX͈͓	IuWFNgւ̃|C^
 *	 					CfbNX͈͊O	NULL
 *
 *	<description>	:	wIDGPanel̎qIuWFNgB
 *
 *	<exception>		:	w̃CfbNXlGCPanel̎qIuWFNgԂB
 *
 */
GBaseWindow* GPanel_ErrorManagement_GetChildAt( void *pSelf, GUInt16 usIdx )
{
	if( (sizeof(pProperty)/sizeof(GBaseWindowProperty*)) > usIdx ){
		return ((GPanel_ErrorManagement*)pSelf)->m_pObjectTable[usIdx];
	}else{
		return NULL;
	}
}

/*
 *	<summary>		:	qIuWFNg
 *
 *	<parameter>		:	(i)GPanel_ErrorManagement *pSelf;		:IuWFNg
 *
 *	<return>		:	Ȃ
 *
 *	<description>	:	qIuWFNg{B
 */
GInt16 GPanel_ErrorManagement_CreateChildren( void *pSelf )
{
	GBaseWindow *pChild;
	GUInt32 i;

	for( i = 1; i < (sizeof(pProperty)/sizeof(GBaseWindowProperty*)); i++ ){
		pChild = GWGetVmt(GScreen_VMT,GWGetScreen())->CreateInstance( GWGetScreen(), pProperty[i]->usType, pProperty[i], (GBaseWindow*)pSelf );
		GWGetVmt( GPanel_ErrorManagement_VMT,pSelf )->AddChild( pSelf, pChild );
		((GPanel_ErrorManagement*)pSelf)->m_pObjectTable[i] = pChild;
		GWGetVmt( GBaseWindow_VMT,pChild )->Create( pChild, pSelf );
	}
	if((sizeof(pFrameAnimationSet)/sizeof(GFrameAnimationSetProperty)) > 1) {
		GWGetVmt( GPanel_ErrorManagement_VMT, pSelf )->SetFrameAnimationSet( pSelf, pFrameAnimationSet );
		GWGetVmt( GPanel_ErrorManagement_VMT, pSelf )->SelectFrameAnimation( pSelf, 1 );
	}
	return G_TRUE;
}


GInt32 GPANEL_ERRORMANAGEMENT_BTNERRORMANAGEMENTMENUOnClick(GPanel_ErrorManagement *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_ERRORMANAGEMENT_BTNERRORMANAGEMENTMENUOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_ERRORMANAGEMENT_BTNERRORMANAGEMENTMENUOnClick)
	CompareOperateTime();
	DoOperate(BTNERRORMANAGEMENTMENU, pSelf);
	GActScreenOpenWindow( pSelf, SHOWGWINDOW_MENU );
	return G_TRUE;
}

GInt32 GPANEL_ERRORMANAGEMENT_SCROLLBARERROROnScroll(GPanel_ErrorManagement *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_ERRORMANAGEMENT_SCROLLBARERROROnScroll)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_ERRORMANAGEMENT_SCROLLBARERROROnScroll)
	GScrollBarEx *pScrollBarEx;
	GInt32 lPosition;
	GStaticText *pSText;
	GInt16 ucIndex;
	GInt16 nErrSts;
	GTCHAR szHistoryStr[ERROR_ITEM_STRING_SIZE];
	GCaption *pCaption;

	CompareOperateTime();
	pScrollBarEx = (GScrollBarEx*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, SCROLLBARERROR );
	lPosition = GWGetVmt( GScrollBarEx_VMT, pScrollBarEx )->GetScrollPosition( pScrollBarEx );

	for(ucIndex=0; ucIndex< ERROR_LIST_ITEM_COUNT; ucIndex++)
	{
		memset(szHistoryStr, NUM_INIT_0, sizeof(szHistoryStr));
		pSText = (GStaticText*)GWGetVmt( GPanel_VMT, pSelf )->GetChild(pSelf, (TESTERRORLIST01 + ucIndex));
		nErrSts = GetErrorHistoryString((lPosition + ucIndex), szHistoryStr);
		GWGetVmt( GStaticText_VMT, pSText )->SetString(pSText, szHistoryStr);
		pCaption = GWGetVmt( GStaticText_VMT, pSText )->GetCaption( pSText );
		/**/
		if (ERROR_STS_TRIGGER == nErrSts)
		{
			/*FԂɐݒ*/
			pCaption->gcColor = RGB16(0xFF, 0x00, 0x00);
		}
		/**/
		else if (ERROR_STS_REPAIR == nErrSts)
		{
			/*Fɐݒ*/
			pCaption->gcColor = RGB16(0x00, 0x00, 0xFF);
		}
	}

	return G_TRUE;
}
void GPanel_ErrorManagement_OnCreate( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPanel_ErrorManagement_OnCreate)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPanel_ErrorManagement_OnCreate)
	GStaticText *pSTextNowErr;
	GTCHAR szNowErrString[ERROR_ITEM_STRING_SIZE];

	/*G[ꗗXV*/
	RefreshErrorList(pSelf);
	/*ݔG[XV*/
	memset(szNowErrString, 0, sizeof(szNowErrString));
	GetNowErrString(szNowErrString);
	pSTextNowErr = (GStaticText*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, TEXTERRORINFO );
	GWGetVmt( GStaticText_VMT, pSTextNowErr )->SetString( pSTextNowErr, szNowErrString );
	return;
}

void GPanel_ErrorManagement_OnUpdateDB( void *pSelf, void *pParam )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPanel_ErrorManagement_OnUpdateDB)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPanel_ErrorManagement_OnUpdateDB)
	GDBChgMgr	*pGDBChgMgr; 
	GStaticText *pSTextNowErr;
	GTCHAR szNowErrString[ERROR_ITEM_STRING_SIZE];

	pGDBChgMgr = (GDBChgMgr*)pParam; 
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_ERR_LIST ) ){
		/*G[ꗗXV*/
		RefreshErrorList(pSelf);
		/*ݔG[XV*/
		memset(szNowErrString, 0, sizeof(szNowErrString));
		GetNowErrString(szNowErrString);

		pSTextNowErr = (GStaticText*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, TEXTERRORINFO );
		GWGetVmt( GStaticText_VMT, pSTextNowErr )->SetString( pSTextNowErr, szNowErrString );
	}
	return;
}

void RefreshErrorList(void *pSelf)
{
	GUInt8				ucIndex;
	GStaticText			*pSText;
	GTCHAR				szErrInfo[ERROR_ITEM_STRING_SIZE];
	ERROR_HISTORY_NODE	*pHistoryNode;
	GCaption			*pCaption;

	for(ucIndex = NUM_INIT_0, pHistoryNode = g_pRecodeHeader_Error->pTop; (ucIndex < ERROR_LIST_ITEM_COUNT) && (NULL != pHistoryNode); ucIndex++, pHistoryNode = pHistoryNode->pNext)
	{
		memset(szErrInfo, NUM_INIT_0, sizeof(szErrInfo));
		pSText = (GStaticText*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (TESTERRORLIST01 + ucIndex) );
		pCaption = GWGetVmt( GStaticText_VMT, pSText )->GetCaption( pSText );
		/*G[*/
		if (pHistoryNode->data.ucErrSts == ERROR_STS_TRIGGER)
		{
			/*	2	2013/12/10	15:30:12	01FA	ʐMG[܂B*/
			sprintf(szErrInfo, ERROR_STRING_FORMAT_TRIGGER, pHistoryNode->data.ucErrLevel,
				pHistoryNode->data.date.usYear, pHistoryNode->data.date.usMonth, pHistoryNode->data.date.usDay,
				pHistoryNode->data.timeTrigger.usHour, pHistoryNode->data.timeTrigger.usMinute, pHistoryNode->data.timeTrigger.usSecond,
				pHistoryNode->data.usErrCode, GRCLoadString(pHistoryNode->data.usStrID));
			/*FԂɐݒ*/
			pCaption->gcColor = RGB16(0xFF, 0x00, 0x00);
		}
		/*G[*/
		else
		{
			/*	2	2013/12/10	15:30:12	01FA	ʐMG[܂B	17:30:56*/
			sprintf(szErrInfo, ERROR_STRING_FORMAT_REPAIR, pHistoryNode->data.ucErrLevel,
				pHistoryNode->data.date.usYear, pHistoryNode->data.date.usMonth, pHistoryNode->data.date.usDay,
				pHistoryNode->data.timeTrigger.usHour, pHistoryNode->data.timeTrigger.usMinute, pHistoryNode->data.timeTrigger.usSecond,
				pHistoryNode->data.usErrCode, GRCLoadString(pHistoryNode->data.usStrID),
				pHistoryNode->data.timeRepair.usHour, pHistoryNode->data.timeRepair.usMinute, pHistoryNode->data.timeRepair.usSecond);

			/*Fɐݒ*/
			pCaption->gcColor = RGB16(0x00, 0x00, 0xFF);
		}
		/*\*/
		GWGetVmt( GStaticText_VMT, pSText )->SetString(pSText, szErrInfo);
	}
}

GInt32 GPANEL_ERRORMANAGEMENT_BTNHIGHTOLOWOnClick(GPanel_ErrorManagement *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	/*G[xHighLow*/
	CompareOperateTime();
	DoOperate(BTNHIGHTOLOW, pSelf);
	SortRecode(SORT_TYPE_HIGH_TO_LOW);
	RefreshErrorList(pSelf);
	/*t@Cɏ*/
	WRITE_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);
	return G_TRUE;
}

GInt32 GPANEL_ERRORMANAGEMENT_BTNHISTORYCLEAROnClick(GPanel_ErrorManagement *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	GStaticText *pSText;
	GUInt8		ucIndex;
	CompareOperateTime();
	DoOperate(BTNHISTORYCLEAR, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1))
	{
		/*G[ꗗXgNA*/
		for(ucIndex=0; ucIndex< ERROR_LIST_ITEM_COUNT; ucIndex++)
		{
			pSText = (GStaticText*)GWGetVmt(GPanel_VMT, pSelf)->GetChild( pSelf, (TESTERRORLIST01 + ucIndex));
			GWGetVmt(GStaticText_VMT, pSText)->SetString(pSText, "");
		}
		/*Oobt@NA*/
		CLEAR_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE);
		/*t@CNA*/
		CLEAR_FILE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);
		/*G[\NA*/
		pSText = (GStaticText*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, TEXTERRORINFO );
		GWGetVmt( GStaticText_VMT, pSText )->SetString( pSText, "" );

	}
	return G_TRUE;
}

GInt32 GPANEL_ERRORMANAGEMENT_BTNLOWTOHIGHOnClick(GPanel_ErrorManagement *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	/*G[xLowHigh*/
	CompareOperateTime();
	DoOperate(BTNLOWTOHIGH, pSelf);
	SortRecode(SORT_TYPE_LOW_TO_HIGH);
	RefreshErrorList(pSelf);
	/*t@Cɏ*/
	WRITE_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);

	return G_TRUE;
}

GInt32 GPANEL_ERRORMANAGEMENT_BTNNEWTOOLDOnClick(GPanel_ErrorManagement *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	/*VÂ*/
	CompareOperateTime();
	DoOperate(BTNNEWTOOLD, pSelf);
	SortRecode(SORT_TYPE_NEW_TO_OLD);
	RefreshErrorList(pSelf);
	/*t@Cɏ*/
	WRITE_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);
	return G_TRUE;
}

GInt32 GPANEL_ERRORMANAGEMENT_BTNOLDTONEWOnClick(GPanel_ErrorManagement *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	/*ÂV*/
	CompareOperateTime();
	DoOperate(BTNOLDTONEW, pSelf);
	SortRecode(SORT_TYPE_OLD_TO_NEW);
	RefreshErrorList(pSelf);
	/*t@Cɏ*/
	WRITE_RECODE(g_pRecodeHeader_Error, ERROR_HISTORY_NODE, ERROR_HISTORY_FILE_NAME);
	return G_TRUE;
}

/*Oobt@\[g*/
void SortRecode(ERROR_SORT_TYPE sortType)
{
	ERROR_HISTORY_NODE	*pNextNode;
	ERROR_HISTORY_NODE	*pNowNode;
	ERROR_HISTORY_HEADER *pNewErrHead;

	pNewErrHead = (ERROR_HISTORY_HEADER*)malloc(sizeof(ERROR_HISTORY_HEADER));
	memset(pNewErrHead, 0, sizeof(ERROR_HISTORY_HEADER));
	pNewErrHead->pTail = NULL;
	pNewErrHead->pTop = NULL;
	pNewErrHead->ucCount = NUM_INIT_0;
	
	while(g_pRecodeHeader_Error->ucCount > 0)
	{
		pNextNode = g_pRecodeHeader_Error->pTop->pNext;
		pNowNode = g_pRecodeHeader_Error->pTop;
		while (NULL != pNextNode)
		{
			if (SORT_TYPE_OLD_TO_NEW == sortType)
			{
				if (0 < CompareTime(pNowNode, pNextNode))
				{
					// ݃m[h̃m[hV
					pNowNode = pNextNode;
				}
			}
			else if (SORT_TYPE_NEW_TO_OLD == sortType)
			{
				if (0 > CompareTime(pNowNode, pNextNode))
				{
					// ݃m[h̃m[hÂ
					pNowNode = pNextNode;
				}
			}
			else if (SORT_TYPE_HIGH_TO_LOW == sortType)
			{
				/*G[ẍԍm[hT*/
				if (pNowNode->data.ucErrLevel < pNextNode->data.ucErrLevel)
				{
					pNowNode = pNextNode;
				}
			}
			else if (SORT_TYPE_LOW_TO_HIGH == sortType)
			{
				/*G[ẍԒႢm[hT*/
				if (pNowNode->data.ucErrLevel > pNextNode->data.ucErrLevel)
				{
					pNowNode = pNextNode;
				}
			}
			pNextNode = pNextNode->pNext;
		}
		/*擪̃m[hł͂Ȃꍇ*/
		if (NULL != pNowNode->pPrev)
		{
			pNowNode->pPrev->pNext = pNowNode->pNext;
		}
		else
		{
			/*cm[hȏ*/
			if (NULL != pNowNode->pNext)
			{
				g_pRecodeHeader_Error->pTop = pNowNode->pNext;
				g_pRecodeHeader_Error->pTop->pPrev = NULL;
			}

		}

		/*Ō̃m[hł͂Ȃꍇ*/
		if (NULL != pNowNode->pNext)
		{
			//pNowNode->pPrev = pNowNode->pNext->pPrev;
			pNowNode->pNext->pPrev = pNowNode->pPrev;
		}
		else
		{
			if (NULL != pNowNode->pPrev)
			{
				g_pRecodeHeader_Error->pTail = pNowNode->pPrev;
				g_pRecodeHeader_Error->pTail->pNext = NULL;
			}
		}

		/*m[hJEg*/
		g_pRecodeHeader_Error->ucCount -= NUM_DATA_1;

		pNowNode->pNext = NULL;
		pNowNode->pPrev = NULL;
		/* VNXgɒǉ */
		PUSH_RECODE(pNewErrHead, pNowNode, ERROR_HISTORY_NODE, RECODE_COUNT_MAX_ERROR);
	}
	
	/*ÂG[wb_[̈J*/
	free(g_pRecodeHeader_Error);
	/*V̈w*/
	g_pRecodeHeader_Error = pNewErrHead;
}

/*Ŏwm[h̃G[擾*/
GInt16 GetErrorHistoryString(GInt32 ucIndex, GTCHAR* pString)
{
	GInt16				nErrSts;
	ERROR_HISTORY_NODE *pNode;

	nErrSts = -1;
	if (ucIndex < g_pRecodeHeader_Error->ucCount)
	{
		/*w肵CfbNXm[hֈړ*/
		for(pNode = g_pRecodeHeader_Error->pTop; ucIndex > 0; pNode = pNode->pNext, ucIndex--);

		if (NULL != pNode)
		{
			sprintf(pString, ERROR_STRING_FORMAT_TRIGGER, pNode->data.ucErrLevel,
						pNode->data.date.usYear, pNode->data.date.usMonth, pNode->data.date.usDay,
						pNode->data.timeTrigger.usHour, pNode->data.timeTrigger.usMinute, pNode->data.timeTrigger.usSecond,
						pNode->data.usErrCode, GRCLoadString(pNode->data.usStrID));
			
			nErrSts = pNode->data.ucErrSts;
		}
	}

	return nErrSts;
}

