#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "GPanel_ManualOperation.h"
#include "gbasiccontrol.h"
#include "gbutton.h"
#include "gcheckbox.h"
#include "glabel.h"
#include "glist.h"
#include "gpicture.h"
#include "gprogressbar.h"
#include "gradiobutton.h"
#include "gtextbox.h"
#include "gtextboxex.h"
#include "gscrollbarex.h"
#include "ggrid.h"
#include "gstatictext.h"
#include "gnumbmp.h"
#include "GC_GUIScreen.h"
#include "gevent.h"
#include "GResource.h"
#include "GControlID.h"
#include "gcachetext.h"
#include "GScript.h"
#include "GDBObject.h"
#include "gsvframe.h"
#include "gdispsubpnl.h"
#include "GPanel_ManualOperation.prc"

#include "math.h"
#include "Common.h"
#include "dataaccessapi.h"

extern DATAACCESSGDBID stGDBID[];

#define		SCR_WIDTH		320				/*ʉ*/
#define		SCR_HEIGHT		(300)			/*ʍ*/
#define		MAX_SCALE		(180)			/*OtXP[*/

#define		HIRAKISEKIONE	(0x0001)
#define		HIRAKISEKITWO	(0x0002)
#define		FORCEDOUT		(0x0004)
#define		TABLERIGHT		(0x0008)
#define		TABLELEFT		(0x0010)
#define		CARRIAGERIGHT	(0x0001)
#define		CARRIAGELEFT	(0x0002)
#define		CARRIAGEUP		(0x0004)
#define		CARRIAGEDOWN	(0x0008)
#define		CARRIAGESTOP	(0x0010)

//{{FUNCTION_TABLE_TABLE
static const GPanel_ManualOperation_VMT vmt=
{
//{{FUNCTION_TABLE_FUNCTION
	GPanel_ManualOperation_MessageProcedure,
	GPanel_ManualOperation_CallBackMessageProcedure,
	GPanel_ManualOperation_GetType,
	GPanel_ManualOperation_GetID,
	GPanel_ManualOperation_GetXPosition,
	GPanel_ManualOperation_GetYPosition,
	GPanel_ManualOperation_GetPosition,
	GPanel_ManualOperation_GetWidth,
	GPanel_ManualOperation_GetHeight,
	GPanel_ManualOperation_GetSize,
	GPanel_ManualOperation_SetBounds,
	GPanel_ManualOperation_GetBounds,
	GPanel_ManualOperation_CalcClientRect,
	GPanel_ManualOperation_GetClientRect,
	GPanel_ManualOperation_ClientToScreen,
	GPanel_ManualOperation_GetStyle,
	GPanel_ManualOperation_SetVisibleStatus,
	GPanel_ManualOperation_GetVisibleStatus,
	GPanel_ManualOperation_SetEnableStatus,
	GPanel_ManualOperation_GetEnableStatus,
	GPanel_ManualOperation_SetConsumableStatus,
	GPanel_ManualOperation_GetConsumableStatus,
	GPanel_ManualOperation_SetCaptionStatus,
	GPanel_ManualOperation_GetCaptionStatus,
	GPanel_ManualOperation_SetFocusStatus,
	GPanel_ManualOperation_GetFocusStatus,
	GPanel_ManualOperation_SetStyleStatus,
	GPanel_ManualOperation_GetStyleStatus,
	GPanel_ManualOperation_SetParent,
	GPanel_ManualOperation_GetParent,
	GPanel_ManualOperation_SetFocusInformation,
	GPanel_ManualOperation_GetFocusInformation,
	GPanel_ManualOperation_Create,
	GPanel_ManualOperation_Delete,
	GPanel_ManualOperation_ImportProperty,
	GPanel_ManualOperation_ExportProperty,
	GPanel_ManualOperation_Paint,
	GPanel_ManualOperation_OnDraw,
	GPanel_ManualOperation_OnNcDraw,
	GPanel_ManualOperation_AddRefreshRect,
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GPanel_ManualOperation_MouseMove,
	GPanel_ManualOperation_OnMouseMove,
	GPanel_ManualOperation_OnNcMouseMove,
#endif /* _ENABLE_MOUSEMOVE_ */
	GPanel_ManualOperation_LButtonPress,
	GPanel_ManualOperation_OnLButtonPress,
	GPanel_ManualOperation_OnNcLButtonPress,
	GPanel_ManualOperation_LButtonRelease,
	GPanel_ManualOperation_OnLButtonRelease,
	GPanel_ManualOperation_OnNcLButtonRelease,
#ifdef _ENABLE_RBUTTON_
	GPanel_ManualOperation_RButtonPress,
	GPanel_ManualOperation_OnRButtonPress,
	GPanel_ManualOperation_OnNcRButtonPress,
	GPanel_ManualOperation_RButtonRelease,
	GPanel_ManualOperation_OnRButtonRelease,
	GPanel_ManualOperation_OnNcRButtonRelease,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GPanel_ManualOperation_KeyPress,
	GPanel_ManualOperation_KeyRelease,
	GPanel_ManualOperation_SetFocus,
	GPanel_ManualOperation_KillFocus,
	GPanel_ManualOperation_Timer,
	GPanel_ManualOperation_User,
	GPanel_ManualOperation_Char,
	GPanel_ManualOperation_Close,
	GPanel_ManualOperation_DeleteChild,
	GPanel_ManualOperation_SetMemorySpace,
	GPanel_ManualOperation_GetMemorySpace,
	GPanel_ManualOperation_SetDrawForceStatus,
	GPanel_ManualOperation_GetDrawForceStatus,
	GPanel_ManualOperation_SetRedrawStatus,
	GPanel_ManualOperation_GetRedrawStatus,
	GPanel_ManualOperation_ClearDrawStatus,
	GPanel_ManualOperation_AddDirtyRect,
	GPanel_ManualOperation_SetPrevTimerObject,
	GPanel_ManualOperation_GetPrevTimerObject,
	GPanel_ManualOperation_SetNextTimerObject,
	GPanel_ManualOperation_GetNextTimerObject,
#ifndef	_DISABLE_GLAYER_
	GPanel_ManualOperation_AddDirtyRectLayer,
	GPanel_ManualOperation_SetDrawForceStatusLayer,
	GPanel_ManualOperation_GetDrawForceStatusLayer,
	GPanel_ManualOperation_SetRedrawStatusLayer,
	GPanel_ManualOperation_GetRedrawStatusLayer,
	GPanel_ManualOperation_SetLayerID,
	GPanel_ManualOperation_GetLayerID,
#endif/*_DISABLE_GLAYER_*/
	GPanel_ManualOperation_HoldImageData,
	GPanel_ManualOperation_GetImageData,
	GPanel_ManualOperation_CleanImageData,
	GPanel_ManualOperation_Active,
	GPanel_ManualOperation_OnActive,
	GPanel_ManualOperation_SetActiveStatus,
	GPanel_ManualOperation_GetActiveStatus,

	GPanel_ManualOperation_OnCreate,
	GPanel_ManualOperation_PreDelete,
	GPanel_ManualOperation_PreKeyPress,
	GPanel_ManualOperation_PreKeyRelease,
	GPanel_ManualOperation_OnUser,
	GPanel_ManualOperation_PrePress,
	GPanel_ManualOperation_PreRelease,
	GPanel_ManualOperation_PrePaint,
	GPanel_ManualOperation_OnTimer,
#if		(_USE_MULTI_COORDINATE_ != 0)
	GPanel_ManualOperation_SetActiveCoordinate,
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GPanel_ManualOperation_OnUpdateDB,
	GPanel_ManualOperation_IsMousePointInBounds,

	GPanel_ManualOperation_SetBackGroundDesign,
	GPanel_ManualOperation_GetBackGroundDesign,
	GPanel_ManualOperation_CreateChildren,
	GPanel_ManualOperation_AddChild,
	GPanel_ManualOperation_DeleteAllChildren,
	GPanel_ManualOperation_GetChild,
	GPanel_ManualOperation_GetChildList,
	GPanel_ManualOperation_DrawChildren,
	GPanel_ManualOperation_DrawBackGround,
	GPanel_ManualOperation_SetActiveChild,
	GPanel_ManualOperation_GetActiveChild,
	GPanel_ManualOperation_EndModal,
	GPanel_ManualOperation_AddBlinkControl,
	GPanel_ManualOperation_RemoveBlinkControl,
	GPanel_ManualOperation_AddScrollControl,
	GPanel_ManualOperation_RemoveScrollControl,
	GPanel_ManualOperation_SetPictureData,
	GPanel_ManualOperation_GetPictureData,
	GPanel_ManualOperation_GetPositionChild,
	GPanel_ManualOperation_SetNoResponseBaseArea,
	GPanel_ManualOperation_GetNoResponseBaseArea,
	GPanel_ManualOperation_SetReleaseType,
	GPanel_ManualOperation_GetReleaseType,
	GPanel_ManualOperation_GetChildAt,
	GPanel_ManualOperation_OnShowPage,
	GPanel_ManualOperation_OnHidePage,
	GPanel_ManualOperation_MoveChildListFirst,
	GPanel_ManualOperation_MoveChildListLast,
	GPanel_ManualOperation_MoveChildListPrev,
	GPanel_ManualOperation_MoveChildListNext,
	GPanel_ManualOperation_MoveChildList,
	GPanel_ManualOperation_GetChildIndex,
	GPanel_ManualOperation_GetPrevChild,
	GPanel_ManualOperation_GetNextChild,
#ifndef	_DISABLE_GLAYER_
	GPanel_ManualOperation_GetChildCount,
	GPanel_ManualOperation_GetFirstChildInLayer,
	GPanel_ManualOperation_GetLastChildInLayer,
	GPanel_ManualOperation_GetChildInLayer,
#endif/*_DISABLE_GLAYER_*/
	GPanel_ManualOperation_AddFrameAnimation,
	GPanel_ManualOperation_RemoveFrameAnimation,
	GPanel_ManualOperation_StartAutoPlayFrameAnimation,
	GPanel_ManualOperation_StartFrameAnimation,
	GPanel_ManualOperation_ResetFrameAnimation,
	GPanel_ManualOperation_StopFrameAnimation,
	GPanel_ManualOperation_ResumeFrameAnimation,
	GPanel_ManualOperation_FindFrameAnimation,
	GPanel_ManualOperation_SetFrameAnimationSet,
	GPanel_ManualOperation_SelectFrameAnimation,
	GPanel_ManualOperation_SetAsyncAnimationStatus,
	GPanel_ManualOperation_GetAsyncAnimationStatus,
	GPanel_ManualOperation_StartAsyncFrameAnimation,
	GPanel_ManualOperation_ResetAsyncFrameAnimation,
	GPanel_ManualOperation_StopAsyncFrameAnimation,
	GPanel_ManualOperation_ResumeAsyncFrameAnimation,
	GPanel_ManualOperation_RestartAsyncFrameAnimation
//}}FUNCTION_TABLE_FUNCTION
};
//}}FUNCTION_TABLE_TABLE

void updatePanelOnShow(void *pSelf, unsigned short gUShortDBstr,short sID);

const GPanel_ManualOperation_VMT *GWGetGPanel_ManualOperationVMT( void )
{
	return &vmt;
}
/*
 *	<summary>		:	IuWFNgB
 *
 *	<parameter>		:	Ȃ
 *
 *	<return>		:	NULL:		s
 *						NULLȊO:	IuWFNgւ̃|C^
 *
 *	<Explanation>	:	GPanel_ManualOperationIuWFNg̃mۂA{B
 */
GPanel_ManualOperation* GWNewGPanel_ManualOperation( void )
{
	GUInt8 ucType,ucPlane;
	GPanel_ManualOperation *pNewObject;

	GWGetVmt( GScreen_VMT, GWGetScreen() )->GetMemorySpace( GWGetScreen(), &ucType, &ucPlane );
	pNewObject = (GPanel_ManualOperation*)GMMemoryAlloc( ucType, ucPlane, sizeof(GPanel_ManualOperation));
	if( pNewObject == NULL ){
		return NULL;
	}

	memset( pNewObject, 0, sizeof(GPanel_ManualOperation) );
	GWInitGPanel_ManualOperation( pNewObject );
	
	return pNewObject;
}

/*
 *	<summary>		:	B
 *
 *	<parameter>		:	(i)GPanel_ManualOperation* pSelf;	sIuWFNg
 *
 *	<return>		:	G_FALSE:	s
 *						G_TRUE:	
 *
 *	<Explanation>	:	GPanel_ManualOperationIuWFNg̏sB
 *						֐\(VMT)IuWFNgɊ֘AtB
 */
GInt16 GWInitGPanel_ManualOperation( GPanel_ManualOperation* pSelf )
{
	if(pSelf == NULL){
		return G_FALSE;
	}

	GWInitGFrameAnimationPanel( (GFrameAnimationPanel*)pSelf );
	((GObject*)pSelf)->vmt = (const GObject_VMT*)&vmt;

	return G_TRUE;
}

/*
 *	<summary>		:	CxgbZ[WvV[WB
 *
 *	<parameter>		:	(i)GBaseWindow* pSelf;	IuWFNg
 *						(i)GUInt16 usMessage;	CxgbZ[W
 *						(i)GLParam lLParam;		t񉺈
 *						(i)GUParam lUParam;		t
 *
 *	<return>		:	-1:		ΉCxg݂ȂB
 *						0ȏ:	CxgɈˑ
 *
 *	<description>	:	CxgbZ[WɑΉ֐̌ĂяosB
 *						
 */
GClassMP( GPanel_ManualOperation )
//{{MESSAGEPROCEDURE
//}}MESSAGEPROCEDURE
GInheritMP( GFrameAnimationPanel )


/*
 *	<summary>		:	qIuWFNǧ
 *
 *	<parameter>		:	(i)void *pSelf;		:IuWFNg
 *						(i)GUInt16 usIdx;	:qIuWFNg̃CfbNX
 *
 *	<return>		:	CfbNX͈͓	IuWFNgւ̃|C^
 *	 					CfbNX͈͊O	NULL
 *
 *	<description>	:	wIDGPanel̎qIuWFNgB
 *
 *	<exception>		:	w̃CfbNXlGCPanel̎qIuWFNgԂB
 *
 */
GBaseWindow* GPanel_ManualOperation_GetChildAt( void *pSelf, GUInt16 usIdx )
{
	if( (sizeof(pProperty)/sizeof(GBaseWindowProperty*)) > usIdx ){
		return ((GPanel_ManualOperation*)pSelf)->m_pObjectTable[usIdx];
	}else{
		return NULL;
	}
}

/*
 *	<summary>		:	qIuWFNg
 *
 *	<parameter>		:	(i)GPanel_ManualOperation *pSelf;		:IuWFNg
 *
 *	<return>		:	Ȃ
 *
 *	<description>	:	qIuWFNg{B
 */
GInt16 GPanel_ManualOperation_CreateChildren( void *pSelf )
{
	GBaseWindow *pChild;
	GUInt32 i;

	for( i = 1; i < (sizeof(pProperty)/sizeof(GBaseWindowProperty*)); i++ ){
		pChild = GWGetVmt(GScreen_VMT,GWGetScreen())->CreateInstance( GWGetScreen(), pProperty[i]->usType, pProperty[i], (GBaseWindow*)pSelf );
		GWGetVmt( GPanel_ManualOperation_VMT,pSelf )->AddChild( pSelf, pChild );
		((GPanel_ManualOperation*)pSelf)->m_pObjectTable[i] = pChild;
		GWGetVmt( GBaseWindow_VMT,pChild )->Create( pChild, pSelf );
	}
	if((sizeof(pFrameAnimationSet)/sizeof(GFrameAnimationSetProperty)) > 1) {
		GWGetVmt( GPanel_ManualOperation_VMT, pSelf )->SetFrameAnimationSet( pSelf, pFrameAnimationSet );
		GWGetVmt( GPanel_ManualOperation_VMT, pSelf )->SelectFrameAnimation( pSelf, 1 );
	}
	return G_TRUE;
}

int showLevel;

GInt32 GPANEL_MANUALOPERATION_BACCTLSINLINEOnCreate(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BACCTLSINLINEOnCreate)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BACCTLSINLINEOnCreate)
	double 	dX, dY;
	GInt16	nLoop;
	GWDC	*pDC;
	GBasicControl *pBasic;
	HGDRAW	hDraw;
	GRect	gRect;
	pDC = (GWDC *)GWGetVmt( GScreen_VMT, GWGetScreen() )->GetWDC( GWGetScreen() );
	hDraw = GWGetVmt( GWDC_VMT, pDC )->GetHGDRAW( pDC );
	pBasic = (GBasicControl*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BACCTLSINLINE );
	GWGetVmt(GBasicControl_VMT, pBasic)->GetBounds( pBasic, &gRect );
	GDSetClipRect( hDraw, &gRect );
	dX = NUM_DATA_2*PI/MAX_DEGREE;
	dY = MAX_SCALE/NUM_DATA_2;
	for( nLoop=0; nLoop<MAX_DEGREE; nLoop++ ){
		pSelf->gGraphPrev[nLoop].nX = nLoop + NUM_POINT_630;
		pSelf->gGraphPrev[nLoop].nY = NUM_NEGATIVE_1 + NUM_DATA_90;
		pSelf->gGraphPoint[nLoop].nX = nLoop + NUM_POINT_630;
		pSelf->gGraphPoint[nLoop].nY = (GInt16 )( SCR_HEIGHT - dY * sin(nLoop * dX) - dY ) + NUM_DATA_90;
	}
	GESetTimer( pBasic, ID_TIMER_DRAWING, NUM_TIMER_100 );
	pSelf->nCounter	= NUM_INIT_0;
	showLevel = NUM_INIT_0;
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BACCTLSINLINEOnTimer(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BACCTLSINLINEOnTimer)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BACCTLSINLINEOnTimer)
	HGDRAW	hDraw;
	GRect	gRect;
	GWDC *pDC;
	GBasicControl *pBasic;
	GInt16 nLoop;
	double dX, dY;
	
	// TCOt̕`
	pDC = (GWDC *)GWGetVmt( GScreen_VMT, GWGetScreen() )->GetWDC( GWGetScreen() );
	hDraw = GWGetVmt( GWDC_VMT, pDC )->GetHGDRAW( pDC );
	pBasic = (GBasicControl*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BACCTLSINLINE );
	GWGetVmt(GBasicControl_VMT, pBasic)->GetBounds( pBasic, &gRect );
	GDSetClipRect( hDraw, &gRect );
	GDBeginDraw( hDraw );
	GDSetPenColor( hDraw, RGB16(0x00, 0x00, 0x00));
	GDSetBackColor( hDraw, RGB16(0x00, 0x00, 0x00));
	GDDrawRect( hDraw, &gRect );
	GDSetPenColor( hDraw, RGB16(0x00, 0x80, 0x00));
	GDMoveTo( hDraw, NUM_DRAW_665, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_665, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_700, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_700, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_735, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_735, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_770, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_770, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_805, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_805, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_840, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_840, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_875, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_875, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_910, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_910, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_945, NUM_DRAW_90 );
	GDLineTo( hDraw, NUM_DRAW_945, NUM_DRAW_330 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_120 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_120 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_150 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_150 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_180 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_180 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_210 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_210 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_240 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_240 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_270 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_270 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_300 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_300 );
	GDMoveTo( hDraw, NUM_DRAW_630, NUM_DRAW_330 );
	GDLineTo( hDraw, NUM_DRAW_950, NUM_DRAW_330 );
	GDMoveTo( hDraw, pSelf->gGraphPoint[NUM_BUFF_0].nX, pSelf->gGraphPoint[NUM_BUFF_0].nY );
	GDSetPenColor( hDraw, RGB16(0xFF, 0xFF, 0x00));
	for( nLoop=0; nLoop<SCR_WIDTH; nLoop++ ){
		GDSetPixel( hDraw, pSelf->gGraphPoint[nLoop].nX, pSelf->gGraphPoint[nLoop].nY );
	}
	dX = NUM_DATA_2*PI/MAX_DEGREE;
	dY = MAX_SCALE/NUM_DATA_2;
	for( nLoop=0; nLoop<MAX_DEGREE; nLoop++ ){
		pSelf->gGraphPrev[nLoop].nY	= pSelf->gGraphPoint[nLoop].nY;
		pSelf->gGraphPoint[nLoop].nY = (GInt16 )(SCR_HEIGHT - dY * sin((nLoop-pSelf->nCounter) * dX) - dY);
	}
	pSelf->nCounter++;
	GDFlushScreen( hDraw, gRect.nXmin, gRect.nYmin, 
					(GInt16 )( gRect.nXmax - gRect.nXmin+1 ), (GInt16 )( gRect.nYmax - gRect.nYmin + 1 ));
	GDEndDraw(hDraw);
	
	// ̃foCXԂǏo
	sprintf(stGDBID[0].cObjectName,"%s","GDB_SIGNAL_STS1");
	stGDBID[0].usGDBID = ID_GDB_SIGNAL_STS1;
	stGDBID[0].sDataSize = 1;
	sprintf(stGDBID[1].cObjectName,"%s","GDB_SIGNAL_STS2");
	stGDBID[1].usGDBID = ID_GDB_SIGNAL_STS2;
	stGDBID[1].sDataSize = 1;
	sprintf(stGDBID[2].cObjectName,"%s","GDB_MACHINE_TEST2");
	stGDBID[2].usGDBID = ID_GDB_MACHINE_TEST2;
	stGDBID[2].sDataSize = 1;
	sprintf(stGDBID[3].cObjectName,"%s","GDB_PC_TEST2");
	stGDBID[3].usGDBID = ID_GDB_PC_TEST2;
	stGDBID[3].sDataSize = 1;
	DataAccessRead(stGDBID,4);
	
//	GWDBReadData( ID_GDB_SIGNAL_STS1, &gUShortDBstr, sizeof( gUShortDBstr ) );
//	updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_SIGNAL_STS1);
	
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNCARRIAGEDOWNOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGEDOWNOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGEDOWNOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNCARRIAGEDOWN, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & CARRIAGEDOWN ) == CARRIAGEDOWN){
			gUShortDBstr -= CARRIAGEDOWN;
		} else {
			gUShortDBstr += CARRIAGEDOWN;
		}
		GWDBWriteData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_PC_TEST1");
		stGDBID[0].usGDBID = ID_GDB_PC_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNCARRIAGEDOWN );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNCARRIAGELEFTOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGELEFTOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGELEFTOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNCARRIAGELEFT, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & CARRIAGELEFT) == CARRIAGELEFT){
			gUShortDBstr -= CARRIAGELEFT;
		} else {
			gUShortDBstr += CARRIAGELEFT;
		}
		GWDBWriteData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_PC_TEST1");
		stGDBID[0].usGDBID = ID_GDB_PC_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNCARRIAGELEFT );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNCARRIAGERIGHTOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGERIGHTOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGERIGHTOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNCARRIAGERIGHT, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & CARRIAGERIGHT ) == CARRIAGERIGHT){
			gUShortDBstr -= CARRIAGERIGHT;
		} else {
			gUShortDBstr += CARRIAGERIGHT;
		}
		GWDBWriteData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_PC_TEST1");
		stGDBID[0].usGDBID = ID_GDB_PC_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNCARRIAGERIGHT );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNCARRIAGESTOPOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGESTOPOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGESTOPOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNCARRIAGESTOP, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & CARRIAGESTOP ) == CARRIAGESTOP){
			gUShortDBstr -= CARRIAGESTOP;
		} else {
			gUShortDBstr += CARRIAGESTOP;
		}
		GWDBWriteData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_PC_TEST1");
		stGDBID[0].usGDBID = ID_GDB_PC_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNCARRIAGESTOP );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNCARRIAGEUPOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGEUPOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNCARRIAGEUPOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNCARRIAGEUP, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & CARRIAGEUP) == CARRIAGEUP){
			gUShortDBstr -= CARRIAGEUP;
		} else {
			gUShortDBstr += CARRIAGEUP;
		}
		GWDBWriteData( ID_GDB_PC_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_PC_TEST1");
		stGDBID[0].usGDBID = ID_GDB_PC_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNCARRIAGEUP );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNFORCEDOUTOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNFORCEDOUTOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNFORCEDOUTOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNFORCEDOUT, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & FORCEDOUT) == FORCEDOUT){
			gUShortDBstr -= FORCEDOUT;
		} else {
			gUShortDBstr += FORCEDOUT;
		}
		GWDBWriteData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_MACHINE_TEST1");
		stGDBID[0].usGDBID = ID_GDB_MACHINE_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNFORCEDOUT );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNHIRAKISEKIONEOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNHIRAKISEKIONEOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNHIRAKISEKIONEOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	
	unsigned short gUShortDBstr;
	CompareOperateTime();
	DoOperate(BTNHIRAKISEKIONE, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & HIRAKISEKIONE) == HIRAKISEKIONE){
			gUShortDBstr -= HIRAKISEKIONE;
		} else {
			gUShortDBstr += HIRAKISEKIONE;
		}
		GWDBWriteData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_MACHINE_TEST1");
		stGDBID[0].usGDBID = ID_GDB_MACHINE_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		// ǗxG[̏ꍇ̓{^OFFɖ߂
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNHIRAKISEKIONE );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNHIRAKISEKITWOOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNHIRAKISEKITWOOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNHIRAKISEKITWOOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNHIRAKISEKITWO, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & HIRAKISEKITWO ) == HIRAKISEKITWO){
			gUShortDBstr -= HIRAKISEKITWO;
		} else {
			gUShortDBstr += HIRAKISEKITWO;
		}
		GWDBWriteData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_MACHINE_TEST1");
		stGDBID[0].usGDBID = ID_GDB_MACHINE_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNHIRAKISEKITWO );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNTABLELEFTOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNTABLELEFTOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNTABLELEFTOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNTABLELEFT, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & TABLELEFT) == TABLELEFT){
			gUShortDBstr -= TABLELEFT;
		} else {
			gUShortDBstr += TABLELEFT;
		}
		GWDBWriteData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_MACHINE_TEST1");
		stGDBID[0].usGDBID = ID_GDB_MACHINE_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNTABLELEFT );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNTABLERIGHTOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNTABLERIGHTOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNTABLERIGHTOnClick)
	GButton *pButton;
	GUInt8 ucStatus;
	unsigned short gUShortDBstr;
	
	CompareOperateTime();
	DoOperate(BTNTABLERIGHT, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_1)){
		GWDBReadData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		if((gUShortDBstr & TABLERIGHT ) == TABLERIGHT){
			gUShortDBstr -= TABLERIGHT;
		} else {
			gUShortDBstr += TABLERIGHT;
		}
		GWDBWriteData( ID_GDB_MACHINE_TEST1, &gUShortDBstr, sizeof( gUShortDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_MACHINE_TEST1");
		stGDBID[0].usGDBID = ID_GDB_MACHINE_TEST1;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}else{
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BTNTABLERIGHT );
		ucStatus = GWGetVmt( GButton_VMT, pButton )->GetStatus( pButton );
		ucStatus = NUM_DATA_1 - ucStatus;
		GWGetVmt( GButton_VMT, pButton )->SetStatus( pButton, ucStatus );
	}
	return G_TRUE;
}

GInt32 GPANEL_MANUALOPERATION_BTNMANUALOPERATIONMENUOnClick(GPanel_ManualOperation *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNMANUALOPERATIONMENUOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MANUALOPERATION_BTNMANUALOPERATIONMENUOnClick)
	GBasicControl *pBasic;
	
	CompareOperateTime();
	pBasic = (GBasicControl*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, BACCTLSINLINE );
//	GEKillTimer( pBasic, ID_TIMER_DRAWING);
	DoOperate(BTNMANUALOPERATIONMENU, pSelf);
	GActScreenOpenWindow( pSelf, SHOWGWINDOW_MENU );
	return G_TRUE;
}


void GPanel_ManualOperation_OnCreate( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPanel_ManualOperation_OnCreate)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPanel_ManualOperation_OnCreate)
	unsigned short gUShortDBstr;

	// ̃foCXԂǏo
	sprintf(stGDBID[0].cObjectName,"%s","GDB_SIGNAL_STS1");
	stGDBID[0].usGDBID = ID_GDB_SIGNAL_STS1;
	stGDBID[0].sDataSize = 1;
	sprintf(stGDBID[1].cObjectName,"%s","GDB_SIGNAL_STS2");
	stGDBID[1].usGDBID = ID_GDB_SIGNAL_STS2;
	stGDBID[1].sDataSize = 1;
	sprintf(stGDBID[2].cObjectName,"%s","GDB_MACHINE_TEST2");
	stGDBID[2].usGDBID = ID_GDB_MACHINE_TEST2;
	stGDBID[2].sDataSize = 1;
	sprintf(stGDBID[3].cObjectName,"%s","GDB_PC_TEST2");
	stGDBID[3].usGDBID = ID_GDB_PC_TEST2;
	stGDBID[3].sDataSize = 1;
	DataAccessRead(stGDBID,4);
	
	GWDBReadData( ID_GDB_SIGNAL_STS1, &gUShortDBstr, sizeof( gUShortDBstr ) );
	updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_SIGNAL_STS1);
	GWDBReadData( ID_GDB_SIGNAL_STS2, &gUShortDBstr, sizeof( gUShortDBstr ) );
	updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_SIGNAL_STS2);
	GWDBReadData( ID_GDB_MACHINE_TEST2, &gUShortDBstr, sizeof( gUShortDBstr ) );
	updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_MACHINE_TEST2);
	GWDBReadData( ID_GDB_PC_TEST2, &gUShortDBstr, sizeof( gUShortDBstr ) );
	updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_PC_TEST2);
	return;
}

void GPanel_ManualOperation_OnUpdateDB( void *pSelf, void *pParam )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPanel_ManualOperation_OnUpdateDB)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPanel_ManualOperation_OnUpdateDB)
	GDBChgMgr	*pGDBChgMgr; 
	unsigned short gUShortDBstr;
	
	pGDBChgMgr = (GDBChgMgr*)pParam; 
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_SIGNAL_STS1 ) ){
		GWDBReadData( ID_GDB_SIGNAL_STS1, &gUShortDBstr, sizeof( gUShortDBstr ) );
		updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_SIGNAL_STS1);
	}
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_SIGNAL_STS2 ) ){
		GWDBReadData( ID_GDB_SIGNAL_STS2, &gUShortDBstr, sizeof( gUShortDBstr ) );
		updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_SIGNAL_STS2);
	}
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_MACHINE_TEST2 ) ){
		GWDBReadData( ID_GDB_MACHINE_TEST2, &gUShortDBstr, sizeof( gUShortDBstr ) );
		updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_MACHINE_TEST2);
	}
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_PC_TEST2 ) ){
		GWDBReadData( ID_GDB_PC_TEST2, &gUShortDBstr, sizeof( gUShortDBstr ) );
		updatePanelOnShow(pSelf, gUShortDBstr,ID_GDB_PC_TEST2);
	}
	return;
}

void updatePanelOnShow(void *pSelf, unsigned short gUShortDBstr,short sID)
{
	GPicture *pPicture;
	int i;
	
	if(sID == ID_GDB_SIGNAL_STS1){
		for(i = NUM_INIT_0; i < NUM_FLG_10; i++){
			pPicture = (GPicture*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (PCTCYCLESTOPONLIGHT - i) );
			if(((gUShortDBstr >> i) % NUM_MOD_2 ) == NUM_FLG_1){
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_1 );
			} else {
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_0 );
			}
			pPicture = (GPicture*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (PCTCYCLESTOPON + i) );
			if(((gUShortDBstr >> i) % NUM_MOD_2 ) == NUM_FLG_1){
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_1 );
			} else {
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_0 );
			}
		}
	}else if(sID == ID_GDB_SIGNAL_STS2){
		for(i = NUM_INIT_0; i< NUM_FLG_8; i++){
			pPicture = (GPicture*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (PCTCARRIAGELDIRECTIVELIGHT - i) );
			if(((gUShortDBstr >> i) % NUM_MOD_2 ) == NUM_FLG_1){
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_1 );
			} else {
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_0 );
			}
			pPicture = (GPicture*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (PCTCYCLESTOPON + i + 10) );
			if(((gUShortDBstr >> i) % NUM_MOD_2 ) == NUM_FLG_1){
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_1 );
			} else {
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_0 );
			}
		}
	}else if(sID == ID_GDB_MACHINE_TEST2){
		for(i = NUM_INIT_0; i < NUM_FLG_5; i++){
			pPicture = (GPicture*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (PCTHIRAKISEKIONELIGHT - i) );
			if(((gUShortDBstr >> i) % NUM_MOD_2 ) == NUM_FLG_1){
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_1 );
			} else {
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_0 );
			}
		}
	}else if(sID == ID_GDB_PC_TEST2){
		for(i = NUM_INIT_0; i < NUM_FLG_5; i++){
			pPicture = (GPicture*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (PCTCARRIAGERIGHTLIGHT - i) );
			if(((gUShortDBstr >> i) % NUM_MOD_2 ) == NUM_FLG_1){
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_1 );
			} else {
				GWGetVmt( GPicture_VMT, pPicture )->SetStatus( pPicture, NUM_STATUS_0 );
			}
		}
	}
}
