#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "GPanel_Monitor.h"
#include "gbasiccontrol.h"
#include "gbutton.h"
#include "gcheckbox.h"
#include "glabel.h"
#include "glist.h"
#include "gpicture.h"
#include "gprogressbar.h"
#include "gradiobutton.h"
#include "gtextbox.h"
#include "gtextboxex.h"
#include "gscrollbarex.h"
#include "ggrid.h"
#include "gstatictext.h"
#include "gnumbmp.h"
#include "GC_GUIScreen.h"
#include "gevent.h"
#include "GResource.h"
#include "GControlID.h"
#include "gcachetext.h"
#include "GScript.h"
#include "GDBObject.h"
#include "gsvframe.h"
#include "gdispsubpnl.h"
#include "GPanel_Monitor.prc"

#include "Common.h"
#include "dataaccessapi.h"

extern DATAACCESSGDBID stGDBID[];

#define		INSPECTION		(0x0001)
#define		POSITIONING		(0x0002)
#define		MARKING			(0x0004)
#define		INPUT_CODE_1	(0x0001)

//{{FUNCTION_TABLE_TABLE
static const GPanel_Monitor_VMT vmt=
{
//{{FUNCTION_TABLE_FUNCTION
	GPanel_Monitor_MessageProcedure,
	GPanel_Monitor_CallBackMessageProcedure,
	GPanel_Monitor_GetType,
	GPanel_Monitor_GetID,
	GPanel_Monitor_GetXPosition,
	GPanel_Monitor_GetYPosition,
	GPanel_Monitor_GetPosition,
	GPanel_Monitor_GetWidth,
	GPanel_Monitor_GetHeight,
	GPanel_Monitor_GetSize,
	GPanel_Monitor_SetBounds,
	GPanel_Monitor_GetBounds,
	GPanel_Monitor_CalcClientRect,
	GPanel_Monitor_GetClientRect,
	GPanel_Monitor_ClientToScreen,
	GPanel_Monitor_GetStyle,
	GPanel_Monitor_SetVisibleStatus,
	GPanel_Monitor_GetVisibleStatus,
	GPanel_Monitor_SetEnableStatus,
	GPanel_Monitor_GetEnableStatus,
	GPanel_Monitor_SetConsumableStatus,
	GPanel_Monitor_GetConsumableStatus,
	GPanel_Monitor_SetCaptionStatus,
	GPanel_Monitor_GetCaptionStatus,
	GPanel_Monitor_SetFocusStatus,
	GPanel_Monitor_GetFocusStatus,
	GPanel_Monitor_SetStyleStatus,
	GPanel_Monitor_GetStyleStatus,
	GPanel_Monitor_SetParent,
	GPanel_Monitor_GetParent,
	GPanel_Monitor_SetFocusInformation,
	GPanel_Monitor_GetFocusInformation,
	GPanel_Monitor_Create,
	GPanel_Monitor_Delete,
	GPanel_Monitor_ImportProperty,
	GPanel_Monitor_ExportProperty,
	GPanel_Monitor_Paint,
	GPanel_Monitor_OnDraw,
	GPanel_Monitor_OnNcDraw,
	GPanel_Monitor_AddRefreshRect,
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GPanel_Monitor_MouseMove,
	GPanel_Monitor_OnMouseMove,
	GPanel_Monitor_OnNcMouseMove,
#endif /* _ENABLE_MOUSEMOVE_ */
	GPanel_Monitor_LButtonPress,
	GPanel_Monitor_OnLButtonPress,
	GPanel_Monitor_OnNcLButtonPress,
	GPanel_Monitor_LButtonRelease,
	GPanel_Monitor_OnLButtonRelease,
	GPanel_Monitor_OnNcLButtonRelease,
#ifdef _ENABLE_RBUTTON_
	GPanel_Monitor_RButtonPress,
	GPanel_Monitor_OnRButtonPress,
	GPanel_Monitor_OnNcRButtonPress,
	GPanel_Monitor_RButtonRelease,
	GPanel_Monitor_OnRButtonRelease,
	GPanel_Monitor_OnNcRButtonRelease,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GPanel_Monitor_KeyPress,
	GPanel_Monitor_KeyRelease,
	GPanel_Monitor_SetFocus,
	GPanel_Monitor_KillFocus,
	GPanel_Monitor_Timer,
	GPanel_Monitor_User,
	GPanel_Monitor_Char,
	GPanel_Monitor_Close,
	GPanel_Monitor_DeleteChild,
	GPanel_Monitor_SetMemorySpace,
	GPanel_Monitor_GetMemorySpace,
	GPanel_Monitor_SetDrawForceStatus,
	GPanel_Monitor_GetDrawForceStatus,
	GPanel_Monitor_SetRedrawStatus,
	GPanel_Monitor_GetRedrawStatus,
	GPanel_Monitor_ClearDrawStatus,
	GPanel_Monitor_AddDirtyRect,
	GPanel_Monitor_SetPrevTimerObject,
	GPanel_Monitor_GetPrevTimerObject,
	GPanel_Monitor_SetNextTimerObject,
	GPanel_Monitor_GetNextTimerObject,
#ifndef	_DISABLE_GLAYER_
	GPanel_Monitor_AddDirtyRectLayer,
	GPanel_Monitor_SetDrawForceStatusLayer,
	GPanel_Monitor_GetDrawForceStatusLayer,
	GPanel_Monitor_SetRedrawStatusLayer,
	GPanel_Monitor_GetRedrawStatusLayer,
	GPanel_Monitor_SetLayerID,
	GPanel_Monitor_GetLayerID,
#endif/*_DISABLE_GLAYER_*/
	GPanel_Monitor_HoldImageData,
	GPanel_Monitor_GetImageData,
	GPanel_Monitor_CleanImageData,
	GPanel_Monitor_Active,
	GPanel_Monitor_OnActive,
	GPanel_Monitor_SetActiveStatus,
	GPanel_Monitor_GetActiveStatus,

	GPanel_Monitor_OnCreate,
	GPanel_Monitor_PreDelete,
	GPanel_Monitor_PreKeyPress,
	GPanel_Monitor_PreKeyRelease,
	GPanel_Monitor_OnUser,
	GPanel_Monitor_PrePress,
	GPanel_Monitor_PreRelease,
	GPanel_Monitor_PrePaint,
	GPanel_Monitor_OnTimer,
#if		(_USE_MULTI_COORDINATE_ != 0)
	GPanel_Monitor_SetActiveCoordinate,
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GPanel_Monitor_OnUpdateDB,
	GPanel_Monitor_IsMousePointInBounds,

	GPanel_Monitor_SetBackGroundDesign,
	GPanel_Monitor_GetBackGroundDesign,
	GPanel_Monitor_CreateChildren,
	GPanel_Monitor_AddChild,
	GPanel_Monitor_DeleteAllChildren,
	GPanel_Monitor_GetChild,
	GPanel_Monitor_GetChildList,
	GPanel_Monitor_DrawChildren,
	GPanel_Monitor_DrawBackGround,
	GPanel_Monitor_SetActiveChild,
	GPanel_Monitor_GetActiveChild,
	GPanel_Monitor_EndModal,
	GPanel_Monitor_AddBlinkControl,
	GPanel_Monitor_RemoveBlinkControl,
	GPanel_Monitor_AddScrollControl,
	GPanel_Monitor_RemoveScrollControl,
	GPanel_Monitor_SetPictureData,
	GPanel_Monitor_GetPictureData,
	GPanel_Monitor_GetPositionChild,
	GPanel_Monitor_SetNoResponseBaseArea,
	GPanel_Monitor_GetNoResponseBaseArea,
	GPanel_Monitor_SetReleaseType,
	GPanel_Monitor_GetReleaseType,
	GPanel_Monitor_GetChildAt,
	GPanel_Monitor_OnShowPage,
	GPanel_Monitor_OnHidePage,
	GPanel_Monitor_MoveChildListFirst,
	GPanel_Monitor_MoveChildListLast,
	GPanel_Monitor_MoveChildListPrev,
	GPanel_Monitor_MoveChildListNext,
	GPanel_Monitor_MoveChildList,
	GPanel_Monitor_GetChildIndex,
	GPanel_Monitor_GetPrevChild,
	GPanel_Monitor_GetNextChild,
#ifndef	_DISABLE_GLAYER_
	GPanel_Monitor_GetChildCount,
	GPanel_Monitor_GetFirstChildInLayer,
	GPanel_Monitor_GetLastChildInLayer,
	GPanel_Monitor_GetChildInLayer,
#endif/*_DISABLE_GLAYER_*/
	GPanel_Monitor_AddFrameAnimation,
	GPanel_Monitor_RemoveFrameAnimation,
	GPanel_Monitor_StartAutoPlayFrameAnimation,
	GPanel_Monitor_StartFrameAnimation,
	GPanel_Monitor_ResetFrameAnimation,
	GPanel_Monitor_StopFrameAnimation,
	GPanel_Monitor_ResumeFrameAnimation,
	GPanel_Monitor_FindFrameAnimation,
	GPanel_Monitor_SetFrameAnimationSet,
	GPanel_Monitor_SelectFrameAnimation,
	GPanel_Monitor_SetAsyncAnimationStatus,
	GPanel_Monitor_GetAsyncAnimationStatus,
	GPanel_Monitor_StartAsyncFrameAnimation,
	GPanel_Monitor_ResetAsyncFrameAnimation,
	GPanel_Monitor_StopAsyncFrameAnimation,
	GPanel_Monitor_ResumeAsyncFrameAnimation,
	GPanel_Monitor_RestartAsyncFrameAnimation
//}}FUNCTION_TABLE_FUNCTION
};
//}}FUNCTION_TABLE_TABLE

static void updatePanelErrorButton(void *pSelf, unsigned short gUShortDBstr);
static void updatePanelDeviceButton(void *pSelf, unsigned short gUShortDBstr);

const GPanel_Monitor_VMT *GWGetGPanel_MonitorVMT( void )
{
	return &vmt;
}
/*
 *	<summary>		:	IuWFNgB
 *
 *	<parameter>		:	Ȃ
 *
 *	<return>		:	NULL:		s
 *						NULLȊO:	IuWFNgւ̃|C^
 *
 *	<Explanation>	:	GPanel_MonitorIuWFNg̃mۂA{B
 */
GPanel_Monitor* GWNewGPanel_Monitor( void )
{
	GUInt8 ucType,ucPlane;
	GPanel_Monitor *pNewObject;

	GWGetVmt( GScreen_VMT, GWGetScreen() )->GetMemorySpace( GWGetScreen(), &ucType, &ucPlane );
	pNewObject = (GPanel_Monitor*)GMMemoryAlloc( ucType, ucPlane, sizeof(GPanel_Monitor));
	if( pNewObject == NULL ){
		return NULL;
	}

	memset( pNewObject, 0, sizeof(GPanel_Monitor) );
	GWInitGPanel_Monitor( pNewObject );
	
	return pNewObject;
}

/*
 *	<summary>		:	B
 *
 *	<parameter>		:	(i)GPanel_Monitor* pSelf;	sIuWFNg
 *
 *	<return>		:	G_FALSE:	s
 *						G_TRUE:	
 *
 *	<Explanation>	:	GPanel_MonitorIuWFNg̏sB
 *						֐\(VMT)IuWFNgɊ֘AtB
 */
GInt16 GWInitGPanel_Monitor( GPanel_Monitor* pSelf )
{
	if(pSelf == NULL){
		return G_FALSE;
	}

	GWInitGFrameAnimationPanel( (GFrameAnimationPanel*)pSelf );
	((GObject*)pSelf)->vmt = (const GObject_VMT*)&vmt;

	return G_TRUE;
}

/*
 *	<summary>		:	CxgbZ[WvV[WB
 *
 *	<parameter>		:	(i)GBaseWindow* pSelf;	IuWFNg
 *						(i)GUInt16 usMessage;	CxgbZ[W
 *						(i)GLParam lLParam;		t񉺈
 *						(i)GUParam lUParam;		t
 *
 *	<return>		:	-1:		ΉCxg݂ȂB
 *						0ȏ:	CxgɈˑ
 *
 *	<description>	:	CxgbZ[WɑΉ֐̌ĂяosB
 *						
 */
GClassMP( GPanel_Monitor )
//{{MESSAGEPROCEDURE
//}}MESSAGEPROCEDURE
GInheritMP( GFrameAnimationPanel )


/*
 *	<summary>		:	qIuWFNǧ
 *
 *	<parameter>		:	(i)void *pSelf;		:IuWFNg
 *						(i)GUInt16 usIdx;	:qIuWFNg̃CfbNX
 *
 *	<return>		:	CfbNX͈͓	IuWFNgւ̃|C^
 *	 					CfbNX͈͊O	NULL
 *
 *	<description>	:	wIDGPanel̎qIuWFNgB
 *
 *	<exception>		:	w̃CfbNXlGCPanel̎qIuWFNgԂB
 *
 */
GBaseWindow* GPanel_Monitor_GetChildAt( void *pSelf, GUInt16 usIdx )
{
	if( (sizeof(pProperty)/sizeof(GBaseWindowProperty*)) > usIdx ){
		return ((GPanel_Monitor*)pSelf)->m_pObjectTable[usIdx];
	}else{
		return NULL;
	}
}

/*
 *	<summary>		:	qIuWFNg
 *
 *	<parameter>		:	(i)GPanel_Monitor *pSelf;		:IuWFNg
 *
 *	<return>		:	Ȃ
 *
 *	<description>	:	qIuWFNg{B
 */
GInt16 GPanel_Monitor_CreateChildren( void *pSelf )
{
	GBaseWindow *pChild;
	GUInt32 i;

	for( i = 1; i < (sizeof(pProperty)/sizeof(GBaseWindowProperty*)); i++ ){
		pChild = GWGetVmt(GScreen_VMT,GWGetScreen())->CreateInstance( GWGetScreen(), pProperty[i]->usType, pProperty[i], (GBaseWindow*)pSelf );
		GWGetVmt( GPanel_Monitor_VMT,pSelf )->AddChild( pSelf, pChild );
		((GPanel_Monitor*)pSelf)->m_pObjectTable[i] = pChild;
		GWGetVmt( GBaseWindow_VMT,pChild )->Create( pChild, pSelf );
	}
	if((sizeof(pFrameAnimationSet)/sizeof(GFrameAnimationSetProperty)) > 1) {
		GWGetVmt( GPanel_Monitor_VMT, pSelf )->SetFrameAnimationSet( pSelf, pFrameAnimationSet );
		GWGetVmt( GPanel_Monitor_VMT, pSelf )->SelectFrameAnimation( pSelf, 1 );
	}
	return G_TRUE;
}


GInt32 GPANEL_MONITOR_BTNMONITORMENUOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNMONITORMENUOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNMONITORMENUOnClick)
	CompareOperateTime();
	DoOperate(BTNMONITORMENU, pSelf);
	GActScreenOpenWindow( pSelf, SHOWGWINDOW_MENU );
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNINSPECTIONAUTOOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNINSPECTIONAUTOOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNINSPECTIONAUTOOnClick)
	unsigned short gUCharDBstr;
	
	CompareOperateTime();
	DoOperate(BTNINSPECTIONAUTO, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_2)){
		GWDBReadData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ) );
		if((gUCharDBstr % NUM_MOD_2 ) == NUM_FLG_1){
			gUCharDBstr -= INSPECTION;
		}
		GWDBWriteData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_DEVICE_TYPE");
		stGDBID[0].usGDBID = ID_GDB_DEVICE_TYPE;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNINSPECTIONMANUALOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNINSPECTIONMANUALOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNINSPECTIONMANUALOnClick)
	unsigned short gUCharDBstr;
	
	CompareOperateTime();
	DoOperate(BTNINSPECTIONMANUAL, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_2)){
		GWDBReadData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ) );
		if((gUCharDBstr % NUM_MOD_2 ) == NUM_FLG_0){
			gUCharDBstr += INSPECTION;
		}
		GWDBWriteData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_DEVICE_TYPE");
		stGDBID[0].usGDBID = ID_GDB_DEVICE_TYPE;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNPOSITIONINGAUTOOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNPOSITIONINGAUTOOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNPOSITIONINGAUTOOnClick)
	unsigned short gUCharDBstr;
	
	CompareOperateTime();
	DoOperate(BTNPOSITIONINGAUTO, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_2)){
		GWDBReadData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ) );
		if(((gUCharDBstr >> NUM_MOVE_1) % NUM_MOD_2 ) == NUM_FLG_1){
			gUCharDBstr -= POSITIONING;
		}
		GWDBWriteData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_DEVICE_TYPE");
		stGDBID[0].usGDBID = ID_GDB_DEVICE_TYPE;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNPOSITIONINGMANUALOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNPOSITIONINGMANUALOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNPOSITIONINGMANUALOnClick)
	unsigned short gUCharDBstr;
	
	CompareOperateTime();
	DoOperate(BTNPOSITIONINGMANUAL, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_2)){
		GWDBReadData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ) );
		if(((gUCharDBstr >> NUM_MOVE_1) % NUM_MOD_2 ) == NUM_FLG_0){
			gUCharDBstr += POSITIONING;
		}
		GWDBWriteData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_DEVICE_TYPE");
		stGDBID[0].usGDBID = ID_GDB_DEVICE_TYPE;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNMARKINGAUTOOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNMARKINGAUTOOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNMARKINGAUTOOnClick)
	unsigned short gUCharDBstr;
	
	CompareOperateTime();
	DoOperate(BTNMARKINGAUTO, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_2)){
		GWDBReadData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ) );
		if(((gUCharDBstr >> NUM_MOVE_2) % NUM_MOD_2 ) == NUM_FLG_1){
			gUCharDBstr -= MARKING;
		}
		GWDBWriteData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_DEVICE_TYPE");
		stGDBID[0].usGDBID = ID_GDB_DEVICE_TYPE;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNMARKINGMANUALOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNMARKINGMANUALOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNMARKINGMANUALOnClick)
	unsigned short gUCharDBstr;
	
	CompareOperateTime();
	DoOperate(BTNMARKINGMANUAL, pSelf);
	if(G_TRUE == CheckOperateLevel(pSelf, Lebel_2))
	{
		GWDBReadData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ) );
		if(((gUCharDBstr >> NUM_MOVE_2) % NUM_MOD_2 ) == NUM_FLG_0)
		{
			gUCharDBstr += MARKING;
		}
		GWDBWriteData( ID_GDB_DEVICE_TYPE, &gUCharDBstr, sizeof( gUCharDBstr ), G_TRUE );
		sprintf(stGDBID[0].cObjectName,"%s","GDB_DEVICE_TYPE");
		stGDBID[0].usGDBID = ID_GDB_DEVICE_TYPE;
		stGDBID[0].sDataSize = 1;
		DataAccessWrite(stGDBID,1);
	}
	return G_TRUE;
}
#if 0
GInt32 GPANEL_MONITOR_BTNALARMRELEASEOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNALARMRELEASEOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNALARMRELEASEOnClick)
	unsigned short gdbAlarmRelease;
	
	CompareOperateTime();
	DoOperate(BTNALARMRELEASE, pSelf);
	gdbAlarmRelease = SIGNAL_ON;
	GWDBWriteData( ID_GDB_WARNING_CLEAR, &gdbAlarmRelease, sizeof( gdbAlarmRelease ), G_TRUE );
	gdbAlarmRelease = 0;
	GWDBWriteData( ID_GDB_ERR_DEVICE_TYPE, &gdbAlarmRelease, sizeof( gdbAlarmRelease ), G_TRUE );
	sprintf(stGDBID[0].cObjectName,"%s","GDB_WARNING_CLEAR");
	stGDBID[0].usGDBID = ID_GDB_WARNING_CLEAR;
	stGDBID[0].sDataSize = 1;
	sprintf(stGDBID[1].cObjectName,"%s","GDB_ERR_DEVICE_TYPE");
	stGDBID[1].usGDBID = ID_GDB_ERR_DEVICE_TYPE;
	stGDBID[1].sDataSize = 1;
	DataAccessWrite(stGDBID,2);
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNBUZZERRELEASEOnClick(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNBUZZERRELEASEOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNBUZZERRELEASEOnClick)
	unsigned short gdbBuzzerClear;
	
	CompareOperateTime();
	DoOperate(BTNBUZZERRELEASE, pSelf);
	gdbBuzzerClear = SIGNAL_ON;
	GWDBWriteData( ID_GDB_BUZZER_CLEAR, &gdbBuzzerClear, sizeof( gdbBuzzerClear ), G_TRUE );
	sprintf(stGDBID[0].cObjectName,"%s","GDB_BUZZER_CLEAR");
	stGDBID[0].usGDBID = ID_GDB_BUZZER_CLEAR;
	stGDBID[0].sDataSize = 1;
	DataAccessWrite(stGDBID,1);
	return G_TRUE;
}
#endif

void GPanel_Monitor_OnCreate( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPanel_Monitor_OnCreate)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPanel_Monitor_OnCreate)
	GInt16 nResult; /**/
	unsigned short gUShortDBstr;
	
	GWDBReadData( ID_GDB_ERR_DEVICE_TYPE, &gUShortDBstr, sizeof( gUShortDBstr ) );
	updatePanelErrorButton(pSelf, gUShortDBstr);
	GWDBReadData( ID_GDB_DEVICE_TYPE, &gUShortDBstr, sizeof( gUShortDBstr ) );
	updatePanelDeviceButton(pSelf, gUShortDBstr);
	/*t[Aj[VĐ*/
	nResult = GWGetVmt( GFrameAnimationPanel_VMT, pSelf )->StartFrameAnimation( pSelf );
	GESetTimer(pSelf, 10, 1000);
	return;
}

void GPanel_Monitor_OnUpdateDB( void *pSelf, void *pParam )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPanel_Monitor_OnUpdateDB)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPanel_Monitor_OnUpdateDB)
	GDBChgMgr	*pGDBChgMgr;
	unsigned short gUShortDBstr;
	pGDBChgMgr = (GDBChgMgr*)pParam;
	
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_ERR_DEVICE_TYPE ) ){
		GWDBReadData( ID_GDB_ERR_DEVICE_TYPE, &gUShortDBstr, sizeof( gUShortDBstr ) );
		updatePanelErrorButton(pSelf, gUShortDBstr);
	}
	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_DEVICE_TYPE ) ){
		GWDBReadData( ID_GDB_DEVICE_TYPE, &gUShortDBstr, sizeof( gUShortDBstr ) );
		updatePanelDeviceButton(pSelf, gUShortDBstr);
	}
//	if( GDBChgMgr_IsChangeData( pGDBChgMgr, ID_GDB_CHECK_RESULT ) ){
//		GWDBReadData( ID_GDB_CHECK_RESULT, &gUShortDBstr, sizeof( gUShortDBstr ) );
//	}
	return;
}

void updatePanelErrorButton(void *pSelf, unsigned short gUShortDBstr)
{
	GButton *pButton;
	GDesign *pDesign;
	int i;
	for(i = NUM_INIT_0; i< NUM_FLG_10; i++){
		pButton = (GButton*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (BTNMONITORSENSOR1ABNORMALITY + i) );
		pDesign = GWGetVmt(GButton_VMT, pButton )->GetOffDesign( pButton );
		if(((gUShortDBstr >> i ) % NUM_MOD_2 ) == SIGNAL_ON){
			/*ُ픭*/
			pDesign->gbBrush.gcBackColor = RGB16( 0xFF, 0xFF, 0x00 );
			pDesign->gbBrush.gcForeColor = RGB16( 0xFF, 0xFF, 0x00 );
		} else {
			pDesign->gbBrush.gcBackColor = RGB16( 0xC0, 0xC0, 0xC0 );
			pDesign->gbBrush.gcForeColor = RGB16( 0xC0, 0xC0, 0xC0 );
		}
		GWGetVmt( GButton_VMT, pButton )->SetOffDesign( pButton, pDesign );
	}
	pDesign = GWGetVmt(GButton_VMT, pButton )->GetOffDesign( pButton );
}

void updatePanelDeviceButton(void *pSelf, unsigned short gUShortDBstr)
{
	GStaticText *pSText;
	int i;
	for(i = NUM_INIT_0; i < NUM_FLG_3; i++){
		pSText = (GStaticText *)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, (SEXTINSPECTIONSHOWCHANGE + i) );
		if(((gUShortDBstr >> i ) % NUM_MOD_2 ) == DEVICE_TYPE_MT){
			/*蓮*/
			GWGetVmt( GStaticText_VMT, pSText )->SetStringID( pSText, ID_STRING_MonitorManual );
			GWGetVmt( GStaticText_VMT, pSText )->SetBackColor( pSText, RGB16( 0xFF, 0xFF, 0x80 ) );
		} else {
			/**/
			GWGetVmt( GStaticText_VMT, pSText )->SetStringID( pSText, ID_STRING_MonitorAuto );
			GWGetVmt( GStaticText_VMT, pSText )->SetBackColor( pSText, RGB16( 0x00, 0xFF, 0x80 ) );
		}
	}
}

void GPanel_Monitor_OnTimer( void *pSelf, GUInt16 usTimerID )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPanel_Monitor_OnTimer)
	sprintf(stGDBID[0].cObjectName,"%s","GDB_ERR_DEVICE_TYPE");
	stGDBID[0].usGDBID = ID_GDB_ERR_DEVICE_TYPE;
	stGDBID[0].sDataSize = 1;
	sprintf(stGDBID[1].cObjectName,"%s","GDB_DEVICE_TYPE");
	stGDBID[1].usGDBID = ID_GDB_DEVICE_TYPE;
	stGDBID[1].sDataSize = 1;
	sprintf(stGDBID[2].cObjectName,"%s","GDB_WARNING_CLEAR");
	stGDBID[2].usGDBID = ID_GDB_WARNING_CLEAR;
	stGDBID[2].sDataSize = 1;
	sprintf(stGDBID[3].cObjectName,"%s","GDB_BUZZER_CLEAR");
	stGDBID[3].usGDBID = ID_GDB_BUZZER_CLEAR;
	stGDBID[3].sDataSize = 1;
	DataAccessRead(stGDBID,4);
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPanel_Monitor_OnTimer)
	return;
}

GInt32 GPANEL_MONITOR_BTNALARMRELEASEOnRelease(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNALARMRELEASEOnRelease)
	unsigned short gdbAlarmRelease;
	
	gdbAlarmRelease = SIGNAL_OFF;
	GWDBWriteData( ID_GDB_WARNING_CLEAR, &gdbAlarmRelease, sizeof( gdbAlarmRelease ), G_TRUE );
	sprintf(stGDBID[0].cObjectName,"%s","GDB_WARNING_CLEAR");
	stGDBID[0].usGDBID = ID_GDB_WARNING_CLEAR;
	stGDBID[0].sDataSize = 1;
	DataAccessWrite(stGDBID,1);
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNALARMRELEASEOnRelease)
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNBUZZERRELEASEOnRelease(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNBUZZERRELEASEOnRelease)
	unsigned short gdbBuzzerClear;
	
	gdbBuzzerClear = SIGNAL_OFF;
	GWDBWriteData( ID_GDB_BUZZER_CLEAR, &gdbBuzzerClear, sizeof( gdbBuzzerClear ), G_TRUE );
	sprintf(stGDBID[0].cObjectName,"%s","GDB_BUZZER_CLEAR");
	stGDBID[0].usGDBID = ID_GDB_BUZZER_CLEAR;
	stGDBID[0].sDataSize = 1;
	DataAccessWrite(stGDBID,1);
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNBUZZERRELEASEOnRelease)
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNALARMRELEASEOnPress(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNALARMRELEASEOnPress)
	unsigned short gdbAlarmRelease;
	
	CompareOperateTime();
	DoOperate(BTNALARMRELEASE, pSelf);
	gdbAlarmRelease = SIGNAL_ON;
	GWDBWriteData( ID_GDB_WARNING_CLEAR, &gdbAlarmRelease, sizeof( gdbAlarmRelease ), G_TRUE );
	gdbAlarmRelease = 0;
	GWDBWriteData( ID_GDB_ERR_DEVICE_TYPE, &gdbAlarmRelease, sizeof( gdbAlarmRelease ), G_TRUE );
	sprintf(stGDBID[0].cObjectName,"%s","GDB_WARNING_CLEAR");
	stGDBID[0].usGDBID = ID_GDB_WARNING_CLEAR;
	stGDBID[0].sDataSize = 1;
	sprintf(stGDBID[1].cObjectName,"%s","GDB_ERR_DEVICE_TYPE");
	stGDBID[1].usGDBID = ID_GDB_ERR_DEVICE_TYPE;
	stGDBID[1].sDataSize = 1;
	DataAccessWrite(stGDBID,2);
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNALARMRELEASEOnPress)
	return G_TRUE;
}

GInt32 GPANEL_MONITOR_BTNBUZZERRELEASEOnPress(GPanel_Monitor *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNBUZZERRELEASEOnPress)
	unsigned short gdbBuzzerClear;
	
	CompareOperateTime();
	DoOperate(BTNBUZZERRELEASE, pSelf);
	gdbBuzzerClear = SIGNAL_ON;
	GWDBWriteData( ID_GDB_BUZZER_CLEAR, &gdbBuzzerClear, sizeof( gdbBuzzerClear ), G_TRUE );
	sprintf(stGDBID[0].cObjectName,"%s","GDB_BUZZER_CLEAR");
	stGDBID[0].usGDBID = ID_GDB_BUZZER_CLEAR;
	stGDBID[0].sDataSize = 1;
	DataAccessWrite(stGDBID,1);
	//}}_GUI_SCRIPT_FUNCTION_CALL(GPANEL_MONITOR_BTNBUZZERRELEASEOnPress)
	return G_TRUE;
}
