#include <stdlib.h>
#include <string.h>
#include "GWindow_Menu.h"
#include "gbasiccontrol.h"
#include "gbutton.h"
#include "gcheckbox.h"
#include "glabel.h"
#include "glist.h"
#include "gpicture.h"
#include "gprogressbar.h"
#include "gradiobutton.h"
#include "gtextbox.h"
#include "gtextboxex.h"
#include "gscrollbarex.h"
#include "ggrid.h"
#include "gstatictext.h"
#include "gnumbmp.h"
#include "GC_GUIScreen.h"
#include "gevent.h"
#include "GResource.h"
#include "GControlID.h"
#include "gcachetext.h"
#include "GScript.h"
#include "GDBObject.h"
#include "gsvframe.h"
#include "gdispsubpnl.h"
#include "GWindow_Menu.prc"
//#include "GFileIO.h"
#include "Common.h"

//{{FUNCTION_TABLE_TABLE
static const GWindow_Menu_VMT vmt=
{
//{{FUNCTION_TABLE_FUNCTION
	GWindow_Menu_MessageProcedure,
	GWindow_Menu_CallBackMessageProcedure,
	GWindow_Menu_GetType,
	GWindow_Menu_GetID,
	GWindow_Menu_GetXPosition,
	GWindow_Menu_GetYPosition,
	GWindow_Menu_GetPosition,
	GWindow_Menu_GetWidth,
	GWindow_Menu_GetHeight,
	GWindow_Menu_GetSize,
	GWindow_Menu_SetBounds,
	GWindow_Menu_GetBounds,
	GWindow_Menu_CalcClientRect,
	GWindow_Menu_GetClientRect,
	GWindow_Menu_ClientToScreen,
	GWindow_Menu_GetStyle,
	GWindow_Menu_SetVisibleStatus,
	GWindow_Menu_GetVisibleStatus,
	GWindow_Menu_SetEnableStatus,
	GWindow_Menu_GetEnableStatus,
	GWindow_Menu_SetConsumableStatus,
	GWindow_Menu_GetConsumableStatus,
	GWindow_Menu_SetCaptionStatus,
	GWindow_Menu_GetCaptionStatus,
	GWindow_Menu_SetFocusStatus,
	GWindow_Menu_GetFocusStatus,
	GWindow_Menu_SetStyleStatus,
	GWindow_Menu_GetStyleStatus,
	GWindow_Menu_SetParent,
	GWindow_Menu_GetParent,
	GWindow_Menu_SetFocusInformation,
	GWindow_Menu_GetFocusInformation,
	GWindow_Menu_Create,
	GWindow_Menu_Delete,
	GWindow_Menu_ImportProperty,
	GWindow_Menu_ExportProperty,
	GWindow_Menu_Paint,
	GWindow_Menu_OnDraw,
	GWindow_Menu_OnNcDraw,
	GWindow_Menu_AddRefreshRect,
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GWindow_Menu_MouseMove,
	GWindow_Menu_OnMouseMove,
	GWindow_Menu_OnNcMouseMove,
#endif /* _ENABLE_MOUSEMOVE_ */
	GWindow_Menu_LButtonPress,
	GWindow_Menu_OnLButtonPress,
	GWindow_Menu_OnNcLButtonPress,
	GWindow_Menu_LButtonRelease,
	GWindow_Menu_OnLButtonRelease,
	GWindow_Menu_OnNcLButtonRelease,
#ifdef _ENABLE_RBUTTON_
	GWindow_Menu_RButtonPress,
	GWindow_Menu_OnRButtonPress,
	GWindow_Menu_OnNcRButtonPress,
	GWindow_Menu_RButtonRelease,
	GWindow_Menu_OnRButtonRelease,
	GWindow_Menu_OnNcRButtonRelease,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GWindow_Menu_KeyPress,
	GWindow_Menu_KeyRelease,
	GWindow_Menu_SetFocus,
	GWindow_Menu_KillFocus,
	GWindow_Menu_Timer,
	GWindow_Menu_User,
	GWindow_Menu_Char,
	GWindow_Menu_Close,
	GWindow_Menu_DeleteChild,
	GWindow_Menu_SetMemorySpace,
	GWindow_Menu_GetMemorySpace,
	GWindow_Menu_SetDrawForceStatus,
	GWindow_Menu_GetDrawForceStatus,
	GWindow_Menu_SetRedrawStatus,
	GWindow_Menu_GetRedrawStatus,
	GWindow_Menu_ClearDrawStatus,
	GWindow_Menu_AddDirtyRect,
	GWindow_Menu_SetPrevTimerObject,
	GWindow_Menu_GetPrevTimerObject,
	GWindow_Menu_SetNextTimerObject,
	GWindow_Menu_GetNextTimerObject,
#ifndef	_DISABLE_GLAYER_
	GWindow_Menu_AddDirtyRectLayer,
	GWindow_Menu_SetDrawForceStatusLayer,
	GWindow_Menu_GetDrawForceStatusLayer,
	GWindow_Menu_SetRedrawStatusLayer,
	GWindow_Menu_GetRedrawStatusLayer,
	GWindow_Menu_SetLayerID,
	GWindow_Menu_GetLayerID,
#endif/*_DISABLE_GLAYER_*/
	GWindow_Menu_HoldImageData,
	GWindow_Menu_GetImageData,
	GWindow_Menu_CleanImageData,
	GWindow_Menu_Active,
	GWindow_Menu_OnActive,
	GWindow_Menu_SetActiveStatus,
	GWindow_Menu_GetActiveStatus,

	GWindow_Menu_OnCreate,
	GWindow_Menu_PreDelete,
	GWindow_Menu_PreKeyPress,
	GWindow_Menu_PreKeyRelease,
	GWindow_Menu_OnUser,
	GWindow_Menu_PrePress,
	GWindow_Menu_PreRelease,
	GWindow_Menu_PrePaint,
	GWindow_Menu_OnTimer,
#if		(_USE_MULTI_COORDINATE_ != 0)
	GWindow_Menu_SetActiveCoordinate,
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GWindow_Menu_OnUpdateDB,
	GWindow_Menu_IsMousePointInBounds,

	GWindow_Menu_SetBackGroundDesign,
	GWindow_Menu_GetBackGroundDesign,
	GWindow_Menu_CreateChildren,
	GWindow_Menu_AddChild,
	GWindow_Menu_DeleteAllChildren,
	GWindow_Menu_GetChild,
	GWindow_Menu_GetChildList,
	GWindow_Menu_DrawChildren,
	GWindow_Menu_DrawBackGround,
	GWindow_Menu_SetActiveChild,
	GWindow_Menu_GetActiveChild,
	GWindow_Menu_EndModal,
	GWindow_Menu_AddBlinkControl,
	GWindow_Menu_RemoveBlinkControl,
	GWindow_Menu_AddScrollControl,
	GWindow_Menu_RemoveScrollControl,
	GWindow_Menu_SetPictureData,
	GWindow_Menu_GetPictureData,
	GWindow_Menu_GetPositionChild,
	GWindow_Menu_SetNoResponseBaseArea,
	GWindow_Menu_GetNoResponseBaseArea,
	GWindow_Menu_SetReleaseType,
	GWindow_Menu_GetReleaseType,
	GWindow_Menu_GetChildAt,
	GWindow_Menu_OnShowPage,
	GWindow_Menu_OnHidePage,
	GWindow_Menu_MoveChildListFirst,
	GWindow_Menu_MoveChildListLast,
	GWindow_Menu_MoveChildListPrev,
	GWindow_Menu_MoveChildListNext,
	GWindow_Menu_MoveChildList,
	GWindow_Menu_GetChildIndex,
	GWindow_Menu_GetPrevChild,
	GWindow_Menu_GetNextChild,
#ifndef	_DISABLE_GLAYER_
	GWindow_Menu_GetChildCount,
	GWindow_Menu_GetFirstChildInLayer,
	GWindow_Menu_GetLastChildInLayer,
	GWindow_Menu_GetChildInLayer,
#endif/*_DISABLE_GLAYER_*/
	GWindow_Menu_AddFrameAnimation,
	GWindow_Menu_RemoveFrameAnimation,
	GWindow_Menu_StartAutoPlayFrameAnimation,
	GWindow_Menu_StartFrameAnimation,
	GWindow_Menu_ResetFrameAnimation,
	GWindow_Menu_StopFrameAnimation,
	GWindow_Menu_ResumeFrameAnimation,
	GWindow_Menu_FindFrameAnimation,
	GWindow_Menu_SetFrameAnimationSet,
	GWindow_Menu_SelectFrameAnimation,
	GWindow_Menu_SetAsyncAnimationStatus,
	GWindow_Menu_GetAsyncAnimationStatus,
	GWindow_Menu_StartAsyncFrameAnimation,
	GWindow_Menu_ResetAsyncFrameAnimation,
	GWindow_Menu_StopAsyncFrameAnimation,
	GWindow_Menu_ResumeAsyncFrameAnimation,
	GWindow_Menu_RestartAsyncFrameAnimation
//}}FUNCTION_TABLE_FUNCTION
};

/* proto type */
void SelectMenuBtn(void *windowObject, GUInt16 controlID, GInt32 changePageID);

const GWindow_Menu_VMT *GWGetGWindow_MenuVMT( void )
{
	return &vmt;
}
/*
 *	<summary>		:	IuWFNgB
 *
 *	<parameter>		:	Ȃ
 *
 *	<return>		:	NULL:		s
 *						NULLȊO:	IuWFNgւ̃|C^
 *
 *	<Explanation>	:	GWindow_MenuIuWFNg̃mۂA{B
 */
GWindow_Menu* GWNewGWindow_Menu( void )
{
	GUInt8 ucType,ucPlane;
	GWindow_Menu *pNewObject;

	GWGetVmt( GScreen_VMT, GWGetScreen() )->GetMemorySpace( GWGetScreen(), &ucType, &ucPlane );
	pNewObject = (GWindow_Menu*)GMMemoryAlloc( ucType, ucPlane, sizeof(GWindow_Menu));
	if( pNewObject == NULL ){
		return NULL;
	}

	memset( pNewObject, 0, sizeof(GWindow_Menu) );
	GWInitGWindow_Menu( pNewObject );
	
	return pNewObject;
}

/*
 *	<summary>		:	B
 *
 *	<parameter>		:	(i)GWindow_Menu* pSelf;	sIuWFNg
 *
 *	<return>		:	G_FALSE:	s
 *						G_TRUE:	
 *
 *	<Explanation>	:	GWindow_MenuIuWFNg̏sB
 *						֐\(VMT)IuWFNgɊ֘AtB
 */
GInt16 GWInitGWindow_Menu( GWindow_Menu* pSelf )
{
	if(pSelf == NULL){
		return G_FALSE;
	}

	GWInitGFrameAnimationPanel( (GFrameAnimationPanel*)pSelf );
	((GObject*)pSelf)->vmt = (const GObject_VMT*)&vmt;

	return G_TRUE;
}

/*
 *	<summary>		:	CxgbZ[WvV[WB
 *
 *	<parameter>		:	(i)GBaseWindow* pSelf;	IuWFNg
 *						(i)GUInt16 usMessage;	CxgbZ[W
 *						(i)GLParam lLParam;		t񉺈
 *						(i)GUParam lUParam;		t
 *
 *	<return>		:	-1:		ΉCxg݂ȂB
 *						0ȏ:	CxgɈˑ
 *
 *	<description>	:	CxgbZ[WɑΉ֐̌ĂяosB
 *						
 */
GClassMP( GWindow_Menu )
//{{MESSAGEPROCEDURE
//}}MESSAGEPROCEDURE
GInheritMP( GFrameAnimationPanel )


/*
 *	<summary>		:	qIuWFNǧ
 *
 *	<parameter>		:	(i)void *pSelf;		:IuWFNg
 *						(i)GUInt16 usIdx;	:qIuWFNg̃CfbNX
 *
 *	<return>		:	CfbNX͈͓	IuWFNgւ̃|C^
 *	 					CfbNX͈͊O	NULL
 *
 *	<description>	:	wIDGPanel̎qIuWFNgB
 *
 *	<exception>		:	w̃CfbNXlGCPanel̎qIuWFNgԂB
 *
 */
GBaseWindow* GWindow_Menu_GetChildAt( void *pSelf, GUInt16 usIdx )
{
	if( (sizeof(pProperty)/sizeof(GBaseWindowProperty*)) > usIdx ){
		return ((GWindow_Menu*)pSelf)->m_pObjectTable[usIdx];
	}else{
		return NULL;
	}
}

/*
 *	<summary>		:	qIuWFNg
 *
 *	<parameter>		:	(i)GWindow_Menu *pSelf;		:IuWFNg
 *
 *	<return>		:	Ȃ
 *
 *	<description>	:	qIuWFNg{B
 */
GInt16 GWindow_Menu_CreateChildren( void *pSelf )
{
	GBaseWindow *pChild;
	GUInt32 i;

	for( i = 1; i < (sizeof(pProperty)/sizeof(GBaseWindowProperty*)); i++ ){
		pChild = GWGetVmt(GScreen_VMT,GWGetScreen())->CreateInstance( GWGetScreen(), pProperty[i]->usType, pProperty[i], (GBaseWindow*)pSelf );
		GWGetVmt( GWindow_Menu_VMT,pSelf )->AddChild( pSelf, pChild );
		((GWindow_Menu*)pSelf)->m_pObjectTable[i] = pChild;
		GWGetVmt( GBaseWindow_VMT,pChild )->Create( pChild, pSelf );
	}
	if((sizeof(pFrameAnimationSet)/sizeof(GFrameAnimationSetProperty)) > 1) {
		GWGetVmt( GWindow_Menu_VMT, pSelf )->SetFrameAnimationSet( pSelf, pFrameAnimationSet );
		GWGetVmt( GWindow_Menu_VMT, pSelf )->SelectFrameAnimation( pSelf, 1 );
	}
	return G_TRUE;
}


GInt32 GWINDOW_MENU_BTNENGLISHOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MENU_BTNENGLISHOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MENU_BTNENGLISHOnClick)
	GPanel *pPanel;
	GButton *pButton1;
	GButton *pButton2;
	GRect grPnlRefreshRect;
	GUInt16 pnlID = 0;
	
	
	CompareOperateTime();
	DoOperate(BTNENGLISH, pSelf);
	pPanel = GWGetVmt( GScreen_VMT, GWGetScreen() )->GetPanel( GWGetScreen() );
	/*
	GActSetLocale( pPanel, ID_LOC_LOCALE1 );
	GActSetLocale( pSelf, ID_LOC_LOCALE1 );
	*/
	GRCSetLocale(ID_LOC_LOCALE1);
	
	pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNENGLISH );
	GWGetVmt( GButton_VMT, pButton1 )->SetFocusStatus( pButton1, G_TRUE );
	pButton2 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNJAPANESE );
	GWGetVmt( GButton_VMT, pButton2 )->SetFocusStatus( pButton2, G_FALSE );
	
	pnlID = GWGetVmt(GPanel_VMT, pPanel )->GetID( pPanel );
	
//	if( pnlID == ID_GPANEL_MANUALOPERATION + 1 ){
//		grPnlRefreshRect.nXmin = 0;
//		grPnlRefreshRect.nYmin = 0;
//		grPnlRefreshRect.nXmax = 575;	/* Oẗĕ`ΏۊOƂ */
//		grPnlRefreshRect.nYmax = 450;	/* Oẗĕ`ΏۊOƂ */
		
//		GWGetVmt(GPanel_VMT, pPanel )->AddRefreshRect( pPanel, &grPnlRefreshRect, GW_REFRESH_BGNOERASE );
//		GWGetVmt(GPanel_VMT, pSelf )->AddRefreshRect( pSelf, NULL, GW_REFRESH_BGNOERASE );
//	}
//	else{
		GWGetVmt(GScreen_VMT, GWGetScreen() )->AddRefreshRect( GWGetScreen(), NULL, GW_REFRESH_BGNOERASE );
//	}
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNERRORMANAGEMENTOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNERRORMANAGEMENT, SHOWGPANEL_ERRORMANAGEMENT);
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNJAPANESEOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MENU_BTNJAPANESEOnClick)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MENU_BTNJAPANESEOnClick)
	GPanel *pPanel;
	GButton *pButton1;
	GButton *pButton2;
	GRect grPnlRefreshRect;
	GUInt16 pnlID = 0;
	
	CompareOperateTime();
	DoOperate(BTNJAPANESE, pSelf);
	pPanel = GWGetVmt( GScreen_VMT, GWGetScreen() )->GetPanel( GWGetScreen() );
	
	/*
	GActSetLocale( pPanel, ID_LOC_LOCALE0 );
	GActSetLocale( pSelf, ID_LOC_LOCALE0 );
	*/
	GRCSetLocale(ID_LOC_LOCALE0);
	
	pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNJAPANESE );
	GWGetVmt( GButton_VMT, pButton1 )->SetFocusStatus( pButton1, G_TRUE );
	pButton2 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNENGLISH );
	GWGetVmt( GButton_VMT, pButton2 )->SetFocusStatus( pButton2, G_FALSE );
	
	pnlID = GWGetVmt(GPanel_VMT, pPanel )->GetID( pPanel );
		
//	if( pnlID == ID_GPANEL_MANUALOPERATION + 1 ){
//		grPnlRefreshRect.nXmin = 0;
//		grPnlRefreshRect.nYmin = 0;
//		grPnlRefreshRect.nXmax = 575;	/* Oẗĕ`ΏۊOƂ */
//		grPnlRefreshRect.nYmax = 450;	/* Oẗĕ`ΏۊOƂ */
		
//		GWGetVmt(GPanel_VMT, pPanel )->AddRefreshRect( pPanel, &grPnlRefreshRect, GW_REFRESH_BGNOERASE );
//		GWGetVmt(GPanel_VMT, pSelf )->AddRefreshRect( pSelf, NULL, GW_REFRESH_BGNOERASE );
//	}
//	else{
		GWGetVmt(GScreen_VMT, GWGetScreen() )->AddRefreshRect( GWGetScreen(), NULL, GW_REFRESH_BGNOERASE );
//	}
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNMAINTENANCEOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNMAINTENANCE, SHOWGPANEL_MAINTENANCE);
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNMANUALMANAGEMENTOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNMANUALMANAGEMENT, SHOWGPANEL_MANUALMANAGEMENT);
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNMANUALOPERATIONOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNMANUALOPERATION, SHOWGPANEL_MANUALOPERATION);
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNMONITOROnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNMONITOR, SHOWGPANEL_MONITOR);
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNOPERATIONHISTORYOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNOPERATIONHISTORY, SHOWGPANEL_OPERATIONHISTORY);
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNOPERDATAMANAGEMENTOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNOPERDATAMANAGEMENT, SHOWGPANEL_OPERDATAMANAGEMENT);
	
	return G_TRUE;
}

GInt32 GWINDOW_MENU_BTNPARAMETERSETTINGSOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	SelectMenuBtn(pSelf, BTNPARAMETERSETTINGS, SHOWGPANEL_PARAMETERSETTING);
	return G_TRUE;
}


void GWindow_Menu_OnCreate( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue )
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GWindow_Menu_OnCreate)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GWindow_Menu_OnCreate)
	GPanel *pPanel;
	GButton *pButton1;
	GButton *pButton2;
	GUInt16 ucPanelID;
	GUInt8 ucLocale;
	ucLocale = GRCGetLocale();
	pPanel = GWGetVmt( GScreen_VMT, GWGetScreen() )->GetPanel( GWGetScreen() );
	ucPanelID = GWGetVmt( GScreen_VMT, pPanel)->GetID( pPanel ) - NUM_DATA_1;
	if(ucPanelID == SHOWGPANEL_MANUALOPERATION)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNMANUALOPERATION );
	}
	else if(ucPanelID == SHOWGPANEL_MONITOR)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNMONITOR );
	}
	else if(ucPanelID == SHOWGPANEL_ERRORMANAGEMENT)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNERRORMANAGEMENT );
	}
	else if(ucPanelID == SHOWGPANEL_OPERDATAMANAGEMENT)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNOPERDATAMANAGEMENT );
	}
	else if(ucPanelID == SHOWGPANEL_MANUALMANAGEMENT)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNMANUALMANAGEMENT );
	}
	else if(ucPanelID == SHOWGPANEL_MAINTENANCE)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNMAINTENANCE );
	}
	else if(ucPanelID == SHOWGPANEL_OPERATIONHISTORY)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNOPERATIONHISTORY );
	}
	else if(ucPanelID == SHOWGPANEL_PARAMETERSETTING)
	{
		pButton1 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNPARAMETERSETTINGS );
	}
	GWGetVmt( GButton_VMT, pButton1 )->SetFocusStatus( pButton1, G_TRUE );
	if(ucLocale == ID_LOC_LOCALE0)
	{
		pButton2 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNJAPANESE );
	}
	else if(ucLocale == ID_LOC_LOCALE1)
	{
		pButton2 = (GButton*)GWGetVmt( GWindow_Menu_VMT, pSelf )->GetChild( pSelf, BTNENGLISH );
	}
	GWGetVmt( GButton_VMT, pButton2 )->SetFocusStatus( pButton2, G_TRUE );

	return;
}

GInt32 GWINDOW_MENU_BTNCLOSEOnClick(GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MENU_BTNCLOSEOnClick)
	GFrame *pFrame = NULL;
	GWindow *pWindow = NULL;

	pFrame = (GFrame*)GWGetVmt(GScreen_VMT, GWGetScreen())->GetFrame(GWGetScreen());
	if(pFrame != NULL){
		pWindow = (GWindow*)GWGetVmt(GFrame_VMT, pFrame)->GetChild(pFrame, ID_GWINDOW_MENU + 1);
		if(pWindow != NULL){
			GWGetVmt(GFrame_VMT, pFrame)->DeleteChild(pFrame, pWindow);
		}
	}
	//}}_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MENU_BTNCLOSEOnClick)
	return G_TRUE;
}
void SelectMenuBtn(void *windowObject, GUInt16 controlID, GInt32 changePageID)
{
	GFrame *pFrame = NULL;
	GWindow *pWindow = NULL;
	
	pFrame = (GFrame*)GWGetVmt(GScreen_VMT, GWGetScreen())->GetFrame(GWGetScreen());

	CompareOperateTime();
	DoOperate(controlID, windowObject);
	GActScreenShowPanel(windowObject, changePageID);

	if(pFrame != NULL){
		pWindow = (GWindow*)GWGetVmt(GFrame_VMT, pFrame)->GetChild(pFrame, ID_GWINDOW_MENU + 1);
		if(pWindow != NULL){
			GWGetVmt(GFrame_VMT, pFrame)->DeleteChild(pFrame, pWindow);
		}
	}
}
