#ifndef _GWINDOW_MENU_H_
#define _GWINDOW_MENU_H_
#include <genifa.h>
#include <gframeanimationpanel.h>

#ifdef __cplusplus
extern "C" {
#endif

//{{CONTROL_ID
enum{
	GWINDOW_MENU_GDUMMYTERMINATOR
};
//}}CONTROL_ID
//{{ANIMATION_ID
enum{
	GWINDOW_MENU_GANIMATIONTERMINATOR
};
//}}ANIMATION_ID

typedef struct GWindow_Menu_VMT{
	//{{FUNCTION_TABLE
	GInt32 (*MessageProcedure)( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GInt32 (*CallBackMessageProcedure)( void* pSelf, GUInt16 usID, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
	GUInt16 (*GetType)( void* pSelf );
	GUInt16 (*GetID)( void* pSelf );
	GInt16 (*GetXPosition)( void* pSelf );
	GInt16 (*GetYPosition)( void* pSelf );
	void (*GetPosition)( void* pSelf, GPoint *pPosition );
	GInt16 (*GetWidth)( void* pSelf );
	GInt16 (*GetHeight)( void* pSelf );
	void (*GetSize)( void* pSelf, GPoint *pSize );
	void (*SetBounds)( void* pSelf, GRect *pBounds );
	void (*GetBounds)( void* pSelf, GRect *pBounds );
	void (*CalcClinetRect)(  void* pSelf, GRect *pClient );
	void (*GetClientRect)( void *pSelf, GRect *pClient );
	void (*ClientToScreen)( void *pSelf, GRect *pRect );
	GUInt32 (*GetStyle)(  void *pSelf );
	void (*SetVisibleStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetVisibleStatus)( void *pSelf );
	void (*SetEnableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetEnableStatus)( void *pSelf );
	void (*SetConsumableStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetConsumableStatus)( void *pSelf );
	void (*SetCaptionStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetCaptionStatus)( void *pSelf );
	void (*SetFocusStatus)( void *pSelf, GInt16 fStatus );
	GInt16 (*GetFocusStatus)( void *pSelf );
	void (*SetStyleStatus)( void* pSelf, GUInt32 ulStyle, GInt16 fStatus );
	GInt16 (*GetStyleStatus)( void* pSelf, GUInt32 ulStyle );
	void (*SetParent)( void* pSelf, GBaseWindow *pParent);
	GBaseWindow* (*GetParent)( void* pSelf );
	void (*SetFocusInformation)( void * pSelf, GFocusInformation *pFocusInfo );
	GFocusInformation *(*GetFocusInformation)( void * pSelf );
	GInt16 (*Create)( void *pSelf, GBaseWindow *pParent );
	void (*Delete)( void *pSelf );
	GInt16 (*ImportProperty)( void *pSelf, const GBaseWindowProperty *pProperty );
	void (*ExportProperty)( void *pSelf, GBaseWindowProperty *pProperty );
	void (*Paint)( void *pSelf, GWDC *pDC );
	void (*OnDraw)( void *pSelf, GWDC *pDC );
	void (*OnNcDraw)( void *pSelf, GWDC *pDC );
	void (*AddRefreshRect)( void *pSelf, GRect *pRefresh, GInt16 nErase );
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GInt32 (*MouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcMouseMove)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_MOUSEMOVE_ */
	GInt32 (*LButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcLButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*LButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcLButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#ifdef _ENABLE_RBUTTON_
	GInt32 (*RButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	GInt32 (*OnNcRButtonPress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*RButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
	void (*OnNcRButtonRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint );
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GInt32 (*KeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*KeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*SetFocus)( void *pSelf );
	void (*KillFocus)( void *pSelf );
	void (*Timer)( void *pSelf, GUInt16 usTimerID );
	GInt32 (*User)( void *pSelf, GLParam lLParam, GUParam lUParam );
	void (*Char)( void * pSelf, GUInt16 usCharCode, GUInt32 ulStatus );
	void (*Close)( void * pSelf );
	void (*DeleteChild)( void * pSelf, GBaseWindow *pChild );
	void (*SetMemorySpace)( void *pSelf, GUInt8 ucType, GUInt8 ucPlane );
	void (*GetMemorySpace)( void *pSelf, GUInt8* ucType, GUInt8* ucPlane );
	void (*SetDrawForceStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetDrawForceStatus)( void *pSelf );	
	void (*SetRedrawStatus)( void *pSelf, GInt16 nStatus );
	GInt16 (*GetRedrawStatus)( void *pSelf );
	void (*ClearDrawStatus)( void *pSelf );
	void (*AddDirtyRect)(	 void *pSelf, GRect *pRefreshRect, GInt16 fErase );
	void (*SetPrevTimerObject)( void *pSelf, GBaseWindow *pbwPrev );
	GBaseWindow* (*GetPrevTimerObject)( void *pSelf );
	void (*SetNextTimerObject)( void *pSelf, GBaseWindow *pbwNext  );
	GBaseWindow* (*GetNextTimerObject)( void *pSelf );
#ifndef	_DISABLE_GLAYER_
	// CΉ >>
	void (*AddDirtyRectLayer)( void *pSelf, GUInt16 usLayerID, GRect *pRefreshRect, GInt16 fErase );
	void (*SetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );		/* ݒ	*/
	GInt16 (*GetDrawForceStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID, GInt16 nStatus );			/* ݒ	*/
	GInt16 (*GetRedrawStatusLayer)( void *pSelf,  GUInt16 usLayerID );						/* 擾	*/
	void (*SetLayerID)( void *pSelf, GUInt16 usLayerID );
	GUInt16 (*GetLayerID)( void *pSelf );
	// CΉ <<
#endif /* _DISABLE_GLAYER_ */
	void *(*HoldImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void *(*GetImageData)(void *pSelf, HGVRAM hGVram, GBitBltSrc tBitBltSrc);
	void (*CleanImageData)(void *pSelf);
	void (*Active)( void *pSelf );
	void (*OnActive)( void *pSelf );
	void (*SetActiveStatus)( void *pSelf, GInt16 nActive );
	GInt16 (*GetActiveStatus)( void *pSelf );

	void (*OnCreate)( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue );
	void (*PreDelete)( void *pSelf );
	GInt16 (*PreKeyPress)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
	GInt16 (*PreKeyRelease)( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
	void (*OnUser)( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
	GInt16 (*PrePress)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
	GInt16 (*PreRelease)( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
	GInt16 (*PrePaint)( void *pSelf, GWDC *pDC );
	void (*OnTimer)( void *pSelf, GUInt16 usTimerID );
#if		(_USE_MULTI_COORDINATE_ != 0)
	GInt16 (*SetActiveCoordinate)( void *pSelf, GInt16 nActive );
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	void (*OnUpdateDB)( void *pSelf, void* pParam );
	GInt16 (*IsMousePointInBounds)( void* pSelf, GPoint gptPoint );

	// GPanel
	void (*SetBackGroundDesign)( void *pSelf, GDesign *pDesign );
	GDesign *(*GetBackGroundDesign)( void *pSelf );
	GInt16 (*CreateChildren)( void *pSelf );
	GInt16 (*AddChild)( void *pSelf, GBaseWindow *pChild );
	void (*DeleteAllChildren)( void *pSelf );
	GBaseWindow *(*GetChild)( void *pSelf, GUInt16 usID );
	GBaseWindowList* (*GetChildList)( void *pSelf );
	void (*DrawChildren)( void *pSelf, GWDC *pDC );
	void (*DrawBackGround)( void *pSelf, GWDC *pDC );
	GInt16 (*SetActiveChild)( void *pSelf, GInt16 nSearch, GBaseWindow *pActiveChild );
	GBaseWindow* (*GetActiveChild)( void *pSelf );
	void (*EndModal)( void *pSelf, GInt16 nRetValue );
	void (*AddBlinkControl)( void *pSelf, GControl *pControl );
	void (*RemoveBlinkControl)( void *pSelf, GControl *pControl );
	void (*AddScrollControl)( void *pSelf, GControl *pControl );
	void (*RemoveScrollControl)( void *pSelf, GControl *pControl );
	GImage *(*SetPictureData)( void *pSelf, GImage *pPictureData );
	GImage *(*GetPictureData)( void *pSelf );
	GBaseWindow* (*GetPositionChild)( void *pSelf, GPoint gptPoint);
	void (*SetNoResponseBaseArea)( void *pSelf, GUInt16 usArea, GInt32 lLength );
	void (*GetNoResponseBaseArea)(void *pSelf, GUInt16 usArea, GInt32 *lLength );
	void (*SetReleaseType) (void *pSelf, GUInt8 ucType);
	void (*GetReleaseType) (void *pSelf, GUInt8 *ucType );
	GBaseWindow* (*GetChildAt)( void *pSelf, GUInt16 usIdx );
	void (*OnShowPage) (void *pSelf );
	void (*OnHidePage) (void *pSelf );
	GInt16 (*MoveChildListFirst)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListLast)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListPrev)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildListNext)(void *pSelf, GBaseWindow *pChild);
	GInt16 (*MoveChildList)(void *pSelf, GBaseWindow *pChild, GInt32 lIndex );
	GInt32 (*GetChildIndex)(void *pSelf, GBaseWindow *pChild);
	GBaseWindow* (*GetPrevChild)( void *pSelf, GBaseWindow* pChild );
	GBaseWindow* (*GetNextChild)( void *pSelf, GBaseWindow* pChild );
#ifndef	_DISABLE_GLAYER_
	GInt32 (*GetChildCount)(void *pSelf, GUInt16 usLayerID);
	GBaseWindow* (*GetFirstChildInLayer)( void *pSelf, GUInt16 usLayerID );
	GBaseWindow* (*GetLastChildInLayer)( void *pSelf, GUInt16 usLayerID );
	GBaseWindow* (*GetChildInLayer)( void *pSelf, GInt32 lIndexInLayer, GUInt16 usLayerID );
#endif /* _DISABLE_GLAYER_ */
	// GFrameAnimationPanel
	void (*AddFrameAnimation)( void *pSelf, GFrameAnimation* pFrameAnimation );
	void (*RemoveFrameAnimation)( void *pSelf, GFrameAnimation* pFrameAnimation );
	void (*StartAutoPlayFrameAnimation)( void *pSelf );
	GInt16 (*StartFrameAnimation)( void *pSelf );
	GInt16 (*ResetFrameAnimation)( void *pSelf );
	GInt16 (*StopFrameAnimation)( void *pSelf );
	GInt16 (*ResumeFrameAnimation)( void *pSelf );
	GFrameAnimation* (*FindFrameAnimation)( void *pSelf, GUInt16 usID );
	void (*SetFrameAnimationSet)( void *pSelf, const GFrameAnimationSetProperty *pAnimeSet );
	GInt16 (*SelectFrameAnimation)( void *pSelf, GUInt16 usID );
	void (*SetAsyncAnimationStatus)( void *pSelf, GUInt8 ucStatus );
	GUInt8 (*GetAsyncAnimationStatus)( void *pSelf );
	GInt16 (*StartAsyncFrameAnimation)( void *pSelf, GUInt16 usID );
	GInt16 (*ResetAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*StopAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*ResumeAsyncFrameAnimation)( void *pSelf, GUInt16 usID  );
	GInt16 (*RestartAsyncFrameAnimation)( void *pSelf, GUInt16 usID, GUInt32 ulKeyFrame );
	//}}FUNCTION_TABLE
}GWindow_Menu_VMT;

GDefClass( GWindow_Menu, GFrameAnimationPanel )
	//{{NATIVE_OBJECT_TABLE
	GBaseWindow* m_pObjectTable[12];
	//}}NATIVE_OBJECT_TABLE
GDefEnd

typedef struct GWindow_Menu GWindow_Menu;

//{{PUBLIC_METHOD
GWindow_Menu *GWNewGWindow_Menu( void );
const GWindow_Menu_VMT *GWGetGWindow_MenuVMT( void );
GInt16 GWInitGWindow_Menu( GWindow_Menu* pSelf );
GInt32 GWindow_Menu_MessageProcedure( void* pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWindow_Menu_CallBackMessageProcedure( void* pSelf, GUInt16 usID, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt16 GWindow_Menu_CreateChildren( void *pSelf );
GBaseWindow* GWindow_Menu_GetChildAt( void *pSelf, GUInt16 usIdx );
//}}PUBLIC_METHOD

//{{CALLBACK_METHOD
GInt32 GWINDOW_MENU_BTNCLOSEOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNENGLISHOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNERRORMANAGEMENTOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNJAPANESEOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNMAINTENANCEOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNMANUALMANAGEMENTOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNMANUALOPERATIONOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNMONITOROnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNOPERATIONHISTORYOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNOPERDATAMANAGEMENTOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
GInt32 GWINDOW_MENU_BTNPARAMETERSETTINGSOnClick( GWindow_Menu *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam );
//}}CALLBACK_METHOD

//{{OVERRIDE_CONDITION
#define OnCreate_USE 1
//}}OVERRIDE_CONDITION

//{{OVERRIDE_METHOD
#ifdef OnCreate_USE
void GWindow_Menu_OnCreate( void *pSelf, GBaseWindow *pParent, GInt16 *pReturnValue );
#endif
#ifdef PreDelete_USE
void GWindow_Menu_PreDelete( void *pSelf );
#endif
#ifdef PreKeyPress_USE
GInt16 GWindow_Menu_PreKeyPress ( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus, GInt32 *pReturnValue);
#endif
#ifdef PreKeyRelease_USE
GInt16 GWindow_Menu_PreKeyRelease( void *pSelf, GUInt16 usKeyCode, GUInt32 ulStatus );
#endif
#ifdef OnUser_USE
void GWindow_Menu_OnUser( void *pSelf, GLParam lLParam, GUParam lUParam, GInt32 *pReturnValue );
#endif
#ifdef PrePress_USE
GInt16 GWindow_Menu_PrePress( void *pSelf, GUInt32 ulStatus, GPoint gptPoint, GInt32 *pReturnValue);
#endif
#ifdef PreRelease_USE
GInt16 GWindow_Menu_PreRelease( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#ifdef PrePaint_USE
GInt16 GWindow_Menu_PrePaint( void *pSelf, GWDC *pDC );
#endif
#ifdef OnTimer_USE
void GWindow_Menu_OnTimer( void *pSelf, GUInt16 usTimerID );
#endif
#ifdef OnActive_USE
void GWindow_Menu_OnActive( void *pSelf );
#endif
#ifdef OnUpdateDB_USE
void GWindow_Menu_OnUpdateDB( void *pSelf, void *pParam );
#endif
#ifdef OnShowPage_USE
void GWindow_Menu_OnShowPage( void *pSelf );
#endif
#ifdef OnHidePage_USE
void GWindow_Menu_OnHidePage( void *pSelf );
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
#ifdef OnMouseMove_USE
GInt32 GWindow_Menu_OnMouseMove( void *pSelf, GUInt32 ulStatus, GPoint gptPoint);
#endif
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
//}}OVERRIDE_METHOD

//{{PROTECTED_METHOD
/* p̏Ȃ֐͊֐̒`Ă */
#define GWindow_Menu_GetType					GFrameAnimationPanel_GetType
#define GWindow_Menu_GetID						GFrameAnimationPanel_GetID
#define GWindow_Menu_GetXPosition				GFrameAnimationPanel_GetXPosition
#define GWindow_Menu_GetYPosition				GFrameAnimationPanel_GetYPosition
#define GWindow_Menu_GetPosition				GFrameAnimationPanel_GetPosition
#define GWindow_Menu_GetWidth					GFrameAnimationPanel_GetWidth
#define GWindow_Menu_GetHeight					GFrameAnimationPanel_GetHeight
#define GWindow_Menu_GetSize					GFrameAnimationPanel_GetSize
#define GWindow_Menu_SetBounds					GFrameAnimationPanel_SetBounds
#define GWindow_Menu_GetBounds					GFrameAnimationPanel_GetBounds
#define GWindow_Menu_CalcClientRect			GFrameAnimationPanel_CalcClientRect
#define GWindow_Menu_GetClientRect				GFrameAnimationPanel_GetClientRect
#define GWindow_Menu_ClientToScreen			GFrameAnimationPanel_ClientToScreen
#define GWindow_Menu_GetStyle					GFrameAnimationPanel_GetStyle
#define GWindow_Menu_SetVisibleStatus			GFrameAnimationPanel_SetVisibleStatus
#define GWindow_Menu_GetVisibleStatus			GFrameAnimationPanel_GetVisibleStatus
#define GWindow_Menu_SetEnableStatus			GFrameAnimationPanel_SetEnableStatus
#define GWindow_Menu_GetEnableStatus			GFrameAnimationPanel_GetEnableStatus
#define GWindow_Menu_SetConsumableStatus		GFrameAnimationPanel_SetConsumableStatus
#define GWindow_Menu_GetConsumableStatus		GFrameAnimationPanel_GetConsumableStatus
#define GWindow_Menu_SetCaptionStatus			GFrameAnimationPanel_SetCaptionStatus
#define GWindow_Menu_GetCaptionStatus			GFrameAnimationPanel_GetCaptionStatus
#define GWindow_Menu_SetFocusStatus			GFrameAnimationPanel_SetFocusStatus
#define GWindow_Menu_GetFocusStatus			GFrameAnimationPanel_GetFocusStatus
#define GWindow_Menu_SetStyleStatus			GFrameAnimationPanel_SetStyleStatus
#define GWindow_Menu_GetStyleStatus			GFrameAnimationPanel_GetStyleStatus
#define GWindow_Menu_SetParent					GFrameAnimationPanel_SetParent
#define GWindow_Menu_GetParent					GFrameAnimationPanel_GetParent
#define GWindow_Menu_SetFocusInformation		GFrameAnimationPanel_SetFocusInformation
#define GWindow_Menu_GetFocusInformation		GFrameAnimationPanel_GetFocusInformation
#define GWindow_Menu_ImportProperty			GFrameAnimationPanel_ImportProperty
#define GWindow_Menu_ExportProperty			GFrameAnimationPanel_ExportProperty
#define GWindow_Menu_Create					GFrameAnimationPanel_Create
#define GWindow_Menu_Delete					GFrameAnimationPanel_Delete
#define GWindow_Menu_Paint						GFrameAnimationPanel_Paint
#define GWindow_Menu_OnDraw					GFrameAnimationPanel_OnDraw
#define GWindow_Menu_OnNcDraw					GFrameAnimationPanel_OnNcDraw
#define GWindow_Menu_AddRefreshRect			GFrameAnimationPanel_AddRefreshRect
#define GWindow_Menu_MouseMove					GFrameAnimationPanel_MouseMove
#define GWindow_Menu_OnNcMouseMove				GFrameAnimationPanel_OnNcMouseMove
#define GWindow_Menu_LButtonPress				GFrameAnimationPanel_LButtonPress
#define GWindow_Menu_OnLButtonPress			GFrameAnimationPanel_OnLButtonPress
#define GWindow_Menu_OnNcLButtonPress			GFrameAnimationPanel_OnNcLButtonPress
#define GWindow_Menu_LButtonRelease			GFrameAnimationPanel_LButtonRelease
#define GWindow_Menu_OnLButtonRelease			GFrameAnimationPanel_OnLButtonRelease
#define GWindow_Menu_OnNcLButtonRelease		GFrameAnimationPanel_OnNcLButtonRelease
#define GWindow_Menu_RButtonPress				GFrameAnimationPanel_RButtonPress
#define GWindow_Menu_OnRButtonPress			GFrameAnimationPanel_OnRButtonPress
#define GWindow_Menu_OnNcRButtonPress			GFrameAnimationPanel_OnNcRButtonPress
#define GWindow_Menu_RButtonRelease			GFrameAnimationPanel_RButtonRelease
#define GWindow_Menu_OnRButtonRelease			GFrameAnimationPanel_OnRButtonRelease
#define GWindow_Menu_OnNcRButtonRelease		GFrameAnimationPanel_OnNcRButtonRelease
#define GWindow_Menu_KeyPress					GFrameAnimationPanel_KeyPress
#define GWindow_Menu_KeyRelease				GFrameAnimationPanel_KeyRelease
#define GWindow_Menu_SetFocus					GFrameAnimationPanel_SetFocus
#define GWindow_Menu_KillFocus					GFrameAnimationPanel_KillFocus
#define GWindow_Menu_Timer						GFrameAnimationPanel_Timer
#define GWindow_Menu_User						GFrameAnimationPanel_User
#define GWindow_Menu_Char						GFrameAnimationPanel_Char
#define GWindow_Menu_Close						GFrameAnimationPanel_Close
#define GWindow_Menu_DeleteChild				GFrameAnimationPanel_DeleteChild
#define GWindow_Menu_SetMemorySpace			GFrameAnimationPanel_SetMemorySpace
#define GWindow_Menu_GetMemorySpace			GFrameAnimationPanel_GetMemorySpace
#define GWindow_Menu_SetDrawForceStatus 		GFrameAnimationPanel_SetDrawForceStatus
#define GWindow_Menu_GetDrawForceStatus 		GFrameAnimationPanel_GetDrawForceStatus
#define GWindow_Menu_SetRedrawStatus 			GFrameAnimationPanel_SetRedrawStatus
#define GWindow_Menu_GetRedrawStatus 			GFrameAnimationPanel_GetRedrawStatus
#define GWindow_Menu_ClearDrawStatus 			GFrameAnimationPanel_ClearDrawStatus
#define GWindow_Menu_AddDirtyRect 				GFrameAnimationPanel_AddDirtyRect
#define GWindow_Menu_SetPrevTimerObject GFrameAnimationPanel_SetPrevTimerObject
#define GWindow_Menu_GetPrevTimerObject GFrameAnimationPanel_GetPrevTimerObject
#define GWindow_Menu_SetNextTimerObject GFrameAnimationPanel_SetNextTimerObject
#define GWindow_Menu_GetNextTimerObject GFrameAnimationPanel_GetNextTimerObject

#define GWindow_Menu_MoveChildListFirst GFrameAnimationPanel_MoveChildListFirst
#define GWindow_Menu_MoveChildListLast GFrameAnimationPanel_MoveChildListLast
#define GWindow_Menu_MoveChildListPrev GFrameAnimationPanel_MoveChildListPrev
#define GWindow_Menu_MoveChildListNext GFrameAnimationPanel_MoveChildListNext
#define GWindow_Menu_MoveChildList GFrameAnimationPanel_MoveChildList
#define GWindow_Menu_GetChildIndex GFrameAnimationPanel_GetChildIndex
#define GWindow_Menu_GetPrevChild	GFrameAnimationPanel_GetPrevChild
#define GWindow_Menu_GetNextChild	GFrameAnimationPanel_GetNextChild
#ifndef _DISABLE_GLAYER_
#define GWindow_Menu_GetChildCount GFrameAnimationPanel_GetChildCount
#define GWindow_Menu_GetFirstChildInLayer	GFrameAnimationPanel_GetFirstChildInLayer
#define GWindow_Menu_GetLastChildInLayer	GFrameAnimationPanel_GetLastChildInLayer
#define GWindow_Menu_GetChildInLayer		GFrameAnimationPanel_GetChildInLayer
#endif /* _DISABLE_GLAYER_ */

#define	GWindow_Menu_SetBackGroundDesign		GFrameAnimationPanel_SetBackGroundDesign
#define	GWindow_Menu_GetBackGroundDesign		GFrameAnimationPanel_GetBackGroundDesign
#define	GWindow_Menu_AddChild					GFrameAnimationPanel_AddChild
#define	GWindow_Menu_DeleteAllChildren			GFrameAnimationPanel_DeleteAllChildren
#define	GWindow_Menu_GetChild					GFrameAnimationPanel_GetChild
#define	GWindow_Menu_GetChildList				GFrameAnimationPanel_GetChildList
#define	GWindow_Menu_DrawChildren				GFrameAnimationPanel_DrawChildren
#define	GWindow_Menu_DrawBackGround			GFrameAnimationPanel_DrawBackGround
#define	GWindow_Menu_SetActiveChild			GFrameAnimationPanel_SetActiveChild
#define	GWindow_Menu_GetActiveChild			GFrameAnimationPanel_GetActiveChild
#define	GWindow_Menu_EndModal					GFrameAnimationPanel_EndModal
#define	GWindow_Menu_AddBlinkControl			GFrameAnimationPanel_AddBlinkControl
#define	GWindow_Menu_RemoveBlinkControl		GFrameAnimationPanel_RemoveBlinkControl
#define	GWindow_Menu_AddScrollControl			GFrameAnimationPanel_AddScrollControl
#define	GWindow_Menu_RemoveScrollControl		GFrameAnimationPanel_RemoveScrollControl
#define GWindow_Menu_SetPictureData			GFrameAnimationPanel_SetPictureData
#define GWindow_Menu_GetPictureData			GFrameAnimationPanel_GetPictureData
#define GWindow_Menu_GetPositionChild			GFrameAnimationPanel_GetPositionChild
#define GWindow_Menu_AddFrameAnimation				GFrameAnimationPanel_AddFrameAnimation
#define GWindow_Menu_RemoveFrameAnimation			GFrameAnimationPanel_RemoveFrameAnimation
#define GWindow_Menu_StartAutoPlayFrameAnimation	GFrameAnimationPanel_StartAutoPlayFrameAnimation
#define GWindow_Menu_StartFrameAnimation			GFrameAnimationPanel_StartFrameAnimation
#define GWindow_Menu_ResetFrameAnimation			GFrameAnimationPanel_ResetFrameAnimation
#define GWindow_Menu_StopFrameAnimation			GFrameAnimationPanel_StopFrameAnimation
#define GWindow_Menu_ResumeFrameAnimation			GFrameAnimationPanel_ResumeFrameAnimation
#define GWindow_Menu_FindFrameAnimation			GFrameAnimationPanel_FindFrameAnimation
#define GWindow_Menu_SetFrameAnimationSet			GFrameAnimationPanel_SetFrameAnimationSet
#define GWindow_Menu_SelectFrameAnimation			GFrameAnimationPanel_SelectFrameAnimation
#define GWindow_Menu_SetAsyncAnimationStatus		GFrameAnimationPanel_SetAsyncAnimationStatus
#define GWindow_Menu_GetAsyncAnimationStatus		GFrameAnimationPanel_GetAsyncAnimationStatus
#define GWindow_Menu_StartAsyncFrameAnimation 		GFrameAnimationPanel_StartAsyncFrameAnimation
#define GWindow_Menu_ResetAsyncFrameAnimation 		GFrameAnimationPanel_ResetAsyncFrameAnimation
#define GWindow_Menu_StopAsyncFrameAnimation 		GFrameAnimationPanel_StopAsyncFrameAnimation
#define GWindow_Menu_ResumeAsyncFrameAnimation 	GFrameAnimationPanel_ResumeAsyncFrameAnimation
#define GWindow_Menu_RestartAsyncFrameAnimation	GFrameAnimationPanel_RestartAsyncFrameAnimation

#ifndef	_DISABLE_GLAYER_
	// CΉ >>
#define GWindow_Menu_AddDirtyRectLayer			GFrameAnimationPanel_AddDirtyRectLayer
#define GWindow_Menu_SetDrawForceStatusLayer	GFrameAnimationPanel_SetDrawForceStatusLayer
#define GWindow_Menu_GetDrawForceStatusLayer	GFrameAnimationPanel_GetDrawForceStatusLayer
#define GWindow_Menu_SetRedrawStatusLayer		GFrameAnimationPanel_SetRedrawStatusLayer
#define GWindow_Menu_GetRedrawStatusLayer		GFrameAnimationPanel_GetRedrawStatusLayer
#define GWindow_Menu_SetLayerID				GFrameAnimationPanel_SetLayerID
#define GWindow_Menu_GetLayerID				GFrameAnimationPanel_GetLayerID
	// CΉ <<
#endif /* _DISABLE_GLAYER_ */
#define GWindow_Menu_HoldImageData				GFrameAnimationPanel_HoldImageData
#define GWindow_Menu_GetImageData				GFrameAnimationPanel_GetImageData
#define GWindow_Menu_CleanImageData			GFrameAnimationPanel_CleanImageData
#define GWindow_Menu_Active					GFrameAnimationPanel_Active
#define GWindow_Menu_SetActiveStatus			GFrameAnimationPanel_SetActiveStatus
#define GWindow_Menu_GetActiveStatus			GFrameAnimationPanel_GetActiveStatus

#ifndef OnCreate_USE
#define GWindow_Menu_OnCreate					GFrameAnimationPanel_OnCreate
#endif
#ifndef PreDelete_USE
#define GWindow_Menu_PreDelete					GFrameAnimationPanel_PreDelete
#endif
#ifndef PreKeyPress_USE
#define GWindow_Menu_PreKeyPress				GFrameAnimationPanel_PreKeyPress
#endif
#ifndef PreKeyRelease_USE
#define GWindow_Menu_PreKeyRelease				GFrameAnimationPanel_PreKeyRelease
#endif
#ifndef OnUser_USE
#define GWindow_Menu_OnUser					GFrameAnimationPanel_OnUser
#endif
#ifndef PrePress_USE
#define GWindow_Menu_PrePress					GFrameAnimationPanel_PrePress
#endif
#ifndef PreRelease_USE
#define GWindow_Menu_PreRelease				GFrameAnimationPanel_PreRelease
#endif
#ifndef PrePaint_USE
#define GWindow_Menu_PrePaint					GFrameAnimationPanel_PrePaint
#endif
#ifndef OnTimer_USE
#define GWindow_Menu_OnTimer					GFrameAnimationPanel_OnTimer
#endif
#ifndef OnActive_USE
#define GWindow_Menu_OnActive					GFrameAnimationPanel_OnActive
#endif
#ifndef OnUpdateDB_USE
#define GWindow_Menu_OnUpdateDB				GFrameAnimationPanel_OnUpdateDB
#endif
#ifndef OnShowPage_USE
#define GWindow_Menu_OnShowPage				GFrameAnimationPanel_OnShowPage
#endif
#ifndef OnHidePage_USE
#define GWindow_Menu_OnHidePage				GFrameAnimationPanel_OnHidePage
#endif
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
#ifndef OnMouseMove_USE
#define GWindow_Menu_OnMouseMove				GFrameAnimationPanel_OnMouseMove
#endif
#endif /* _ENABLE_MOUSEMOVE_ */
#endif /* _DISABLE_POINTING_DEVICE_ */

#if		(_USE_MULTI_COORDINATE_ != 0)
#define	GWindow_Menu_SetActiveCoordinate		GFrameAnimationPanel_SetActiveCoordinate
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
#define GWindow_Menu_IsMousePointInBounds		GFrameAnimationPanel_IsMousePointInBounds
#define GWindow_Menu_SetNoResponseBaseArea		GFrameAnimationPanel_SetNoResponseBaseArea
#define GWindow_Menu_GetNoResponseBaseArea		GFrameAnimationPanel_GetNoResponseBaseArea
#define GWindow_Menu_SetReleaseType			GFrameAnimationPanel_SetReleaseType
#define GWindow_Menu_GetReleaseType			GFrameAnimationPanel_GetReleaseType
//#define GWindow_Menu_GetChildAt				GFrameAnimationPanel_GetChildAt
//}}PROTECTED_METHOD

//{{UNDEF_OVERRIDE_CONDITION
#undef OnCreate_USE
#undef PreDelete_USE
#undef PreKeyPress_USE
#undef PreKeyRelease_USE
#undef OnUser_USE
#undef PrePress_USE
#undef PreRelease_USE
#undef PrePaint_USE
#undef OnTimer_USE
#undef OnActive_USE
#undef OnUpdateDB_USE
#undef OnMouseMove_USE
//}}UNDEF_OVERRIDE_CONDITION
#ifdef __cplusplus
}
#endif

#endif /* _GWINDOW_MENU_H_ */
