#include <stdlib.h>
#include <string.h>
#include "GWindow_Message.h"
#include "gbasiccontrol.h"
#include "gbutton.h"
#include "gcheckbox.h"
#include "glabel.h"
#include "glist.h"
#include "gpicture.h"
#include "gprogressbar.h"
#include "gradiobutton.h"
#include "gtextbox.h"
#include "gtextboxex.h"
#include "gscrollbarex.h"
#include "ggrid.h"
#include "gstatictext.h"
#include "gnumbmp.h"
#include "GC_GUIScreen.h"
#include "gevent.h"
#include "GResource.h"
#include "GControlID.h"
#include "gcachetext.h"
#include "GScript.h"
#include "GDBObject.h"
#include "gsvframe.h"
#include "gdispsubpnl.h"
#include "GWindow_Message.prc"
#include "Common.h"

//{{FUNCTION_TABLE_TABLE
static const GWindow_Message_VMT vmt=
{
//{{FUNCTION_TABLE_FUNCTION
	GWindow_Message_MessageProcedure,
	GWindow_Message_CallBackMessageProcedure,
	GWindow_Message_GetType,
	GWindow_Message_GetID,
	GWindow_Message_GetXPosition,
	GWindow_Message_GetYPosition,
	GWindow_Message_GetPosition,
	GWindow_Message_GetWidth,
	GWindow_Message_GetHeight,
	GWindow_Message_GetSize,
	GWindow_Message_SetBounds,
	GWindow_Message_GetBounds,
	GWindow_Message_CalcClientRect,
	GWindow_Message_GetClientRect,
	GWindow_Message_ClientToScreen,
	GWindow_Message_GetStyle,
	GWindow_Message_SetVisibleStatus,
	GWindow_Message_GetVisibleStatus,
	GWindow_Message_SetEnableStatus,
	GWindow_Message_GetEnableStatus,
	GWindow_Message_SetConsumableStatus,
	GWindow_Message_GetConsumableStatus,
	GWindow_Message_SetCaptionStatus,
	GWindow_Message_GetCaptionStatus,
	GWindow_Message_SetFocusStatus,
	GWindow_Message_GetFocusStatus,
	GWindow_Message_SetStyleStatus,
	GWindow_Message_GetStyleStatus,
	GWindow_Message_SetParent,
	GWindow_Message_GetParent,
	GWindow_Message_SetFocusInformation,
	GWindow_Message_GetFocusInformation,
	GWindow_Message_Create,
	GWindow_Message_Delete,
	GWindow_Message_ImportProperty,
	GWindow_Message_ExportProperty,
	GWindow_Message_Paint,
	GWindow_Message_OnDraw,
	GWindow_Message_OnNcDraw,
	GWindow_Message_AddRefreshRect,
#ifndef _DISABLE_POINTING_DEVICE_
#ifdef _ENABLE_MOUSEMOVE_
	GWindow_Message_MouseMove,
	GWindow_Message_OnMouseMove,
	GWindow_Message_OnNcMouseMove,
#endif /* _ENABLE_MOUSEMOVE_ */
	GWindow_Message_LButtonPress,
	GWindow_Message_OnLButtonPress,
	GWindow_Message_OnNcLButtonPress,
	GWindow_Message_LButtonRelease,
	GWindow_Message_OnLButtonRelease,
	GWindow_Message_OnNcLButtonRelease,
#ifdef _ENABLE_RBUTTON_
	GWindow_Message_RButtonPress,
	GWindow_Message_OnRButtonPress,
	GWindow_Message_OnNcRButtonPress,
	GWindow_Message_RButtonRelease,
	GWindow_Message_OnRButtonRelease,
	GWindow_Message_OnNcRButtonRelease,
#endif /* _ENABLE_RBUTTON_ */
#endif /* _DISABLE_POINTING_DEVICE_ */
	GWindow_Message_KeyPress,
	GWindow_Message_KeyRelease,
	GWindow_Message_SetFocus,
	GWindow_Message_KillFocus,
	GWindow_Message_Timer,
	GWindow_Message_User,
	GWindow_Message_Char,
	GWindow_Message_Close,
	GWindow_Message_DeleteChild,
	GWindow_Message_SetMemorySpace,
	GWindow_Message_GetMemorySpace,
	GWindow_Message_SetDrawForceStatus,
	GWindow_Message_GetDrawForceStatus,
	GWindow_Message_SetRedrawStatus,
	GWindow_Message_GetRedrawStatus,
	GWindow_Message_ClearDrawStatus,
	GWindow_Message_AddDirtyRect,
	GWindow_Message_SetPrevTimerObject,
	GWindow_Message_GetPrevTimerObject,
	GWindow_Message_SetNextTimerObject,
	GWindow_Message_GetNextTimerObject,
#ifndef	_DISABLE_GLAYER_
	GWindow_Message_AddDirtyRectLayer,
	GWindow_Message_SetDrawForceStatusLayer,
	GWindow_Message_GetDrawForceStatusLayer,
	GWindow_Message_SetRedrawStatusLayer,
	GWindow_Message_GetRedrawStatusLayer,
	GWindow_Message_SetLayerID,
	GWindow_Message_GetLayerID,
#endif/*_DISABLE_GLAYER_*/
	GWindow_Message_HoldImageData,
	GWindow_Message_GetImageData,
	GWindow_Message_CleanImageData,
	GWindow_Message_Active,
	GWindow_Message_OnActive,
	GWindow_Message_SetActiveStatus,
	GWindow_Message_GetActiveStatus,

	GWindow_Message_OnCreate,
	GWindow_Message_PreDelete,
	GWindow_Message_PreKeyPress,
	GWindow_Message_PreKeyRelease,
	GWindow_Message_OnUser,
	GWindow_Message_PrePress,
	GWindow_Message_PreRelease,
	GWindow_Message_PrePaint,
	GWindow_Message_OnTimer,
#if		(_USE_MULTI_COORDINATE_ != 0)
	GWindow_Message_SetActiveCoordinate,
#endif/*(_USE_MULTI_COORDINATE_ != 0)*/
	GWindow_Message_OnUpdateDB,
	GWindow_Message_IsMousePointInBounds,

	GWindow_Message_SetBackGroundDesign,
	GWindow_Message_GetBackGroundDesign,
	GWindow_Message_CreateChildren,
	GWindow_Message_AddChild,
	GWindow_Message_DeleteAllChildren,
	GWindow_Message_GetChild,
	GWindow_Message_GetChildList,
	GWindow_Message_DrawChildren,
	GWindow_Message_DrawBackGround,
	GWindow_Message_SetActiveChild,
	GWindow_Message_GetActiveChild,
	GWindow_Message_EndModal,
	GWindow_Message_AddBlinkControl,
	GWindow_Message_RemoveBlinkControl,
	GWindow_Message_AddScrollControl,
	GWindow_Message_RemoveScrollControl,
	GWindow_Message_SetPictureData,
	GWindow_Message_GetPictureData,
	GWindow_Message_GetPositionChild,
	GWindow_Message_SetNoResponseBaseArea,
	GWindow_Message_GetNoResponseBaseArea,
	GWindow_Message_SetReleaseType,
	GWindow_Message_GetReleaseType,
	GWindow_Message_GetChildAt,
	GWindow_Message_OnShowPage,
	GWindow_Message_OnHidePage,
	GWindow_Message_MoveChildListFirst,
	GWindow_Message_MoveChildListLast,
	GWindow_Message_MoveChildListPrev,
	GWindow_Message_MoveChildListNext,
	GWindow_Message_MoveChildList,
	GWindow_Message_GetChildIndex,
	GWindow_Message_GetPrevChild,
	GWindow_Message_GetNextChild,
#ifndef	_DISABLE_GLAYER_
	GWindow_Message_GetChildCount,
	GWindow_Message_GetFirstChildInLayer,
	GWindow_Message_GetLastChildInLayer,
	GWindow_Message_GetChildInLayer,
#endif/*_DISABLE_GLAYER_*/
	GWindow_Message_AddFrameAnimation,
	GWindow_Message_RemoveFrameAnimation,
	GWindow_Message_StartAutoPlayFrameAnimation,
	GWindow_Message_StartFrameAnimation,
	GWindow_Message_ResetFrameAnimation,
	GWindow_Message_StopFrameAnimation,
	GWindow_Message_ResumeFrameAnimation,
	GWindow_Message_FindFrameAnimation,
	GWindow_Message_SetFrameAnimationSet,
	GWindow_Message_SelectFrameAnimation,
	GWindow_Message_SetAsyncAnimationStatus,
	GWindow_Message_GetAsyncAnimationStatus,
	GWindow_Message_StartAsyncFrameAnimation,
	GWindow_Message_ResetAsyncFrameAnimation,
	GWindow_Message_StopAsyncFrameAnimation,
	GWindow_Message_ResumeAsyncFrameAnimation,
	GWindow_Message_RestartAsyncFrameAnimation
//}}FUNCTION_TABLE_FUNCTION
};
//}}FUNCTION_TABLE_TABLE

const GWindow_Message_VMT *GWGetGWindow_MessageVMT( void )
{
	return &vmt;
}
/*
 *	<summary>		:	IuWFNgB
 *
 *	<parameter>		:	Ȃ
 *
 *	<return>		:	NULL:		s
 *						NULLȊO:	IuWFNgւ̃|C^
 *
 *	<Explanation>	:	GWindow_MessageIuWFNg̃mۂA{B
 */
GWindow_Message* GWNewGWindow_Message( void )
{
	GUInt8 ucType,ucPlane;
	GWindow_Message *pNewObject;

	GWGetVmt( GScreen_VMT, GWGetScreen() )->GetMemorySpace( GWGetScreen(), &ucType, &ucPlane );
	pNewObject = (GWindow_Message*)GMMemoryAlloc( ucType, ucPlane, sizeof(GWindow_Message));
	if( pNewObject == NULL ){
		return NULL;
	}

	memset( pNewObject, 0, sizeof(GWindow_Message) );
	GWInitGWindow_Message( pNewObject );
	
	return pNewObject;
}

/*
 *	<summary>		:	B
 *
 *	<parameter>		:	(i)GWindow_Message* pSelf;	sIuWFNg
 *
 *	<return>		:	G_FALSE:	s
 *						G_TRUE:	
 *
 *	<Explanation>	:	GWindow_MessageIuWFNg̏sB
 *						֐\(VMT)IuWFNgɊ֘AtB
 */
GInt16 GWInitGWindow_Message( GWindow_Message* pSelf )
{
	if(pSelf == NULL){
		return G_FALSE;
	}

	GWInitGFrameAnimationPanel( (GFrameAnimationPanel*)pSelf );
	((GObject*)pSelf)->vmt = (const GObject_VMT*)&vmt;

	return G_TRUE;
}

/*
 *	<summary>		:	CxgbZ[WvV[WB
 *
 *	<parameter>		:	(i)GBaseWindow* pSelf;	IuWFNg
 *						(i)GUInt16 usMessage;	CxgbZ[W
 *						(i)GLParam lLParam;		t񉺈
 *						(i)GUParam lUParam;		t
 *
 *	<return>		:	-1:		ΉCxg݂ȂB
 *						0ȏ:	CxgɈˑ
 *
 *	<description>	:	CxgbZ[WɑΉ֐̌ĂяosB
 *						
 */
GClassMP( GWindow_Message )
//{{MESSAGEPROCEDURE
//}}MESSAGEPROCEDURE
GInheritMP( GFrameAnimationPanel )


/*
 *	<summary>		:	qIuWFNǧ
 *
 *	<parameter>		:	(i)void *pSelf;		:IuWFNg
 *						(i)GUInt16 usIdx;	:qIuWFNg̃CfbNX
 *
 *	<return>		:	CfbNX͈͓	IuWFNgւ̃|C^
 *	 					CfbNX͈͊O	NULL
 *
 *	<description>	:	wIDGPanel̎qIuWFNgB
 *
 *	<exception>		:	w̃CfbNXlGCPanel̎qIuWFNgԂB
 *
 */
GBaseWindow* GWindow_Message_GetChildAt( void *pSelf, GUInt16 usIdx )
{
	if( (sizeof(pProperty)/sizeof(GBaseWindowProperty*)) > usIdx ){
		return ((GWindow_Message*)pSelf)->m_pObjectTable[usIdx];
	}else{
		return NULL;
	}
}

/*
 *	<summary>		:	qIuWFNg
 *
 *	<parameter>		:	(i)GWindow_Message *pSelf;		:IuWFNg
 *
 *	<return>		:	Ȃ
 *
 *	<description>	:	qIuWFNg{B
 */
GInt16 GWindow_Message_CreateChildren( void *pSelf )
{
	GBaseWindow *pChild;
	GUInt32 i;

	for( i = 1; i < (sizeof(pProperty)/sizeof(GBaseWindowProperty*)); i++ ){
		pChild = GWGetVmt(GScreen_VMT,GWGetScreen())->CreateInstance( GWGetScreen(), pProperty[i]->usType, pProperty[i], (GBaseWindow*)pSelf );
		GWGetVmt( GWindow_Message_VMT,pSelf )->AddChild( pSelf, pChild );
		((GWindow_Message*)pSelf)->m_pObjectTable[i] = pChild;
		GWGetVmt( GBaseWindow_VMT,pChild )->Create( pChild, pSelf );
	}
	if((sizeof(pFrameAnimationSet)/sizeof(GFrameAnimationSetProperty)) > 1) {
		GWGetVmt( GWindow_Message_VMT, pSelf )->SetFrameAnimationSet( pSelf, pFrameAnimationSet );
		GWGetVmt( GWindow_Message_VMT, pSelf )->SelectFrameAnimation( pSelf, 1 );
	}
	return G_TRUE;
}


GInt32 GWINDOW_MESSAGE_STCERRORMESSAGEOnCreate(GWindow_Message *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MESSAGE_STCERRORMESSAGEOnCreate)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MESSAGE_STCERRORMESSAGEOnCreate)
	GStaticText *pSText;
	pSText = (GStaticText*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, STCERRORMESSAGE );
	GWGetVmt(GStaticText_VMT, pSText )->SetString(pSText, g_szErrorMsg);
	GESetTimer( pSText, ID_TIMER_MESSAGE, NUM_TIMER_1500 );
	return G_TRUE;
}

GInt32 GWINDOW_MESSAGE_STCERRORMESSAGEOnTimer(GWindow_Message *pSelf, GUInt16 usMessage, GLParam lLParam, GUParam lUParam)
{
	//{{_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MESSAGE_STCERRORMESSAGEOnTimer)
	//}}_GUI_SCRIPT_FUNCTION_CALL(GWINDOW_MESSAGE_STCERRORMESSAGEOnTimer)
	GStaticText *pSText;
	GFrame *pFrame = NULL;
	GWindow *pWindow = NULL;

	pFrame = (GFrame*)GWGetVmt(GScreen_VMT, GWGetScreen())->GetFrame(GWGetScreen());
	pSText = (GStaticText*)GWGetVmt( GPanel_VMT, pSelf )->GetChild( pSelf, STCERRORMESSAGE );
	GEKillTimer( pSText, ID_TIMER_MESSAGE);
	if(pFrame != NULL){
		pWindow = (GWindow*)GWGetVmt(GFrame_VMT, pFrame)->GetChild(pFrame, ID_GWINDOW_MESSAGE + 1);
		if(pWindow != NULL){
			GWGetVmt(GFrame_VMT, pFrame)->DeleteChild(pFrame, pWindow);
		}
	}
	return G_TRUE;
}

