/* dataaccessapi.c - dataaccessapi */

/* Copyright 2013-2014 ILC, Inc. All Rights Reserved */

/*
modification history
--------------------
2014.03.12 new
*/

/*
DESCRIPTION


*/

#include <vxWorks.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <QbfFunc.h>
#include "dataaccessapi.h"
#include "gdbobject.h"
#include "gevent.h"

/* define */
#define GDBID_MAX 100
#define IOOBJECT_1LINE_MAX 256
#define DEVICE_BIT	0
#define DEVICE_WORD	1

/* prototype */
BOOL IOObjectFileRead(void);
BOOL GetDeviceInfo(char *,short *,unsigned long *,short *);

/* */
typedef struct _IOObjectFile{
	char objectName[32];
	short devName;
	unsigned long devNo;
	short devType;
}IOOBJECTFILE;
IOOBJECTFILE stIOObjectFile[GDBID_MAX];
long lPath;


short DataAccessStart(void)
{
	if(IOObjectFileRead() == FALSE){
		return -1;
	}
	/* Open QBF Function */
	if(QBF_Open(2,&lPath) != 0){
		return -2;
	}
	return 0;
}

short DataAccessEnd(void)
{
	/* Close QBF Function */
	if(QBF_Close(lPath) != 0){
		return -1;
	}
	return 0;
}

short DataAccessRead(DATAACCESSGDBID *stGDBID,short IDcnt)
{
	short nLoop = 0;
	short nDevName = 0;
	unsigned long devNo = 0;
	short nDevType = 0;
	short nReturn = 0;
	short nCnt = 0;
	BOOL bReturn = FALSE;
	unsigned short *pusBuf;
	
	/* Read PLC & Write DataBase */
	for(nLoop = 0;nLoop < IDcnt;nLoop++){
		bReturn = GetDeviceInfo(stGDBID[nLoop].cObjectName,&nDevName,&devNo,&nDevType);
		if(bReturn == FALSE){
			return -1;
		}
		/* make read buffer */
		pusBuf = malloc(stGDBID[nLoop].sDataSize * sizeof(short));
		if(pusBuf == NULL){
			return -2;
		}
		/* param. check */
		if(nDevType == DEVICE_BIT){
			if((devNo%16) != 0){
				free(pusBuf);
				return -3;
			}
		}
		/* read PLC device */
		if(nDevName == QBFDev_MCPU_X || nDevName == QBFDev_MCPU_Y){
			for(nCnt = 0;nCnt < stGDBID[nLoop].sDataSize;nCnt++){
				if(nDevName == QBFDev_MCPU_X){
					nReturn = QBF_X_In_WordEx(lPath,0,devNo+(nCnt*16),1,&pusBuf[nCnt],1);
				}else{
					nReturn = QBF_Y_In_WordEx(lPath,0,devNo+(nCnt*16),1,&pusBuf[nCnt],1);
				}
				if(nReturn != 0){
					free(pusBuf);
					return -4;
				}
			}
		}else if(nDevName == QBFDev_MCPU_M || nDevName == QBFDev_MCPU_B){
			for(nCnt = 0;nCnt < stGDBID[nLoop].sDataSize;nCnt++){
				nReturn = QBF_ReadDevice(lPath,nDevName,devNo+(nCnt*16),1,&pusBuf[nCnt],(unsigned long)sizeof(short));
				if(nReturn != 0){
					free(pusBuf);
					return -4;
				}
			}
		}else{
			nReturn = QBF_ReadDevice(lPath,
									nDevName,
									devNo,
									(unsigned long)stGDBID[nLoop].sDataSize,
									pusBuf,
									(unsigned long)stGDBID[nLoop].sDataSize * sizeof(short));
			if(nReturn != 0){
				free(pusBuf);
				return -4;
			}
		}
		/* write database */
		GWDBWriteData(stGDBID[nLoop].usGDBID,pusBuf,stGDBID[nLoop].sDataSize * sizeof(short),TRUE);
		free(pusBuf);
	}
	return 0;
}

short DataAccessWrite(DATAACCESSGDBID *stGDBID,short IDcnt)
{
	short nLoop = 0;
	short nDevName = 0;
	unsigned long devNo = 0;
	short nDevType = 0;
	short nReturn = 0;
	short nCnt = 0;
	BOOL bReturn = FALSE;
	unsigned short *pusBuf;
	
	/* Read DataBase & Write PLC */
	for(nLoop = 0;nLoop < IDcnt;nLoop++){
		bReturn = GetDeviceInfo(stGDBID[nLoop].cObjectName,&nDevName,&devNo,&nDevType);
		if(bReturn == FALSE){
			return -1;
		}
		if(nDevName == QBFDev_MCPU_X){
			return -5;			
		}
		/* param. check */
		if(nDevType == DEVICE_BIT && (devNo%16) != 0){
			return -3;
		}
		/* make write buffer */
		pusBuf = malloc(stGDBID[nLoop].sDataSize * sizeof(short));
		if(pusBuf == NULL){
			return -2;
		}
		/* read database */
		GWDBReadData(stGDBID[nLoop].usGDBID,pusBuf,stGDBID[nLoop].sDataSize * sizeof(short));
		/* write PLC device */
		if(nDevName == QBFDev_MCPU_Y){
			for(nCnt = 0;nCnt < stGDBID[nLoop].sDataSize;nCnt++){
				nReturn = QBF_Y_Out_WordEx(lPath,0,devNo+(nCnt*16),1,&pusBuf[nCnt],0);
				if(nReturn != 0){
					free(pusBuf);
					return -4;
				}
			}
		}else if(nDevName == QBFDev_MCPU_M || nDevName == QBFDev_MCPU_B){
			for(nCnt = 0;nCnt < stGDBID[nLoop].sDataSize;nCnt++){
				nReturn = QBF_WriteDevice(lPath,nDevName,devNo+(nCnt*16),1,&pusBuf[nCnt],(unsigned long)sizeof(short));
				if(nReturn != 0){
					free(pusBuf);
					return -4;
				}
			}
		}else{
			nReturn = QBF_WriteDevice(lPath,
									nDevName,
									devNo,
									(unsigned long)stGDBID[nLoop].sDataSize,
									pusBuf,
									0);
			if(nReturn != 0){
				free(pusBuf);
				return -4;
			}
		}
		free(pusBuf);
	}
	return 0;
}

BOOL GetDeviceInfo(char *objectName,short *devName,unsigned long *devNo,short *devType)
{
	short nLoop;
	
	for(nLoop = 0;nLoop < GDBID_MAX;nLoop++){
		if(strcmp(objectName,stIOObjectFile[nLoop].objectName) == 0){
			*devName = stIOObjectFile[nLoop].devName;
			*devNo = stIOObjectFile[nLoop].devNo;
			*devType = stIOObjectFile[nLoop].devType;
			return TRUE;
		}
	}
	return FALSE;
}

BOOL IOObjectFileRead(void)
{
	FILE *fp = NULL;
	char buffer[IOOBJECT_1LINE_MAX];
	char *strp = NULL;
	char *strp2 = NULL;
	short nCnt;
	
	fp = fopen("/ROM/IOObject.csv","r");
	if(fp == NULL){
		return FALSE;
	}
	memset(&stIOObjectFile[0],0,sizeof(IOOBJECTFILE)*GDBID_MAX);
	nCnt = 0;
	while(fgets(buffer,IOOBJECT_1LINE_MAX,fp) != NULL){
		/* GUI Database Object Name */
		strp = strchr(buffer,',');
		if(strp == NULL){
			fclose(fp);
			return FALSE;
		}
		memcpy(&stIOObjectFile[nCnt].objectName[0],buffer,strp-buffer);
		/* next , */
		strp++;
		/* get device name */
		switch(strp[0]){
		case 'X':
			stIOObjectFile[nCnt].devName = QBFDev_MCPU_X;
			stIOObjectFile[nCnt].devType = DEVICE_BIT;
			break;
		case 'Y':
			stIOObjectFile[nCnt].devName = QBFDev_MCPU_Y;
			stIOObjectFile[nCnt].devType = DEVICE_BIT;
			break;
		case 'M':
			stIOObjectFile[nCnt].devName = QBFDev_MCPU_M;
			stIOObjectFile[nCnt].devType = DEVICE_BIT;
			break;
		case 'S':
			strp++;
			if(strp[0] == 'M'){
				stIOObjectFile[nCnt].devName = QBFDev_MCPU_SM;
				stIOObjectFile[nCnt].devType = DEVICE_BIT;
			}else{
				stIOObjectFile[nCnt].devName = QBFDev_MCPU_SD;
				stIOObjectFile[nCnt].devType = DEVICE_WORD;
			}
			break;
		case 'D':
			stIOObjectFile[nCnt].devName = QBFDev_MCPU_D;
			stIOObjectFile[nCnt].devType = DEVICE_WORD;
			break;
		case 'B':
			stIOObjectFile[nCnt].devName = QBFDev_MCPU_B;
			stIOObjectFile[nCnt].devType = DEVICE_BIT;
			break;
		case 'W':
			stIOObjectFile[nCnt].devName = QBFDev_MCPU_W;
			stIOObjectFile[nCnt].devType = DEVICE_WORD;
			break;
		default:
			fclose(fp);
			return FALSE;
		}
		strp++;
		strp2 = strchr(strp,',');
		if(strp2 == NULL){
			fclose(fp);
			return FALSE;
		}
		strp2[0] = 0;
		/* get device no. */
		if(stIOObjectFile[nCnt].devName == QBFDev_MCPU_X ||
		   stIOObjectFile[nCnt].devName == QBFDev_MCPU_Y ||
		   stIOObjectFile[nCnt].devName == QBFDev_MCPU_B ||
		   stIOObjectFile[nCnt].devName == QBFDev_MCPU_W){
			stIOObjectFile[nCnt].devNo = strtoul(strp, NULL, 16);
		}else{
			stIOObjectFile[nCnt].devNo = strtoul(strp, NULL, 10);
		}
		nCnt++;
		if(GDBID_MAX <= nCnt){
			break;
		}
	}
	fclose(fp);
	return TRUE;
}
