# 
# windml-env.mk - Supplies basic environment variables for WindML
#                       static build.
#
# modification history
# --------------------
# 01g,23jul07,jlb  Fix inclusion of windml-env.mk
# 01f,12jun07,jlb  restructured to support SMP build
# 01e,04apr05,edc  Re-arranged/renamed macros
# 01d,30mar05,edc  Updated for WindML 4.0
# 01c,15sep04,jlb  Work around for SPR 101772 - strict aliasing on gcc
# 01b,30aug04,jlb  cleanup build of demo
# 01a,17may04,jlb  created
#
#
# DESCRIPTION
#
# This file is the top level makefile when used within a workbench
# environment, which is the typical use case.
#

#
# setup basic environment variables
#

export WIND_HOME_FS := $(subst \,/,$(WIND_HOME))
WINDML_BASE = $(WRVX_COMPBASE)/$(COMP_WINDML)
export WINDML_BASE := $(subst \,/,$(WINDML_BASE))
export COMPONENTS_DIR := $(patsubst %/$(COMP_WINDML),%,$(WINDML_BASE))

export ADDED_INCLUDES += -I$(WINDML_BASE)/h -I$(WINDML_BASE)/h/ugl

export VXBUILD

# this is the base of the WindML source tree
export WINDML_SOURCE_TREE := $(WINDML_BASE)/src

#default for space
ifeq ($(SPACE),)
SPACE := kernel
endif

ifeq ($(SPACE),krnl)
SPACE := kernel
endif

ifeq ($(CPU),)
	ifneq ($(CPU_CONFIG),)
		CPU := $(CPU_CONFIG)
	else
		WINDML_ENV_PROBLEM += CPU;
	endif
endif
ifeq ($(TOOL),)
	ifneq ($(TOOL_CONFIG),)
		TOOL := $(TOOL_CONFIG)
	else
		WINDML_ENV_PROBLEM += TOOL;
	endif
endif
ifeq ($(TOOL_FAMILY),)
	ifeq ($(findstring gnu,$(TOOL)),gnu)
		TOOL_FAMILY	= gnu
	endif
	ifeq ($(findstring diab,$(TOOL)),diab)
		TOOL_FAMILY	= diab
	endif
endif


 # make sure we have the proper build type setup
ifeq ($(PROJECT_TYPE),RTP)
	SPACE := user
endif

ifeq ($(PROJECT_TYPE),DKM)
	SPACE := kernel
endif

ifeq ($(PROJECT_TYPE),SL)
	SPACE := user
endif

export CPU
export VX_CPU_FAMILY
export TOOL
export TOOL_FAMILY
export SPACE
export WINDML_ENV_PROBLEM		
