# 
# windml-nolink-app.makefile - Wind Media application build for a managed build by 
#                   Wind River Workbench. 
#
# modification history
# --------------------
# 01a,03oct07,jlb  created
#
#
# DESCRIPTION
#
# This file is the top level makefile when used within a workbench
# environment for unlinked applications.
#

-include $(PRJ_ROOT_DIR)/windml-env.mk

WINDML_WORKSPACE_DIR := $(subst \,/,$(WS_ROOT_DIR))

SPACE_DIR := krnl

ifeq ($(CPU),)
	CPU := $(CPU_CONFIG)
endif
ifeq ($(TOOL),)
	TOOL := $(TOOL_CONFIG)
endif
ifeq ($(TOOL_FAMILY),)
	ifeq ($(findstring gnu,$(TOOL)),gnu)
		TOOL_FAMILY	= gnu
	endif
	ifeq ($(findstring diab,$(TOOL)),diab)
		TOOL_FAMILY	= diab
	endif
endif

ifeq ($(VX_CPU_FAMILY),)
	ifeq ($(SPACE_DIR),krnl)
		-include $(WIND_BASE)/target/h/tool/$(TOOL_FAMILY)/make.$(CPU)$(TOOL)
	else
		-include $(WIND_BASE)/target/usr/tool/$(TOOL_FAMILY)/make.$(CPU)$(TOOL)
	endif
endif
ifeq ($(TOOL_COMMON_DIR),)
	TOOL_COMMON_DIR	:= $(subst $(TOOL_FAMILY),common,$(TOOL))
endif	

-include $(WIND_BASE)/target/h/make/defs.options

	
