/****************************************************************************/
/* FILE NAME       MakeRAMDisk_R12.c                                        */
/* VERSION         1.00                                                     */
/* FUNCTION        : Sample program to Create RAM disk device               */
/*                   (For R12CCPU-V)                                        */
/*                                                                          */
/* When you want to build this sample,                                      */
/* Please copy CCPUFunc.h and MDFunc.h from SYSTEMROM INCLUDE folder        */
/* in C Controller module to C:\WindRiver\INCLUDE.                          */
/*                                                                          */
/* Sample Program, User at Own Risk                                         */
/*                                                                          */
/* CREATED         2014/10/22   MITSUBISHI ELECTRIC CORPORATION             */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxworks.h>
#include    <stdio.h>
#include    <dosFsLib.h>
#include    <xbdRamDisk.h>

#define RAM_DRV_NAME    "/RAMDISK"  /* RAM disk name (Optional)            */

/* Create RAM disk                                                         */
int ramMake(int iBlockSize);

/****************************************************************************/
/* MODULE   : ramMake                                                       */
/* ABSTRACT : Create RAM disk device                                        */
/* FUNCTION : The RAM disk is made by the specified number of blocks.       */
/* NOTE     : Specify the number of blocks for RAM disk using the argument  */
/*            The size of RAM disk is "specified number of blocks * 512     */
/*            bytes(bytesPerBlock)"                                         */
/*            In addition, the number of simultaneous file which can        */
/*            open on the RAM disk is 10 (Specify MaxFileNum)               */
/*                                                                          */
/*            call functions -                                              */
/*              xbdRamDiskDevCreate = Creating RAM disk                     */
/*              dosFsVolFormat      = Formatting as DOS file system         */
/* RETURN   :                                                               */
/*            0          Normal                                             */
/*            Otherwise  Error                                              */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
int ramMake(
    int iBlockSize)         /* Number of RAM disk blocks                    */
{
    int             iRamDiskSize;
    device_t        stxbdId;
    
    /************************************************************************/
    /* Create RAM disk                                                      */
    /************************************************************************/
    iRamDiskSize = (512 * iBlockSize);  /* Size of RAM disk                 */
    /************************************************************************/
    /* Create RAM disk(device)                                              */
    /************************************************************************/
    stxbdId = (device_t)(BLK_DEV*)xbdRamDiskDevCreate(512, iRamDiskSize, 0, RAM_DRV_NAME);
    if(stxbdId == NULLDEV) {
        goto ERROR_EXIT;
    }

    /************************************************************************/
    /* Configure file-system                                                */
    /************************************************************************/
    /* Format RAM disk device                                               */
    dosFsVolFormat(RAM_DRV_NAME, (DOS_OPT_BLANK | DOS_OPT_QUIET), NULL);
    return OK;

/****************************************************************************/
/* In case of Error, terminate                                              */
/****************************************************************************/
ERROR_EXIT:
    printf("\nramMake ERROR: iBlockSize=%d\n", iBlockSize);
    return ERROR;
}
