/****************************************************************************/
/* FILE NAME       SDTaskPrioritySet_R12.c                                  */
/* VERSION         1.00                                                     */
/* FUNCTION        : Sets the (new) priority for the SD task                */
/*                   (For R12CCPU-V)                                        */
/*                                                                          */
/*  This program changes the priority of XBD service task (default 50)      */
/*  when SD card inserted in R12CCPU-V is accessed                          */
/*                                                                          */
/* When you want to build this sample,                                      */
/* Please copy CCPUFunc.h and MDFunc.h from SYSTEMROM INCLUDE folder        */
/* in C Controller module to C:\WindRiver\INCLUDE.                          */
/*                                                                          */
/*  Sample program, User at Own Risk                                        */
/*                                                                          */
/* CREATED         2014/10/22   MITSUBISHI ELECTRIC CORPORATION             */
/*                                                                          */
/* COPYRIGHT (C) 2014 MITSUBISHI ELECTRIC CORPORATION ALL RIGHTS RESERVED   */
/****************************************************************************/

#include    <vxworks.h>
#include    <taskLib.h>
#include    <stdio.h>

#define SD_XBDTASK_NAME     "tXbdService"

/* SD task priority setting processing                                      */
int SDTaskPrioritySet(int iPriority);

/****************************************************************************/
/* MODULE   : SDTaskPrioritySet                                             */
/* ABSTRACT : Set new priority of SD task                                   */
/* FUNCTION : TaskID of the SD task is acquired and set the priority        */
/* NOTE     : The new priority of SD task to be set should be specified as  */
/*            argument of this function                                     */
/*  call functions -                                                        */
/*      taskNameToId    = Task ID acquisition                               */
/*      taskPrioritySet = Set priority of SD task                           */
/* RETURN   :                                                               */
/*             0    Normal                                                  */
/*            -1    Error                                                   */
/* CREATE   : 2014-10-22    MITSUBISHI ELECTRIC CORPORATION                 */
/* UPDATE   :                                                               */
/****************************************************************************/
int SDTaskPrioritySet(
    int iPriority)      /* Priority of SD task to set                       */
{
    int             iTaskId;
    int             iRet;

    /************************************************************************/
    /* Get the Task ID                                                      */
    /************************************************************************/
    iTaskId = taskNameToId( SD_XBDTASK_NAME );  /* Task ID of SD task       */
    if(iTaskId == ERROR) {
        printf("\ntaskNameToId ERROR\n");
        goto ERROR_EXIT;
    }

    /************************************************************************/
    /* Set new priority of SD task                                          */
    /************************************************************************/
    iRet = taskPrioritySet( iTaskId, iPriority );
    if(iRet == ERROR){
        printf("\ntaskPrioritySet ERROR\n");
        goto ERROR_EXIT;
    }

    return OK;
    
/****************************************************************************/
/* In case of Error, terminate                                              */
/****************************************************************************/
ERROR_EXIT:
    return ERROR;
}
